/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.event.EVCacheEvent;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.internal.GenericCompletionListener;
import net.spy.memcached.internal.ListenableFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheLatchImpl
implements EVCacheLatch,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(EVCacheLatchImpl.class);
    private final int expectedCompleteCount;
    private final CountDownLatch latch;
    private final List<Future<Boolean>> futures;
    private final EVCacheLatch.Policy policy;
    private final int totalFutureCount;
    private final long start = System.currentTimeMillis();
    private final String appName;
    private EVCacheEvent evcacheEvent = null;
    private boolean onCompleteDone = false;
    private int completeCount = 0;
    private int failureCount = 0;
    private ScheduledFuture<?> scheduledFuture;

    public EVCacheLatchImpl(EVCacheLatch.Policy policy, int _count, String appName) {
        this.policy = policy;
        this.futures = new ArrayList<Future<Boolean>>(_count);
        this.appName = appName;
        this.totalFutureCount = _count;
        this.expectedCompleteCount = this.policyToCount(policy, _count);
        this.latch = new CountDownLatch(this.expectedCompleteCount);
        if (log.isDebugEnabled()) {
            log.debug("Number of Futures = " + _count + "; Number of Futures that need to completed for Latch to be released = " + this.expectedCompleteCount);
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Current Latch Count = " + this.latch.getCount() + "; await for " + timeout + " " + unit.name() + " appName : " + this.appName);
        }
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        boolean awaitSuccess = this.latch.await(timeout, unit);
        if (log.isDebugEnabled()) {
            log.debug("await success = " + awaitSuccess + " after " + (System.currentTimeMillis() - start) + " msec." + " appName : " + this.appName + (this.evcacheEvent != null ? " keys : " + this.evcacheEvent.getCanonicalKeys() : ""));
        }
        return awaitSuccess;
    }

    public void addFuture(ListenableFuture<Boolean, OperationCompletionListener> future) {
        future.addListener((GenericCompletionListener)this);
        if (future.isDone()) {
            this.countDown();
        }
        this.futures.add((Future<Boolean>)future);
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    public void countDown() {
        if (log.isDebugEnabled()) {
            log.debug("Current Latch Count = " + this.latch.getCount() + "; Count Down.");
        }
        this.latch.countDown();
    }

    @Override
    public int getPendingCount() {
        if (log.isDebugEnabled()) {
            log.debug("Pending Count = " + this.latch.getCount());
        }
        return (int)this.latch.getCount();
    }

    @Override
    public int getCompletedCount() {
        if (log.isDebugEnabled()) {
            log.debug("Completed Count = " + this.completeCount);
        }
        return this.completeCount;
    }

    @Override
    public List<Future<Boolean>> getPendingFutures() {
        ArrayList<Future<Boolean>> returnFutures = new ArrayList<Future<Boolean>>(this.expectedCompleteCount);
        for (Future<Boolean> future : this.futures) {
            if (future.isDone()) continue;
            returnFutures.add(future);
        }
        return returnFutures;
    }

    @Override
    public List<Future<Boolean>> getAllFutures() {
        return this.futures;
    }

    @Override
    public List<Future<Boolean>> getCompletedFutures() {
        ArrayList<Future<Boolean>> returnFutures = new ArrayList<Future<Boolean>>(this.expectedCompleteCount);
        for (Future<Boolean> future : this.futures) {
            if (!future.isDone()) continue;
            returnFutures.add(future);
        }
        return returnFutures;
    }

    private int policyToCount(EVCacheLatch.Policy policy, int count) {
        if (policy == null) {
            return 0;
        }
        switch (policy) {
            case NONE: {
                return 0;
            }
            case ONE: {
                return 1;
            }
            case QUORUM: {
                if (count == 0) {
                    return 0;
                }
                if (count <= 2) {
                    return 1;
                }
                return this.futures.size() / 2 + 1;
            }
            case ALL_MINUS_1: {
                if (count == 0) {
                    return 0;
                }
                if (count <= 2) {
                    return 1;
                }
                return count - 1;
            }
        }
        return count;
    }

    @Override
    public void setEVCacheEvent(EVCacheEvent e) {
        this.evcacheEvent = e;
    }

    public void onComplete(OperationFuture<?> future) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("BEGIN : onComplete - Calling Countdown. Completed Future = " + future + "; App : " + this.appName);
        }
        this.countDown();
        ++this.completeCount;
        if (this.evcacheEvent != null) {
            Iterator<EVCacheClient> iterator;
            if (log.isDebugEnabled()) {
                log.debug(";App : " + this.evcacheEvent.getAppName() + "; Call : " + (Object)((Object)this.evcacheEvent.getCall()) + "; Keys : " + this.evcacheEvent.getCanonicalKeys() + "; completeCount : " + this.completeCount + "; totalFutureCount : " + this.totalFutureCount + "; failureCount : " + this.failureCount);
            }
            if (future.isDone() && future.get().equals(Boolean.FALSE)) {
                ++this.failureCount;
            }
            if (!this.onCompleteDone && this.getCompletedCount() >= this.getExpectedSuccessCount() && this.evcacheEvent.getClients().size() > 0 && (iterator = this.evcacheEvent.getClients().iterator()).hasNext()) {
                EVCacheClient client = iterator.next();
                List<EVCacheEventListener> evcacheEventListenerList = client.getPool().getEVCacheClientPoolManager().getEVCacheEventListeners();
                for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
                    evcacheEventListener.onComplete(this.evcacheEvent);
                }
                this.onCompleteDone = true;
            }
            if (this.scheduledFuture != null) {
                boolean futureCancelled = this.scheduledFuture.isCancelled();
                if (log.isDebugEnabled()) {
                    log.debug("App : " + this.evcacheEvent.getAppName() + "; Call : " + (Object)((Object)this.evcacheEvent.getCall()) + "; Keys : " + this.evcacheEvent.getCanonicalKeys() + "; completeCount : " + this.completeCount + "; totalFutureCount : " + this.totalFutureCount + "; failureCount : " + this.failureCount + "; futureCancelled : " + futureCancelled);
                }
                if (this.onCompleteDone && !futureCancelled && this.completeCount == this.totalFutureCount && this.failureCount == 0) {
                    boolean status = this.scheduledFuture.cancel(true);
                    if (log.isDebugEnabled()) {
                        log.debug("Cancelled the scheduled task : " + status);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("App : " + this.evcacheEvent.getAppName() + "; Call : " + (Object)((Object)this.evcacheEvent.getCall()) + "; Keys : " + this.evcacheEvent.getCanonicalKeys() + "; completeCount : " + this.completeCount + "; totalFutureCount : " + this.totalFutureCount + "; failureCount : " + this.failureCount);
            }
        }
        if (this.totalFutureCount == this.completeCount) {
            ArrayList<Tag> tags = new ArrayList<Tag>(3);
            tags.add((Tag)new BasicTag("cache", this.appName));
            tags.add((Tag)new BasicTag("failCount", String.valueOf(this.failureCount)));
            tags.add((Tag)new BasicTag("completeCount", String.valueOf(this.completeCount)));
            tags.add((Tag)new BasicTag("operation", "callback"));
            EVCacheMetricsFactory.getInstance().getPercentileTimer("internal.evcache.client.latch", tags).record(System.currentTimeMillis() - this.start, TimeUnit.MILLISECONDS);
        }
        if (log.isDebugEnabled()) {
            log.debug("END : onComplete - Calling Countdown. Completed Future = " + future + "; App : " + this.appName);
        }
    }

    @Override
    public int getFailureCount() {
        int fail = 0;
        for (Future<Boolean> future : this.futures) {
            try {
                if (!future.isDone() || !future.get().equals(Boolean.FALSE)) continue;
                ++fail;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return fail;
    }

    @Override
    public int getExpectedCompleteCount() {
        return this.expectedCompleteCount;
    }

    @Override
    public int getExpectedSuccessCount() {
        return this.expectedCompleteCount;
    }

    @Override
    public int getSuccessCount() {
        int success = 0;
        for (Future<Boolean> future : this.futures) {
            try {
                if (!future.isDone() || !future.get().equals(Boolean.TRUE)) continue;
                ++success;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return success;
    }

    public String getAppName() {
        return this.appName;
    }

    @Override
    public EVCacheLatch.Policy getPolicy() {
        return this.policy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"AppName\":\"");
        builder.append(this.getAppName());
        builder.append("\",\"isDone\":\"");
        builder.append(this.isDone());
        builder.append("\",\"Pending Count\":\"");
        builder.append(this.getPendingCount());
        builder.append("\",\"Completed Count\":\"");
        builder.append(this.getCompletedCount());
        builder.append("\",\"Pending Futures\":\"");
        builder.append(this.getPendingFutures());
        builder.append("\",\"All Futures\":\"");
        builder.append(this.getAllFutures());
        builder.append("\",\"Completed Futures\":\"");
        builder.append(this.getCompletedFutures());
        builder.append("\",\"Failure Count\":\"");
        builder.append(this.getFailureCount());
        builder.append("\",\"Success Count\":\"");
        builder.append(this.getSuccessCount());
        builder.append("\",\"Excpected Success Count\":\"");
        builder.append(this.getExpectedSuccessCount());
        builder.append("\"}");
        return builder.toString();
    }

    @Override
    public int getPendingFutureCount() {
        int count = 0;
        for (Future<Boolean> future : this.futures) {
            if (future.isDone()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getCompletedFutureCount() {
        int count = 0;
        for (Future<Boolean> future : this.futures) {
            if (!future.isDone()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isFastFailure() {
        return this.totalFutureCount == 0;
    }

    @Override
    public void run() {
        ArrayList<Tag> tags = new ArrayList<Tag>(4);
        tags.add((Tag)new BasicTag("cache", this.appName));
        tags.add((Tag)new BasicTag("operation", "verify"));
        if (this.evcacheEvent != null) {
            int failCount = 0;
            Iterator<Object> iterator = this.futures.iterator();
            while (iterator.hasNext()) {
                boolean fail;
                Future<Boolean> future;
                block9: {
                    future = iterator.next();
                    fail = false;
                    try {
                        fail = future.get().equals(Boolean.FALSE);
                    }
                    catch (Exception e) {
                        fail = true;
                        if (!log.isDebugEnabled()) break block9;
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                }
                if (!fail) continue;
                ++failCount;
                if (!(future instanceof EVCacheOperationFuture)) continue;
                EVCacheOperationFuture evcFuture = (EVCacheOperationFuture)((Object)future);
                ArrayList<ServerGroup> listOfFailedServerGroups = (ArrayList<ServerGroup>)this.evcacheEvent.getAttribute("FailedServerGroups");
                if (listOfFailedServerGroups == null) {
                    listOfFailedServerGroups = new ArrayList<ServerGroup>(failCount);
                    this.evcacheEvent.setAttribute("FailedServerGroups", listOfFailedServerGroups);
                }
                listOfFailedServerGroups.add(evcFuture.getServerGroup());
                tags.add((Tag)new BasicTag("failedServerGroup", evcFuture.getServerGroup().getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug("Fail Count : " + failCount);
            }
            tags.add((Tag)new BasicTag("failCount", String.valueOf(failCount)));
            if (failCount > 0 && this.evcacheEvent.getClients().size() > 0 && (iterator = this.evcacheEvent.getClients().iterator()).hasNext()) {
                EVCacheClient client = (EVCacheClient)iterator.next();
                List<EVCacheEventListener> evcacheEventListenerList = client.getPool().getEVCacheClientPoolManager().getEVCacheEventListeners();
                if (log.isDebugEnabled()) {
                    log.debug("\nClient : " + client + "\nEvcacheEventListenerList : " + evcacheEventListenerList);
                }
                for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
                    evcacheEventListener.onError(this.evcacheEvent, null);
                }
            }
        }
        EVCacheMetricsFactory.getInstance().getCounter("internal.evcache.client.latch", tags).increment();
    }

    public int hashCode() {
        return this.evcacheEvent == null ? 0 : this.evcacheEvent.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EVCacheLatchImpl other = (EVCacheLatchImpl)obj;
        if (this.appName == null ? other.appName != null : !this.appName.equals(other.appName)) {
            return false;
        }
        return !(this.evcacheEvent == null ? other.evcacheEvent != null : !this.evcacheEvent.equals(other.evcacheEvent));
    }

    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }
}

