/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.Weigher;
import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.util.EVCacheConfig;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheInMemoryCache<T> {
    private static final Logger log = LoggerFactory.getLogger(EVCacheInMemoryCache.class);
    private final DynamicIntProperty _cacheDuration;
    private final DynamicIntProperty _cacheSize;
    private final String appName;
    private Cache<String, T> cache;

    public EVCacheInMemoryCache(String appName) {
        this.appName = appName;
        this._cacheDuration = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".inmemory.cache.duration.ms", 20);
        this._cacheDuration.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheInMemoryCache.this.setupCache();
            }
        });
        this._cacheSize = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".inmemory.cache.size", 100);
        this._cacheSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheInMemoryCache.this.setupCache();
            }
        });
        this.setupCache();
    }

    private void setupCache() {
        try {
            Cache<String, T> currentCache = this.cache;
            CacheBuilder builder = CacheBuilder.newBuilder().recordStats();
            if (this._cacheSize.get() > 0) {
                builder = builder.maximumSize((long)this._cacheSize.get());
            }
            if (this._cacheDuration.get() > 0) {
                builder = builder.expireAfterWrite((long)this._cacheDuration.get(), TimeUnit.MILLISECONDS);
            }
            this.setupMonitoring(this.appName);
            this.cache = builder.build();
            if (currentCache != null) {
                currentCache.invalidateAll();
                currentCache.cleanUp();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private long getSize() {
        long size = this.cache.size();
        CacheStats stats = this.cache.stats();
        EVCacheMetricsFactory.getInstance().getRegistry().counter("EVCacheInMemoryCache-" + this.appName + "-hits").increment(stats.hitCount());
        EVCacheMetricsFactory.getInstance().getRegistry().counter("EVCacheInMemoryCache-" + this.appName + "-miss").increment(stats.missCount());
        EVCacheMetricsFactory.getInstance().getRegistry().counter("EVCacheInMemoryCache-" + this.appName + "-evictions").increment(stats.evictionCount());
        EVCacheMetricsFactory.getInstance().getRegistry().counter("EVCacheInMemoryCache-" + this.appName + "-requests").increment(stats.requestCount());
        EVCacheMetricsFactory.getInstance().getRegistry().gauge("EVCacheInMemoryCache-" + this.appName + "-hitrate", (Object)stats, CacheStats::hitRate);
        return size;
    }

    private void setupMonitoring(String appName) {
        EVCacheMetricsFactory.getInstance().getRegistry().gauge("EVCacheInMemoryCache-" + appName + "-size", (Object)this, EVCacheInMemoryCache::getSize);
    }

    public T get(String key) {
        if (this.cache == null) {
            return null;
        }
        Object val = this.cache.getIfPresent((Object)key);
        if (log.isDebugEnabled()) {
            log.debug("GET : appName : " + this.appName + "; Key : " + key + "; val : " + val);
        }
        return (T)val;
    }

    public void put(String key, T value) {
        if (this.cache == null) {
            return;
        }
        this.cache.put((Object)key, value);
        if (log.isDebugEnabled()) {
            log.debug("PUT : appName : " + this.appName + "; Key : " + key + "; val : " + value);
        }
    }

    public void delete(String key) {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidate((Object)key);
        if (log.isDebugEnabled()) {
            log.debug("DEL : appName : " + this.appName + "; Key : " + key);
        }
    }

    static class DataWeigher
    implements Weigher<Object, Object> {
        private Transcoder<?> transcoder;

        DataWeigher() {
        }

        public Transcoder<?> getTranscoder() {
            return this.transcoder;
        }

        public void setTranscoder(Transcoder<?> transcoder) {
            this.transcoder = transcoder;
        }

        public int weigh(Object key, Object value) {
            return 0;
        }
    }
}

