/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.eureka;

import com.google.common.net.InetAddresses;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheServerGroupConfig;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.spectator.api.BasicTag;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaNodeListProvider
implements EVCacheNodeList {
    private static final Logger log = LoggerFactory.getLogger(EurekaNodeListProvider.class);
    private final EurekaClient _eurekaClient;
    private PropertyRepository props;
    private final ApplicationInfoManager applicationInfoManager;
    private final Map<String, Property<Boolean>> useRendBatchPortMap = new HashMap<String, Property<Boolean>>();
    private Property<Set> ignoreHosts = null;

    public EurekaNodeListProvider(ApplicationInfoManager applicationInfoManager, EurekaClient eurekaClient, PropertyRepository props) {
        this.applicationInfoManager = applicationInfoManager;
        this._eurekaClient = eurekaClient;
        this.props = props;
    }

    public Map<ServerGroup, EVCacheServerGroupConfig> discoverInstances(String _appName) throws IOException {
        Property ignoreAppEurekaStatus = this.props.get("evcache.ignoreAppEurekaStatus", Boolean.class).orElse((Object)false);
        if (((Boolean)ignoreAppEurekaStatus.get()).booleanValue()) {
            log.info("Not going to consider the eureka status of the application, to initialize evcache client.");
        }
        if (!((Boolean)ignoreAppEurekaStatus.get()).booleanValue() && this.applicationInfoManager.getInfo().getStatus() == InstanceInfo.InstanceStatus.DOWN) {
            log.info("Not initializing evcache client as application eureka status is DOWN. One can override this behavior by setting evcache.ignoreAppEurekaStatus property to true, scoped to your application.");
            return Collections.emptyMap();
        }
        Application app = this._eurekaClient.getApplication(_appName);
        if (app == null) {
            return Collections.emptyMap();
        }
        List appInstances = app.getInstances();
        HashMap<ServerGroup, EVCacheServerGroupConfig> instancesSpecific = new HashMap<ServerGroup, EVCacheServerGroupConfig>();
        for (InstanceInfo iInfo : appInstances) {
            Set<InetSocketAddress> instances;
            EVCacheServerGroupConfig config;
            ServerGroup serverGroup;
            DataCenterInfo dcInfo = iInfo.getDataCenterInfo();
            if (dcInfo == null) {
                if (!log.isErrorEnabled()) continue;
                log.error("Data Center Info is null for appName - " + _appName);
                continue;
            }
            if (DataCenterInfo.Name.Amazon != dcInfo.getName() || !(dcInfo instanceof AmazonInfo)) {
                log.error("This is not an AWSDataCenter. You will not be able to use Discovery Nodelist Provider. Cannot proceed. DataCenterInfo : {}; appName - {}. Please use SimpleNodeList provider and specify the server groups manually.", (Object)dcInfo, (Object)_appName);
                continue;
            }
            AmazonInfo amznInfo = (AmazonInfo)dcInfo;
            String zone = amznInfo.get(AmazonInfo.MetaDataKey.availabilityZone);
            if (zone == null) {
                ArrayList<BasicTag> tagList = new ArrayList<BasicTag>(3);
                EVCacheMetricsFactory.getInstance().addAppNameTags(tagList, _appName);
                tagList.add(new BasicTag("evc.config", "nullZone"));
                EVCacheMetricsFactory.getInstance().increment("internal.evc.client.config", tagList);
                continue;
            }
            String asgName = iInfo.getASGName();
            if (asgName == null) {
                ArrayList<BasicTag> tagList = new ArrayList<BasicTag>(3);
                EVCacheMetricsFactory.getInstance().addAppNameTags(tagList, _appName);
                tagList.add(new BasicTag("evc.config", "nullASG"));
                EVCacheMetricsFactory.getInstance().increment("internal.evc.client.config", tagList);
                continue;
            }
            Property asgEnabled = this.props.get(asgName + ".enabled", Boolean.class).orElse((Object)true);
            if (!((Boolean)asgEnabled.get()).booleanValue()) {
                if (!log.isDebugEnabled()) continue;
                log.debug("ASG " + asgName + " is disabled so ignoring it");
                continue;
            }
            Map metaInfo = iInfo.getMetadata();
            int evcachePort = Integer.parseInt(metaInfo != null && metaInfo.containsKey("evcache.port") ? (String)metaInfo.get("evcache.port") : "11211");
            int rendPort = metaInfo != null && metaInfo.containsKey("rend.port") ? Integer.parseInt((String)metaInfo.get("rend.port")) : 0;
            int rendBatchPort = metaInfo != null && metaInfo.containsKey("rend.batch.port") ? Integer.parseInt((String)metaInfo.get("rend.batch.port")) : 0;
            int udsproxyMemcachedPort = metaInfo != null && metaInfo.containsKey("udsproxy.memcached.port") ? Integer.parseInt((String)metaInfo.get("udsproxy.memcached.port")) : 0;
            int udsproxyMementoPort = metaInfo != null && metaInfo.containsKey("udsproxy.memento.port") ? Integer.parseInt((String)metaInfo.get("udsproxy.memento.port")) : 0;
            Property useBatchPort = this.useRendBatchPortMap.get(asgName);
            if (useBatchPort == null) {
                useBatchPort = this.props.get(_appName + ".use.batch.port", Boolean.class).orElseGet("evcache.use.batch.port").orElse((Object)false);
                this.useRendBatchPortMap.put(asgName, (Property<Boolean>)useBatchPort);
            }
            int port = rendPort == 0 ? evcachePort : ((Boolean)useBatchPort.get() != false ? rendBatchPort : rendPort);
            Property isSecure = this.props.get(asgName + ".use.secure", Boolean.class).orElseGet(_appName + ".use.secure").orElse((Object)false);
            if (((Boolean)isSecure.get()).booleanValue()) {
                port = Integer.parseInt(metaInfo != null && metaInfo.containsKey("evcache.secure.port") ? (String)metaInfo.get("evcache.secure.port") : "11443");
            }
            if (instancesSpecific.containsKey(serverGroup = new ServerGroup(zone, asgName))) {
                config = (EVCacheServerGroupConfig)instancesSpecific.get(serverGroup);
                instances = config.getInetSocketAddress();
            } else {
                instances = new HashSet();
                config = new EVCacheServerGroupConfig(serverGroup, instances, rendPort, udsproxyMemcachedPort, udsproxyMementoPort);
                instancesSpecific.put(serverGroup, config);
            }
            InstanceInfo.InstanceStatus status = iInfo.getStatus();
            if (status == null || InstanceInfo.InstanceStatus.OUT_OF_SERVICE == status || InstanceInfo.InstanceStatus.DOWN == status) {
                if (!log.isDebugEnabled()) continue;
                log.debug("The Status of the instance in Discovery is " + status + ". App Name : " + _appName + "; Zone : " + zone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                continue;
            }
            InstanceInfo myInfo = this.applicationInfoManager.getInfo();
            DataCenterInfo myDC = myInfo.getDataCenterInfo();
            AmazonInfo myAmznDC = myDC instanceof AmazonInfo ? (AmazonInfo)myDC : null;
            String myInstanceId = myInfo.getInstanceId();
            String myIp = myInfo.getIPAddr();
            String myPublicHostName = myAmznDC != null ? myAmznDC.get(AmazonInfo.MetaDataKey.publicHostname) : null;
            boolean isInCloud = false;
            if (myPublicHostName != null) {
                isInCloud = myPublicHostName.startsWith("ec2");
            }
            if (!isInCloud) {
                if (myAmznDC != null && myAmznDC.get(AmazonInfo.MetaDataKey.vpcId) != null) {
                    isInCloud = true;
                } else if (myIp.equals(myInstanceId)) {
                    isInCloud = false;
                }
            }
            String myZone = myAmznDC != null ? myAmznDC.get(AmazonInfo.MetaDataKey.availabilityZone) : null;
            String myRegion = myZone != null ? myZone.substring(0, myZone.length() - 1) : null;
            String region = zone != null ? zone.substring(0, zone.length() - 1) : null;
            String host = amznInfo.get(AmazonInfo.MetaDataKey.publicHostname);
            InetSocketAddress address = null;
            String vpcId = amznInfo.get(AmazonInfo.MetaDataKey.vpcId);
            String localIp = amznInfo.get(AmazonInfo.MetaDataKey.localIpv4);
            if (log.isDebugEnabled()) {
                log.debug("myZone - " + myZone + "; zone : " + zone + "; myRegion : " + myRegion + "; region : " + region + "; host : " + host + "; vpcId : " + vpcId);
            }
            if (this.ignoreHosts == null) {
                this.ignoreHosts = this.props.get(_appName + ".ignore.hosts", Set.class).orElse(Collections.emptySet());
            }
            if (localIp != null && ((Set)this.ignoreHosts.get()).contains(localIp) || host != null && ((Set)this.ignoreHosts.get()).contains(host)) continue;
            if (vpcId != null) {
                InetAddress add = InetAddresses.forString((String)localIp);
                InetAddress inetAddress = InetAddress.getByAddress(localIp, add.getAddress());
                address = new InetSocketAddress(inetAddress, port);
                if (log.isDebugEnabled()) {
                    log.debug("VPC : localIp - " + localIp + " ; add : " + add + "; inetAddress : " + inetAddress + "; address - " + address + "; App Name : " + _appName + "; Zone : " + zone + "; myZone - " + myZone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                }
            } else if (host != null && host.startsWith("ec2")) {
                InetAddress inetAddress = localIp != null ? InetAddress.getByAddress(host, InetAddresses.forString((String)localIp).getAddress()) : InetAddress.getByName(host);
                address = new InetSocketAddress(inetAddress, port);
                if (log.isDebugEnabled()) {
                    log.debug("myZone - " + myZone + ". host : " + host + "; inetAddress : " + inetAddress + "; address - " + address + "; App Name : " + _appName + "; Zone : " + zone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                }
            } else {
                String ipToUse = isInCloud ? localIp : amznInfo.get(AmazonInfo.MetaDataKey.publicIpv4);
                InetAddress add = InetAddresses.forString((String)ipToUse);
                InetAddress inetAddress = InetAddress.getByAddress(ipToUse, add.getAddress());
                address = new InetSocketAddress(inetAddress, port);
                if (log.isDebugEnabled()) {
                    log.debug("CLASSIC : IPToUse - " + ipToUse + " ; add : " + add + "; inetAddress : " + inetAddress + "; address - " + address + "; App Name : " + _appName + "; Zone : " + zone + "; myZone - " + myZone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                }
            }
            instances.add(address);
        }
        return instancesSpecific;
    }
}

