/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.connection;

import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.discovery.EurekaClient;
import com.netflix.evcache.connection.ConnectionFactoryBuilder;
import com.netflix.evcache.connection.DIAsciiConnectionFactory;
import com.netflix.evcache.connection.DIConnectionFactory;
import com.netflix.evcache.connection.IConnectionBuilder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.util.EVCacheConfig;
import javax.inject.Inject;
import javax.inject.Provider;
import net.spy.memcached.ConnectionFactory;

public class DIConnectionFactoryBuilderProvider
extends ConnectionFactoryBuilder
implements Provider<IConnectionBuilder> {
    private final EurekaClient eurekaClient;
    private PropertyRepository props;

    @Inject
    public DIConnectionFactoryBuilderProvider(EurekaClient eurekaClient, PropertyRepository props) {
        this.eurekaClient = eurekaClient;
        this.props = props;
    }

    public ConnectionFactoryBuilder get() {
        return this;
    }

    public ConnectionFactory getConnectionFactory(EVCacheClient client) {
        String appName = client.getAppName();
        int maxQueueSize = (Integer)this.props.get(appName + ".max.queue.length", Integer.class).orElse((Object)16384).get();
        Property operationTimeout = this.props.get(appName + ".operation.timeout", Integer.class).orElse((Object)2500);
        int opQueueMaxBlockTime = (Integer)this.props.get(appName + ".operation.QueueMaxBlockTime", Integer.class).orElse((Object)10).get();
        boolean useBinary = (Boolean)EVCacheConfig.getInstance().getPropertyRepository().get("evcache.use.binary.protocol", Boolean.class).orElse((Object)true).get();
        if (useBinary) {
            return new DIConnectionFactory(client, this.eurekaClient, maxQueueSize, (Property<Integer>)operationTimeout, opQueueMaxBlockTime);
        }
        return new DIAsciiConnectionFactory(client, this.eurekaClient, maxQueueSize, (Property<Integer>)operationTimeout, opQueueMaxBlockTime);
    }
}

