/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.netflix.evcache.connection.DIConnectionModule;
import com.netflix.evcache.event.hotkey.HotKeyListener;
import com.netflix.evcache.event.throttle.ThrottleListener;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.eureka.DIEVCacheNodeListProvider;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@Singleton
public class EVCacheModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new DIConnectionModule());
        this.bind(EVCacheNodeList.class).toProvider(DIEVCacheNodeListProvider.class);
        this.bind(EVCacheClientPoolManager.class).asEagerSingleton();
        this.bind(HotKeyListener.class).asEagerSingleton();
        this.bind(ThrottleListener.class).asEagerSingleton();
    }

    @PostConstruct
    public void init() {
        EVCacheClientPoolManager.getInstance().initAtStartup();
    }

    @PreDestroy
    public void shutdown() {
        EVCacheClientPoolManager.getInstance().shutdown();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }
}

