/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.event.hotkey;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicStringSetProperty;
import com.netflix.evcache.event.EVCacheEvent;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.util.EVCacheConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HotKeyListener
implements EVCacheEventListener {
    private static final Logger log = LoggerFactory.getLogger(HotKeyListener.class);
    private final Map<String, DynamicBooleanProperty> throttleMap;
    private final Map<String, Cache<String, Integer>> cacheMap;
    private final Integer START_VAL = 1;
    private final DynamicBooleanProperty enableThrottleHotKeys;
    private final EVCacheClientPoolManager poolManager;
    private final Map<String, DynamicStringSetProperty> throttleKeysMap;

    @Inject
    public HotKeyListener(EVCacheClientPoolManager poolManager) {
        this.poolManager = poolManager;
        this.throttleKeysMap = new ConcurrentHashMap<String, DynamicStringSetProperty>();
        this.throttleMap = new ConcurrentHashMap<String, DynamicBooleanProperty>();
        this.cacheMap = new ConcurrentHashMap<String, Cache<String, Integer>>();
        this.enableThrottleHotKeys = EVCacheConfig.getInstance().getDynamicBooleanProperty("EVCacheThrottler.throttle.hot.keys", false);
        this.enableThrottleHotKeys.addCallback(new Runnable(){

            @Override
            public void run() {
                HotKeyListener.this.setupHotKeyListener();
            }
        });
        if (this.enableThrottleHotKeys.get()) {
            this.setupHotKeyListener();
        }
    }

    private void setupHotKeyListener() {
        if (this.enableThrottleHotKeys.get()) {
            this.poolManager.addEVCacheEventListener(this);
        } else {
            this.poolManager.removeEVCacheEventListener(this);
            for (Cache<String, Integer> cache : this.cacheMap.values()) {
                cache.invalidateAll();
            }
        }
    }

    private Cache<String, Integer> getCache(String appName) {
        DynamicBooleanProperty throttleFlag = this.throttleMap.get(appName);
        if (throttleFlag == null) {
            throttleFlag = EVCacheConfig.getInstance().getDynamicBooleanProperty("EVCacheThrottler." + appName + ".throttle.hot.keys", false);
            this.throttleMap.put(appName, throttleFlag);
        }
        if (log.isDebugEnabled()) {
            log.debug("Throttle hot keys : " + throttleFlag);
        }
        if (!throttleFlag.get()) {
            return null;
        }
        Cache cache = this.cacheMap.get(appName);
        if (cache != null) {
            return cache;
        }
        DynamicIntProperty _cacheDuration = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheThrottler." + appName + ".inmemory.expire.after.write.duration.ms", 10000);
        DynamicIntProperty _exireAfterAccessDuration = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheThrottler." + appName + ".inmemory.expire.after.access.duration.ms", 10000);
        DynamicIntProperty _cacheSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheThrottler." + appName + ".inmemory.cache.size", 100);
        CacheBuilder builder = CacheBuilder.newBuilder().recordStats();
        if (_cacheSize.get() > 0) {
            builder = builder.maximumSize((long)_cacheSize.get());
        }
        if (_exireAfterAccessDuration.get() > 0) {
            builder = builder.expireAfterAccess((long)_exireAfterAccessDuration.get(), TimeUnit.MILLISECONDS);
        } else if (_cacheDuration.get() > 0) {
            builder = builder.expireAfterWrite((long)_cacheDuration.get(), TimeUnit.MILLISECONDS);
        }
        cache = builder.build();
        this.cacheMap.put(appName, (Cache<String, Integer>)cache);
        return cache;
    }

    @Override
    public void onStart(EVCacheEvent e) {
        if (!this.enableThrottleHotKeys.get()) {
            return;
        }
        Cache<String, Integer> cache = this.getCache(e.getAppName());
        if (cache == null) {
            return;
        }
        for (String key : e.getKeys()) {
            Integer val = (Integer)cache.getIfPresent((Object)key);
            if (val == null) {
                cache.put((Object)key, (Object)this.START_VAL);
                continue;
            }
            cache.put((Object)key, (Object)(val + 1));
        }
    }

    @Override
    public boolean onThrottle(EVCacheEvent e) {
        Cache<String, Integer> cache;
        if (!this.enableThrottleHotKeys.get()) {
            return false;
        }
        String appName = e.getAppName();
        DynamicStringSetProperty throttleKeysSet = this.throttleKeysMap.get(appName);
        if (throttleKeysSet == null) {
            throttleKeysSet = new DynamicStringSetProperty(appName + ".throttle.keys", "");
        }
        if (throttleKeysSet.get().size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Throttle : " + throttleKeysSet);
            }
            for (String key : e.getKeys()) {
                if (!throttleKeysSet.get().contains(key)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Key : " + key + " is throttled");
                }
                return true;
            }
        }
        if ((cache = this.getCache(appName)) == null) {
            return false;
        }
        DynamicIntProperty _throttleVal = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheThrottler." + appName + ".throttle.value", 3);
        for (String key : e.getKeys()) {
            Integer val = (Integer)cache.getIfPresent((Object)key);
            if (val <= _throttleVal.get()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Key : " + key + " has exceeded " + _throttleVal.get() + ". Will throttle this request");
            }
            return true;
        }
        return false;
    }

    @Override
    public void onComplete(EVCacheEvent e) {
        if (!this.enableThrottleHotKeys.get()) {
            return;
        }
        String appName = e.getAppName();
        Cache<String, Integer> cache = this.getCache(appName);
        if (cache == null) {
            return;
        }
        for (String key : e.getKeys()) {
            Integer val = (Integer)cache.getIfPresent((Object)key);
            if (val == null) continue;
            cache.put((Object)key, (Object)(val - 1));
        }
    }

    @Override
    public void onError(EVCacheEvent e, Throwable t) {
        if (!this.enableThrottleHotKeys.get()) {
            return;
        }
        String appName = e.getAppName();
        Cache<String, Integer> cache = this.getCache(appName);
        if (cache == null) {
            return;
        }
        for (String key : e.getKeys()) {
            Integer val = (Integer)cache.getIfPresent((Object)key);
            if (val == null) continue;
            cache.put((Object)key, (Object)(val - 1));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheMap == null ? 0 : this.cacheMap.hashCode());
        result = 31 * result + (this.throttleMap == null ? 0 : this.throttleMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HotKeyListener other = (HotKeyListener)obj;
        if (this.cacheMap == null ? other.cacheMap != null : !this.cacheMap.equals(other.cacheMap)) {
            return false;
        }
        return !(this.throttleMap == null ? other.throttleMap != null : !this.throttleMap.equals(other.throttleMap));
    }
}

