/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheScheduledExecutorMBean;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.tag.Tag;
import java.lang.management.ManagementFactory;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheScheduledExecutor
extends ScheduledThreadPoolExecutor
implements EVCacheScheduledExecutorMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheScheduledExecutor.class);
    private final DynamicIntProperty maxAsyncPoolSize;
    private final DynamicIntProperty coreAsyncPoolSize;
    private final String name;

    public EVCacheScheduledExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, handler);
        this.name = name;
        this.maxAsyncPoolSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheScheduledExecutor." + name + ".max.size", maximumPoolSize);
        this.setMaximumPoolSize(this.maxAsyncPoolSize.get());
        this.coreAsyncPoolSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheScheduledExecutor." + name + ".core.size", corePoolSize);
        this.setCorePoolSize(this.coreAsyncPoolSize.get());
        this.setKeepAliveTime(keepAliveTime, unit);
        ThreadFactory asyncFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EVCacheScheduledExecutor-" + name + "-%d").build();
        this.setThreadFactory(asyncFactory);
        this.maxAsyncPoolSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheScheduledExecutor.this.setMaximumPoolSize(EVCacheScheduledExecutor.this.maxAsyncPoolSize.get());
            }
        });
        this.coreAsyncPoolSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheScheduledExecutor.this.setCorePoolSize(EVCacheScheduledExecutor.this.coreAsyncPoolSize.get());
                EVCacheScheduledExecutor.this.prestartAllCoreThreads();
            }
        });
        this.setupMonitoring(name);
    }

    private void setupMonitoring(String name) {
        block6: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("Exception", (Throwable)e);
            }
        }
        MonitorRegistry registry = DefaultMonitorRegistry.getInstance();
        MonitorConfig.Builder builder = MonitorConfig.builder((String)"EVCacheScheduledExecutor.currentQueueSize").withTag((Tag)DataSourceType.GAUGE).withTag(EVCacheMetricsFactory.OWNER);
        LongGauge queueSize = new LongGauge(builder.build()){

            public Number getValue() {
                return (long)EVCacheScheduledExecutor.this.getQueueSize();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }
        };
        if (registry.isRegistered((Monitor)queueSize)) {
            registry.unregister((Monitor)queueSize);
        }
        registry.register((Monitor)queueSize);
        MonitorConfig.Builder builderTasks = MonitorConfig.builder((String)"EVCacheScheduledExecutor.completedTaskCount").withTag((Tag)DataSourceType.COUNTER).withTag(EVCacheMetricsFactory.OWNER);
        StepCounter completedTaskCount = new StepCounter(builderTasks.build()){

            public Number getValue() {
                return EVCacheScheduledExecutor.this.getCompletedTaskCount();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }
        };
        if (registry.isRegistered((Monitor)completedTaskCount)) {
            registry.unregister((Monitor)completedTaskCount);
        }
        registry.register((Monitor)completedTaskCount);
    }

    @Override
    public void shutdown() {
        block2: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + this.name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                mbeanServer.unregisterMBean(mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Exception", (Throwable)e);
            }
        }
        super.shutdown();
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }
}

