/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.observer;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.pool.observer.EVCacheConnectionObserverMBean;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.ConnectionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheConnectionObserver
implements ConnectionObserver,
EVCacheConnectionObserverMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheConnectionObserver.class);
    private final InstanceInfo instanceInfo = ApplicationInfoManager.getInstance().getInfo();
    private final String appName;
    private final ServerGroup serverGroup;
    private final int id;
    private long lostCount = 0L;
    private long connectCount = 0L;
    private final Set<SocketAddress> evCacheActiveSet;
    private final Set<SocketAddress> evCacheInActiveSet;
    private final Map<InetSocketAddress, Long> evCacheActiveStringSet;
    private final Map<InetSocketAddress, Long> evCacheInActiveStringSet;
    private final String monitorName;

    public EVCacheConnectionObserver(String appName, ServerGroup serverGroup, int id) {
        this.appName = appName;
        this.serverGroup = serverGroup;
        this.evCacheActiveSet = Collections.newSetFromMap(new ConcurrentHashMap());
        this.evCacheInActiveSet = Collections.newSetFromMap(new ConcurrentHashMap());
        this.evCacheActiveStringSet = new ConcurrentHashMap<InetSocketAddress, Long>();
        this.evCacheInActiveStringSet = new ConcurrentHashMap<InetSocketAddress, Long>();
        this.id = id;
        this.monitorName = appName + "_" + serverGroup.getName() + "_" + id + "_connections";
        this.setupMonitoring(false);
    }

    public void connectionEstablished(SocketAddress sa, int reconnectCount) {
        String address = sa.toString();
        this.evCacheActiveSet.add(sa);
        this.evCacheInActiveSet.remove(sa);
        InetSocketAddress inetAdd = (InetSocketAddress)sa;
        this.evCacheActiveStringSet.put(inetAdd, System.currentTimeMillis());
        this.evCacheInActiveStringSet.remove(inetAdd);
        if (this.instanceInfo != null && log.isDebugEnabled()) {
            log.debug(this.appName + ":CONNECTION ESTABLISHED : From " + this.instanceInfo.getHostName() + " to " + address + " was established after " + reconnectCount + " retries");
        }
        if (log.isTraceEnabled()) {
            log.trace("Stack", (Throwable)new Exception());
        }
        EVCacheMetricsFactory.increment(this.appName, null, this.serverGroup.getName(), this.appName + "-CONNECT");
        ++this.connectCount;
    }

    public void connectionLost(SocketAddress sa) {
        String address = sa.toString();
        this.evCacheInActiveSet.add(sa);
        this.evCacheActiveSet.remove(sa);
        InetSocketAddress inetAdd = (InetSocketAddress)sa;
        this.evCacheInActiveStringSet.put(inetAdd, System.currentTimeMillis());
        this.evCacheActiveStringSet.remove(inetAdd);
        if (this.instanceInfo != null && log.isDebugEnabled()) {
            log.debug(this.appName + ":CONNECTION LOST : From " + this.instanceInfo.getHostName() + " to " + address);
        }
        if (log.isTraceEnabled()) {
            log.trace("Stack", (Throwable)new Exception());
        }
        BasicTag tag = new BasicTag("HOST", inetAdd.getAddress().getHostAddress());
        EVCacheMetricsFactory.getCounter(this.appName, null, this.serverGroup.getName(), this.appName + "-CONNECTION_LOST", (Tag)tag).increment();
        ++this.lostCount;
    }

    @Override
    public int getActiveServerCount() {
        return this.evCacheActiveSet.size();
    }

    @Override
    public Set<SocketAddress> getActiveServerNames() {
        return this.evCacheActiveSet;
    }

    @Override
    public int getInActiveServerCount() {
        return this.evCacheInActiveSet.size();
    }

    @Override
    public Set<SocketAddress> getInActiveServerNames() {
        return this.evCacheInActiveSet;
    }

    @Override
    public long getLostCount() {
        return this.lostCount;
    }

    @Override
    public long getConnectCount() {
        return this.connectCount;
    }

    public Map<InetSocketAddress, Long> getInActiveServers() {
        return this.evCacheInActiveStringSet;
    }

    public Map<InetSocketAddress, Long> getActiveServers() {
        return this.evCacheActiveStringSet;
    }

    private void setupMonitoring(boolean shutdown) {
        block6: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this.appName + ",SubGroup=pool,SubSubGroup=" + this.serverGroup.getName() + ",SubSubSubGroup=" + this.id);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                if (!shutdown) {
                    mbeanServer.registerMBean(this, mBeanName);
                    Monitors.registerObject((Object)this);
                } else {
                    Monitors.unregisterObject((Object)this);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void unRegisterInActiveNodes() {
        block4: {
            try {
                for (SocketAddress sa : this.evCacheInActiveSet) {
                    ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this.appName + ",SubGroup=pool" + ",SubSubGroup=" + this.serverGroup.getName() + ",SubSubSubGroup=" + this.id + ",SubSubSubSubGroup=" + ((InetSocketAddress)sa).getHostName());
                    MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                    if (!mbeanServer.isRegistered(mBeanName)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.unRegisterInActiveNodes();
        this.setupMonitoring(true);
    }

    public String toString() {
        return "EVCacheConnectionObserver [instanceInfo=" + this.instanceInfo + ", appName=" + this.appName + ", ServerGroup=" + this.serverGroup.toString() + ", id=" + this.id + ", evCacheActiveSet=" + this.evCacheActiveSet + ", evCacheInActiveSet=" + this.evCacheInActiveSet + ", evCacheActiveStringSet=" + this.evCacheActiveStringSet + ", evCacheInActiveStringSet=" + this.evCacheInActiveStringSet + ", monitorName=" + this.monitorName + "]";
    }

    public String getAppName() {
        return this.appName;
    }

    public String getServerGroup() {
        return this.serverGroup.toString();
    }

    public int getId() {
        return this.id;
    }
}

