/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.net.InetAddresses;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicStringSetProperty;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.shared.Application;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheServerGroupConfig;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryNodeListProvider
implements EVCacheNodeList {
    public static final String DEFAULT_PORT = "11211";
    private static Logger log = LoggerFactory.getLogger(DiscoveryNodeListProvider.class);
    private final DiscoveryClient _discoveryClient;
    private final String _appName;
    private final ApplicationInfoManager applicationInfoManager;
    private final Map<String, ChainedDynamicProperty.BooleanProperty> useRendBatchPortMap = new HashMap<String, ChainedDynamicProperty.BooleanProperty>();
    private final DynamicStringSetProperty ignoreHosts;

    public DiscoveryNodeListProvider(ApplicationInfoManager applicationInfoManager, DiscoveryClient discoveryClient, String appName) {
        this.applicationInfoManager = applicationInfoManager;
        this._discoveryClient = discoveryClient;
        this._appName = appName;
        this.ignoreHosts = new DynamicStringSetProperty(appName + ".ignore.hosts", "");
    }

    @Override
    public Map<ServerGroup, EVCacheServerGroupConfig> discoverInstances() throws IOException {
        if (this.applicationInfoManager.getInfo().getStatus() == InstanceInfo.InstanceStatus.DOWN) {
            return Collections.emptyMap();
        }
        Application app = this._discoveryClient.getApplication(this._appName);
        if (app == null) {
            return Collections.emptyMap();
        }
        List appInstances = app.getInstances();
        HashMap<ServerGroup, EVCacheServerGroupConfig> instancesSpecific = new HashMap<ServerGroup, EVCacheServerGroupConfig>();
        for (InstanceInfo iInfo : appInstances) {
            HashSet<InetSocketAddress> instances;
            EVCacheServerGroupConfig config;
            DataCenterInfo dcInfo = iInfo.getDataCenterInfo();
            if (dcInfo == null) {
                if (!log.isErrorEnabled()) continue;
                log.error("Data Center Info is null for appName - " + this._appName);
                continue;
            }
            if (DataCenterInfo.Name.Amazon != dcInfo.getName() || !(dcInfo instanceof AmazonInfo)) {
                log.error("This is not a AWSDataCenter. You will not be able to use Discovery Nodelist Provider. Cannot proceed. DataCenterInfo : " + dcInfo + "; appName - " + this._appName + ". Please use SimpleNodeList provider and specify the server groups manually.");
                continue;
            }
            AmazonInfo amznInfo = (AmazonInfo)dcInfo;
            String zone = amznInfo.get(AmazonInfo.MetaDataKey.availabilityZone);
            if (zone == null) {
                EVCacheMetricsFactory.increment(this._appName, null, "EVCacheClient-DiscoveryNodeListProvider-NULL_ZONE");
                continue;
            }
            String asgName = iInfo.getASGName();
            if (asgName == null) {
                EVCacheMetricsFactory.increment(this._appName, null, "EVCacheClient-DiscoveryNodeListProvider-NULL_SERVER_GROUP");
                continue;
            }
            Map metaInfo = iInfo.getMetadata();
            int evcachePort = Integer.parseInt(metaInfo != null && metaInfo.containsKey("evcache.port") ? (String)metaInfo.get("evcache.port") : DEFAULT_PORT);
            int rendPort = metaInfo != null && metaInfo.containsKey("rend.port") ? Integer.parseInt((String)metaInfo.get("rend.port")) : 0;
            int rendBatchPort = metaInfo != null && metaInfo.containsKey("rend.batch.port") ? Integer.parseInt((String)metaInfo.get("rend.batch.port")) : 0;
            int udsproxyMemcachedPort = metaInfo != null && metaInfo.containsKey("udsproxy.memcached.port") ? Integer.parseInt((String)metaInfo.get("udsproxy.memcached.port")) : 0;
            int udsproxyMementoPort = metaInfo != null && metaInfo.containsKey("udsproxy.memento.port") ? Integer.parseInt((String)metaInfo.get("udsproxy.memento.port")) : 0;
            ChainedDynamicProperty.BooleanProperty useBatchPort = this.useRendBatchPortMap.get(asgName);
            if (useBatchPort == null) {
                useBatchPort = EVCacheConfig.getInstance().getChainedBooleanProperty(this._appName + ".use.batch.port", "evcache.use.batch.port", Boolean.FALSE, null);
                this.useRendBatchPortMap.put(asgName, useBatchPort);
            }
            int port = rendPort == 0 ? evcachePort : ((Boolean)useBatchPort.get() != false ? rendBatchPort : rendPort);
            ServerGroup serverGroup = new ServerGroup(zone, asgName);
            if (instancesSpecific.containsKey(serverGroup)) {
                config = (EVCacheServerGroupConfig)instancesSpecific.get(serverGroup);
                instances = config.getInetSocketAddress();
            } else {
                instances = new HashSet();
                config = new EVCacheServerGroupConfig(serverGroup, instances, rendPort, udsproxyMemcachedPort, udsproxyMementoPort);
                instancesSpecific.put(serverGroup, config);
                EVCacheMetricsFactory.getLongGauge(this._appName + "-port", (TagList)BasicTagList.of((String[])new String[]{"ServerGroup", asgName, "APP", this._appName})).set(Long.valueOf(port));
            }
            InstanceInfo.InstanceStatus status = iInfo.getStatus();
            if (status == null || InstanceInfo.InstanceStatus.OUT_OF_SERVICE == status || InstanceInfo.InstanceStatus.DOWN == status) {
                if (!log.isDebugEnabled()) continue;
                log.debug("The Status of the instance in Discovery is " + status + ". App Name : " + this._appName + "; Zone : " + zone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                continue;
            }
            InstanceInfo myInfo = this.applicationInfoManager.getInfo();
            DataCenterInfo myDC = myInfo.getDataCenterInfo();
            AmazonInfo myAmznDC = myDC instanceof AmazonInfo ? (AmazonInfo)myDC : null;
            String myInstanceId = myInfo.getInstanceId();
            String myIp = myInfo.getIPAddr();
            String myPublicHostName = myAmznDC != null ? myAmznDC.get(AmazonInfo.MetaDataKey.publicHostname) : null;
            boolean isInCloud = false;
            if (myPublicHostName != null) {
                isInCloud = myPublicHostName.startsWith("ec2");
            }
            if (!isInCloud) {
                if (myAmznDC != null && myAmznDC.get(AmazonInfo.MetaDataKey.vpcId) != null) {
                    isInCloud = true;
                } else if (myIp.equals(myInstanceId)) {
                    isInCloud = false;
                }
            }
            String myZone = myAmznDC != null ? myAmznDC.get(AmazonInfo.MetaDataKey.availabilityZone) : null;
            String myRegion = myZone != null ? myZone.substring(0, myZone.length() - 1) : null;
            String region = zone != null ? zone.substring(0, zone.length() - 1) : null;
            String host = amznInfo.get(AmazonInfo.MetaDataKey.publicHostname);
            InetSocketAddress address = null;
            String vpcId = amznInfo.get(AmazonInfo.MetaDataKey.vpcId);
            String localIp = amznInfo.get(AmazonInfo.MetaDataKey.localIpv4);
            if (log.isDebugEnabled()) {
                log.debug("myZone - " + myZone + "; zone : " + zone + "; myRegion : " + myRegion + "; region : " + region + "; host : " + host + "; vpcId : " + vpcId);
            }
            if (localIp != null && this.ignoreHosts.get().contains(localIp) || host != null && this.ignoreHosts.get().contains(host)) continue;
            if (vpcId != null) {
                InetAddress add = InetAddresses.forString((String)localIp);
                InetAddress inetAddress = InetAddress.getByAddress(localIp, add.getAddress());
                address = new InetSocketAddress(inetAddress, port);
                if (log.isDebugEnabled()) {
                    log.debug("VPC : localIp - " + localIp + " ; add : " + add + "; inetAddress : " + inetAddress + "; address - " + address + "; App Name : " + this._appName + "; Zone : " + zone + "; myZone - " + myZone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                }
            } else if (host != null && host.startsWith("ec2")) {
                InetAddress inetAddress = localIp != null ? InetAddress.getByAddress(host, InetAddresses.forString((String)localIp).getAddress()) : InetAddress.getByName(host);
                address = new InetSocketAddress(inetAddress, port);
                if (log.isDebugEnabled()) {
                    log.debug("myZone - " + myZone + ". host : " + host + "; inetAddress : " + inetAddress + "; address - " + address + "; App Name : " + this._appName + "; Zone : " + zone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                }
            } else {
                String ipToUse = isInCloud ? localIp : amznInfo.get(AmazonInfo.MetaDataKey.publicIpv4);
                InetAddress add = InetAddresses.forString((String)ipToUse);
                InetAddress inetAddress = InetAddress.getByAddress(ipToUse, add.getAddress());
                address = new InetSocketAddress(inetAddress, port);
                if (log.isDebugEnabled()) {
                    log.debug("CLASSIC : IPToUse - " + ipToUse + " ; add : " + add + "; inetAddress : " + inetAddress + "; address - " + address + "; App Name : " + this._appName + "; Zone : " + zone + "; myZone - " + myZone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                }
            }
            instances.add(address);
        }
        return instancesSpecific;
    }
}

