/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.connection;

import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.connection.BaseConnectionFactory;
import com.netflix.evcache.connection.IConnectionFactoryProvider;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import net.spy.memcached.ConnectionFactory;

public class ConnectionFactoryProvider
implements IConnectionFactoryProvider {
    @Override
    public ConnectionFactory getConnectionFactory(String appName, int id, ServerGroup serverGroup, EVCacheClientPoolManager poolManager) {
        int maxQueueSize = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".max.queue.length", 16384).get();
        DynamicIntProperty operationTimeout = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".operation.timeout", 2500);
        int opQueueMaxBlockTime = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".operation.QueueMaxBlockTime", 10).get();
        return new BaseConnectionFactory(appName, maxQueueSize, operationTimeout, opQueueMaxBlockTime, id, serverGroup, poolManager);
    }
}

