/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.ChunkTranscoder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.spectator.api.DistributionSummary;
import java.util.List;
import java.util.concurrent.Future;
import net.spy.memcached.CachedData;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheClientUtil {
    private static Logger log = LoggerFactory.getLogger(EVCacheClientUtil.class);
    private static final ChunkTranscoder ct = new ChunkTranscoder();

    public static EVCacheLatch add(final String canonicalKey, CachedData cd, final int timeToLive, final EVCacheClientPool _pool, EVCacheLatch.Policy policy) throws Exception {
        DistributionSummary addTTLSummary;
        if (cd == null) {
            return null;
        }
        final String _appName = _pool.getAppName();
        DistributionSummary addDataSizeSummary = EVCacheMetricsFactory.getDistributionSummary(_appName + "-AddData-Size", _appName, null);
        if (addDataSizeSummary != null) {
            addDataSizeSummary.record((long)cd.getData().length);
        }
        if ((addTTLSummary = EVCacheMetricsFactory.getDistributionSummary(_appName + "-AddData-TTL", _appName, null)) != null) {
            addTTLSummary.record((long)timeToLive);
        }
        EVCacheClient[] clients = _pool.getEVCacheClientForWrite();
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy, clients.length, _pool.getAppName()){

            @Override
            public void onComplete(OperationFuture<?> operationFuture) throws Exception {
                if (this.getPendingCount() > 1) {
                    super.onComplete(operationFuture);
                } else {
                    List<Future<Boolean>> futures = this.getAllFutures();
                    int successCount = 0;
                    int failCount = 0;
                    for (int i = 0; i < futures.size(); ++i) {
                        Future<Boolean> future = futures.get(i);
                        if (!(future instanceof EVCacheOperationFuture)) continue;
                        EVCacheOperationFuture f = (EVCacheOperationFuture)((Object)future);
                        if (f.getStatus().getStatusCode() == StatusCode.SUCCESS) {
                            ++successCount;
                            if (!log.isDebugEnabled()) continue;
                            log.debug("ADD : Success : APP " + _appName + ", key " + canonicalKey + ", ServerGroup : " + f.getServerGroup().getName());
                            continue;
                        }
                        ++failCount;
                        if (!log.isDebugEnabled()) continue;
                        log.debug("ADD : Fail : APP " + _appName + ", key : " + canonicalKey + ", ServerGroup : " + f.getServerGroup().getName());
                    }
                    if (successCount > 0 && failCount > 0) {
                        EVCacheClient client;
                        EVCacheOperationFuture f;
                        Future<Boolean> evFuture;
                        int i;
                        CachedData readData = null;
                        for (i = 0; i < futures.size(); ++i) {
                            evFuture = futures.get(i);
                            if (!(evFuture instanceof EVCacheOperationFuture) || (f = (EVCacheOperationFuture)((Object)evFuture)).getStatus().getStatusCode() != StatusCode.ERR_EXISTS || (client = _pool.getEVCacheClient(f.getServerGroup())) == null) continue;
                            readData = client.get(canonicalKey, ct, false, false);
                            if (log.isDebugEnabled()) {
                                log.debug("Add : Read existing data for: APP " + _pool.getAppName() + ", key " + canonicalKey + "; ServerGroup : " + client.getServerGroupName());
                            }
                            if (readData != null) break;
                        }
                        if (readData != null) {
                            for (i = 0; i < futures.size(); ++i) {
                                evFuture = futures.get(i);
                                if (!(evFuture instanceof OperationFuture) || (f = (EVCacheOperationFuture)((Object)evFuture)).getStatus().getStatusCode() != StatusCode.SUCCESS || (client = _pool.getEVCacheClient(f.getServerGroup())) == null) continue;
                                futures.remove(i);
                                client.set(canonicalKey, readData, timeToLive, this);
                                if (log.isDebugEnabled()) {
                                    log.debug("Add: Fixup for : APP " + _pool.getAppName() + ", key " + canonicalKey + "; ServerGroup : " + client.getServerGroupName());
                                }
                                EVCacheMetricsFactory.increment(_appName, null, client.getServerGroupName(), _appName + "-AddCall-FixUp");
                            }
                        }
                    }
                    super.onComplete(operationFuture);
                }
            }
        };
        for (EVCacheClient client : clients) {
            Future<Boolean> future = client.add(canonicalKey, timeToLive, cd, ct, latch);
            if (!log.isDebugEnabled()) continue;
            log.debug("ADD : Op Submitted : APP " + _pool.getAppName() + ", key " + canonicalKey + "; future : " + future);
        }
        return latch;
    }
}

