/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.net.InetAddresses;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheServerGroupConfig;
import com.netflix.evcache.pool.ServerGroup;
import com.sun.javafx.runtime.SystemProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleNodeListProvider
implements EVCacheNodeList {
    private static Logger log = LoggerFactory.getLogger(EVCacheClientPool.class);
    private String currentNodeList = "";
    private final String propertyName;

    public SimpleNodeListProvider(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Map<ServerGroup, EVCacheServerGroupConfig> discoverInstances() throws IOException {
        String nodeListString = SystemProperties.getProperty((String)this.propertyName);
        if (log.isDebugEnabled()) {
            log.debug("List of Nodes = " + nodeListString);
        }
        if (nodeListString != null && nodeListString.length() > 0) {
            HashMap<ServerGroup, EVCacheServerGroupConfig> instancesSpecific = new HashMap<ServerGroup, EVCacheServerGroupConfig>();
            StringTokenizer setTokenizer = new StringTokenizer(nodeListString, ";");
            while (setTokenizer.hasMoreTokens()) {
                String token = setTokenizer.nextToken();
                StringTokenizer replicaSetTokenizer = new StringTokenizer(token, "=");
                while (replicaSetTokenizer.hasMoreTokens()) {
                    String replicaSetToken = replicaSetTokenizer.nextToken();
                    String instanceToken = replicaSetTokenizer.nextToken();
                    StringTokenizer instanceTokenizer = new StringTokenizer(instanceToken, ",");
                    HashSet<InetSocketAddress> instanceList = new HashSet<InetSocketAddress>();
                    ServerGroup rSet = new ServerGroup(replicaSetToken, replicaSetToken);
                    EVCacheServerGroupConfig config = new EVCacheServerGroupConfig(rSet, instanceList, 0, 0, 0);
                    instancesSpecific.put(rSet, config);
                    while (instanceTokenizer.hasMoreTokens()) {
                        String instance = instanceTokenizer.nextToken();
                        int index = instance.indexOf(58);
                        String host = instance.substring(0, index);
                        String port = instance.substring(index + 1);
                        int ind = host.indexOf(47);
                        if (ind == -1) {
                            InetAddress add = InetAddress.getByName(host);
                            instanceList.add(new InetSocketAddress(add, Integer.parseInt(port)));
                            continue;
                        }
                        String hostName = host.substring(0, ind);
                        String localIp = host.substring(ind + 1);
                        InetAddress add = InetAddresses.forString((String)localIp);
                        InetAddress inetAddress = InetAddress.getByAddress(hostName, add.getAddress());
                        instanceList.add(new InetSocketAddress(inetAddress, Integer.parseInt(port)));
                    }
                }
            }
            this.currentNodeList = nodeListString;
            log.debug("List by Servergroup" + instancesSpecific);
            return instancesSpecific;
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"Current Node List\":\"");
        builder.append(this.currentNodeList);
        builder.append("\",\"System Property Name\":\"");
        builder.append(this.propertyName);
        builder.append("\"}");
        return builder.toString();
    }
}

