/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.evcache.EVCacheGetOperationListener;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheBulkGetFuture;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.Tag;
import com.netflix.spectator.api.DistributionSummary;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.CASValue;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.ListenableFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.ConcatenationType;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class EVCacheMemcachedClient
extends MemcachedClient {
    private static final Logger log = LoggerFactory.getLogger(EVCacheMemcachedClient.class);
    private final int id;
    private final String appName;
    private final String zone;
    private final ChainedDynamicProperty.IntProperty readTimeout;
    private final ServerGroup serverGroup;
    private DistributionSummary getDataSize;
    private DistributionSummary bulkDataSize;
    private DistributionSummary getAndTouchDataSize;

    public EVCacheMemcachedClient(ConnectionFactory cf, List<InetSocketAddress> addrs, ChainedDynamicProperty.IntProperty readTimeout, String appName, String zone, int id, ServerGroup serverGroup) throws IOException {
        super(cf, addrs);
        this.id = id;
        this.appName = appName;
        this.zone = zone;
        this.readTimeout = readTimeout;
        this.serverGroup = serverGroup;
    }

    public NodeLocator getNodeLocator() {
        return this.mconn.getLocator();
    }

    public MemcachedNode getEVCacheNode(String key) {
        return this.mconn.getLocator().getPrimary(key);
    }

    public <T> GetFuture<T> asyncGet(String key, Transcoder<T> tc) {
        throw new UnsupportedOperationException("asyncGet");
    }

    public <T> EVCacheOperationFuture<T> asyncGet(final String key, final Transcoder<T> tc, EVCacheGetOperationListener<T> listener) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), ((Integer)this.readTimeout.get()).intValue(), this.executorService, this.appName, this.serverGroup, "GetOperation");
        GetOperation op = this.opFact.get(key, new GetOperation.Callback(){
            private Future<T> val = null;

            public void receivedStatus(OperationStatus status) {
                try {
                    if (this.val != null) {
                        rv.set(this.val.get(), status);
                    } else {
                        rv.set(null, status);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    rv.set(null, status);
                }
            }

            public void gotData(String k, int flags, byte[] data) {
                if (data != null) {
                    if (EVCacheMemcachedClient.this.getDataSize == null) {
                        EVCacheMemcachedClient.this.getDataSize = EVCacheMetricsFactory.getDistributionSummary(EVCacheMemcachedClient.this.appName + "-GetData-Size", EVCacheMemcachedClient.this.appName, EVCacheMemcachedClient.this.serverGroup.getName());
                    }
                    if (EVCacheMemcachedClient.this.getDataSize != null) {
                        EVCacheMemcachedClient.this.getDataSize.record((long)data.length);
                    }
                }
                if (!key.equals(k)) {
                    log.warn("Wrong key returned. Key - " + key + "; Returned Key " + k);
                }
                if (tc == null) {
                    if (EVCacheMemcachedClient.this.tcService == null) {
                        log.error("tcService is null, will not be able to decode");
                        throw new RuntimeException("TranscoderSevice is null. Not able to decode");
                    }
                    Transcoder t = EVCacheMemcachedClient.this.getTranscoder();
                    this.val = EVCacheMemcachedClient.this.tcService.decode(t, new CachedData(flags, data, t.getMaxSize()));
                } else {
                    if (EVCacheMemcachedClient.this.tcService == null) {
                        log.error("tcService is null, will not be able to decode");
                        throw new RuntimeException("TranscoderSevice is null. Not able to decode");
                    }
                    this.val = EVCacheMemcachedClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize()));
                }
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (listener != null) {
            rv.addListener(listener);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> EVCacheBulkGetFuture<T> asyncGetBulk(Collection<String> keys, final Transcoder<T> tc, EVCacheGetOperationListener<T> listener, String metricName) {
        final ConcurrentHashMap m = new ConcurrentHashMap();
        HashMap<MemcachedNode, ArrayList<String>> chunks = new HashMap<MemcachedNode, ArrayList<String>>();
        NodeLocator locator = this.mconn.getLocator();
        for (String key : keys) {
            StringUtils.validateKey((String)key, (boolean)(this.opFact instanceof BinaryOperationFactory));
            MemcachedNode primaryNode = locator.getPrimary(key);
            if (!primaryNode.isActive()) continue;
            ArrayList<String> ks = (ArrayList<String>)chunks.get(primaryNode);
            if (ks == null) {
                ks = new ArrayList<String>();
                chunks.put(primaryNode, ks);
            }
            ks.add(key);
        }
        final AtomicInteger pendingChunks = new AtomicInteger(chunks.size());
        int initialLatchCount = chunks.isEmpty() ? 0 : 1;
        final CountDownLatch latch = new CountDownLatch(initialLatchCount);
        ArrayList<Operation> ops = new ArrayList<Operation>(chunks.size());
        final EVCacheBulkGetFuture rv = new EVCacheBulkGetFuture(this.appName, m, ops, latch, this.executorService, this.serverGroup, metricName);
        GetOperation.Callback cb = new GetOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
                rv.setStatus(status);
            }

            public void gotData(String k, int flags, byte[] data) {
                if (data != null) {
                    if (EVCacheMemcachedClient.this.bulkDataSize == null) {
                        EVCacheMemcachedClient.this.bulkDataSize = EVCacheMetricsFactory.getDistributionSummary(EVCacheMemcachedClient.this.appName + "-BulkData-Size", EVCacheMemcachedClient.this.appName, EVCacheMemcachedClient.this.serverGroup.getName());
                    }
                    if (EVCacheMemcachedClient.this.bulkDataSize != null) {
                        EVCacheMemcachedClient.this.bulkDataSize.record((long)data.length);
                    }
                }
                m.put(k, EVCacheMemcachedClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize())));
            }

            public void complete() {
                if (pendingChunks.decrementAndGet() <= 0) {
                    latch.countDown();
                    rv.signalComplete();
                }
            }
        };
        HashMap mops = new HashMap();
        for (Map.Entry me : chunks.entrySet()) {
            GetOperation op = this.opFact.get((Collection)me.getValue(), cb);
            mops.put(me.getKey(), op);
            ops.add((Operation)op);
        }
        assert (mops.size() == chunks.size());
        this.mconn.checkState();
        this.mconn.addOperations(mops);
        return rv;
    }

    public <T> EVCacheOperationFuture<CASValue<T>> asyncGetAndTouch(final String key, int exp, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.appName, this.serverGroup, "GetOperation");
        GetAndTouchOperation op = this.opFact.getAndTouch(key, exp, new GetAndTouchOperation.Callback(){
            private CASValue<T> val = null;

            public void receivedStatus(OperationStatus status) {
                rv.set(this.val, status);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }

            public void gotData(String k, int flags, long cas, byte[] data) {
                if (!key.equals(k)) {
                    log.warn("Wrong key returned. Key - " + key + "; Returned Key " + k);
                }
                if (data != null) {
                    if (EVCacheMemcachedClient.this.getAndTouchDataSize == null) {
                        EVCacheMemcachedClient.this.getAndTouchDataSize = EVCacheMetricsFactory.getDistributionSummary(EVCacheMemcachedClient.this.appName + "-GATData-Size", EVCacheMemcachedClient.this.appName, EVCacheMemcachedClient.this.serverGroup.getName());
                    }
                    if (EVCacheMemcachedClient.this.getAndTouchDataSize != null) {
                        EVCacheMemcachedClient.this.getAndTouchDataSize.record((long)data.length);
                    }
                }
                this.val = new CASValue(cas, tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> set(String key, int exp, T o, Transcoder<T> tc) {
        return this.asyncStore(StoreType.set, key, exp, o, tc, null);
    }

    public OperationFuture<Boolean> set(String key, int exp, Object o) {
        return this.asyncStore(StoreType.set, key, exp, o, this.transcoder, null);
    }

    public <T> OperationFuture<Boolean> set(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.set, key, exp, o, t, latch);
    }

    public <T> OperationFuture<Boolean> replace(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.replace, key, exp, o, t, latch);
    }

    public <T> OperationFuture<Boolean> add(String key, int exp, T o, Transcoder<T> tc) {
        return this.asyncStore(StoreType.add, key, exp, o, tc, null);
    }

    public OperationFuture<Boolean> delete(final String key, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout, this.executorService);
        DeleteOperation.Callback callback = new DeleteOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
                rv.set((Object)Boolean.TRUE, status);
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-DeleteCall-SUCCESS").increment();
                } else {
                    BasicTag tag = null;
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node.getSocketAddress() instanceof InetSocketAddress) {
                        tag = new BasicTag("HOST", ((InetSocketAddress)node.getSocketAddress()).getHostName());
                    }
                    EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-DeleteCall-" + status.getStatusCode().name(), (Tag)tag).increment();
                }
            }

            public void gotData(long cas) {
                rv.setCas(cas);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        };
        DeleteOperation op = this.opFact.delete(key, callback);
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> touch(final String key, int exp, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout, this.executorService);
        KeyedOperation op = this.opFact.touch(key, exp, new OperationCallback(){

            public void receivedStatus(OperationStatus status) {
                rv.set((Object)status.isSuccess(), status);
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-TouchCall-SUCCESS").increment();
                } else {
                    BasicTag tag = null;
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node.getSocketAddress() instanceof InetSocketAddress) {
                        tag = new BasicTag("HOST", ((InetSocketAddress)node.getSocketAddress()).getHostName());
                    }
                    EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-TouchCall-" + status.getStatusCode().name(), (Tag)tag).increment();
                }
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> asyncAppendOrAdd(final String key, final int exp, final CachedData co, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.appName, this.serverGroup, "LatencyAoA");
        ConcatenationOperation op = this.opFact.cat(ConcatenationType.append, 0L, key, co.getData(), new OperationCallback(){
            final Stopwatch operationDuration;
            boolean appendSuccess;
            {
                this.operationDuration = EVCacheMetricsFactory.getStatsTimer(EVCacheMemcachedClient.this.appName, EVCacheMemcachedClient.this.serverGroup, "LatencyAoA").start();
                this.appendSuccess = false;
            }

            public void receivedStatus(OperationStatus val) {
                if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    this.operationDuration.stop();
                    if (log.isDebugEnabled()) {
                        log.debug("AddOrAppend Key (Append Operation): " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - this.operationDuration.getDuration()));
                    }
                    EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-AoA-AppendCall-SUCCESS").increment();
                    rv.set((Object)val.isSuccess(), val);
                    this.appendSuccess = true;
                } else {
                    EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-AoA-AppendCall-FAIL").increment();
                    this.appendSuccess = false;
                }
            }

            public void complete() {
                if (this.appendSuccess) {
                    latch.countDown();
                    rv.signalComplete();
                } else {
                    StoreOperation op = EVCacheMemcachedClient.this.opFact.store(StoreType.add, key, co.getFlags(), exp, co.getData(), new StoreOperation.Callback(){

                        public void receivedStatus(OperationStatus val) {
                            operationDuration.stop();
                            if (log.isDebugEnabled()) {
                                log.debug("AddOrAppend Key (Ad Operation): " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - operationDuration.getDuration()));
                            }
                            rv.set((Object)val.isSuccess(), val);
                            if (val.isSuccess()) {
                                appendSuccess = true;
                                EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-AoA-AddCall-SUCCESS").increment();
                            } else {
                                EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-AoA-AddCall-FAIL").increment();
                                ConcatenationOperation op = EVCacheMemcachedClient.this.opFact.cat(ConcatenationType.append, 0L, key, co.getData(), new OperationCallback(){

                                    public void receivedStatus(OperationStatus val) {
                                        if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                                            if (log.isDebugEnabled()) {
                                                log.debug("AddOrAppend Retry append Key (Append Operation): " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - operationDuration.getDuration()));
                                            }
                                            EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-AoA-RetryAppendCall-SUCCESS").increment();
                                            rv.set((Object)val.isSuccess(), val);
                                        } else {
                                            EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName + "-" + EVCacheMemcachedClient.this.serverGroup.getName() + "-AoA-Retry-AppendCall-FAIL").increment();
                                        }
                                    }

                                    public void complete() {
                                        latch.countDown();
                                        rv.signalComplete();
                                    }
                                });
                                rv.setOperation((Operation)op);
                                EVCacheMemcachedClient.this.mconn.enqueueOperation(key, (Operation)op);
                            }
                        }

                        public void gotData(String key, long cas) {
                            rv.setCas(cas);
                        }

                        public void complete() {
                            if (appendSuccess) {
                                latch.countDown();
                                rv.signalComplete();
                            }
                        }
                    });
                    rv.setOperation((Operation)op);
                    EVCacheMemcachedClient.this.mconn.enqueueOperation(key, (Operation)op);
                }
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        return rv;
    }

    private <T> OperationFuture<Boolean> asyncStore(StoreType storeType, final String key, int exp, T value, Transcoder<T> tc, EVCacheLatch evcacheLatch) {
        CachedData co = value instanceof CachedData ? (CachedData)value : tc.encode(value);
        final CountDownLatch latch = new CountDownLatch(1);
        final String operationStr = storeType == StoreType.set ? "Set" : (storeType == StoreType.add ? "Add" : "Replace");
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.operationTimeout, this.executorService, this.appName, this.serverGroup, "Latency" + operationStr);
        StoreOperation op = this.opFact.store(storeType, key, co.getFlags(), exp, co.getData(), new StoreOperation.Callback(){
            final Stopwatch operationDuration;
            {
                this.operationDuration = EVCacheMetricsFactory.getStatsTimer(EVCacheMemcachedClient.this.appName, EVCacheMemcachedClient.this.serverGroup, "Latency" + operationStr).start();
            }

            public void receivedStatus(OperationStatus val) {
                this.operationDuration.stop();
                if (log.isDebugEnabled()) {
                    log.debug("Storing Key : " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + (System.currentTimeMillis() - this.operationDuration.getDuration()));
                }
                if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMetricsFactory.increment(EVCacheMemcachedClient.this.appName, null, EVCacheMemcachedClient.this.serverGroup.getName(), EVCacheMemcachedClient.this.appName + "-" + operationStr + "Call-SUCCESS");
                } else if (val.getStatusCode().equals((Object)StatusCode.TIMEDOUT)) {
                    BasicTag tag = null;
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node.getSocketAddress() instanceof InetSocketAddress) {
                        tag = new BasicTag("HOST", ((InetSocketAddress)node.getSocketAddress()).getHostName());
                    }
                    EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName, null, EVCacheMemcachedClient.this.serverGroup.getName(), EVCacheMemcachedClient.this.appName + "-" + operationStr + "Call-TIMEDOUT", (Tag)tag).increment();
                } else {
                    BasicTag tag = null;
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node.getSocketAddress() instanceof InetSocketAddress) {
                        tag = new BasicTag("HOST", ((InetSocketAddress)node.getSocketAddress()).getHostName());
                    }
                    EVCacheMetricsFactory.getCounter(EVCacheMemcachedClient.this.appName, null, EVCacheMemcachedClient.this.serverGroup.getName(), EVCacheMemcachedClient.this.appName + "-" + operationStr + "Call-" + val.getStatusCode().name(), (Tag)tag).increment();
                }
                rv.set((Object)val.isSuccess(), val);
            }

            public void gotData(String key2, long cas) {
                rv.setCas(cas);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public String toString() {
        return this.appName + "_" + this.zone + " _" + this.id;
    }

    public <T> OperationFuture<Boolean> add(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.add, key, exp, o, t, latch);
    }
}

