/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheImpl;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.inject.Inject;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Single;

public interface EVCache {
    public <T> Future<Boolean>[] set(String var1, T var2) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, int var3) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, Transcoder<T> var3) throws EVCacheException;

    public <T> EVCacheLatch set(String var1, T var2, EVCacheLatch.Policy var3) throws EVCacheException;

    public <T> EVCacheLatch set(String var1, T var2, int var3, EVCacheLatch.Policy var4) throws EVCacheException;

    public <T> EVCacheLatch set(String var1, T var2, Transcoder<T> var3, EVCacheLatch.Policy var4) throws EVCacheException;

    public <T> EVCacheLatch set(String var1, T var2, Transcoder<T> var3, int var4, EVCacheLatch.Policy var5) throws EVCacheException;

    public <T> EVCacheLatch replace(String var1, T var2, EVCacheLatch.Policy var3) throws EVCacheException;

    public <T> EVCacheLatch replace(String var1, T var2, Transcoder<T> var3, EVCacheLatch.Policy var4) throws EVCacheException;

    public <T> EVCacheLatch replace(String var1, T var2, Transcoder<T> var3, int var4, EVCacheLatch.Policy var5) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, Transcoder<T> var3, int var4) throws EVCacheException;

    public Future<Boolean>[] delete(String var1) throws EVCacheException;

    public <T> T get(String var1) throws EVCacheException;

    public <T> Single<T> get(String var1, Scheduler var2);

    public <T> T get(String var1, Transcoder<T> var2) throws EVCacheException;

    public <T> Single<T> get(String var1, Transcoder<T> var2, Scheduler var3);

    public <T> Single<T> getAndTouch(String var1, int var2, Scheduler var3);

    public <T> Single<T> getAndTouch(String var1, int var2, Transcoder<T> var3, Scheduler var4);

    public <T> T getAndTouch(String var1, int var2) throws EVCacheException;

    public <T> T getAndTouch(String var1, int var2, Transcoder<T> var3) throws EVCacheException;

    public <T> Map<String, T> getBulk(String ... var1) throws EVCacheException;

    public <T> Map<String, T> getBulk(Transcoder<T> var1, String ... var2) throws EVCacheException;

    public <T> Map<String, T> getBulk(Collection<String> var1) throws EVCacheException;

    public <T> Map<String, T> getBulk(Collection<String> var1, Transcoder<T> var2) throws EVCacheException;

    public <T> Map<String, T> getBulkAndTouch(Collection<String> var1, Transcoder<T> var2, int var3) throws EVCacheException;

    public <T> Future<T> getAsynchronous(String var1) throws EVCacheException;

    public <T> Future<T> getAsynchronous(String var1, Transcoder<T> var2) throws EVCacheException;

    public long incr(String var1, long var2, long var4, int var6) throws EVCacheException;

    public long decr(String var1, long var2, long var4, int var6) throws EVCacheException;

    public <T> Future<Boolean>[] append(String var1, T var2, Transcoder<T> var3) throws EVCacheException;

    public <T> Future<Boolean>[] append(String var1, T var2) throws EVCacheException;

    public <T> Future<Boolean>[] touch(String var1, int var2) throws EVCacheException;

    public String getAppName();

    public String getCachePrefix();

    public static class Builder {
        private static final Logger log = LoggerFactory.getLogger(EVCacheImpl.class);
        private String _appName;
        private String _cachePrefix = null;
        private int _ttl = 900;
        private Transcoder<?> _transcoder = null;
        private boolean _serverGroupRetry = true;
        private boolean _enableExceptionThrowing = false;
        @Inject
        private EVCacheClientPoolManager _poolManager;

        public Builder setAppName(String appName) {
            if (appName == null) {
                throw new IllegalArgumentException("param appName cannot be null.");
            }
            this._appName = appName.toUpperCase(Locale.US);
            if (!this._appName.startsWith("EVCACHE")) {
                log.warn("Make sure the app you are connecting to is EVCache App");
            }
            return this;
        }

        public Builder setCachePrefix(String cachePrefix) {
            this._cachePrefix = cachePrefix;
            if (this._cachePrefix != null && this._cachePrefix.indexOf(58) != -1) {
                throw new IllegalArgumentException("param cacheName cannot contain ':' character.");
            }
            return this;
        }

        public Builder setCacheName(String cacheName) {
            return this.setCachePrefix(cacheName);
        }

        public Builder setDefaultTTL(int ttl) {
            if (ttl < 0) {
                throw new IllegalArgumentException("Time to Live cannot be less than 0.");
            }
            this._ttl = ttl;
            return this;
        }

        public <T> Builder setTranscoder(Transcoder<T> transcoder) {
            this._transcoder = transcoder;
            return this;
        }

        public <T> Builder enableZoneFallback() {
            this._serverGroupRetry = true;
            return this;
        }

        public <T> Builder enableRetry() {
            this._serverGroupRetry = true;
            return this;
        }

        public <T> Builder disableRetry() {
            this._serverGroupRetry = true;
            return this;
        }

        public <T> Builder disableZoneFallback() {
            this._serverGroupRetry = false;
            return this;
        }

        public <T> Builder enableExceptionPropagation() {
            this._enableExceptionThrowing = true;
            return this;
        }

        public EVCache build() {
            if (this._poolManager == null) {
                this._poolManager = EVCacheClientPoolManager.getInstance();
                if (log.isDebugEnabled()) {
                    log.debug("_poolManager - " + this._poolManager + " through getInstance");
                }
            }
            if (this._appName == null) {
                throw new IllegalArgumentException("param appName cannot be null.");
            }
            EVCacheImpl cache = new EVCacheImpl(this._appName, this._cachePrefix, this._ttl, this._transcoder, this._serverGroupRetry, this._enableExceptionThrowing, this._poolManager);
            return cache;
        }
    }

    public static enum Call {
        GET,
        GETL,
        GET_AND_TOUCH,
        ASYNC_GET,
        BULK,
        SET,
        DELETE,
        INCR,
        DECR,
        TOUCH,
        APPEND,
        PREPEND,
        REPLACE,
        ADD;

    }
}

