/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.net.InetAddresses;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ChainedDynamicProperty;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.shared.Application;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.EVCacheServerGroupConfig;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryNodeListProvider
implements EVCacheNodeList {
    public static final String DEFAULT_PORT = "11211";
    private static Logger log = LoggerFactory.getLogger(DiscoveryNodeListProvider.class);
    private final DiscoveryClient _discoveryClient;
    private final String _appName;
    private final Map<ServerGroup, ChainedDynamicProperty.BooleanProperty> useLocalIpFPMap = new HashMap<ServerGroup, ChainedDynamicProperty.BooleanProperty>();
    private final ApplicationInfoManager applicationInfoManager;

    public DiscoveryNodeListProvider(ApplicationInfoManager applicationInfoManager, DiscoveryClient discoveryClient, String appName) {
        this.applicationInfoManager = applicationInfoManager;
        this._discoveryClient = discoveryClient;
        this._appName = appName;
    }

    @Override
    public Map<ServerGroup, EVCacheServerGroupConfig> discoverInstances() throws IOException {
        if (this.applicationInfoManager.getInfo().getStatus() == InstanceInfo.InstanceStatus.DOWN) {
            return Collections.emptyMap();
        }
        Application app = this._discoveryClient.getApplication(this._appName);
        if (app == null) {
            return Collections.emptyMap();
        }
        List appInstances = app.getInstances();
        HashMap<ServerGroup, EVCacheServerGroupConfig> instancesSpecific = new HashMap<ServerGroup, EVCacheServerGroupConfig>();
        for (InstanceInfo iInfo : appInstances) {
            InetAddress inetAddress;
            InetAddress add;
            String localHostname;
            String localIp;
            String myZone;
            HashSet<InetSocketAddress> instances;
            EVCacheServerGroupConfig config;
            DataCenterInfo dcInfo = iInfo.getDataCenterInfo();
            if (dcInfo == null) {
                if (!log.isErrorEnabled()) continue;
                log.error("Data Center Info is null for appName - " + this._appName);
                continue;
            }
            if (DataCenterInfo.Name.Amazon != dcInfo.getName()) {
                if (!log.isErrorEnabled()) continue;
                log.error("This is not a AWSDataCenter. You will not be able to use Discovery Nodelist Provider. Cannot proceed. DataCenterInfo : " + dcInfo + "; appName - " + this._appName);
                continue;
            }
            AmazonInfo amznInfo = (AmazonInfo)dcInfo;
            String zone = amznInfo.get(AmazonInfo.MetaDataKey.availabilityZone);
            String rSetName = iInfo.getASGName();
            Map metaInfo = iInfo.getMetadata();
            int evcachePort = Integer.parseInt(metaInfo != null && metaInfo.containsKey("evcache.port") ? (String)metaInfo.get("evcache.port") : DEFAULT_PORT);
            int rendPort = metaInfo != null && metaInfo.containsKey("rend.port") ? Integer.parseInt((String)metaInfo.get("evcache.port")) : 0;
            int rendMemcachedPort = metaInfo != null && metaInfo.containsKey("rend.memcached.port") ? Integer.parseInt((String)metaInfo.get("evcache.port")) : 0;
            int rendMementoPort = metaInfo != null && metaInfo.containsKey("rend.memento.port") ? Integer.parseInt((String)metaInfo.get("evcache.port")) : 0;
            ServerGroup rSet = new ServerGroup(zone, rSetName);
            if (instancesSpecific.containsKey(rSet)) {
                config = (EVCacheServerGroupConfig)instancesSpecific.get(rSet);
                instances = config.getInetSocketAddress();
            } else {
                instances = new HashSet();
                config = new EVCacheServerGroupConfig(rSet, instances, rendPort, rendMemcachedPort, rendMementoPort);
                instancesSpecific.put(rSet, config);
            }
            InstanceInfo.InstanceStatus status = iInfo.getStatus();
            if (status == null || InstanceInfo.InstanceStatus.OUT_OF_SERVICE == status || InstanceInfo.InstanceStatus.DOWN == status) {
                if (!log.isDebugEnabled()) continue;
                log.debug("The Status of the instance in Discovery is " + status + ". App Name : " + this._appName + "; Zone : " + zone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                continue;
            }
            ChainedDynamicProperty.BooleanProperty useLocalIp = this.useLocalIpFPMap.get(rSet);
            InetSocketAddress address = null;
            if (useLocalIp == null) {
                useLocalIp = EVCacheConfig.getInstance().getChainedBooleanProperty(this._appName + "." + rSet.getName() + ".use.localip", this._appName + ".use.localip", Boolean.FALSE);
                this.useLocalIpFPMap.put(rSet, useLocalIp);
            }
            InstanceInfo myInfo = this.applicationInfoManager.getInfo();
            String myInstanceId = myInfo.getInstanceId();
            String myIp = myInfo.getIPAddr();
            String myPublicHostName = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicHostname);
            boolean isInCloud = false;
            if (myPublicHostName != null) {
                isInCloud = myPublicHostName.startsWith("ec2");
            }
            if (!isInCloud) {
                if (((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.vpcId) != null) {
                    isInCloud = true;
                } else if (myIp.equals(myInstanceId)) {
                    isInCloud = false;
                }
            }
            String myRegion = (myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone)) != null ? myZone.substring(0, myZone.length() - 1) : null;
            String region = zone != null ? zone.substring(0, zone.length() - 1) : null;
            String host = amznInfo.get(AmazonInfo.MetaDataKey.publicHostname);
            if (log.isDebugEnabled()) {
                log.debug("myZone - " + myZone + "; zone : " + zone + "; myRegion : " + myRegion + "; region : " + region + "; host : " + host);
            }
            if (host != null) {
                if (myRegion == null || region == null || !myRegion.equals(region)) {
                    InetAddress inetAddress2 = InetAddress.getByName(host);
                    address = new InetSocketAddress(inetAddress2, evcachePort);
                    if (log.isDebugEnabled()) {
                        log.debug("myZone - " + myZone + ". host : " + host + "; inetAddress : " + inetAddress2 + "; address - " + address + "; App Name : " + this._appName + "; Zone : " + zone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                    }
                } else {
                    localIp = isInCloud ? amznInfo.get(AmazonInfo.MetaDataKey.localIpv4) : amznInfo.get(AmazonInfo.MetaDataKey.publicIpv4);
                    InetAddress add2 = InetAddresses.forString((String)localIp);
                    InetAddress inetAddress3 = InetAddress.getByAddress(host, add2.getAddress());
                    address = new InetSocketAddress(inetAddress3, evcachePort);
                    if (log.isDebugEnabled()) {
                        log.debug("CLASSIC : localIp - " + localIp + ". host : " + host + "; add : " + add2 + "; inetAddress : " + inetAddress3 + "; address - " + address + "; App Name : " + this._appName + "; Zone : " + zone + "; myZone - " + myZone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                    }
                }
            } else if (((Boolean)useLocalIp.get()).booleanValue() || amznInfo.get(AmazonInfo.MetaDataKey.vpcId) != null) {
                localIp = amznInfo.get(AmazonInfo.MetaDataKey.localIpv4);
                localHostname = amznInfo.get(AmazonInfo.MetaDataKey.localHostname);
                add = InetAddresses.forString((String)localIp);
                inetAddress = InetAddress.getByAddress(localHostname, add.getAddress());
                address = new InetSocketAddress(inetAddress, evcachePort);
                if (log.isDebugEnabled()) {
                    log.debug("VPC : localIp - " + localIp + ". localHostname : " + localHostname + "; add : " + add + "; inetAddress : " + inetAddress + "; address - " + address + "; App Name : " + this._appName + "; Zone : " + zone + "; myZone - " + myZone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                }
            } else {
                localIp = isInCloud ? amznInfo.get(AmazonInfo.MetaDataKey.localIpv4) : amznInfo.get(AmazonInfo.MetaDataKey.publicIpv4);
                localHostname = amznInfo.get(AmazonInfo.MetaDataKey.localHostname);
                if (localHostname == null) {
                    localHostname = localIp;
                }
                add = InetAddresses.forString((String)localIp);
                inetAddress = InetAddress.getByAddress(localHostname, add.getAddress());
                address = new InetSocketAddress(inetAddress, evcachePort);
                if (log.isDebugEnabled()) {
                    log.debug("CLASSIC : localIp - " + localIp + ". localHostname : " + localHostname + "; add : " + add + "; inetAddress : " + inetAddress + "; address - " + address + "; App Name : " + this._appName + "; Zone : " + zone + "; myZone - " + myZone + "; Host : " + iInfo.getHostName() + "; Instance Id - " + iInfo.getId());
                }
            }
            instances.add(address);
        }
        return instancesSpecific;
    }
}

