/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.protocol.binary.BinaryMemcachedNodeImpl;
import net.spy.memcached.protocol.binary.EVCacheNodeImplMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "EXS_EXCEPTION_SOFTENING_NO_CHECKED", "REC_CATCH_EXCEPTION", "SCII_SPOILED_CHILD_INTERFACE_IMPLEMENTATOR"})
public class EVCacheNodeImpl
extends BinaryMemcachedNodeImpl
implements EVCacheNodeImplMBean,
CompositeMonitor<Long> {
    private static final Logger log = LoggerFactory.getLogger(EVCacheNodeImpl.class);
    protected long stTime;
    protected final AtomicLong opCount = new AtomicLong(0L);
    protected final AtomicInteger reconnectCount = new AtomicInteger(0);
    protected final String _appName;
    protected final String hostName;
    protected final ServerGroup _serverGroup;
    protected final int id;
    protected final BlockingQueue<Operation> readQ;
    protected final BlockingQueue<Operation> inputQueue;
    protected final String metricPrefix;
    protected final DynamicBooleanProperty sendMetrics;
    protected final MonitorConfig baseConfig;
    protected final TagList baseTags;
    protected final TagList tags;
    private long timeoutStartTime;

    public EVCacheNodeImpl(SocketAddress sa, SocketChannel c, int bufSize, BlockingQueue<Operation> rq, BlockingQueue<Operation> wq, BlockingQueue<Operation> iq, long opQueueMaxBlockTimeMillis, boolean waitForAuth, long dt, long at, ConnectionFactory fa, String appName, int id, ServerGroup serverGroup, long stTime) {
        super(sa, c, bufSize, rq, wq, iq, Long.valueOf(opQueueMaxBlockTimeMillis), waitForAuth, dt, at, fa);
        this.id = id;
        this._appName = appName;
        this._serverGroup = serverGroup;
        this.setConnectTime(stTime);
        this.readQ = rq;
        this.inputQueue = iq;
        this.sendMetrics = EVCacheConfig.getInstance().getDynamicBooleanProperty("EVCacheNodeImpl." + appName + ".sendMetrics", false);
        this.tags = BasicTagList.of((String[])new String[]{"ServerGroup", this._serverGroup.getName(), "APP", appName, "Id", String.valueOf(id), EVCacheMetricsFactory.OWNER.getKey(), EVCacheMetricsFactory.OWNER.getValue()});
        this.hostName = ((InetSocketAddress)this.getSocketAddress()).getHostName();
        this.metricPrefix = "EVCacheNode";
        this.baseConfig = MonitorConfig.builder((String)this.metricPrefix).build();
        this.baseTags = BasicTagList.concat((TagList)this.tags, (TagList)BasicTagList.of((String[])new String[]{"HOST", this.hostName}));
    }

    private String getMonitorName() {
        return "com.netflix.evcache:Group=" + this._appName + ",SubGroup=pool,SubSubGroup=" + this._serverGroup.getName() + ",SubSubSubGroup=" + this.id + ",SubSubSubSubGroup=" + this.hostName + "_" + this.stTime;
    }

    public void setupMonitoring(String appName, ServerGroup serverGroup) {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance(this.getMonitorName());
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
                Monitors.registerObject((Object)this);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception while setting up the monitoring.", (Throwable)e);
            }
        }
    }

    public boolean isAvailable() {
        return this.isActive();
    }

    @Override
    public int getWriteQueueSize() {
        return this.writeQ.size();
    }

    @Override
    public int getReadQueueSize() {
        return this.readQ.size();
    }

    @Override
    public int getInputQueueSize() {
        return this.inputQueue.size();
    }

    public long incrOps() {
        return this.opCount.incrementAndGet();
    }

    @Override
    public long getNumOfOps() {
        return this.opCount.get();
    }

    @Override
    public void flushInputQueue() {
        this.inputQueue.clear();
    }

    public long getStartTime() {
        return this.stTime;
    }

    public long getTimeoutStartTime() {
        return this.timeoutStartTime;
    }

    @Override
    public void removeMonitoring() {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance(this.getMonitorName());
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception while setting up the monitoring.", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.removeMonitoring();
        this.writeQ.clear();
        this.readQ.clear();
        this.inputQueue.clear();
        try {
            if (this.getRbuf() instanceof DirectBuffer) {
                Cleaner cleaner = ((DirectBuffer)((Object)this.getRbuf())).cleaner();
                if (cleaner != null) {
                    cleaner.clean();
                }
                if ((cleaner = ((DirectBuffer)((Object)this.getWbuf())).cleaner()) != null) {
                    cleaner.clean();
                }
            }
        }
        catch (Throwable t) {
            this.getLogger().error((Object)"Exception cleaning ByteBuffer.", t);
        }
    }

    public Long getValue() {
        return this.getValue(0);
    }

    public Long getValue(int pollerIndex) {
        return this.sendMetrics.get() ? Long.valueOf(3L) : Long.valueOf(0L);
    }

    public MonitorConfig getConfig() {
        return this.baseConfig;
    }

    public List<Monitor<?>> getMonitors() {
        if (!this.sendMetrics.get() && this.getContinuousTimeout() == 0) {
            return Collections.emptyList();
        }
        try {
            MonitorConfig monitorConfig;
            ArrayList metrics = new ArrayList();
            if (this.getContinuousTimeout() > 0) {
                monitorConfig = EVCacheConfig.getInstance().getMonitorConfig(this.metricPrefix + "_ContinuousTimeout", (Tag)DataSourceType.GAUGE, this.baseTags);
                LongGauge cTimeouts = new LongGauge(monitorConfig);
                cTimeouts.set(Long.valueOf(this.getContinuousTimeout()));
                metrics.add((Monitor<?>)cTimeouts);
            }
            if (this.sendMetrics.get()) {
                monitorConfig = EVCacheConfig.getInstance().getMonitorConfig(this.metricPrefix + "_WriteQ", (Tag)DataSourceType.GAUGE, this.baseTags);
                LongGauge wQueue = new LongGauge(monitorConfig);
                wQueue.set(Long.valueOf(this.writeQ.size()));
                metrics.add((Monitor<?>)wQueue);
                monitorConfig = EVCacheConfig.getInstance().getMonitorConfig(this.metricPrefix + "_ReadQ", (Tag)DataSourceType.GAUGE, this.baseTags);
                LongGauge rQueue = new LongGauge(monitorConfig);
                rQueue.set(Long.valueOf(this.readQ.size()));
                metrics.add((Monitor<?>)rQueue);
                monitorConfig = EVCacheConfig.getInstance().getMonitorConfig(this.metricPrefix + "_NumOfOps", (Tag)DataSourceType.COUNTER, this.baseTags);
                BasicCounter counter = new BasicCounter(monitorConfig);
                counter.increment(this.opCount.get());
                metrics.add((Monitor<?>)counter);
            }
            return metrics;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public long getCreateTime() {
        return this.stTime;
    }

    public void setConnectTime(long cTime) {
        this.stTime = cTime;
        this.reconnectCount.incrementAndGet();
    }

    public String getAppName() {
        return this._appName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public ServerGroup getServerGroup() {
        return this._serverGroup;
    }

    public int getId() {
        return this.id;
    }

    public TagList getBaseTags() {
        return this.baseTags;
    }

    public int getTotalReconnectCount() {
        return this.reconnectCount.get();
    }
}

