/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.operation;

import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.pool.ServerGroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.spy.memcached.internal.ListenableFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DE_MIGHT_IGNORE", "EI_EXPOSE_REP2"})
public class EVCacheFutures
implements ListenableFuture<Boolean, OperationCompletionListener>,
OperationCompletionListener {
    private Logger log = LoggerFactory.getLogger(EVCacheFutures.class);
    private final OperationFuture<Boolean>[] futures;
    private final String app;
    private final ServerGroup serverGroup;
    private final String key;
    private final AtomicInteger completionCounter;
    private final EVCacheLatch latch;

    public EVCacheFutures(OperationFuture<Boolean>[] futures, String key, String app, ServerGroup serverGroup, EVCacheLatch latch) {
        this.futures = futures;
        this.app = app;
        this.serverGroup = serverGroup;
        this.key = key;
        this.latch = latch;
        this.completionCounter = new AtomicInteger(futures.length);
        if (latch != null && latch instanceof EVCacheLatchImpl) {
            ((EVCacheLatchImpl)latch).addFuture(this);
        }
        for (int i = 0; i < futures.length; ++i) {
            OperationFuture<Boolean> of = futures[i];
            if (of.isDone()) {
                try {
                    this.onComplete(of);
                }
                catch (Exception exception) {}
                continue;
            }
            of.addListener((OperationCompletionListener)this);
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Operation cancelled", (Throwable)new Exception());
        }
        for (OperationFuture<Boolean> future : this.futures) {
            future.cancel();
        }
        return true;
    }

    public boolean isCancelled() {
        for (OperationFuture<Boolean> future : this.futures) {
            if (future.isCancelled()) continue;
            return false;
        }
        return true;
    }

    public boolean isDone() {
        for (OperationFuture<Boolean> future : this.futures) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    public Boolean get() throws InterruptedException, ExecutionException {
        for (OperationFuture<Boolean> future : this.futures) {
            if (((Boolean)future.get()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        for (OperationFuture<Boolean> future : this.futures) {
            if (((Boolean)future.get(timeout, unit)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public String getApp() {
        return this.app;
    }

    public String getZone() {
        return this.serverGroup.getZone();
    }

    public String getReplicaSetNamae() {
        return this.serverGroup.getName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EVCacheFutures [futures=[");
        for (OperationFuture<Boolean> future : this.futures) {
            sb.append(future);
        }
        sb.append("], app=").append(this.app).append(", ReplicaSet=").append(this.serverGroup.toString()).append("]");
        return sb.toString();
    }

    public void onComplete(OperationFuture<?> future) throws Exception {
        int val = this.completionCounter.decrementAndGet();
        if (val == 0 && this.latch != null) {
            this.latch.onComplete((Future)future);
        }
    }

    public Future<Boolean> addListener(OperationCompletionListener listener) {
        return this;
    }

    public Future<Boolean> removeListener(OperationCompletionListener listener) {
        return this;
    }
}

