/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.metrics;

import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.EVCache;
import com.netflix.evcache.metrics.EVCacheMetrics;
import com.netflix.evcache.metrics.EVCacheOperation;
import com.netflix.evcache.metrics.Operation;
import com.netflix.evcache.metrics.Stats;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StatsTimer;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.stats.StatsConfig;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@SuppressFBWarnings(value={"NF_LOCAL_FAST_PROPERTY", "PMB_POSSIBLE_MEMORY_BLOAT"}, justification="Creates only when needed")
public final class EVCacheMetricsFactory {
    private static final Map<String, Stats> statsMap = new ConcurrentHashMap<String, Stats>();
    private static final Map<String, Monitor<?>> monitorMap = new ConcurrentHashMap();
    private static final Lock writeLock = new ReentrantReadWriteLock().writeLock();
    private static final Map<String, Timer> timerMap = new HashMap<String, Timer>();
    private static final DynamicIntProperty sampleSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCache.metrics.sample.size", 100);

    public static Operation getOperation(String name) {
        return EVCacheMetricsFactory.getOperation(name, null, null, Operation.TYPE.MILLI);
    }

    public static Operation getOperation(String name, EVCache.Call op, Stats stats) {
        return EVCacheMetricsFactory.getOperation(name, op, stats, Operation.TYPE.MILLI);
    }

    public static Operation getOperation(String name, EVCache.Call op, Stats stats, Operation.TYPE type) {
        EVCacheOperation operation = new EVCacheOperation(name, op, stats, type);
        operation.start();
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stats getStats(String appName, String cacheName) {
        String key = cacheName == null ? appName + ":NA" : appName + ":" + cacheName;
        Stats metrics = statsMap.get(key);
        if (metrics != null) {
            return metrics;
        }
        writeLock.lock();
        try {
            if (statsMap.containsKey(key)) {
                metrics = statsMap.get(key);
            } else {
                metrics = new EVCacheMetrics(appName, cacheName);
                statsMap.put(key, metrics);
            }
        }
        finally {
            writeLock.unlock();
        }
        return metrics;
    }

    public static Map<String, Stats> getAllMetrics() {
        return statsMap;
    }

    public static Map<String, Monitor<?>> getAllMonitor() {
        return monitorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongGauge getLongGauge(String name) {
        LongGauge gauge = (LongGauge)monitorMap.get(name);
        if (gauge == null) {
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    gauge = (LongGauge)monitorMap.get(name);
                } else {
                    gauge = new LongGauge(MonitorConfig.builder((String)name).build());
                    monitorMap.put(name, (Monitor<?>)gauge);
                    DefaultMonitorRegistry.getInstance().register((Monitor)gauge);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return gauge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongGauge getLongGauge(String cName, TagList tag) {
        String name = cName + tag.toString();
        LongGauge gauge = (LongGauge)monitorMap.get(name);
        if (gauge == null) {
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    gauge = (LongGauge)monitorMap.get(name);
                } else {
                    gauge = new LongGauge(MonitorConfig.builder((String)cName).withTags(tag).build());
                    monitorMap.put(name, (Monitor<?>)gauge);
                    DefaultMonitorRegistry.getInstance().register((Monitor)gauge);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return gauge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getCounter(String cName, Tag tag) {
        if (tag == null) {
            return EVCacheMetricsFactory.getCounter(cName);
        }
        String name = cName + tag.tagString();
        Counter counter = (Counter)monitorMap.get(name);
        if (counter == null) {
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    counter = (Counter)monitorMap.get(name);
                } else {
                    counter = new BasicCounter(MonitorConfig.builder((String)cName).withTag(tag).build());
                    monitorMap.put(name, (Monitor<?>)counter);
                    DefaultMonitorRegistry.getInstance().register((Monitor)counter);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getCounter(String cName, TagList tag) {
        String name = cName + tag.toString();
        Counter counter = (Counter)monitorMap.get(name);
        if (counter == null) {
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    counter = (Counter)monitorMap.get(name);
                } else {
                    counter = new BasicCounter(MonitorConfig.builder((String)cName).withTags(tag).build());
                    monitorMap.put(name, (Monitor<?>)counter);
                    DefaultMonitorRegistry.getInstance().register((Monitor)counter);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return counter;
    }

    public static Counter getCounter(String name) {
        return EVCacheMetricsFactory.getCounter(name, (Tag)DataSourceType.COUNTER);
    }

    public static void increment(String name) {
        Counter counter = EVCacheMetricsFactory.getCounter(name);
        counter.increment();
    }

    public static void increment(String appName, String cacheName, String metricName) {
        Counter counter = EVCacheMetricsFactory.getCounter(appName, cacheName, metricName, (Tag)DataSourceType.COUNTER);
        counter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getCounter(String appName, String cacheName, String metricName, Tag tag) {
        String name = appName + (cacheName != null ? cacheName : "") + metricName + tag.tagString();
        Counter counter = (Counter)monitorMap.get(name);
        if (counter == null) {
            BasicTagList tags = cacheName != null && cacheName.length() > 0 ? BasicTagList.of((String[])new String[]{"APP", appName, "CACHE", cacheName, tag.getKey(), tag.getValue()}) : BasicTagList.of((String[])new String[]{"APP", appName, tag.getKey(), tag.getValue()});
            writeLock.lock();
            try {
                if (monitorMap.containsKey(name)) {
                    counter = (Counter)monitorMap.get(name);
                } else {
                    counter = new BasicCounter(MonitorConfig.builder((String)metricName).build().withAdditionalTags((TagList)tags));
                    monitorMap.put(name, (Monitor<?>)counter);
                    DefaultMonitorRegistry.getInstance().register((Monitor)counter);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StepCounter getStepCounter(String appName, String cacheName, String metric) {
        String name = EVCacheMetricsFactory.getMetricName(appName, cacheName, metric) + "type=StepCounter";
        StepCounter counter = (StepCounter)monitorMap.get(name);
        if (counter != null) {
            return counter;
        }
        writeLock.lock();
        try {
            if (monitorMap.containsKey(name)) {
                StepCounter stepCounter = (StepCounter)monitorMap.get(name);
                return stepCounter;
            }
            StepCounter _counter = new StepCounter(EVCacheMetricsFactory.getMonitorConfig(name, appName, cacheName, metric));
            monitorMap.put(name, (Monitor<?>)_counter);
            DefaultMonitorRegistry.getInstance().register((Monitor)_counter);
            StepCounter stepCounter = _counter;
            return stepCounter;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatsTimer getStatsTimer(String appName, String cacheName, String metric) {
        String name = EVCacheMetricsFactory.getMetricName(appName, cacheName, metric) + "type=StatsTimer";
        StatsTimer duration = (StatsTimer)monitorMap.get(name);
        if (duration != null) {
            return duration;
        }
        writeLock.lock();
        try {
            if (monitorMap.containsKey(name)) {
                StatsTimer statsTimer = (StatsTimer)monitorMap.get(name);
                return statsTimer;
            }
            StatsConfig statsConfig = new StatsConfig.Builder().withPercentiles(new double[]{95.0, 99.0}).withPublishMax(true).withPublishMin(true).withPublishMean(true).withPublishCount(true).withSampleSize(sampleSize.get()).build();
            StatsTimer _duration = new StatsTimer(EVCacheMetricsFactory.getMonitorConfig(name, appName, cacheName, metric), statsConfig, TimeUnit.MILLISECONDS);
            monitorMap.put(name, (Monitor<?>)_duration);
            DefaultMonitorRegistry.getInstance().register((Monitor)_duration);
            StatsTimer statsTimer = _duration;
            return statsTimer;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatsTimer getStatsTimer(String appName, ServerGroup serverGroup, String metric) {
        String serverGroupName = serverGroup != null ? serverGroup.getName() : "";
        String name = EVCacheMetricsFactory.getMetricName(appName, serverGroupName, metric) + "type=StatsTimer";
        StatsTimer duration = (StatsTimer)monitorMap.get(name);
        if (duration != null) {
            return duration;
        }
        writeLock.lock();
        try {
            if (monitorMap.containsKey(name)) {
                StatsTimer statsTimer = (StatsTimer)monitorMap.get(name);
                return statsTimer;
            }
            StatsConfig statsConfig = new StatsConfig.Builder().withPercentiles(new double[]{95.0, 99.0}).withPublishMax(true).withPublishMin(true).withPublishMean(true).withPublishCount(true).withSampleSize(sampleSize.get()).build();
            StatsTimer _duration = new StatsTimer(EVCacheMetricsFactory.getMonitorConfig(name, appName, null, serverGroupName, metric), statsConfig, TimeUnit.MILLISECONDS);
            monitorMap.put(name, (Monitor<?>)_duration);
            DefaultMonitorRegistry.getInstance().register((Monitor)_duration);
            StatsTimer statsTimer = _duration;
            return statsTimer;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static String getMetricName(String appName, String cacheName, String metric) {
        return appName + (cacheName == null ? "-" : "-" + cacheName + "-") + metric;
    }

    public static MonitorConfig getMonitorConfig(String appName, String cacheName, String metric) {
        return EVCacheMetricsFactory.getMonitorConfig(EVCacheMetricsFactory.getMetricName(appName, cacheName, metric), appName, cacheName, metric);
    }

    public static MonitorConfig getMonitorConfig(String name, String appName, String cacheName, String metric) {
        MonitorConfig.Builder builder = MonitorConfig.builder((String)name).withTag("APP", appName).withTag("METRIC", metric);
        if (cacheName != null && cacheName.length() > 0) {
            builder = builder.withTag("CACHE", cacheName);
        }
        return builder.build();
    }

    public static MonitorConfig getMonitorConfig(String name, String appName, String cacheName, String serverGroup, String metric) {
        MonitorConfig.Builder builder = MonitorConfig.builder((String)name).withTag("APP", appName).withTag("METRIC", metric);
        if (cacheName != null && cacheName.length() > 0) {
            builder = builder.withTag("CACHE", cacheName);
        }
        if (serverGroup != null && serverGroup.length() > 0) {
            builder = builder.withTag("ServerGroup", serverGroup);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer getStatsTimer(String name) {
        Timer timer = timerMap.get(name);
        if (timer != null) {
            return timer;
        }
        writeLock.lock();
        try {
            if (timerMap.containsKey(name)) {
                Timer timer2 = timerMap.get(name);
                return timer2;
            }
            StatsConfig statsConfig = new StatsConfig.Builder().withPercentiles(new double[]{95.0, 99.0}).withPublishMax(true).withPublishMin(true).withPublishMean(true).withPublishCount(true).withSampleSize(sampleSize.get()).build();
            MonitorConfig monitorConfig = MonitorConfig.builder((String)name).build();
            timer = new StatsTimer(monitorConfig, statsConfig, TimeUnit.MILLISECONDS);
            DefaultMonitorRegistry.getInstance().register((Monitor)timer);
            timerMap.put(name, timer);
            Timer timer3 = timer;
            return timer3;
        }
        finally {
            writeLock.unlock();
        }
    }
}

