/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.standalone;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEVCacheClientPoolImpl
implements Runnable,
EVCacheClientPool {
    private static Logger log = LoggerFactory.getLogger(AbstractEVCacheClientPoolImpl.class);
    private String _appName;
    private DynamicIntProperty _readTimeout;
    private DynamicIntProperty _poolSize;
    private AtomicLong numOfOps = new AtomicLong(0L);
    private boolean _shutdown = false;

    @Override
    public void init(String appName) {
        this._appName = appName;
        this._readTimeout = DynamicPropertyFactory.getInstance().getIntProperty(appName + ".EVCacheClientPool.readTimeout", 100);
        this._poolSize = DynamicPropertyFactory.getInstance().getIntProperty(appName + ".EVCacheClientPool.poolSize", 1);
        if (log.isInfoEnabled()) {
            log.info("EVCacheClientPool:init" + "\n\tAPP->" + appName + "\n\tReadTimeout->" + this._readTimeout + "\n\tPoolSize->" + this._poolSize);
        }
        this.setupMonitoring();
    }

    protected void shutdownClient(EVCacheClient client) {
        if (!client.isShutdown()) {
            if (log.isDebugEnabled()) {
                log.debug("Shutting down in Fallback -> AppName : " + this._appName + "; client {" + client + "};");
            }
            try {
                if (client.getConnectionObserver() != null) {
                    boolean obsRemoved = client.removeConnectionObserver();
                    if (log.isDebugEnabled()) {
                        log.debug("Connection observer removed " + obsRemoved);
                    }
                }
                boolean status = client.shutdown(60L, TimeUnit.SECONDS);
                if (log.isDebugEnabled()) {
                    log.debug("Shutting down {" + client + "} ; status : " + status);
                }
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info("EVCacheClientPool for App : " + this._appName + " is being shutdown.");
        }
        this._shutdown = true;
        this.setupMonitoring();
    }

    private void setupMonitoring() {
        block5: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this._appName + ",SubGroup=pool");
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isInfoEnabled()) {
                        log.info("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                if (!this._shutdown) {
                    mbeanServer.registerMBean(this, mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception", (Throwable)e);
            }
        }
    }

    protected String getAppName() {
        return this._appName;
    }

    protected DynamicIntProperty getReadTimeout() {
        return this._readTimeout;
    }

    protected DynamicIntProperty getPoolSize() {
        return this._poolSize;
    }

    protected boolean isShutdown() {
        return this._shutdown;
    }

    protected AtomicLong getNumOfOps() {
        return this.numOfOps;
    }

    @Override
    public EVCacheClient getEVCacheClientExcludeZone(String zone) {
        return this.getEVCacheClient();
    }

    @Override
    public EVCacheClient[] getAllEVCacheClients() {
        EVCacheClient[] clientArr = new EVCacheClient[]{this.getEVCacheClient()};
        return clientArr;
    }

    public String toString() {
        return "appName=" + this._appName + ", readTimeout=" + this._readTimeout + ", poolSize=" + this._poolSize + ", numberOfOperations=" + this.numOfOps + ", shutdown=" + this._shutdown;
    }
}

