/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.observer;

import com.netflix.evcache.pool.observer.EVCacheConnectionObserverMBean;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.ConnectionObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheConnectionObserver
implements ConnectionObserver,
EVCacheConnectionObserverMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheConnectionObserver.class);
    private String localHostName;
    private final String appName;
    private final String zone;
    private final int id;
    private final HashSet<SocketAddress> evCacheActiveSet;
    private final HashSet<SocketAddress> evCacheInActiveSet;
    private final Map<String, Long> evCacheActiveStringSet;
    private final Map<String, Long> evCacheInActiveStringSet;

    public EVCacheConnectionObserver(String appName) {
        this(appName, 0);
    }

    public EVCacheConnectionObserver(String appName, int id) {
        this(appName, "GLOBAL", id);
    }

    public EVCacheConnectionObserver(String appName, String zone, int id) {
        try {
            this.localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.localHostName = "NA";
        }
        this.appName = appName;
        this.zone = zone;
        this.evCacheActiveSet = new HashSet();
        this.evCacheInActiveSet = new HashSet();
        this.evCacheActiveStringSet = new ConcurrentHashMap<String, Long>();
        this.evCacheInActiveStringSet = new ConcurrentHashMap<String, Long>();
        this.id = id;
        this.setupMonitoring(false);
    }

    public void connectionEstablished(SocketAddress sa, int reconnectCount) {
        String address = sa.toString();
        this.evCacheActiveSet.add(sa);
        this.evCacheInActiveSet.remove(sa);
        String hostName = ((InetSocketAddress)sa).getHostName();
        this.evCacheActiveStringSet.put(hostName, System.currentTimeMillis());
        this.evCacheInActiveStringSet.remove(hostName);
        if (log.isInfoEnabled()) {
            log.info(this.appName + ":CONNECTION ESTABLISHED : From " + this.localHostName + " to " + address + " was established after " + reconnectCount + " retries");
        }
    }

    public void connectionLost(SocketAddress sa) {
        String address = sa.toString();
        this.evCacheInActiveSet.add(sa);
        this.evCacheActiveSet.remove(sa);
        String hostName = ((InetSocketAddress)sa).getHostName();
        this.evCacheInActiveStringSet.put(hostName, System.currentTimeMillis());
        this.evCacheActiveStringSet.remove(hostName);
        if (log.isInfoEnabled()) {
            log.info(this.appName + ":CONNECTION LOST : From " + this.localHostName + " to " + address);
        }
    }

    @Override
    @Monitor(name="ActiveServerCount", type=DataSourceType.GAUGE)
    public int getActiveServerCount() {
        return this.evCacheActiveSet.size();
    }

    @Override
    @Monitor(name="ActiveServerNames", type=DataSourceType.INFORMATIONAL)
    public Set<SocketAddress> getActiveServerNames() {
        return this.evCacheActiveSet;
    }

    @Override
    @Monitor(name="InActiveServerCount", type=DataSourceType.GAUGE)
    public int getInActiveServerCount() {
        return this.evCacheInActiveSet.size();
    }

    @Override
    @Monitor(name="InActiveServerNames", type=DataSourceType.INFORMATIONAL)
    public Set<SocketAddress> getInActiveServerNames() {
        return this.evCacheInActiveSet;
    }

    public Map<String, Long> getInActiveServerInfo() {
        return Collections.unmodifiableMap(this.evCacheInActiveStringSet);
    }

    public Map<String, Long> getActiveServerInfo() {
        return Collections.unmodifiableMap(this.evCacheActiveStringSet);
    }

    private void setupMonitoring(boolean shutdown) {
        block5: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=" + this.appName + ",SubGroup=pool,SubSubGroup=" + this.zone + ",SubSubSubGroup=" + this.id);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isInfoEnabled()) {
                        log.info("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                if (!shutdown) {
                    mbeanServer.registerMBean(this, mBeanName);
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn("Issue while trying to setup monitoring", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.setupMonitoring(true);
    }

    public String toString() {
        return "EVCacheConnectionObserver [host=" + this.localHostName + ", appName=" + this.appName + ", zone=" + this.zone + ", id=" + this.id + ", evCacheActiveSet=" + this.evCacheActiveSet + ", evCacheInActiveSet=" + this.evCacheInActiveSet + ", evCacheActiveStringSet=" + this.evCacheActiveStringSet + ", evCacheInActiveStringSet=" + this.evCacheInActiveStringSet + "]";
    }
}

