/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.Version;
import com.netflix.eureka.registry.Key;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.registry.ResponseCache;
import com.netflix.eureka.resources.ApplicationResource;
import com.netflix.eureka.resources.CurrentRequestVersion;
import com.netflix.eureka.util.EurekaMonitors;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;

@Path(value="/{version}/apps")
@Produces(value={"application/xml", "application/json"})
public class ApplicationsResource {
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_GZIP_VALUE = "gzip";
    private static final String HEADER_JSON_VALUE = "json";
    private final EurekaServerConfig serverConfig;
    private final PeerAwareInstanceRegistry registry;
    private final ResponseCache responseCache;

    @Inject
    ApplicationsResource(EurekaServerContext eurekaServer) {
        this.serverConfig = eurekaServer.getServerConfig();
        this.registry = eurekaServer.getRegistry();
        this.responseCache = this.registry.getResponseCache();
    }

    public ApplicationsResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="{appId}")
    public ApplicationResource getApplicationResource(@PathParam(value="version") String version, @PathParam(value="appId") String appId) {
        CurrentRequestVersion.set(Version.toEnum(version));
        try {
            ApplicationResource applicationResource = new ApplicationResource(appId, this.serverConfig, this.registry);
            return applicationResource;
        }
        finally {
            CurrentRequestVersion.remove();
        }
    }

    @GET
    public Response getContainers(@PathParam(value="version") String version, @HeaderParam(value="Accept") String acceptHeader, @HeaderParam(value="Accept-Encoding") String acceptEncoding, @HeaderParam(value="X-Eureka-Accept") String eurekaAccept, @Context UriInfo uriInfo, @Nullable @QueryParam(value="regions") String regionsStr) {
        boolean isRemoteRegionRequested = null != regionsStr && !regionsStr.isEmpty();
        Object[] regions = null;
        if (!isRemoteRegionRequested) {
            EurekaMonitors.GET_ALL.increment();
        } else {
            regions = regionsStr.toLowerCase().split(",");
            Arrays.sort(regions);
            EurekaMonitors.GET_ALL_WITH_REMOTE_REGIONS.increment();
        }
        if (!this.registry.shouldAllowAccess(isRemoteRegionRequested)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        CurrentRequestVersion.set(Version.toEnum(version));
        Key.KeyType keyType = Key.KeyType.JSON;
        String returnMediaType = "application/json";
        if (acceptHeader == null || !acceptHeader.contains(HEADER_JSON_VALUE)) {
            keyType = Key.KeyType.XML;
            returnMediaType = "application/xml";
        }
        Key cacheKey = new Key(Key.EntityType.Application, "ALL_APPS", keyType, CurrentRequestVersion.get(), EurekaAccept.fromString((String)eurekaAccept), (String[])regions);
        Response response = acceptEncoding != null && acceptEncoding.contains(HEADER_GZIP_VALUE) ? Response.ok((Object)this.responseCache.getGZIP(cacheKey)).header(HEADER_CONTENT_ENCODING, (Object)HEADER_GZIP_VALUE).header(HEADER_CONTENT_TYPE, (Object)returnMediaType).build() : Response.ok((Object)this.responseCache.get(cacheKey)).build();
        CurrentRequestVersion.remove();
        return response;
    }

    @Path(value="delta")
    @GET
    public Response getContainerDifferential(@PathParam(value="version") String version, @HeaderParam(value="Accept") String acceptHeader, @HeaderParam(value="Accept-Encoding") String acceptEncoding, @HeaderParam(value="X-Eureka-Accept") String eurekaAccept, @Context UriInfo uriInfo, @Nullable @QueryParam(value="regions") String regionsStr) {
        boolean isRemoteRegionRequested;
        boolean bl = isRemoteRegionRequested = null != regionsStr && !regionsStr.isEmpty();
        if (this.serverConfig.shouldDisableDelta() || !this.registry.shouldAllowAccess(isRemoteRegionRequested)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Object[] regions = null;
        if (!isRemoteRegionRequested) {
            EurekaMonitors.GET_ALL_DELTA.increment();
        } else {
            regions = regionsStr.toLowerCase().split(",");
            Arrays.sort(regions);
            EurekaMonitors.GET_ALL_DELTA_WITH_REMOTE_REGIONS.increment();
        }
        CurrentRequestVersion.set(Version.toEnum(version));
        Key.KeyType keyType = Key.KeyType.JSON;
        String returnMediaType = "application/json";
        if (acceptHeader == null || !acceptHeader.contains(HEADER_JSON_VALUE)) {
            keyType = Key.KeyType.XML;
            returnMediaType = "application/xml";
        }
        Key cacheKey = new Key(Key.EntityType.Application, "ALL_APPS_DELTA", keyType, CurrentRequestVersion.get(), EurekaAccept.fromString((String)eurekaAccept), (String[])regions);
        Response response = acceptEncoding != null && acceptEncoding.contains(HEADER_GZIP_VALUE) ? Response.ok((Object)this.responseCache.getGZIP(cacheKey)).header(HEADER_CONTENT_ENCODING, (Object)HEADER_GZIP_VALUE).header(HEADER_CONTENT_TYPE, (Object)returnMediaType).build() : Response.ok((Object)this.responseCache.get(cacheKey)).build();
        CurrentRequestVersion.remove();
        return response;
    }
}

