/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util.batcher;

import com.netflix.discovery.util.SpectatorUtil;
import com.netflix.eureka.util.batcher.TaskHolder;
import com.netflix.eureka.util.batcher.TaskProcessor;
import com.netflix.eureka.util.batcher.TrafficShaper;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.histogram.PercentileDistributionSummary;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AcceptorExecutor<ID, T> {
    private static final Logger logger = LoggerFactory.getLogger(AcceptorExecutor.class);
    private final String id;
    private final int maxBufferSize;
    private final int maxBatchingSize;
    private final long maxBatchingDelay;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final BlockingQueue<TaskHolder<ID, T>> acceptorQueue = new LinkedBlockingQueue<TaskHolder<ID, T>>();
    private final BlockingDeque<TaskHolder<ID, T>> reprocessQueue = new LinkedBlockingDeque<TaskHolder<ID, T>>();
    private final Thread acceptorThread;
    private final Map<ID, TaskHolder<ID, T>> pendingTasks = new HashMap<ID, TaskHolder<ID, T>>();
    private final Deque<ID> processingOrder = new LinkedList<ID>();
    private final Semaphore singleItemWorkRequests = new Semaphore(0);
    private final BlockingQueue<TaskHolder<ID, T>> singleItemWorkQueue = new LinkedBlockingQueue<TaskHolder<ID, T>>();
    private final Semaphore batchWorkRequests = new Semaphore(0);
    private final BlockingQueue<List<TaskHolder<ID, T>>> batchWorkQueue = new LinkedBlockingQueue<List<TaskHolder<ID, T>>>();
    private final TrafficShaper trafficShaper;
    AtomicLong acceptedTasks = SpectatorUtil.monitoredLong((String)"eurekaServer.replication.acceptedTasks", AcceptorExecutor.class);
    AtomicLong replayedTasks = SpectatorUtil.monitoredLong((String)"eurekaServer.replication.replayedTasks", AcceptorExecutor.class);
    AtomicLong expiredTasks = SpectatorUtil.monitoredLong((String)"eurekaServer.replication.expiredTasks", AcceptorExecutor.class);
    AtomicLong overriddenTasks = SpectatorUtil.monitoredLong((String)"eurekaServer.replication.overriddenTasks", AcceptorExecutor.class);
    AtomicLong queueOverflows = SpectatorUtil.monitoredLong((String)"eurekaServer.replication.queueOverflows", AcceptorExecutor.class);
    private final PercentileDistributionSummary batchSizeMetric;

    AcceptorExecutor(String id, int maxBufferSize, int maxBatchingSize, long maxBatchingDelay, long congestionRetryDelayMs, long networkFailureRetryMs) {
        this.id = id;
        this.maxBufferSize = maxBufferSize;
        this.maxBatchingSize = maxBatchingSize;
        this.maxBatchingDelay = maxBatchingDelay;
        this.trafficShaper = new TrafficShaper(congestionRetryDelayMs, networkFailureRetryMs);
        ThreadGroup threadGroup = new ThreadGroup("eurekaTaskExecutors");
        this.acceptorThread = new Thread(threadGroup, new AcceptorRunner(), "TaskAcceptor-" + id);
        this.acceptorThread.setDaemon(true);
        this.acceptorThread.start();
        this.batchSizeMetric = ((PercentileDistributionSummary.Builder)((PercentileDistributionSummary.Builder)PercentileDistributionSummary.builder((Registry)Spectator.globalRegistry()).withName("eurekaServer.replication.batchSize")).withTags((Iterable)SpectatorUtil.tags(this.getClass()))).build();
        SpectatorUtil.monitoredValue((String)"eurekaServer.replication.reprocessQueueSize", (Object)this, AcceptorExecutor::getReprocessQueueSize);
        SpectatorUtil.monitoredValue((String)"eurekaServer.replication.acceptorQueueSize", (Object)this, AcceptorExecutor::getAcceptorQueueSize);
        SpectatorUtil.monitoredValue((String)"eurekaServer.replication.reprocessQueueSize", (Object)this, AcceptorExecutor::getReprocessQueueSize);
        SpectatorUtil.monitoredValue((String)"eurekaServer.replication.queueSize", (Object)this, AcceptorExecutor::getQueueSize);
        SpectatorUtil.monitoredValue((String)"eurekaServer.replication.pendingJobRequests", (Object)this, AcceptorExecutor::getPendingJobRequests);
        SpectatorUtil.monitoredValue((String)"eurekaServer.replication.availableJobs", (Object)this, AcceptorExecutor::workerTaskQueueSize);
    }

    void process(ID id, T task, long expiryTime) {
        this.acceptorQueue.add(new TaskHolder<ID, T>(id, task, expiryTime));
        this.acceptedTasks.incrementAndGet();
    }

    void reprocess(List<TaskHolder<ID, T>> holders, TaskProcessor.ProcessingResult processingResult) {
        this.reprocessQueue.addAll(holders);
        this.replayedTasks.addAndGet(holders.size());
        this.trafficShaper.registerFailure(processingResult);
    }

    void reprocess(TaskHolder<ID, T> taskHolder, TaskProcessor.ProcessingResult processingResult) {
        this.reprocessQueue.add(taskHolder);
        this.replayedTasks.incrementAndGet();
        this.trafficShaper.registerFailure(processingResult);
    }

    BlockingQueue<TaskHolder<ID, T>> requestWorkItem() {
        this.singleItemWorkRequests.release();
        return this.singleItemWorkQueue;
    }

    BlockingQueue<List<TaskHolder<ID, T>>> requestWorkItems() {
        this.batchWorkRequests.release();
        return this.batchWorkQueue;
    }

    void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.acceptorThread.interrupt();
        }
    }

    public long getAcceptorQueueSize() {
        return this.acceptorQueue.size();
    }

    public long getReprocessQueueSize() {
        return this.reprocessQueue.size();
    }

    public long getQueueSize() {
        return this.pendingTasks.size();
    }

    public long getPendingJobRequests() {
        return this.singleItemWorkRequests.availablePermits() + this.batchWorkRequests.availablePermits();
    }

    public long workerTaskQueueSize() {
        return this.singleItemWorkQueue.size() + this.batchWorkQueue.size();
    }

    class AcceptorRunner
    implements Runnable {
        AcceptorRunner() {
        }

        @Override
        public void run() {
            long scheduleTime = 0L;
            while (!AcceptorExecutor.this.isShutdown.get()) {
                try {
                    this.drainInputQueues();
                    int totalItems = AcceptorExecutor.this.processingOrder.size();
                    long now = System.currentTimeMillis();
                    if (scheduleTime < now) {
                        scheduleTime = now + AcceptorExecutor.this.trafficShaper.transmissionDelay();
                    }
                    if (scheduleTime <= now) {
                        this.assignBatchWork();
                        this.assignSingleItemWork();
                    }
                    if (totalItems != AcceptorExecutor.this.processingOrder.size()) continue;
                    Thread.sleep(10L);
                }
                catch (InterruptedException totalItems) {
                }
                catch (Throwable e) {
                    logger.warn("Discovery AcceptorThread error", e);
                }
            }
        }

        private boolean isFull() {
            return AcceptorExecutor.this.pendingTasks.size() >= AcceptorExecutor.this.maxBufferSize;
        }

        private void drainInputQueues() throws InterruptedException {
            do {
                TaskHolder taskHolder;
                this.drainReprocessQueue();
                this.drainAcceptorQueue();
                if (AcceptorExecutor.this.isShutdown.get()) break;
                if (!AcceptorExecutor.this.reprocessQueue.isEmpty() || !AcceptorExecutor.this.acceptorQueue.isEmpty() || !AcceptorExecutor.this.pendingTasks.isEmpty() || (taskHolder = (TaskHolder)AcceptorExecutor.this.acceptorQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                this.appendTaskHolder(taskHolder);
            } while (!AcceptorExecutor.this.reprocessQueue.isEmpty() || !AcceptorExecutor.this.acceptorQueue.isEmpty() || AcceptorExecutor.this.pendingTasks.isEmpty());
        }

        private void drainAcceptorQueue() {
            while (!AcceptorExecutor.this.acceptorQueue.isEmpty()) {
                this.appendTaskHolder((TaskHolder)AcceptorExecutor.this.acceptorQueue.poll());
            }
        }

        private void drainReprocessQueue() {
            long now = System.currentTimeMillis();
            while (!AcceptorExecutor.this.reprocessQueue.isEmpty() && !this.isFull()) {
                TaskHolder taskHolder = (TaskHolder)AcceptorExecutor.this.reprocessQueue.pollLast();
                Object id = taskHolder.getId();
                if (taskHolder.getExpiryTime() <= now) {
                    AcceptorExecutor.this.expiredTasks.incrementAndGet();
                    continue;
                }
                if (AcceptorExecutor.this.pendingTasks.containsKey(id)) {
                    AcceptorExecutor.this.overriddenTasks.incrementAndGet();
                    continue;
                }
                AcceptorExecutor.this.pendingTasks.put(id, taskHolder);
                AcceptorExecutor.this.processingOrder.addFirst(id);
            }
            if (this.isFull()) {
                AcceptorExecutor.this.queueOverflows.addAndGet(AcceptorExecutor.this.reprocessQueue.size());
                AcceptorExecutor.this.reprocessQueue.clear();
            }
        }

        private void appendTaskHolder(TaskHolder<ID, T> taskHolder) {
            TaskHolder previousTask;
            if (this.isFull()) {
                AcceptorExecutor.this.pendingTasks.remove(AcceptorExecutor.this.processingOrder.poll());
                AcceptorExecutor.this.queueOverflows.incrementAndGet();
            }
            if ((previousTask = AcceptorExecutor.this.pendingTasks.put(taskHolder.getId(), taskHolder)) == null) {
                AcceptorExecutor.this.processingOrder.add(taskHolder.getId());
            } else {
                AcceptorExecutor.this.overriddenTasks.incrementAndGet();
            }
        }

        void assignSingleItemWork() {
            if (!AcceptorExecutor.this.processingOrder.isEmpty() && AcceptorExecutor.this.singleItemWorkRequests.tryAcquire(1)) {
                long now = System.currentTimeMillis();
                while (!AcceptorExecutor.this.processingOrder.isEmpty()) {
                    Object id = AcceptorExecutor.this.processingOrder.poll();
                    TaskHolder holder = (TaskHolder)AcceptorExecutor.this.pendingTasks.remove(id);
                    if (holder.getExpiryTime() > now) {
                        AcceptorExecutor.this.singleItemWorkQueue.add(holder);
                        return;
                    }
                    AcceptorExecutor.this.expiredTasks.incrementAndGet();
                }
                AcceptorExecutor.this.singleItemWorkRequests.release();
            }
        }

        void assignBatchWork() {
            if (this.hasEnoughTasksForNextBatch() && AcceptorExecutor.this.batchWorkRequests.tryAcquire(1)) {
                long now = System.currentTimeMillis();
                int len = Math.min(AcceptorExecutor.this.maxBatchingSize, AcceptorExecutor.this.processingOrder.size());
                ArrayList<TaskHolder> holders = new ArrayList<TaskHolder>(len);
                while (holders.size() < len && !AcceptorExecutor.this.processingOrder.isEmpty()) {
                    Object id = AcceptorExecutor.this.processingOrder.poll();
                    TaskHolder holder = (TaskHolder)AcceptorExecutor.this.pendingTasks.remove(id);
                    if (holder.getExpiryTime() > now) {
                        holders.add(holder);
                        continue;
                    }
                    AcceptorExecutor.this.expiredTasks.incrementAndGet();
                }
                if (holders.isEmpty()) {
                    AcceptorExecutor.this.batchWorkRequests.release();
                } else {
                    AcceptorExecutor.this.batchSizeMetric.record((long)holders.size());
                    AcceptorExecutor.this.batchWorkQueue.add(holders);
                }
            }
        }

        private boolean hasEnoughTasksForNextBatch() {
            if (AcceptorExecutor.this.processingOrder.isEmpty()) {
                return false;
            }
            if (AcceptorExecutor.this.pendingTasks.size() >= AcceptorExecutor.this.maxBufferSize) {
                return true;
            }
            TaskHolder nextHolder = (TaskHolder)AcceptorExecutor.this.pendingTasks.get(AcceptorExecutor.this.processingOrder.peek());
            long delay = System.currentTimeMillis() - nextHolder.getSubmitTimestamp();
            return delay >= AcceptorExecutor.this.maxBatchingDelay;
        }
    }
}

