/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry.rule;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.aws.AsgClient;
import com.netflix.eureka.lease.Lease;
import com.netflix.eureka.registry.rule.InstanceStatusOverrideRule;
import com.netflix.eureka.registry.rule.StatusOverrideResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsgEnabledRule
implements InstanceStatusOverrideRule {
    private static final Logger logger = LoggerFactory.getLogger(AsgEnabledRule.class);
    private final AsgClient asgClient;

    public AsgEnabledRule(AsgClient asgClient) {
        this.asgClient = asgClient;
    }

    @Override
    public StatusOverrideResult apply(InstanceInfo instanceInfo, Lease<InstanceInfo> existingLease, boolean isReplication) {
        if (instanceInfo.getASGName() != null) {
            boolean isASGDisabled = !this.asgClient.isASGEnabled(instanceInfo);
            logger.debug("The ASG name is specified {} and the value is {}", (Object)instanceInfo.getASGName(), (Object)isASGDisabled);
            if (isASGDisabled) {
                return StatusOverrideResult.matchingStatus(InstanceInfo.InstanceStatus.OUT_OF_SERVICE);
            }
            return StatusOverrideResult.matchingStatus(InstanceInfo.InstanceStatus.UP);
        }
        return StatusOverrideResult.NO_MATCH;
    }

    public String toString() {
        return AsgEnabledRule.class.getName();
    }
}

