/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry.rule;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.lease.Lease;
import com.netflix.eureka.registry.rule.InstanceStatusOverrideRule;
import com.netflix.eureka.registry.rule.StatusOverrideResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseExistsRule
implements InstanceStatusOverrideRule {
    private static final Logger logger = LoggerFactory.getLogger(LeaseExistsRule.class);

    @Override
    public StatusOverrideResult apply(InstanceInfo instanceInfo, Lease<InstanceInfo> existingLease, boolean isReplication) {
        if (!isReplication) {
            InstanceInfo.InstanceStatus existingStatus = null;
            if (existingLease != null) {
                existingStatus = existingLease.getHolder().getStatus();
            }
            if (existingStatus != null && (InstanceInfo.InstanceStatus.OUT_OF_SERVICE.equals((Object)existingStatus) || InstanceInfo.InstanceStatus.UP.equals((Object)existingStatus))) {
                logger.debug("There is already an existing lease with status {}  for instance {}", (Object)existingLease.getHolder().getStatus().name(), (Object)existingLease.getHolder().getId());
                return StatusOverrideResult.matchingStatus(existingLease.getHolder().getStatus());
            }
        }
        return StatusOverrideResult.NO_MATCH;
    }

    public String toString() {
        return LeaseExistsRule.class.getName();
    }
}

