/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.LookupService;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.resolver.StaticClusterResolver;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.EurekaServerHttpClients;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRegionRegistry
implements LookupService<String> {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRegionRegistry.class);
    private final ApacheHttpClient4 discoveryApacheClient;
    private final EurekaJerseyClient discoveryJerseyClient;
    private final Timer fetchRegistryTimer;
    private final URL remoteRegionURL;
    private final ScheduledExecutorService scheduler;
    private final AtomicLong fullRegistryGeneration = new AtomicLong(0L);
    private final AtomicLong deltaGeneration = new AtomicLong(0L);
    private final AtomicReference<Applications> applications = new AtomicReference();
    private final AtomicReference<Applications> applicationsDelta = new AtomicReference();
    private final EurekaServerConfig serverConfig;
    private volatile boolean readyForServingData;
    private final EurekaHttpClient eurekaHttpClient;

    @Inject
    public RemoteRegionRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, String regionName, URL remoteRegionURL) {
        this.serverConfig = serverConfig;
        this.remoteRegionURL = remoteRegionURL;
        this.fetchRegistryTimer = Monitors.newTimer((String)(this.remoteRegionURL.toString() + "_FetchRegistry"));
        EurekaJerseyClientImpl.EurekaJerseyClientBuilder clientBuilder = new EurekaJerseyClientImpl.EurekaJerseyClientBuilder().withUserAgent("Java-EurekaClient-RemoteRegion").withEncoderWrapper((EncoderWrapper)serverCodecs.getFullJsonCodec()).withDecoderWrapper((DecoderWrapper)serverCodecs.getFullJsonCodec()).withConnectionTimeout(serverConfig.getRemoteRegionConnectTimeoutMs()).withReadTimeout(serverConfig.getRemoteRegionReadTimeoutMs()).withMaxConnectionsPerHost(serverConfig.getRemoteRegionTotalConnectionsPerHost()).withMaxTotalConnections(serverConfig.getRemoteRegionTotalConnections()).withConnectionIdleTimeout(serverConfig.getRemoteRegionConnectionIdleTimeoutSeconds());
        if (remoteRegionURL.getProtocol().equals("http")) {
            clientBuilder.withClientName("Discovery-RemoteRegionClient-" + regionName);
        } else if ("true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
            clientBuilder.withClientName("Discovery-RemoteRegionSystemSecureClient-" + regionName).withSystemSSLConfiguration();
        } else {
            clientBuilder.withClientName("Discovery-RemoteRegionSecureClient-" + regionName).withTrustStoreFile(serverConfig.getRemoteRegionTrustStore(), serverConfig.getRemoteRegionTrustStorePassword());
        }
        this.discoveryJerseyClient = clientBuilder.build();
        this.discoveryApacheClient = this.discoveryJerseyClient.getClient();
        if (serverConfig.shouldGZipContentFromRemoteRegion()) {
            this.discoveryApacheClient.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
        }
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warn("Cannot find localhost ip", (Throwable)e);
        }
        EurekaServerIdentity identity = new EurekaServerIdentity(ip);
        this.discoveryApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
        EurekaHttpClient newEurekaHttpClient = null;
        try {
            ClusterResolver clusterResolver = StaticClusterResolver.fromURL((String)regionName, (URL)remoteRegionURL);
            newEurekaHttpClient = EurekaServerHttpClients.createRemoteRegionClient(serverConfig, clientConfig.getTransportConfig(), serverCodecs, (ClusterResolver<EurekaEndpoint>)clusterResolver);
        }
        catch (Exception e) {
            logger.warn("Transport initialization failure", (Throwable)e);
        }
        this.eurekaHttpClient = newEurekaHttpClient;
        this.applications.set(new Applications());
        try {
            if (this.fetchRegistry()) {
                this.readyForServingData = true;
            } else {
                logger.warn("Failed to fetch remote registry. This means this eureka server is not ready for serving traffic.");
            }
        }
        catch (Throwable e) {
            logger.error("Problem fetching registry information :", e);
        }
        Runnable remoteRegionFetchTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (RemoteRegionRegistry.this.fetchRegistry()) {
                        RemoteRegionRegistry.this.readyForServingData = true;
                    } else {
                        logger.warn("Failed to fetch remote registry. This means this eureka server is not ready for serving traffic.");
                    }
                }
                catch (Throwable e) {
                    logger.error("Error getting from remote registry :", e);
                }
            }
        };
        ThreadPoolExecutor remoteRegionFetchExecutor = new ThreadPoolExecutor(1, serverConfig.getRemoteRegionFetchThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("Eureka-RemoteRegionCacheRefresher_" + regionName + "-%d").setDaemon(true).build());
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("RemoteRegionFetch_" + regionName, this.scheduler, remoteRegionFetchExecutor, serverConfig.getRemoteRegionRegistryFetchInterval(), TimeUnit.SECONDS, 5, remoteRegionFetchTask), (long)serverConfig.getRemoteRegionRegistryFetchInterval(), TimeUnit.SECONDS);
    }

    public boolean isReadyForServingData() {
        return this.readyForServingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchRegistry() {
        boolean success;
        Stopwatch tracer = this.fetchRegistryTimer.start();
        try {
            if (this.serverConfig.shouldDisableDeltaForRemoteRegions() || this.getApplications() == null || this.getApplications().getRegisteredApplications().size() == 0) {
                logger.info("Disable delta property : {}", (Object)this.serverConfig.shouldDisableDeltaForRemoteRegions());
                logger.info("Application is null : {}", (Object)(this.getApplications() == null ? 1 : 0));
                logger.info("Registered Applications size is zero : {}", (Object)this.getApplications().getRegisteredApplications().isEmpty());
                success = this.storeFullRegistry();
            } else {
                success = this.fetchAndStoreDelta();
            }
            this.logTotalInstances();
        }
        catch (Throwable e) {
            logger.error("Unable to fetch registry information from the remote registry " + this.remoteRegionURL.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
        return success;
    }

    private boolean fetchAndStoreDelta() throws Throwable {
        long currDeltaGeneration = this.deltaGeneration.get();
        Applications delta = this.fetchRemoteRegistry(true);
        if (delta == null) {
            logger.error("The delta is null for some reason. Not storing this information");
        } else if (this.deltaGeneration.compareAndSet(currDeltaGeneration, currDeltaGeneration + 1L)) {
            this.applicationsDelta.set(delta);
        } else {
            delta = null;
            logger.warn("Not updating delta as another thread is updating it already");
        }
        if (delta == null) {
            logger.warn("The server does not allow the delta revision to be applied because it is not safe. Hence got the full registry.");
            return this.storeFullRegistry();
        }
        this.updateDelta(delta);
        String reconcileHashCode = this.getApplications().getReconcileHashCode();
        if (!reconcileHashCode.equals(delta.getAppsHashCode())) {
            return this.reconcileAndLogDifference(delta, reconcileHashCode);
        }
        return delta != null;
    }

    private void updateDelta(Applications delta) {
        int deltaCount = 0;
        for (Application app : delta.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                Application existingApp;
                ++deltaCount;
                if (InstanceInfo.ActionType.ADDED.equals((Object)instance.getActionType())) {
                    existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        this.getApplications().addApplication(app);
                    }
                    logger.debug("Added instance {} to the existing apps ", (Object)instance.getId());
                    this.getApplications().getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (InstanceInfo.ActionType.MODIFIED.equals((Object)instance.getActionType())) {
                    existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        this.getApplications().addApplication(app);
                    }
                    logger.debug("Modified instance {} to the existing apps ", (Object)instance.getId());
                    this.getApplications().getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (!InstanceInfo.ActionType.DELETED.equals((Object)instance.getActionType())) continue;
                existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                if (existingApp == null) {
                    this.getApplications().addApplication(app);
                }
                logger.debug("Deleted instance {} to the existing apps ", (Object)instance.getId());
                this.getApplications().getRegisteredApplications(instance.getAppName()).removeInstance(instance);
            }
        }
        logger.debug("The total number of instances fetched by the delta processor : {}", (Object)deltaCount);
    }

    private void closeResponse(ClientResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Throwable th) {
                logger.error("Cannot release response resource :", th);
            }
        }
    }

    public boolean storeFullRegistry() {
        long currentUpdateGeneration = this.fullRegistryGeneration.get();
        Applications apps = this.fetchRemoteRegistry(false);
        if (apps == null) {
            logger.error("The application is null for some reason. Not storing this information");
        } else {
            if (this.fullRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
                this.applications.set(apps);
                logger.info("Successfully updated registry with the latest content");
                return true;
            }
            logger.warn("Not updating applications as another thread is updating it already");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Applications fetchRemoteRegistry(boolean delta) {
        logger.info("Getting instance registry info from the eureka server : {} , delta : {}", (Object)this.remoteRegionURL, (Object)delta);
        if (this.shouldUseExperimentalTransport()) {
            try {
                EurekaHttpResponse httpResponse = delta ? this.eurekaHttpClient.getDelta(new String[0]) : this.eurekaHttpClient.getApplications(new String[0]);
                int httpStatus = httpResponse.getStatusCode();
                if (httpStatus >= 200 && httpStatus < 300) {
                    logger.debug("Got the data successfully : {}", (Object)httpStatus);
                    return (Applications)httpResponse.getEntity();
                }
                logger.warn("Cannot get the data from {} : {}", (Object)this.remoteRegionURL, (Object)httpStatus);
            }
            catch (Throwable t) {
                logger.error("Can't get a response from " + this.remoteRegionURL, t);
            }
        } else {
            int httpStatus;
            ClientResponse response;
            block11: {
                response = null;
                String urlPath = delta ? "apps/delta" : "apps/";
                response = (ClientResponse)this.discoveryApacheClient.resource(this.remoteRegionURL + urlPath).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
                httpStatus = response.getStatus();
                if (httpStatus < 200 || httpStatus >= 300) break block11;
                logger.debug("Got the data successfully : {}", (Object)httpStatus);
                Applications applications = (Applications)response.getEntity(Applications.class);
                this.closeResponse(response);
                return applications;
            }
            try {
                logger.warn("Cannot get the data from {} : {}", (Object)this.remoteRegionURL, (Object)httpStatus);
                this.closeResponse(response);
            }
            catch (Throwable t) {
                try {
                    logger.error("Can't get a response from " + this.remoteRegionURL, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.closeResponse(response);
                }
            }
        }
        return null;
    }

    private boolean reconcileAndLogDifference(Applications delta, String reconcileHashCode) throws Throwable {
        logger.warn("The Reconcile hashcodes do not match, client : {}, server : {}. Getting the full registry", (Object)reconcileHashCode, (Object)delta.getAppsHashCode());
        Applications serverApps = this.fetchRemoteRegistry(false);
        this.applications.set(serverApps);
        this.applicationsDelta.set(serverApps);
        logger.warn("The Reconcile hashcodes after complete sync up, client : {}, server : {}.", (Object)this.getApplications().getReconcileHashCode(), (Object)delta.getAppsHashCode());
        return true;
    }

    private void logTotalInstances() {
        int totInstances = 0;
        for (Application application : this.getApplications().getRegisteredApplications()) {
            totInstances += application.getInstancesAsIsFromEureka().size();
        }
        logger.debug("The total number of all instances in the client now is {}", (Object)totInstances);
    }

    public Applications getApplications() {
        return this.applications.get();
    }

    public InstanceInfo getNextServerFromEureka(String arg0, boolean arg1) {
        return null;
    }

    public Application getApplication(String appName) {
        return this.applications.get().getRegisteredApplications(appName);
    }

    public List<InstanceInfo> getInstancesById(String id) {
        List<InstanceInfo> list = Collections.emptyList();
        for (Application app : this.applications.get().getRegisteredApplications()) {
            InstanceInfo info = app.getByInstanceId(id);
            if (info == null) continue;
            list.add(info);
            return list;
        }
        return list;
    }

    public Applications getApplicationDeltas() {
        return this.applicationsDelta.get();
    }

    private boolean shouldUseExperimentalTransport() {
        if (this.eurekaHttpClient == null) {
            return false;
        }
        String enabled = this.serverConfig.getExperimental("transport.enabled");
        return enabled != null && "true".equalsIgnoreCase(enabled);
    }
}

