/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.DynamicStringSetProperty;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.aws.AwsBindingStrategy;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultEurekaServerConfig
implements EurekaServerConfig {
    private static final String ARCHAIUS_DEPLOYMENT_ENVIRONMENT = "archaius.deployment.environment";
    private static final String TEST = "test";
    private static final String EUREKA_ENVIRONMENT = "eureka.environment";
    private static final Logger logger = LoggerFactory.getLogger(DefaultEurekaServerConfig.class);
    private static final DynamicPropertyFactory configInstance = DynamicPropertyFactory.getInstance();
    private static final DynamicStringProperty EUREKA_PROPS_FILE = DynamicPropertyFactory.getInstance().getStringProperty("eureka.server.props", "eureka-server");
    private static final int TIME_TO_WAIT_FOR_REPLICATION = 30000;
    private String namespace = "eureka.";
    private final DynamicStringSetProperty rateLimiterPrivilegedClients = new DynamicStringSetProperty(this.namespace + "rateLimiter.privilegedClients", Collections.emptySet());
    private final DynamicBooleanProperty rateLimiterEnabled = configInstance.getBooleanProperty(this.namespace + "rateLimiter.enabled", false);
    private final DynamicBooleanProperty rateLimiterThrottleStandardClients = configInstance.getBooleanProperty(this.namespace + "rateLimiter.throttleStandardClients", false);
    private final DynamicIntProperty rateLimiterBurstSize = configInstance.getIntProperty(this.namespace + "rateLimiter.burstSize", 10);
    private final DynamicIntProperty rateLimiterRegistryFetchAverageRate = configInstance.getIntProperty(this.namespace + "rateLimiter.registryFetchAverageRate", 500);
    private final DynamicIntProperty rateLimiterFullFetchAverageRate = configInstance.getIntProperty(this.namespace + "rateLimiter.fullFetchAverageRate", 100);
    private final DynamicStringProperty listAutoScalingGroupsRoleName = configInstance.getStringProperty(this.namespace + "listAutoScalingGroupsRoleName", "ListAutoScalingGroups");

    public DefaultEurekaServerConfig() {
        this.init();
    }

    public DefaultEurekaServerConfig(String namespace) {
        this.namespace = namespace;
        this.init();
    }

    private void init() {
        String env = ConfigurationManager.getConfigInstance().getString(EUREKA_ENVIRONMENT, TEST);
        ConfigurationManager.getConfigInstance().setProperty(ARCHAIUS_DEPLOYMENT_ENVIRONMENT, (Object)env);
        String eurekaPropsFile = EUREKA_PROPS_FILE.get();
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)eurekaPropsFile);
        }
        catch (IOException e) {
            logger.warn("Cannot find the properties specified : {}. This may be okay if there are other environment specific properties or the configuration is installed with a different mechanism.", (Object)eurekaPropsFile);
        }
    }

    @Override
    public String getAWSAccessId() {
        String aWSAccessId = configInstance.getStringProperty(this.namespace + "awsAccessId", null).get();
        if (null != aWSAccessId) {
            return aWSAccessId.trim();
        }
        return null;
    }

    @Override
    public String getAWSSecretKey() {
        String aWSSecretKey = configInstance.getStringProperty(this.namespace + "awsSecretKey", null).get();
        if (null != aWSSecretKey) {
            return aWSSecretKey.trim();
        }
        return null;
    }

    @Override
    public int getEIPBindRebindRetries() {
        return configInstance.getIntProperty(this.namespace + "eipBindRebindRetries", 3).get();
    }

    @Override
    public int getEIPBindingRetryIntervalMsWhenUnbound() {
        return configInstance.getIntProperty(this.namespace + "eipBindRebindRetryIntervalMsWhenUnbound", 60000).get();
    }

    @Override
    public int getEIPBindingRetryIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "eipBindRebindRetryIntervalMs", 300000).get();
    }

    @Override
    public boolean shouldEnableSelfPreservation() {
        return configInstance.getBooleanProperty(this.namespace + "enableSelfPreservation", true).get();
    }

    @Override
    public int getPeerEurekaNodesUpdateIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "peerEurekaNodesUpdateIntervalMs", 600000).get();
    }

    @Override
    public int getRenewalThresholdUpdateIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "renewalThresholdUpdateIntervalMs", 900000).get();
    }

    @Override
    public double getRenewalPercentThreshold() {
        return configInstance.getDoubleProperty(this.namespace + "renewalPercentThreshold", 0.85).get();
    }

    @Override
    public boolean shouldEnableReplicatedRequestCompression() {
        return configInstance.getBooleanProperty(this.namespace + "enableReplicatedRequestCompression", false).get();
    }

    @Override
    public int getNumberOfReplicationRetries() {
        return configInstance.getIntProperty(this.namespace + "numberOfReplicationRetries", 5).get();
    }

    @Override
    public int getPeerEurekaStatusRefreshTimeIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "peerEurekaStatusRefreshTimeIntervalMs", 30000).get();
    }

    @Override
    public int getWaitTimeInMsWhenSyncEmpty() {
        return configInstance.getIntProperty(this.namespace + "waitTimeInMsWhenSyncEmpty", 300000).get();
    }

    @Override
    public int getPeerNodeConnectTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "peerNodeConnectTimeoutMs", 200).get();
    }

    @Override
    public int getPeerNodeReadTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "peerNodeReadTimeoutMs", 200).get();
    }

    @Override
    public int getPeerNodeTotalConnections() {
        return configInstance.getIntProperty(this.namespace + "peerNodeTotalConnections", 1000).get();
    }

    @Override
    public int getPeerNodeTotalConnectionsPerHost() {
        return configInstance.getIntProperty(this.namespace + "peerNodeTotalConnectionsPerHost", 500).get();
    }

    @Override
    public int getPeerNodeConnectionIdleTimeoutSeconds() {
        return configInstance.getIntProperty(this.namespace + "peerNodeConnectionIdleTimeoutSeconds", 30).get();
    }

    @Override
    public long getRetentionTimeInMSInDeltaQueue() {
        return configInstance.getLongProperty(this.namespace + "retentionTimeInMSInDeltaQueue", 180000L).get();
    }

    @Override
    public long getDeltaRetentionTimerIntervalInMs() {
        return configInstance.getLongProperty(this.namespace + "deltaRetentionTimerIntervalInMs", 30000L).get();
    }

    @Override
    public long getEvictionIntervalTimerInMs() {
        return configInstance.getLongProperty(this.namespace + "evictionIntervalTimerInMs", 60000L).get();
    }

    @Override
    public int getASGQueryTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "asgQueryTimeoutMs", 300).get();
    }

    @Override
    public long getASGUpdateIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "asgUpdateIntervalMs", 300000).get();
    }

    @Override
    public long getASGCacheExpiryTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "asgCacheExpiryTimeoutMs", 600000).get();
    }

    @Override
    public long getResponseCacheAutoExpirationInSeconds() {
        return configInstance.getIntProperty(this.namespace + "responseCacheAutoExpirationInSeconds", 180).get();
    }

    @Override
    public long getResponseCacheUpdateIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "responseCacheUpdateIntervalMs", 30000).get();
    }

    @Override
    public boolean shouldUseReadOnlyResponseCache() {
        return configInstance.getBooleanProperty(this.namespace + "shouldUseReadOnlyResponseCache", true).get();
    }

    @Override
    public boolean shouldDisableDelta() {
        return configInstance.getBooleanProperty(this.namespace + "disableDelta", false).get();
    }

    @Override
    public long getMaxIdleThreadInMinutesAgeForStatusReplication() {
        return configInstance.getLongProperty(this.namespace + "maxIdleThreadAgeInMinutesForStatusReplication", 10L).get();
    }

    @Override
    public int getMinThreadsForStatusReplication() {
        return configInstance.getIntProperty(this.namespace + "minThreadsForStatusReplication", 1).get();
    }

    @Override
    public int getMaxThreadsForStatusReplication() {
        return configInstance.getIntProperty(this.namespace + "maxThreadsForStatusReplication", 1).get();
    }

    @Override
    public int getMaxElementsInStatusReplicationPool() {
        return configInstance.getIntProperty(this.namespace + "maxElementsInStatusReplicationPool", 10000).get();
    }

    @Override
    public boolean shouldSyncWhenTimestampDiffers() {
        return configInstance.getBooleanProperty(this.namespace + "syncWhenTimestampDiffers", true).get();
    }

    @Override
    public int getRegistrySyncRetries() {
        return configInstance.getIntProperty(this.namespace + "numberRegistrySyncRetries", 5).get();
    }

    @Override
    public long getRegistrySyncRetryWaitMs() {
        return configInstance.getIntProperty(this.namespace + "registrySyncRetryWaitMs", 30000).get();
    }

    @Override
    public int getMaxElementsInPeerReplicationPool() {
        return configInstance.getIntProperty(this.namespace + "maxElementsInPeerReplicationPool", 10000).get();
    }

    @Override
    public long getMaxIdleThreadAgeInMinutesForPeerReplication() {
        return configInstance.getIntProperty(this.namespace + "maxIdleThreadAgeInMinutesForPeerReplication", 15).get();
    }

    @Override
    public int getMinThreadsForPeerReplication() {
        return configInstance.getIntProperty(this.namespace + "minThreadsForPeerReplication", 5).get();
    }

    @Override
    public int getMaxThreadsForPeerReplication() {
        return configInstance.getIntProperty(this.namespace + "maxThreadsForPeerReplication", 20).get();
    }

    @Override
    public int getMaxTimeForReplication() {
        return configInstance.getIntProperty(this.namespace + "maxTimeForReplication", 30000).get();
    }

    @Override
    public boolean shouldPrimeAwsReplicaConnections() {
        return configInstance.getBooleanProperty(this.namespace + "primeAwsReplicaConnections", true).get();
    }

    @Override
    public boolean shouldDisableDeltaForRemoteRegions() {
        return configInstance.getBooleanProperty(this.namespace + "disableDeltaForRemoteRegions", false).get();
    }

    @Override
    public int getRemoteRegionConnectTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "remoteRegionConnectTimeoutMs", 1000).get();
    }

    @Override
    public int getRemoteRegionReadTimeoutMs() {
        return configInstance.getIntProperty(this.namespace + "remoteRegionReadTimeoutMs", 1000).get();
    }

    @Override
    public int getRemoteRegionTotalConnections() {
        return configInstance.getIntProperty(this.namespace + "remoteRegionTotalConnections", 1000).get();
    }

    @Override
    public int getRemoteRegionTotalConnectionsPerHost() {
        return configInstance.getIntProperty(this.namespace + "remoteRegionTotalConnectionsPerHost", 500).get();
    }

    @Override
    public int getRemoteRegionConnectionIdleTimeoutSeconds() {
        return configInstance.getIntProperty(this.namespace + "remoteRegionConnectionIdleTimeoutSeconds", 30).get();
    }

    @Override
    public boolean shouldGZipContentFromRemoteRegion() {
        return configInstance.getBooleanProperty(this.namespace + "remoteRegion.gzipContent", true).get();
    }

    @Override
    public Map<String, String> getRemoteRegionUrlsWithName() {
        String propName = this.namespace + "remoteRegionUrlsWithName";
        String remoteRegionUrlWithNameString = configInstance.getStringProperty(propName, null).get();
        if (null == remoteRegionUrlWithNameString) {
            return Collections.emptyMap();
        }
        String[] remoteRegionUrlWithNamePairs = remoteRegionUrlWithNameString.split(",");
        HashMap<String, String> toReturn = new HashMap<String, String>(remoteRegionUrlWithNamePairs.length);
        String pairSplitChar = ";";
        for (String remoteRegionUrlWithNamePair : remoteRegionUrlWithNamePairs) {
            String[] pairSplit = remoteRegionUrlWithNamePair.split(";");
            if (pairSplit.length < 2) {
                logger.error("Error reading eureka remote region urls from property {}. Invalid entry {} for remote region url. The entry must contain region name and url separated by a {}. Ignoring this entry.", (Object[])new String[]{propName, remoteRegionUrlWithNamePair, ";"});
                continue;
            }
            String regionName = pairSplit[0];
            String regionUrl = pairSplit[1];
            if (pairSplit.length > 2) {
                StringBuilder regionUrlAssembler = new StringBuilder();
                for (int i = 1; i < pairSplit.length; ++i) {
                    if (regionUrlAssembler.length() != 0) {
                        regionUrlAssembler.append(";");
                    }
                    regionUrlAssembler.append(pairSplit[i]);
                }
                regionUrl = regionUrlAssembler.toString();
            }
            toReturn.put(regionName, regionUrl);
        }
        return toReturn;
    }

    @Override
    public String[] getRemoteRegionUrls() {
        String remoteRegionUrlString = configInstance.getStringProperty(this.namespace + "remoteRegionUrls", null).get();
        String[] remoteRegionUrl = null;
        if (remoteRegionUrlString != null) {
            remoteRegionUrl = remoteRegionUrlString.split(",");
        }
        return remoteRegionUrl;
    }

    @Override
    @Nullable
    public Set<String> getRemoteRegionAppWhitelist(@Nullable String regionName) {
        regionName = null == regionName ? "global" : regionName.trim().toLowerCase();
        DynamicStringProperty appWhiteListProp = configInstance.getStringProperty(this.namespace + "remoteRegion." + regionName + ".appWhiteList", null);
        if (null == appWhiteListProp || null == appWhiteListProp.get()) {
            return null;
        }
        String appWhiteListStr = appWhiteListProp.get();
        String[] whitelistEntries = appWhiteListStr.split(",");
        return new HashSet<String>(Arrays.asList(whitelistEntries));
    }

    @Override
    public int getRemoteRegionRegistryFetchInterval() {
        return configInstance.getIntProperty(this.namespace + "remoteRegion.registryFetchIntervalInSeconds", 30).get();
    }

    @Override
    public int getRemoteRegionFetchThreadPoolSize() {
        return configInstance.getIntProperty(this.namespace + "remoteRegion.fetchThreadPoolSize", 20).get();
    }

    @Override
    public String getRemoteRegionTrustStore() {
        return configInstance.getStringProperty(this.namespace + "remoteRegion.trustStoreFileName", "").get();
    }

    @Override
    public String getRemoteRegionTrustStorePassword() {
        return configInstance.getStringProperty(this.namespace + "remoteRegion.trustStorePassword", "changeit").get();
    }

    @Override
    public boolean disableTransparentFallbackToOtherRegion() {
        return configInstance.getBooleanProperty(this.namespace + "remoteRegion.disable.transparent.fallback", false).get();
    }

    @Override
    public boolean shouldBatchReplication() {
        return configInstance.getBooleanProperty(this.namespace + "shouldBatchReplication", false).get();
    }

    @Override
    public boolean shouldLogIdentityHeaders() {
        return configInstance.getBooleanProperty(this.namespace + "auth.shouldLogIdentityHeaders", true).get();
    }

    @Override
    public String getJsonCodecName() {
        return configInstance.getStringProperty(this.namespace + "jsonCodecName", null).get();
    }

    @Override
    public String getXmlCodecName() {
        return configInstance.getStringProperty(this.namespace + "xmlCodecName", null).get();
    }

    @Override
    public boolean isRateLimiterEnabled() {
        return this.rateLimiterEnabled.get();
    }

    @Override
    public boolean isRateLimiterThrottleStandardClients() {
        return this.rateLimiterThrottleStandardClients.get();
    }

    @Override
    public Set<String> getRateLimiterPrivilegedClients() {
        return this.rateLimiterPrivilegedClients.get();
    }

    @Override
    public int getRateLimiterBurstSize() {
        return this.rateLimiterBurstSize.get();
    }

    @Override
    public int getRateLimiterRegistryFetchAverageRate() {
        return this.rateLimiterRegistryFetchAverageRate.get();
    }

    @Override
    public int getRateLimiterFullFetchAverageRate() {
        return this.rateLimiterFullFetchAverageRate.get();
    }

    @Override
    public String getListAutoScalingGroupsRoleName() {
        return this.listAutoScalingGroupsRoleName.get();
    }

    @Override
    public int getRoute53BindRebindRetries() {
        return configInstance.getIntProperty(this.namespace + "route53BindRebindRetries", 3).get();
    }

    @Override
    public int getRoute53BindingRetryIntervalMs() {
        return configInstance.getIntProperty(this.namespace + "route53BindRebindRetryIntervalMs", 300000).get();
    }

    @Override
    public long getRoute53DomainTTL() {
        return configInstance.getLongProperty(this.namespace + "route53DomainTTL", 30L).get();
    }

    @Override
    public AwsBindingStrategy getBindingStrategy() {
        return AwsBindingStrategy.valueOf(configInstance.getStringProperty(this.namespace + "awsBindingStrategy", AwsBindingStrategy.EIP.name()).get().toUpperCase());
    }

    @Override
    public String getExperimental(String name) {
        return configInstance.getStringProperty(this.namespace + "experimental." + name, null).get();
    }
}

