/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.util.StatusInfo;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{version}/status")
@Produces(value={"application/xml", "application/json"})
public class StatusResource {
    private static final Logger logger = LoggerFactory.getLogger(StatusResource.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss Z";
    private final PeerAwareInstanceRegistryImpl registry = PeerAwareInstanceRegistryImpl.getInstance();

    @GET
    public StatusInfo getStatusInfo() {
        StatusInfo.Builder builder = StatusInfo.Builder.newBuilder();
        StringBuilder upReplicas = new StringBuilder();
        StringBuilder downReplicas = new StringBuilder();
        StringBuilder replicaHostNames = new StringBuilder();
        String myAppName = ApplicationInfoManager.getInstance().getInfo().getAppName();
        for (PeerEurekaNode node : this.registry.getReplicaNodes()) {
            if (replicaHostNames.length() > 0) {
                replicaHostNames.append(", ");
            }
            replicaHostNames.append(node.getServiceUrl());
            if (this.isReplicaAvailable(myAppName, node.getServiceUrl())) {
                upReplicas.append(node.getServiceUrl()).append(',');
                continue;
            }
            downReplicas.append(node.getServiceUrl()).append(',');
        }
        builder.add("registered-replicas", replicaHostNames.toString());
        builder.add("available-replicas", upReplicas.toString());
        builder.add("unavailable-replicas", downReplicas.toString());
        return builder.build();
    }

    private boolean isReplicaAvailable(String myAppName, String url) {
        try {
            String givenHostName = new URI(url).getHost();
            Application app = PeerAwareInstanceRegistryImpl.getInstance().getApplication(myAppName, false);
            for (InstanceInfo info : app.getInstances()) {
                if (!info.getHostName().equals(givenHostName)) continue;
                return true;
            }
            givenHostName = new URI(url).getHost();
        }
        catch (Throwable e) {
            logger.error("Could not determine if the replica is available ", e);
        }
        return false;
    }

    public static String getCurrentTimeAsString() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(new Date());
    }
}

