/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasuredRate {
    private static final Logger logger = LoggerFactory.getLogger(MeasuredRate.class);
    private final AtomicLong lastBucket = new AtomicLong(0L);
    private final AtomicLong currentBucket = new AtomicLong(0L);
    private final long sampleInterval;
    private Timer timer = new Timer("Eureka-MeasureRateTimer", true);

    public MeasuredRate(long sampleInterval) {
        this.sampleInterval = sampleInterval;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    MeasuredRate.this.lastBucket.set(MeasuredRate.this.currentBucket.getAndSet(0L));
                }
                catch (Throwable e) {
                    logger.error("Cannot reset the Measured Rate", e);
                }
            }
        }, sampleInterval, sampleInterval);
    }

    public long getCount() {
        return this.lastBucket.get();
    }

    public void increment() {
        this.currentBucket.incrementAndGet();
    }
}

