/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.resources.ResponseCache;

class ServerCodecs {
    private final EncoderWrapper fullJsonEncoder;
    private final EncoderWrapper miniJsonEncoder;
    private final EncoderWrapper fullXmlEncoder;
    private final EncoderWrapper miniXmlEncoder;

    public ServerCodecs(EurekaServerConfig config) {
        EncoderWrapper temp = CodecWrappers.getEncoder((String)config.getJsonCodecName());
        this.fullJsonEncoder = temp == null ? CodecWrappers.getEncoder(CodecWrappers.LegacyJacksonJson.class) : temp;
        temp = CodecWrappers.getEncoder((String)config.getXmlCodecName());
        this.fullXmlEncoder = temp == null ? CodecWrappers.getEncoder(CodecWrappers.XStreamXml.class) : temp;
        this.miniJsonEncoder = CodecWrappers.getEncoder(CodecWrappers.JacksonJsonMini.class);
        this.miniXmlEncoder = CodecWrappers.getEncoder(CodecWrappers.JacksonXmlMini.class);
    }

    public EncoderWrapper getEncoder(ResponseCache.KeyType keyType, boolean compact) {
        switch (keyType) {
            case JSON: {
                return compact ? this.miniJsonEncoder : this.fullJsonEncoder;
            }
        }
        return compact ? this.miniXmlEncoder : this.fullXmlEncoder;
    }

    public EncoderWrapper getEncoder(ResponseCache.KeyType keyType, EurekaAccept eurekaAccept) {
        switch (eurekaAccept) {
            case compact: {
                return this.getEncoder(keyType, true);
            }
        }
        return this.getEncoder(keyType, false);
    }
}

