/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.google.common.base.Strings;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.servo.monitor.DynamicCounter;
import com.netflix.servo.monitor.MonitorConfig;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ServerRequestAuthFilter
implements Filter {
    public static final String UNKNOWN = "unknown";
    private static final String NAME_PREFIX = "DiscoveryServerRequestAuth_Name_";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.logAuth(request);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected void logAuth(ServletRequest request) {
        if (EurekaServerConfigurationManager.getInstance().getConfiguration().shouldLogIdentityHeaders() && request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String clientName = this.getHeader(httpRequest, "DiscoveryIdentity-Name");
            String clientVersion = this.getHeader(httpRequest, "DiscoveryIdentity-Version");
            DynamicCounter.increment((MonitorConfig)MonitorConfig.builder((String)(NAME_PREFIX + clientName + "-" + clientVersion)).build());
        }
    }

    protected String getHeader(HttpServletRequest request, String headerKey) {
        String value = request.getHeader(headerKey);
        return Strings.isNullOrEmpty((String)value) ? UNKNOWN : value;
    }
}

