/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.cluster.ReplicationTask;

public abstract class InstanceReplicationTask
extends ReplicationTask {
    private final String appName;
    private final String id;
    private final InstanceInfo instanceInfo;
    private final InstanceInfo.InstanceStatus overriddenStatus;
    private final boolean replicateInstanceInfo;

    protected InstanceReplicationTask(String peerNodeName, PeerAwareInstanceRegistryImpl.Action action, String appName, String id) {
        super(peerNodeName, action);
        this.appName = appName;
        this.id = id;
        this.instanceInfo = null;
        this.overriddenStatus = null;
        this.replicateInstanceInfo = false;
    }

    protected InstanceReplicationTask(String peerNodeName, PeerAwareInstanceRegistryImpl.Action action, InstanceInfo instanceInfo, InstanceInfo.InstanceStatus overriddenStatus, boolean replicateInstanceInfo) {
        super(peerNodeName, action);
        this.appName = instanceInfo.getAppName();
        this.id = instanceInfo.getId();
        this.instanceInfo = instanceInfo;
        this.overriddenStatus = overriddenStatus;
        this.replicateInstanceInfo = replicateInstanceInfo;
    }

    @Override
    public String getTaskName() {
        return this.appName + '/' + this.id + ':' + (Object)((Object)this.action) + '@' + this.peerNodeName;
    }

    @Override
    public boolean isBatchingSupported() {
        return true;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getId() {
        return this.id;
    }

    public InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    public InstanceInfo.InstanceStatus getOverriddenStatus() {
        return this.overriddenStatus;
    }

    public boolean shouldReplicateInstanceInfo() {
        return this.replicateInstanceInfo;
    }
}

