/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComputationException;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.LookupService;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.InstanceRegistry;
import com.netflix.eureka.Version;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.eureka.util.EurekaMonitors;
import com.netflix.eureka.util.MeasuredRate;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerAwareInstanceRegistry
extends InstanceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PeerAwareInstanceRegistry.class);
    private static final EurekaServerConfig eurekaServerConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private static final String DICOVERY_FAILED_REPLICATION_AFTER_RETRY = "FailedReplicationAfterRetry";
    private static final int REPL_RETRY_SLEEP_TIME_IN_MS = 40;
    private long startupTime = 0L;
    private boolean peerInstancesTransferEmptyOnStartup = true;
    private static final java.util.Timer timerReplicaNodes = new java.util.Timer("Eureka-PeerNodesUpdater", true);
    private static final Comparator<Application> APP_COMPARATOR = new Comparator<Application>(){

        @Override
        public int compare(Application l, Application r) {
            return l.getName().compareTo(r.getName());
        }
    };
    private final MeasuredRate numberOfReplicationsLastMin = new MeasuredRate(60000L);
    private final ThreadPoolExecutor replicationExecutorPool;
    private volatile int numberOfRenewsPerMinThreshold;
    private AtomicReference<List<PeerEurekaNode>> peerEurekaNodes;
    private java.util.Timer timer = new java.util.Timer("ReplicaAwareInstanceRegistry - RenewalThresholdUpdater", true);
    private static final LoadingCache<String, Boolean> peerEurekaStatusCache = CacheBuilder.newBuilder().initialCapacity(10).expireAfterWrite((long)eurekaServerConfig.getPeerEurekaStatusRefreshTimeIntervalMs(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, Boolean>(){

        public Boolean load(String serviceUrl) {
            try {
                return PeerAwareInstanceRegistry.isPeerAliveInMyRegistery(serviceUrl);
            }
            catch (Throwable e) {
                throw new ComputationException(e);
            }
        }
    });
    private static ConcurrentMap<String, Boolean> peerEurekaStatusMap = new ConcurrentHashMap<String, Boolean>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Boolean get(Object key) {
            String myKey = (String)key;
            try {
                return (Boolean)peerEurekaStatusCache.get((Object)myKey);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Cannot get other discovery instances ", e);
            }
        }
    };
    private static final PeerAwareInstanceRegistry instance = new PeerAwareInstanceRegistry();
    private Counter failedReplicationAfterRetry = Monitors.newCounter((String)"FailedReplicationAfterRetry");

    PeerAwareInstanceRegistry() {
        this.peerEurekaNodes = new AtomicReference();
        this.peerEurekaNodes.set(new ArrayList());
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(false).setNameFormat("Eureka-Replication-Thread").build();
        this.replicationExecutorPool = new ThreadPoolExecutor(eurekaServerConfig.getMinThreadsForReplication(), eurekaServerConfig.getMaxThreadsForReplication(), eurekaServerConfig.getMaxIdleThreadAgeInMinutesForReplication(), TimeUnit.MINUTES, new ArrayBlockingQueue(eurekaServerConfig.getMaxElementsInReplicationPool()), threadFactory){};
        this.init();
    }

    public static PeerAwareInstanceRegistry getInstance() {
        return instance;
    }

    private void init() {
        this.setupPeerEurekaNodes();
        this.scheduleRenewalThresholdUpdateTask();
    }

    private void scheduleRenewalThresholdUpdateTask() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PeerAwareInstanceRegistry.this.updateRenewalThreshold();
            }
        }, eurekaServerConfig.getRenewalThresholdUpdateIntervalMs(), (long)eurekaServerConfig.getRenewalThresholdUpdateIntervalMs());
    }

    private void setupPeerEurekaNodes() {
        try {
            this.updatePeerEurekaNodes();
            timerReplicaNodes.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        PeerAwareInstanceRegistry.this.updatePeerEurekaNodes();
                    }
                    catch (Throwable e) {
                        logger.error("Cannot update the replica Nodes", e);
                    }
                }
            }, eurekaServerConfig.getPeerEurekaNodesUpdateIntervalMs(), (long)eurekaServerConfig.getPeerEurekaNodesUpdateIntervalMs());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void updatePeerEurekaNodes() {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        List replicaUrls = DiscoveryManager.getInstance().getDiscoveryClient().getDiscoveryServiceUrls(DiscoveryClient.getZone((InstanceInfo)myInfo));
        ArrayList<PeerEurekaNode> replicaNodes = new ArrayList<PeerEurekaNode>();
        for (String replicaUrl : replicaUrls) {
            if (this.isThisMe(replicaUrl)) continue;
            logger.info("Adding replica node: " + replicaUrl);
            replicaNodes.add(new PeerEurekaNode(replicaUrl));
        }
        if (replicaNodes.isEmpty()) {
            logger.warn("The replica size seems to be empty. Check the route 53 DNS Registry");
            return;
        }
        if (!((Object)replicaNodes).equals(this.peerEurekaNodes.get())) {
            ArrayList<String> previousServiceUrls = new ArrayList<String>();
            for (PeerEurekaNode node : this.peerEurekaNodes.get()) {
                previousServiceUrls.add(node.getServiceUrl());
            }
            ArrayList<String> currentServiceUrls = new ArrayList<String>();
            for (PeerEurekaNode node : replicaNodes) {
                currentServiceUrls.add(node.getServiceUrl());
            }
            logger.info("Updating the replica nodes as they seem to have changed from {} to {} ", previousServiceUrls, currentServiceUrls);
            this.peerEurekaNodes.set(replicaNodes);
        }
    }

    public void syncUp() {
        LookupService lookupService = DiscoveryManager.getInstance().getLookupService();
        Applications apps = lookupService.getApplications();
        int count = 0;
        for (Application app : apps.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                try {
                    this.register(instance, -1, true);
                    ++count;
                }
                catch (Throwable t) {
                    logger.error("During DS init copy", t);
                }
            }
        }
        this.numberOfRenewsPerMinThreshold = (int)((double)(count * 2) * eurekaServerConfig.getRenewalPercentThreshold());
        logger.info("Got " + count + " instances from neighboring DS node.  Changing status to UP.");
        logger.info("Renew threshold is: " + this.numberOfRenewsPerMinThreshold);
        this.startupTime = System.currentTimeMillis();
        if (count > 0) {
            this.peerInstancesTransferEmptyOnStartup = false;
        }
        ApplicationInfoManager.getInstance().setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        super.postInit();
    }

    public boolean shouldAllowAccess() {
        if (this.peerInstancesTransferEmptyOnStartup) {
            return System.currentTimeMillis() > this.startupTime + (long)eurekaServerConfig.getWaitTimeInMsWhenSyncEmpty();
        }
        return true;
    }

    public List<PeerEurekaNode> getReplicaNodes() {
        return Collections.unmodifiableList(this.peerEurekaNodes.get());
    }

    @Override
    public boolean cancel(String appName, String id, boolean isReplication) {
        if (super.cancel(appName, id, isReplication)) {
            this.replicateToPeers(Action.Cancel, appName, id, null, null, isReplication);
            return true;
        }
        return false;
    }

    public void register(InstanceInfo info, boolean isReplication) {
        int leaseDuration = 90;
        if (info.getLeaseInfo() != null && info.getLeaseInfo().getDurationInSecs() > 0) {
            leaseDuration = info.getLeaseInfo().getDurationInSecs();
        }
        super.register(info, leaseDuration, isReplication);
        this.replicateToPeers(Action.Register, info.getAppName(), info.getId(), info, null, isReplication);
    }

    @Override
    public boolean renew(String appName, String id, boolean isReplication) {
        if (super.renew(appName, id, isReplication)) {
            this.replicateToPeers(Action.Heartbeat, appName, id, null, null, isReplication);
            return true;
        }
        return false;
    }

    @Override
    public boolean statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, boolean isReplication) {
        if (super.statusUpdate(appName, id, newStatus, isReplication)) {
            this.replicateToPeers(Action.StatusUpdate, appName, id, null, newStatus, isReplication);
            return true;
        }
        return false;
    }

    public void statusUpdate(final String asgName, final ASGResource.ASGStatus newStatus, boolean isReplication) {
        if (isReplication) {
            return;
        }
        for (final PeerEurekaNode node : this.peerEurekaNodes.get()) {
            String serviceUrl = node.getServiceUrl();
            if (!this.isPeerAlive(serviceUrl) && eurekaServerConfig.shouldReplicateOnlyIfUP()) {
                logger.warn("The eureka peer node {} seems to be down and hence not replicating it there", (Object)serviceUrl);
            }
            try {
                this.replicationExecutorPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        PeerAwareInstanceRegistry.this.replicateASGInfoToReplicaNodes(asgName, newStatus, node);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                logger.error("ReplicaAwareInstanceRegistry: RejectedExecutionException: ASGStatusUpdate  - " + node.getServiceUrl());
                EurekaMonitors.REJECTED_REPLICATIONS.increment();
            }
            catch (Throwable t) {
                logger.error("ReplicaAwareInstanceRegistry: ASGStatusUpdate", t);
                EurekaMonitors.FAILED_REPLICATIONS.increment();
            }
        }
    }

    @Override
    public boolean isLeaseExpirationEnabled() {
        boolean leaseExpirationEnabled = this.getNumOfRenewsInLastMin() > (long)this.numberOfRenewsPerMinThreshold;
        boolean isSelfPreservationModeEnabled = this.isSelfPreservationModeEnabled();
        if (!leaseExpirationEnabled) {
            if (isSelfPreservationModeEnabled) {
                logger.error("The lease expiration has been disabled since the number of renewals per minute   is lower than the minimum threshold. Number of Renewals Last Minute : " + this.getNumOfRenewsInLastMin() + ". The Threshold is " + eurekaServerConfig.getRenewalPercentThreshold() + " of total instances : " + this.numberOfRenewsPerMinThreshold);
            } else {
                logger.warn("The self preservation mode is disabled!. Hence allowing the instances to expire.");
                leaseExpirationEnabled = true;
            }
        }
        return leaseExpirationEnabled;
    }

    public boolean isSelfPreservationModeEnabled() {
        return eurekaServerConfig.shouldEnableSelfPreservation();
    }

    void shutdown() {
        try {
            this.replicationExecutorPool.shutdown();
            DefaultMonitorRegistry.getInstance().unregister((Monitor)Monitors.newObjectMonitor((Object)this));
        }
        catch (Throwable t) {
            logger.error("Cannot shutdown ReplicaAwareInstanceRegistry", t);
        }
    }

    public InstanceInfo getNextServerFromEureka(String virtualHostname, boolean secure) {
        return null;
    }

    private void updateRenewalThreshold() {
        try {
            LookupService lookupService = DiscoveryManager.getInstance().getLookupService();
            Applications apps = lookupService.getApplications();
            int count = 0;
            for (Application app : apps.getRegisteredApplications()) {
                for (InstanceInfo instance : app.getInstances()) {
                    ++count;
                }
            }
            if ((double)(count * 2) > eurekaServerConfig.getRenewalPercentThreshold() * (double)this.numberOfRenewsPerMinThreshold) {
                this.numberOfRenewsPerMinThreshold = (int)((double)(count * 2) * eurekaServerConfig.getRenewalPercentThreshold());
                logger.info("Updated the renewal threshold to : {}", (Object)this.numberOfRenewsPerMinThreshold);
            }
        }
        catch (Throwable e) {
            logger.error("Cannot update renewal threshold", e);
        }
    }

    public List<Application> getSortedApplications() {
        ArrayList<Application> apps = new ArrayList<Application>(this.getApplications().getRegisteredApplications());
        Collections.sort(apps, APP_COMPARATOR);
        return apps;
    }

    @com.netflix.servo.annotations.Monitor(name="numOfReplicationsInLastMin", description="Number of total replications received in the last minute", type=DataSourceType.GAUGE)
    public long getNumOfReplicationsInLastMin() {
        return this.numberOfReplicationsLastMin.getCount();
    }

    @com.netflix.servo.annotations.Monitor(name="isBelowRenewThreshold", description="0 = false, 1 = true", type=DataSourceType.GAUGE)
    public int isBelowRenewThresold() {
        if (this.getNumOfRenewsInLastMin() < (long)this.numberOfRenewsPerMinThreshold && this.startupTime > 0L && System.currentTimeMillis() > this.startupTime + (long)eurekaServerConfig.getWaitTimeInMsWhenSyncEmpty()) {
            return 1;
        }
        return 0;
    }

    @com.netflix.servo.annotations.Monitor(name="numOfRenewsPerMinThreshold", type=DataSourceType.GAUGE)
    public int getNumOfRenewsPerMinThreshold() {
        return this.numberOfRenewsPerMinThreshold;
    }

    @com.netflix.servo.annotations.Monitor(name="itemsInReplicationPipeline", type=DataSourceType.GAUGE)
    public long getNumOfItemsInReplicationPipeline() {
        return this.replicationExecutorPool.getQueue().size();
    }

    @com.netflix.servo.annotations.Monitor(name="numOfActiveThreadsInReplicationPipeline", type=DataSourceType.GAUGE)
    public long getNumOfActiveThreadsInReplicationPipeline() {
        return this.replicationExecutorPool.getActiveCount();
    }

    public void setNumOfRenewsPerMinThreshold(int newThreshold) {
        this.numberOfRenewsPerMinThreshold = newThreshold;
    }

    private boolean isThisMe(String url) {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        try {
            URI uri = new URI(url);
            return uri.getHost().equals(myInfo.getHostName());
        }
        catch (URISyntaxException e) {
            logger.error("Error in syntax", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateToPeers(final Action action, final String appName, final String id, final InstanceInfo info, final InstanceInfo.InstanceStatus newStatus, boolean isReplication) {
        Stopwatch tracer = action.getTimer().start();
        try {
            if (isReplication) {
                this.numberOfReplicationsLastMin.increment();
            }
            if (this.peerEurekaNodes == Collections.EMPTY_LIST || isReplication) {
                return;
            }
            for (final PeerEurekaNode node : this.peerEurekaNodes.get()) {
                try {
                    this.replicationExecutorPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            int retryCounter = eurekaServerConfig.getNumberOfReplicationRetries();
                            if (PeerAwareInstanceRegistry.this.isThisMe(node.getServiceUrl())) {
                                return;
                            }
                            PeerAwareInstanceRegistry.this.replicateInstanceActionsToPeers(action, appName, id, info, newStatus, node, retryCounter);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    logger.error("ReplicaAwareInstanceRegistry: RejectedExecutionException: " + (Object)((Object)action) + " - " + node.getServiceUrl());
                    EurekaMonitors.REJECTED_REPLICATIONS.increment();
                }
                catch (Throwable t) {
                    logger.error("ReplicaAwareInstanceRegistry: " + (Object)((Object)action), t);
                    EurekaMonitors.FAILED_REPLICATIONS.increment();
                }
            }
        }
        finally {
            tracer.stop();
        }
    }

    private void replicateInstanceActionsToPeers(Action action, String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus newStatus, PeerEurekaNode node, int retryCounter) {
        String serviceUrl = node.getServiceUrl();
        try {
            if (!this.isPeerAlive(serviceUrl) && eurekaServerConfig.shouldReplicateOnlyIfUP() && !ApplicationInfoManager.getInstance().getInfo().getAppName().equals(appName)) {
                retryCounter = 0;
                logger.warn("The peer eureka node {} seems to be down and hence not replicating it there", (Object)serviceUrl);
                node.disableStatusReplication();
                return;
            }
            node.enableStatusReplication();
            CurrentRequestVersion.set(Version.V2);
            switch (action) {
                case Cancel: {
                    node.cancel(appName, id);
                    break;
                }
                case Heartbeat: {
                    InstanceInfo.InstanceStatus overriddenStatus = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.get(id);
                    InstanceInfo infoFromRegistry = this.getInstanceByAppAndId(appName, id);
                    if (node.heartbeat(appName, id, infoFromRegistry, overriddenStatus)) break;
                    logger.warn("Cannot find instance id {} and hence replicating the instance with status {}", (Object)infoFromRegistry.getId(), (Object)infoFromRegistry.getStatus().toString());
                    if (infoFromRegistry != null) {
                        node.register(infoFromRegistry);
                        break;
                    }
                    logger.warn("ReplicaAwareInstanceRegistry: renew: missing entry!");
                    break;
                }
                case Register: {
                    node.register(info);
                    break;
                }
                case StatusUpdate: {
                    node.statusUpdate(appName, id, newStatus);
                }
            }
        }
        catch (Throwable t) {
            Object[] args = new Object[]{action.name(), serviceUrl, id, retryCounter--};
            logger.warn("ReplicaAwareInstanceRegistry: Failed replicating action {} for the server {} and instance id {}. Counting down from retry attempt {} ", args);
            EurekaMonitors.FAILED_REPLICATIONS.increment();
            if (retryCounter > 0) {
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                this.replicateInstanceActionsToPeers(action, appName, id, info, newStatus, node, retryCounter);
            }
            this.failedReplicationAfterRetry = Monitors.newCounter((String)DICOVERY_FAILED_REPLICATION_AFTER_RETRY);
            this.failedReplicationAfterRetry.increment();
            Object[] args_1 = new Object[]{action.name(), serviceUrl, id};
            logger.error("ReplicaAwareInstanceRegistry: Failed replicating action {} for the server {} and instance id {}. No more retries left.", args_1);
        }
    }

    private void replicateASGInfoToReplicaNodes(String asgName, ASGResource.ASGStatus newStatus, PeerEurekaNode node) {
        boolean success = false;
        int retryCounter = eurekaServerConfig.getNumberOfReplicationRetries();
        int ctr = 0;
        CurrentRequestVersion.set(Version.V2);
        while (!success && ctr++ < retryCounter) {
            try {
                if (node.statusUpdate(asgName, newStatus)) {
                    success = true;
                    continue;
                }
                Thread.sleep(40L);
            }
            catch (Throwable e) {
                logger.error("ReplicaAwareInstanceRegistry: ASGStatusUpdate", e);
                EurekaMonitors.FAILED_REPLICATIONS.increment();
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException e1) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPeerAlive(String serviceUrl) {
        Stopwatch t = Monitors.newTimer((String)"Eureka-checkReplicaAlive").start();
        boolean isReplicaAlive = (Boolean)peerEurekaStatusMap.get(serviceUrl);
        try {
            if (!isReplicaAlive) {
                boolean bl = PeerAwareInstanceRegistry.isPeerAliveInMyRegistery(serviceUrl);
                return bl;
            }
            boolean bl = isReplicaAlive;
            return bl;
        }
        catch (Throwable e) {
            boolean bl = true;
            return bl;
        }
        finally {
            t.stop();
        }
    }

    private static boolean isPeerAliveInMyRegistery(String serviceUrl) throws URISyntaxException {
        String myName = ApplicationInfoManager.getInstance().getInfo().getAppName();
        URI uri = new URI(serviceUrl);
        Application app = PeerAwareInstanceRegistry.getInstance().getApplication(myName);
        List instanceInfoList = app.getInstances();
        for (InstanceInfo instanceInfo : instanceInfoList) {
            if (!((AmazonInfo)instanceInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicHostname).equalsIgnoreCase(uri.getHost())) continue;
            return true;
        }
        return false;
    }

    static enum Action {
        Heartbeat,
        Register,
        Cancel,
        StatusUpdate;

        private Timer timer = Monitors.newTimer((String)this.name());

        public Timer getTimer() {
            return this.timer;
        }
    }
}

