/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.discovery.converters.JsonXStream;
import com.netflix.discovery.converters.XmlXStream;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.Version;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCache {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCache.class);
    private static final EurekaServerConfig eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
    public static final String ALL_APPS = "ALL_APPS";
    public static final String ALL_APPS_DELTA = "ALL_APPS_DELTA";
    private final Timer serializeAllAppsTimer = Monitors.newTimer((String)"serialize-all");
    private final Timer serializeDeltaAppsTimer = Monitors.newTimer((String)"serialize-all-delta");
    private final Timer serializeOneApptimer = Monitors.newTimer((String)"serialize-one");
    private final Timer compressPayloadTimer = Monitors.newTimer((String)"compress-payload");
    private static final java.util.Timer timer = new java.util.Timer("Eureka -CacheFillTimer", true);
    private static final AtomicLong versionDelta = new AtomicLong(0L);
    private static final String EMPTY_PAYLOAD = "";
    private final ConcurrentMap<Key, Value> readOnlyCacheMap = new ConcurrentHashMap<Key, Value>();
    private final LoadingCache<Key, Value> readWriteCacheMap = CacheBuilder.newBuilder().initialCapacity(1000).expireAfterWrite(eurekaConfig.getResponseCacheAutoExpirationInSeconds(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Key, Value>(){

        public Value load(Key key) throws Exception {
            return ResponseCache.this.generatePayload(key);
        }
    });
    private static final ResponseCache s_instance = new ResponseCache();

    private ResponseCache() {
        timer.schedule(this.getCacheUpdateTask(), eurekaConfig.getResponseCacheUpdateIntervalMs(), eurekaConfig.getResponseCacheUpdateIntervalMs());
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
    }

    private TimerTask getCacheUpdateTask() {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    ResponseCache.this.updateClientCache();
                }
                catch (Throwable e) {
                    logger.error("Cannot update client cache from response cache: ", e);
                }
            }
        };
    }

    public static ResponseCache getInstance() {
        return s_instance;
    }

    public String get(Key key) {
        Value payload = this.getValue(key);
        if (payload == null || payload.getPayload() == EMPTY_PAYLOAD) {
            return null;
        }
        return payload.getPayload();
    }

    public byte[] getGZIP(Key key) {
        Value payload = this.getValue(key);
        if (payload == null) {
            return null;
        }
        return payload.getGzipped();
    }

    public void invalidate(String appName) {
        for (KeyType type : KeyType.values()) {
            for (Version v : Version.values()) {
                this.invalidate(new Key(appName, type, v), new Key(ALL_APPS, type, v), new Key(ALL_APPS_DELTA, type, v));
            }
        }
    }

    public void invalidate(Key ... keys) {
        for (Key key : keys) {
            Object[] args = new Object[]{key.getName(), key.getVersion(), key.getType()};
            logger.debug("Invalidating the response cache key : {} {} {}", args);
            this.readWriteCacheMap.invalidate((Object)key);
        }
    }

    public static AtomicLong getVersionDelta() {
        return versionDelta;
    }

    @Monitor(name="responseCacheSize", type=DataSourceType.GAUGE)
    public int getCurrentSize() {
        return this.readWriteCacheMap.asMap().size();
    }

    private Value getValue(Key key) {
        Value payload = null;
        try {
            Value currentPayload = (Value)this.readOnlyCacheMap.get(key);
            if (currentPayload != null) {
                payload = currentPayload;
            } else {
                payload = (Value)this.readWriteCacheMap.get((Object)key);
                this.readOnlyCacheMap.put(key, payload);
            }
        }
        catch (Throwable t) {
            logger.error("Cannot get value for key :" + key, t);
        }
        return payload;
    }

    private String getPayLoad(Key key, Applications apps) {
        if (key.getType() == KeyType.JSON) {
            return JsonXStream.getInstance().toXML((Object)apps);
        }
        return XmlXStream.getInstance().toXML((Object)apps);
    }

    private String getPayLoad(Key key, Application app) {
        if (app == null) {
            return EMPTY_PAYLOAD;
        }
        if (key.getType() == KeyType.JSON) {
            return JsonXStream.getInstance().toXML((Object)app);
        }
        return XmlXStream.getInstance().toXML((Object)app);
    }

    private void updateClientCache() {
        logger.debug("Updating the client cache from response cache");
        for (Key key : this.readOnlyCacheMap.keySet()) {
            Object[] args = new Object[]{key.getName(), key.getVersion(), key.getType()};
            logger.debug("Updating the client cache from response cache for key : {} {} {}", args);
            try {
                Value currentCacheValue;
                CurrentRequestVersion.set(key.getVersion());
                Value cacheValue = (Value)this.readWriteCacheMap.get((Object)key);
                if (cacheValue == (currentCacheValue = (Value)this.readOnlyCacheMap.get(key))) continue;
                this.readOnlyCacheMap.put(key, cacheValue);
            }
            catch (Throwable th) {
                logger.error("Error while updating the client cache from response cache", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value generatePayload(Key key) {
        Stopwatch tracer = null;
        PeerAwareInstanceRegistry registry = PeerAwareInstanceRegistry.getInstance();
        try {
            String payload = null;
            if (ALL_APPS.equals(key.getName())) {
                tracer = this.serializeAllAppsTimer.start();
                payload = this.getPayLoad(key, registry.getApplications());
            } else if (ALL_APPS_DELTA.equals(key.getName())) {
                tracer = this.serializeDeltaAppsTimer.start();
                versionDelta.incrementAndGet();
                payload = this.getPayLoad(key, registry.getApplicationDeltas());
            } else {
                tracer = this.serializeOneApptimer.start();
                payload = this.getPayLoad(key, registry.getApplication(key.getName()));
            }
            Value value = new Value(payload);
            return value;
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    private class Value {
        private final String payload;
        private byte[] gzipped;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value(String payload) {
            this.payload = payload;
            if (payload != ResponseCache.EMPTY_PAYLOAD) {
                Stopwatch tracer = ResponseCache.this.compressPayloadTimer.start();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    GZIPOutputStream out = new GZIPOutputStream(bos);
                    byte[] rawBytes = payload.getBytes();
                    out.write(rawBytes);
                    out.finish();
                    out.close();
                    bos.close();
                    this.gzipped = bos.toByteArray();
                }
                catch (IOException e) {
                    this.gzipped = null;
                }
                finally {
                    if (tracer != null) {
                        tracer.stop();
                    }
                }
            } else {
                this.gzipped = null;
            }
        }

        public String getPayload() {
            return this.payload;
        }

        public byte[] getGzipped() {
            return this.gzipped;
        }
    }

    public static class Key {
        private final String appName;
        private final KeyType requestType;
        private final Version requestVersion;
        private final String hashKey;

        public Key(String app, KeyType type, Version v) {
            this.appName = app;
            this.requestType = type;
            this.requestVersion = v;
            this.hashKey = this.appName + this.requestType.name() + this.requestVersion.name();
        }

        public String getName() {
            return this.appName;
        }

        public String getHashKey() {
            return this.hashKey;
        }

        public KeyType getType() {
            return this.requestType;
        }

        public Version getVersion() {
            return this.requestVersion;
        }

        public int hashCode() {
            String hashKey = this.getHashKey();
            return hashKey.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Key) {
                return this.getHashKey().equals(((Key)other).getHashKey());
            }
            return false;
        }
    }

    public static enum KeyType {
        JSON,
        XML;

    }
}

