/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.EurekaJerseyClient;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.Version;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerEurekaNode {
    private static final Logger logger = LoggerFactory.getLogger(PeerEurekaNode.class);
    private static final int RETRY_SLEEP_TIME_MS = 100;
    public static final String HEADER_REPLICATION = "x-netflix-discovery-replication";
    private static final EurekaServerConfig config = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private final Timer registerTimer = Monitors.newTimer((String)"Register");
    private final Timer cancelTimer = Monitors.newTimer((String)"Cancel");
    private final Timer renewTimer = Monitors.newTimer((String)"Renew");
    private final Timer asgStatusUpdateTimer = Monitors.newTimer((String)"ASGStatusUpdate");
    private final Timer instanceStatusUpdateTimer = Monitors.newTimer((String)"InstanceStatusUpdate");
    private final String serviceUrl;
    private final String name;
    private volatile EurekaJerseyClient.JerseyClient jerseyClient;
    private volatile ApacheHttpClient4 jerseyApacheClient;
    private volatile ThreadPoolExecutor statusReplicationPool;
    private volatile boolean statusReplication = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerEurekaNode(String serviceUrl) {
        this.serviceUrl = serviceUrl.intern();
        this.name = this.getClass().getSimpleName() + ": " + serviceUrl + "apps/: ";
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(false).setNameFormat("Eureka-ReplicaNode-Thread-" + serviceUrl).build();
        this.statusReplicationPool = new ThreadPoolExecutor(config.getMinThreadsForStatusReplication(), config.getMaxThreadsForStatusReplication(), config.getMaxIdleThreadInMinutesAgeForStatusReplication(), TimeUnit.MINUTES, new ArrayBlockingQueue(config.getMaxElementsInStatusReplicationPool()), threadFactory){};
        String string = this.serviceUrl;
        synchronized (string) {
            if (this.jerseyApacheClient == null) {
                try {
                    this.jerseyClient = EurekaJerseyClient.createJerseyClient((int)config.getPeerNodeConnectTimeoutMs(), (int)config.getPeerNodeReadTimeoutMs(), (int)config.getPeerNodeTotalConnections(), (int)config.getPeerNodeTotalConnectionsPerHost(), (int)config.getPeerNodeConnectionIdleTimeoutSeconds());
                    this.jerseyApacheClient = this.jerseyClient.getClient();
                }
                catch (Throwable e) {
                    throw new RuntimeException("Cannot Create new Replica Node :" + this.name);
                }
            }
        }
        try {
            Monitors.registerObject((String)serviceUrl, (Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(InstanceInfo info) throws Exception {
        Stopwatch tracer = this.registerTimer.start();
        String urlPath = "apps/" + info.getAppName();
        ClientResponse response = null;
        try {
            response = (ClientResponse)((WebResource.Builder)this.jerseyApacheClient.resource(this.serviceUrl).path(urlPath).header(HEADER_REPLICATION, (Object)"true").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)info);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String appName, String id) throws Exception {
        ClientResponse response = null;
        Stopwatch tracer = this.cancelTimer.start();
        try {
            String urlPath = "apps/" + appName + "/" + id;
            response = (ClientResponse)this.jerseyApacheClient.resource(this.serviceUrl).path(urlPath).header(HEADER_REPLICATION, (Object)"true").delete(ClientResponse.class);
            if (response.getStatus() == 404) {
                logger.warn(this.name + appName + "/" + id + " : delete: missing entry.");
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean heartbeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) throws Exception {
        ClientResponse response = null;
        Stopwatch tracer = this.renewTimer.start();
        try {
            String urlPath = "apps/" + appName + "/" + id;
            WebResource r = this.jerseyApacheClient.resource(this.serviceUrl).path(urlPath).queryParam("status", info.getStatus().toString()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString());
            if (overriddenStatus != null) {
                r = r.queryParam("overriddenstatus", overriddenStatus.name());
            }
            if ((response = (ClientResponse)r.header(HEADER_REPLICATION, (Object)"true").put(ClientResponse.class)).getStatus() == 404) {
                logger.warn(this.name + appName + "/" + id + " : heartbeat: missing entry.");
                boolean bl = false;
                return bl;
            }
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                this.syncInstancesIfTimestampDiffers(id, info, response);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (tracer != null) {
                tracer.stop();
            }
        }
        return true;
    }

    private void syncInstancesIfTimestampDiffers(String id, InstanceInfo info, ClientResponse response) {
        try {
            InstanceInfo infoFromPeer;
            if (config.shouldSyncWhenTimestampDiffers() && response.hasEntity() && (infoFromPeer = (InstanceInfo)response.getEntity(InstanceInfo.class)) != null) {
                Object[] args = new Object[]{id, info.getLastDirtyTimestamp(), infoFromPeer.getLastDirtyTimestamp()};
                logger.warn("Peer wants us to take the instance information from it, since the timestamp differs,Id : {} My Timestamp : {}, Peer's timestamp: {}", args);
                if (infoFromPeer.getOverriddenStatus() != null && !InstanceInfo.InstanceStatus.UNKNOWN.equals((Object)infoFromPeer.getOverriddenStatus())) {
                    Object[] args1 = new Object[]{id, info.getOverriddenStatus(), infoFromPeer.getOverriddenStatus()};
                    logger.warn("Overridden Status info -id {}, mine {}, peer's {}", args1);
                    PeerAwareInstanceRegistry.getInstance().storeOverriddenStatusIfRequired(id, infoFromPeer.getOverriddenStatus());
                }
                PeerAwareInstanceRegistry.getInstance().register(infoFromPeer, true);
            }
        }
        catch (Throwable e) {
            logger.warn("Exception when trying to get information from peer :", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean statusUpdate(String asgName, ASGResource.ASGStatus newStatus) throws Exception {
        ClientResponse response = null;
        Stopwatch tracer = this.asgStatusUpdateTimer.start();
        try {
            String urlPath = "asg/" + asgName + "/status";
            response = (ClientResponse)this.jerseyApacheClient.resource(this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).header(HEADER_REPLICATION, (Object)"true").put(ClientResponse.class);
            if (response.getStatus() == 200) {
                boolean bl = true;
                return bl;
            }
            logger.error(this.name + asgName + " : statusUpdate:  failed!");
            tracer.stop();
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    public boolean statusUpdate(final String appName, final String id, final InstanceInfo.InstanceStatus newStatus, final InstanceInfo info) throws Throwable {
        this.statusReplicationPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CurrentRequestVersion.set(Version.V2);
                boolean success = false;
                while (!success) {
                    ClientResponse response = null;
                    Stopwatch tracer = PeerEurekaNode.this.instanceStatusUpdateTimer.start();
                    try {
                        String urlPath = "apps/" + appName + "/" + id + "/status";
                        response = (ClientResponse)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString()).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").put(ClientResponse.class);
                        if (response.getStatus() != 200) {
                            logger.error(PeerEurekaNode.this.name + appName + "/" + id + " : statusUpdate:  failed!");
                        }
                        success = true;
                    }
                    catch (Throwable e) {
                        logger.error(PeerEurekaNode.this.name + appName + "/" + id + " : statusUpdate:  failed!", e);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e1) {
                            // empty catch block
                        }
                        if (config.shouldRetryIndefinitelyToReplicateStatus() && PeerEurekaNode.this.statusReplication) continue;
                        success = true;
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                        if (tracer == null) continue;
                        tracer.stop();
                    }
                }
            }
        });
        return true;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerEurekaNode other = (PeerEurekaNode)obj;
        return !(this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl));
    }

    @Monitor(name="itemsInReplicationPipeline", type=DataSourceType.GAUGE)
    public long getNumOfItemsInReplicationPipeline() {
        return this.statusReplicationPool.getQueue().size();
    }

    public void disableStatusReplication() {
        if (this.statusReplicationPool.getQueue().size() > 0) {
            logger.info("Clearing the internal status queue for {}", (Object)this.serviceUrl);
            this.statusReplicationPool.getQueue().clear();
        }
        this.statusReplication = false;
    }

    public void enableStatusReplication() {
        this.statusReplication = true;
    }
}

