/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.HealthCheckCallback;
import com.netflix.appinfo.HealthCheckCallbackToHandlerBridge;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractAzToRegionMapper;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.AzToRegionMapper;
import com.netflix.discovery.BackupRegistry;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.DNSBasedAzToRegionMapper;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaEvent;
import com.netflix.discovery.EurekaEventListener;
import com.netflix.discovery.InstanceInfoReplicator;
import com.netflix.discovery.InstanceRegionChecker;
import com.netflix.discovery.NotImplementedRegistryImpl;
import com.netflix.discovery.PreRegistrationHandler;
import com.netflix.discovery.PropertyBasedAzToRegionMapper;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.ClosableResolver;
import com.netflix.discovery.shared.resolver.aws.ApplicationsResolver;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpClients;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.Jersey1DiscoveryClientOptionalArgs;
import com.netflix.discovery.shared.transport.jersey.Jersey1TransportClientFactories;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import com.netflix.discovery.util.ThresholdLevelsMetric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiscoveryClient
implements EurekaClient {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryClient.class);
    public static final String HTTP_X_DISCOVERY_ALLOW_REDIRECT = "X-Discovery-AllowRedirect";
    private static final String VALUE_DELIMITER = ",";
    private static final String COMMA_STRING = ",";
    @Deprecated
    private static EurekaClientConfig staticClientConfig;
    private static final String PREFIX = "DiscoveryClient_";
    private final Counter RECONCILE_HASH_CODES_MISMATCH = Monitors.newCounter((String)"DiscoveryClient_ReconcileHashCodeMismatch");
    private final Timer FETCH_REGISTRY_TIMER = Monitors.newTimer((String)"DiscoveryClient_FetchRegistry");
    private final Counter REREGISTER_COUNTER = Monitors.newCounter((String)"DiscoveryClient_Reregister");
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor heartbeatExecutor;
    private final ThreadPoolExecutor cacheRefreshExecutor;
    private final Provider<HealthCheckHandler> healthCheckHandlerProvider;
    private final Provider<HealthCheckCallback> healthCheckCallbackProvider;
    private final PreRegistrationHandler preRegistrationHandler;
    private final AtomicReference<Applications> localRegionApps = new AtomicReference();
    private final Lock fetchRegistryUpdateLock = new ReentrantLock();
    private final AtomicLong fetchRegistryGeneration;
    private final ApplicationInfoManager applicationInfoManager;
    private final InstanceInfo instanceInfo;
    private final AtomicReference<String> remoteRegionsToFetch;
    private final AtomicReference<String[]> remoteRegionsRef;
    private final InstanceRegionChecker instanceRegionChecker;
    private final EndpointUtils.ServiceUrlRandomizer urlRandomizer;
    private final Provider<BackupRegistry> backupRegistryProvider;
    private final EurekaTransport eurekaTransport;
    private volatile HealthCheckHandler healthCheckHandler;
    private volatile Map<String, Applications> remoteRegionVsApps = new ConcurrentHashMap<String, Applications>();
    private volatile InstanceInfo.InstanceStatus lastRemoteInstanceStatus = InstanceInfo.InstanceStatus.UNKNOWN;
    private final CopyOnWriteArraySet<EurekaEventListener> eventListeners = new CopyOnWriteArraySet();
    private String appPathIdentifier;
    private ApplicationInfoManager.StatusChangeListener statusChangeListener;
    private InstanceInfoReplicator instanceInfoReplicator;
    private volatile int registrySize = 0;
    private volatile long lastSuccessfulRegistryFetchTimestamp = -1L;
    private volatile long lastSuccessfulHeartbeatTimestamp = -1L;
    private final ThresholdLevelsMetric heartbeatStalenessMonitor;
    private final ThresholdLevelsMetric registryStalenessMonitor;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    protected final EurekaClientConfig clientConfig;
    protected final EurekaTransportConfig transportConfig;
    private final long initTimestampMs;

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config) {
        this(myInfo, config, null);
    }

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config, DiscoveryClientOptionalArgs args) {
        this(ApplicationInfoManager.getInstance(), config, args);
    }

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config, AbstractDiscoveryClientOptionalArgs args) {
        this(ApplicationInfoManager.getInstance(), config, args);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config) {
        this(applicationInfoManager, config, null);
    }

    @Deprecated
    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, DiscoveryClientOptionalArgs args) {
        this(applicationInfoManager, config, (AbstractDiscoveryClientOptionalArgs)args);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, final EurekaClientConfig config, AbstractDiscoveryClientOptionalArgs args) {
        this(applicationInfoManager, config, args, new Provider<BackupRegistry>(){
            private volatile BackupRegistry backupRegistryInstance;

            public synchronized BackupRegistry get() {
                if (this.backupRegistryInstance == null) {
                    String backupRegistryClassName = config.getBackupRegistryImpl();
                    if (null != backupRegistryClassName) {
                        try {
                            this.backupRegistryInstance = (BackupRegistry)Class.forName(backupRegistryClassName).newInstance();
                            logger.info("Enabled backup registry of type " + this.backupRegistryInstance.getClass());
                        }
                        catch (InstantiationException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                    }
                    if (this.backupRegistryInstance == null) {
                        logger.warn("Using default backup registry implementation which does not do anything.");
                        this.backupRegistryInstance = new NotImplementedRegistryImpl();
                    }
                }
                return this.backupRegistryInstance;
            }
        });
    }

    @Inject
    DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, AbstractDiscoveryClientOptionalArgs args, Provider<BackupRegistry> backupRegistryProvider) {
        if (args != null) {
            this.healthCheckHandlerProvider = args.healthCheckHandlerProvider;
            this.healthCheckCallbackProvider = args.healthCheckCallbackProvider;
            this.eventListeners.addAll(args.getEventListeners());
            this.preRegistrationHandler = args.preRegistrationHandler;
        } else {
            this.healthCheckCallbackProvider = null;
            this.healthCheckHandlerProvider = null;
            this.preRegistrationHandler = null;
        }
        this.applicationInfoManager = applicationInfoManager;
        InstanceInfo myInfo = applicationInfoManager.getInfo();
        staticClientConfig = this.clientConfig = config;
        this.transportConfig = config.getTransportConfig();
        this.instanceInfo = myInfo;
        if (myInfo != null) {
            this.appPathIdentifier = this.instanceInfo.getAppName() + "/" + this.instanceInfo.getId();
        } else {
            logger.warn("Setting instanceInfo to a passed in null value");
        }
        this.backupRegistryProvider = backupRegistryProvider;
        this.urlRandomizer = new EndpointUtils.InstanceInfoBasedUrlRandomizer(this.instanceInfo);
        this.localRegionApps.set(new Applications());
        this.fetchRegistryGeneration = new AtomicLong(0L);
        this.remoteRegionsToFetch = new AtomicReference<String>(this.clientConfig.fetchRegistryForRemoteRegions());
        this.remoteRegionsRef = new AtomicReference<Object>((this.remoteRegionsToFetch.get() == null ? null : this.remoteRegionsToFetch.get().split(",")));
        this.registryStalenessMonitor = config.shouldFetchRegistry() ? new ThresholdLevelsMetric(this, "eurekaClient.registry.lastUpdateSec_", new long[]{15L, 30L, 60L, 120L, 240L, 480L}) : ThresholdLevelsMetric.NO_OP_METRIC;
        this.heartbeatStalenessMonitor = config.shouldRegisterWithEureka() ? new ThresholdLevelsMetric(this, "eurekaClient.registration.lastHeartbeatSec_", new long[]{15L, 30L, 60L, 120L, 240L, 480L}) : ThresholdLevelsMetric.NO_OP_METRIC;
        logger.info("Initializing Eureka in region {}", (Object)this.clientConfig.getRegion());
        if (!config.shouldRegisterWithEureka() && !config.shouldFetchRegistry()) {
            logger.info("Client configured to neither register nor query for data.");
            this.scheduler = null;
            this.heartbeatExecutor = null;
            this.cacheRefreshExecutor = null;
            this.eurekaTransport = null;
            this.instanceRegionChecker = new InstanceRegionChecker(new PropertyBasedAzToRegionMapper(config), this.clientConfig.getRegion());
            DiscoveryManager.getInstance().setDiscoveryClient(this);
            DiscoveryManager.getInstance().setEurekaClientConfig(config);
            this.initTimestampMs = System.currentTimeMillis();
            logger.info("Discovery Client initialized at timestamp {} with initial instances count: {}", (Object)this.initTimestampMs, (Object)this.getApplications().size());
            return;
        }
        try {
            this.scheduler = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("DiscoveryClient-%d").setDaemon(true).build());
            this.heartbeatExecutor = new ThreadPoolExecutor(1, this.clientConfig.getHeartbeatExecutorThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("DiscoveryClient-HeartbeatExecutor-%d").setDaemon(true).build());
            this.cacheRefreshExecutor = new ThreadPoolExecutor(1, this.clientConfig.getCacheRefreshExecutorThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("DiscoveryClient-CacheRefreshExecutor-%d").setDaemon(true).build());
            this.eurekaTransport = new EurekaTransport();
            this.scheduleServerEndpointTask(this.eurekaTransport, args);
            AbstractAzToRegionMapper azToRegionMapper = this.clientConfig.shouldUseDnsForFetchingServiceUrls() ? new DNSBasedAzToRegionMapper(this.clientConfig) : new PropertyBasedAzToRegionMapper(this.clientConfig);
            if (null != this.remoteRegionsToFetch.get()) {
                azToRegionMapper.setRegionsToFetch(this.remoteRegionsToFetch.get().split(","));
            }
            this.instanceRegionChecker = new InstanceRegionChecker(azToRegionMapper, this.clientConfig.getRegion());
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize DiscoveryClient!", e);
        }
        if (this.clientConfig.shouldFetchRegistry() && !this.fetchRegistry(false)) {
            this.fetchRegistryFromBackup();
        }
        if (this.preRegistrationHandler != null) {
            this.preRegistrationHandler.beforeRegistration();
        }
        this.initScheduledTasks();
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register timers", e);
        }
        DiscoveryManager.getInstance().setDiscoveryClient(this);
        DiscoveryManager.getInstance().setEurekaClientConfig(config);
        this.initTimestampMs = System.currentTimeMillis();
        logger.info("Discovery Client initialized at timestamp {} with initial instances count: {}", (Object)this.initTimestampMs, (Object)this.getApplications().size());
    }

    private void scheduleServerEndpointTask(EurekaTransport eurekaTransport, AbstractDiscoveryClientOptionalArgs args) {
        Collection additionalFilters = args == null ? Collections.emptyList() : args.additionalFilters;
        EurekaJerseyClient providedJerseyClient = args == null ? null : args.eurekaJerseyClient;
        TransportClientFactories<ClientFilter> argsTransportClientFactories = null;
        if (args != null && args.getTransportClientFactories() != null) {
            argsTransportClientFactories = args.getTransportClientFactories();
        }
        Jersey1TransportClientFactories transportClientFactories = argsTransportClientFactories == null ? new Jersey1TransportClientFactories() : argsTransportClientFactories;
        eurekaTransport.transportClientFactory = providedJerseyClient == null ? transportClientFactories.newTransportClientFactory(this.clientConfig, additionalFilters, this.applicationInfoManager.getInfo()) : transportClientFactories.newTransportClientFactory(additionalFilters, providedJerseyClient);
        ApplicationsResolver.ApplicationsSource applicationsSource = new ApplicationsResolver.ApplicationsSource(){

            @Override
            public Applications getApplications(int stalenessThreshold, TimeUnit timeUnit) {
                long thresholdInMs = TimeUnit.MILLISECONDS.convert(stalenessThreshold, timeUnit);
                long delay = DiscoveryClient.this.getLastSuccessfulRegistryFetchTimePeriod();
                if (delay > thresholdInMs) {
                    logger.info("Local registry is too stale for local lookup. Threshold:{}, actual:{}", (Object)thresholdInMs, (Object)delay);
                    return null;
                }
                return (Applications)DiscoveryClient.this.localRegionApps.get();
            }
        };
        eurekaTransport.bootstrapResolver = EurekaHttpClients.newBootstrapResolver(this.clientConfig, this.transportConfig, eurekaTransport.transportClientFactory, this.applicationInfoManager.getInfo(), applicationsSource);
        if (this.clientConfig.shouldRegisterWithEureka()) {
            EurekaHttpClientFactory newRegistrationClientFactory = null;
            EurekaHttpClient newRegistrationClient = null;
            try {
                newRegistrationClientFactory = EurekaHttpClients.registrationClientFactory(eurekaTransport.bootstrapResolver, eurekaTransport.transportClientFactory, this.transportConfig);
                newRegistrationClient = newRegistrationClientFactory.newClient();
            }
            catch (Exception e) {
                logger.warn("Transport initialization failure", (Throwable)e);
            }
            eurekaTransport.registrationClientFactory = newRegistrationClientFactory;
            eurekaTransport.registrationClient = newRegistrationClient;
        }
        if (this.clientConfig.shouldFetchRegistry()) {
            EurekaHttpClientFactory newQueryClientFactory = null;
            EurekaHttpClient newQueryClient = null;
            try {
                newQueryClientFactory = EurekaHttpClients.queryClientFactory(eurekaTransport.bootstrapResolver, eurekaTransport.transportClientFactory, this.clientConfig, this.transportConfig, this.applicationInfoManager.getInfo(), applicationsSource);
                newQueryClient = newQueryClientFactory.newClient();
            }
            catch (Exception e) {
                logger.warn("Transport initialization failure", (Throwable)e);
            }
            eurekaTransport.queryClientFactory = newQueryClientFactory;
            eurekaTransport.queryClient = newQueryClient;
        }
    }

    @Override
    public EurekaClientConfig getEurekaClientConfig() {
        return this.clientConfig;
    }

    @Override
    public ApplicationInfoManager getApplicationInfoManager() {
        return this.applicationInfoManager;
    }

    @Override
    public Application getApplication(String appName) {
        return this.getApplications().getRegisteredApplications(appName);
    }

    @Override
    public Applications getApplications() {
        return this.localRegionApps.get();
    }

    @Override
    public Applications getApplicationsForARegion(@Nullable String region) {
        if (this.instanceRegionChecker.isLocalRegion(region)) {
            return this.localRegionApps.get();
        }
        return this.remoteRegionVsApps.get(region);
    }

    @Override
    public Set<String> getAllKnownRegions() {
        String localRegion = this.instanceRegionChecker.getLocalRegion();
        if (!this.remoteRegionVsApps.isEmpty()) {
            Set<String> regions = this.remoteRegionVsApps.keySet();
            HashSet<String> toReturn = new HashSet<String>(regions);
            toReturn.add(localRegion);
            return toReturn;
        }
        return Collections.singleton(localRegion);
    }

    @Override
    public List<InstanceInfo> getInstancesById(String id) {
        ArrayList<InstanceInfo> instancesList = new ArrayList<InstanceInfo>();
        for (Application app : this.getApplications().getRegisteredApplications()) {
            InstanceInfo instanceInfo = app.getByInstanceId(id);
            if (instanceInfo == null) continue;
            instancesList.add(instanceInfo);
        }
        return instancesList;
    }

    @Override
    @Deprecated
    public void registerHealthCheckCallback(HealthCheckCallback callback) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a listener for instance info since it is null!");
        }
        if (callback != null) {
            this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge(callback);
        }
    }

    @Override
    public void registerHealthCheck(HealthCheckHandler healthCheckHandler) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a healthcheck handler when instance info is null!");
        }
        if (healthCheckHandler != null) {
            this.healthCheckHandler = healthCheckHandler;
            if (this.instanceInfoReplicator != null) {
                this.instanceInfoReplicator.onDemandUpdate();
            }
        }
    }

    @Override
    public void registerEventListener(EurekaEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    @Override
    public boolean unregisterEventListener(EurekaEventListener eventListener) {
        return this.eventListeners.remove(eventListener);
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure) {
        return this.getInstancesByVipAddress(vipAddress, secure, this.instanceRegionChecker.getLocalRegion());
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure, @Nullable String region) {
        Applications applications;
        if (vipAddress == null) {
            throw new IllegalArgumentException("Supplied VIP Address cannot be null");
        }
        if (this.instanceRegionChecker.isLocalRegion(region)) {
            applications = this.localRegionApps.get();
        } else {
            applications = this.remoteRegionVsApps.get(region);
            if (null == applications) {
                logger.debug("No applications are defined for region {}, so returning an empty instance list for vip address {}.", (Object)region, (Object)vipAddress);
                return Collections.emptyList();
            }
        }
        if (!secure) {
            return applications.getInstancesByVirtualHostName(vipAddress);
        }
        return applications.getInstancesBySecureVirtualHostName(vipAddress);
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddressAndAppName(String vipAddress, String appName, boolean secure) {
        List<InstanceInfo> result = new ArrayList<InstanceInfo>();
        if (vipAddress == null && appName == null) {
            throw new IllegalArgumentException("Supplied VIP Address and application name cannot both be null");
        }
        if (vipAddress != null && appName == null) {
            return this.getInstancesByVipAddress(vipAddress, secure);
        }
        if (vipAddress == null && appName != null) {
            Application application = this.getApplication(appName);
            if (application != null) {
                result = application.getInstances();
            }
            return result;
        }
        for (Application app : this.getApplications().getRegisteredApplications()) {
            block1: for (InstanceInfo instance : app.getInstances()) {
                String[] instanceVipAddresses;
                String instanceVipAddress = secure ? instance.getSecureVipAddress() : instance.getVIPAddress();
                if (instanceVipAddress == null) continue;
                for (String vipAddressFromList : instanceVipAddresses = instanceVipAddress.split(",")) {
                    if (!vipAddress.equalsIgnoreCase(vipAddressFromList.trim()) || !appName.equalsIgnoreCase(instance.getAppName())) continue;
                    result.add(instance);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public InstanceInfo getNextServerFromEureka(String virtualHostname, boolean secure) {
        List<InstanceInfo> instanceInfoList = this.getInstancesByVipAddress(virtualHostname, secure);
        if (instanceInfoList == null || instanceInfoList.isEmpty()) {
            throw new RuntimeException("No matches for the virtual host name :" + virtualHostname);
        }
        Applications apps = this.localRegionApps.get();
        int index = (int)(apps.getNextIndex(virtualHostname, secure).incrementAndGet() % (long)instanceInfoList.size());
        return instanceInfoList.get(index);
    }

    @Override
    public Applications getApplications(String serviceUrl) {
        try {
            EurekaHttpResponse<Applications> response;
            EurekaHttpResponse<Applications> eurekaHttpResponse = response = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(new String[0]) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), new String[0]);
            if (response.getStatusCode() == 200) {
                logger.debug(PREFIX + this.appPathIdentifier + " -  refresh status: " + response.getStatusCode());
                return response.getEntity();
            }
            logger.error(PREFIX + this.appPathIdentifier + " - was unable to refresh its cache! status = " + response.getStatusCode());
        }
        catch (Throwable th) {
            logger.error(PREFIX + this.appPathIdentifier + " - was unable to refresh its cache! status = " + th.getMessage(), th);
        }
        return null;
    }

    boolean register() throws Throwable {
        EurekaHttpResponse<Void> httpResponse;
        logger.info(PREFIX + this.appPathIdentifier + ": registering service...");
        try {
            httpResponse = this.eurekaTransport.registrationClient.register(this.instanceInfo);
        }
        catch (Exception e) {
            logger.warn("{} - registration failed {}", new Object[]{PREFIX + this.appPathIdentifier, e.getMessage(), e});
            throw e;
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} - registration status: {}", (Object)(PREFIX + this.appPathIdentifier), (Object)httpResponse.getStatusCode());
        }
        return httpResponse.getStatusCode() == 204;
    }

    boolean renew() {
        try {
            EurekaHttpResponse<InstanceInfo> httpResponse = this.eurekaTransport.registrationClient.sendHeartBeat(this.instanceInfo.getAppName(), this.instanceInfo.getId(), this.instanceInfo, null);
            logger.debug("{} - Heartbeat status: {}", (Object)(PREFIX + this.appPathIdentifier), (Object)httpResponse.getStatusCode());
            if (httpResponse.getStatusCode() == 404) {
                this.REREGISTER_COUNTER.increment();
                logger.info("{} - Re-registering apps/{}", (Object)(PREFIX + this.appPathIdentifier), (Object)this.instanceInfo.getAppName());
                long timestamp = this.instanceInfo.setIsDirtyWithTime();
                boolean result = this.register();
                this.instanceInfo.unsetIsDirty(timestamp);
                return result;
            }
            return httpResponse.getStatusCode() == 200;
        }
        catch (Throwable e) {
            logger.error("{} - was unable to send heartbeat!", (Object)(PREFIX + this.appPathIdentifier), (Object)e);
            return false;
        }
    }

    @Override
    @Deprecated
    public List<String> getServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromConfig(this.clientConfig, instanceZone, preferSameZone);
    }

    @Override
    @PreDestroy
    public synchronized void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            logger.info("Shutting down DiscoveryClient ...");
            if (this.statusChangeListener != null && this.applicationInfoManager != null) {
                this.applicationInfoManager.unregisterStatusChangeListener(this.statusChangeListener.getId());
            }
            this.cancelScheduledTasks();
            if (this.applicationInfoManager != null && this.clientConfig.shouldRegisterWithEureka()) {
                this.applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
                this.unregister();
            }
            if (this.eurekaTransport != null) {
                this.eurekaTransport.shutdown();
            }
            this.heartbeatStalenessMonitor.shutdown();
            this.registryStalenessMonitor.shutdown();
            logger.info("Completed shut down of DiscoveryClient");
        }
    }

    void unregister() {
        if (this.eurekaTransport != null && this.eurekaTransport.registrationClient != null) {
            try {
                logger.info("Unregistering ...");
                EurekaHttpResponse<Void> httpResponse = this.eurekaTransport.registrationClient.cancel(this.instanceInfo.getAppName(), this.instanceInfo.getId());
                logger.info(PREFIX + this.appPathIdentifier + " - deregister  status: " + httpResponse.getStatusCode());
            }
            catch (Exception e) {
                logger.error(PREFIX + this.appPathIdentifier + " - de-registration failed" + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchRegistry(boolean forceFullRegistryFetch) {
        Stopwatch tracer = this.FETCH_REGISTRY_TIMER.start();
        try {
            Applications applications = this.getApplications();
            if (this.clientConfig.shouldDisableDelta() || !Strings.isNullOrEmpty((String)this.clientConfig.getRegistryRefreshSingleVipAddress()) || forceFullRegistryFetch || applications == null || applications.getRegisteredApplications().size() == 0 || applications.getVersion() == -1L) {
                logger.info("Disable delta property : {}", (Object)this.clientConfig.shouldDisableDelta());
                logger.info("Single vip registry refresh property : {}", (Object)this.clientConfig.getRegistryRefreshSingleVipAddress());
                logger.info("Force full registry fetch : {}", (Object)forceFullRegistryFetch);
                logger.info("Application is null : {}", (Object)(applications == null ? 1 : 0));
                logger.info("Registered Applications size is zero : {}", (Object)(applications.getRegisteredApplications().size() == 0 ? 1 : 0));
                logger.info("Application version is -1: {}", (Object)(applications.getVersion() == -1L ? 1 : 0));
                this.getAndStoreFullRegistry();
            } else {
                this.getAndUpdateDelta(applications);
            }
            applications.setAppsHashCode(applications.getReconcileHashCode());
            this.logTotalInstances();
        }
        catch (Throwable e) {
            logger.error(PREFIX + this.appPathIdentifier + " - was unable to refresh its cache! status = " + e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
        this.onCacheRefreshed();
        this.updateInstanceRemoteStatus();
        return true;
    }

    private synchronized void updateInstanceRemoteStatus() {
        InstanceInfo remoteInstanceInfo;
        Application app;
        InstanceInfo.InstanceStatus currentRemoteInstanceStatus = null;
        if (this.instanceInfo.getAppName() != null && (app = this.getApplication(this.instanceInfo.getAppName())) != null && (remoteInstanceInfo = app.getByInstanceId(this.instanceInfo.getId())) != null) {
            currentRemoteInstanceStatus = remoteInstanceInfo.getStatus();
        }
        if (currentRemoteInstanceStatus == null) {
            currentRemoteInstanceStatus = InstanceInfo.InstanceStatus.UNKNOWN;
        }
        if (this.lastRemoteInstanceStatus != currentRemoteInstanceStatus) {
            this.onRemoteStatusChanged(this.lastRemoteInstanceStatus, currentRemoteInstanceStatus);
            this.lastRemoteInstanceStatus = currentRemoteInstanceStatus;
        }
    }

    @Override
    public InstanceInfo.InstanceStatus getInstanceRemoteStatus() {
        return this.lastRemoteInstanceStatus;
    }

    private String getReconcileHashCode(Applications applications) {
        TreeMap<String, AtomicInteger> instanceCountMap = new TreeMap<String, AtomicInteger>();
        if (this.isFetchingRemoteRegionRegistries()) {
            for (Applications remoteApp : this.remoteRegionVsApps.values()) {
                remoteApp.populateInstanceCountMap(instanceCountMap);
            }
        }
        applications.populateInstanceCountMap(instanceCountMap);
        return Applications.getReconcileHashCode(instanceCountMap);
    }

    private void getAndStoreFullRegistry() throws Throwable {
        EurekaHttpResponse<Applications> httpResponse;
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        logger.info("Getting all instance registry info from the eureka server");
        Applications apps = null;
        EurekaHttpResponse<Applications> eurekaHttpResponse = httpResponse = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(this.remoteRegionsRef.get()) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), this.remoteRegionsRef.get());
        if (httpResponse.getStatusCode() == Response.Status.OK.getStatusCode()) {
            apps = httpResponse.getEntity();
        }
        logger.info("The response status is {}", (Object)httpResponse.getStatusCode());
        if (apps == null) {
            logger.error("The application is null for some reason. Not storing this information");
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.localRegionApps.set(this.filterAndShuffle(apps));
            logger.debug("Got full registry with apps hashcode {}", (Object)apps.getAppsHashCode());
        } else {
            logger.warn("Not updating applications as another thread is updating it already");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndUpdateDelta(Applications applications) throws Throwable {
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        Applications delta = null;
        EurekaHttpResponse<Applications> httpResponse = this.eurekaTransport.queryClient.getDelta(this.remoteRegionsRef.get());
        if (httpResponse.getStatusCode() == Response.Status.OK.getStatusCode()) {
            delta = httpResponse.getEntity();
        }
        if (delta == null) {
            logger.warn("The server does not allow the delta revision to be applied because it is not safe. Hence got the full registry.");
            this.getAndStoreFullRegistry();
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            logger.debug("Got delta update with apps hashcode {}", (Object)delta.getAppsHashCode());
            String reconcileHashCode = "";
            if (this.fetchRegistryUpdateLock.tryLock()) {
                try {
                    this.updateDelta(delta);
                    reconcileHashCode = this.getReconcileHashCode(applications);
                }
                finally {
                    this.fetchRegistryUpdateLock.unlock();
                }
            } else {
                logger.warn("Cannot acquire update lock, aborting getAndUpdateDelta");
            }
            if (!reconcileHashCode.equals(delta.getAppsHashCode()) || this.clientConfig.shouldLogDeltaDiff()) {
                this.reconcileAndLogDifference(delta, reconcileHashCode);
            }
        } else {
            logger.warn("Not updating application delta as another thread is updating it already");
            logger.debug("Ignoring delta update with apps hashcode {}, as another thread is updating it already", (Object)delta.getAppsHashCode());
        }
    }

    private void logTotalInstances() {
        if (logger.isDebugEnabled()) {
            int totInstances = 0;
            for (Application application : this.getApplications().getRegisteredApplications()) {
                totInstances += application.getInstancesAsIsFromEureka().size();
            }
            logger.debug("The total number of all instances in the client now is {}", (Object)totInstances);
        }
    }

    private void reconcileAndLogDifference(Applications delta, String reconcileHashCode) throws Throwable {
        logger.debug("The Reconcile hashcodes do not match, client : {}, server : {}. Getting the full registry", (Object)reconcileHashCode, (Object)delta.getAppsHashCode());
        this.RECONCILE_HASH_CODES_MISMATCH.increment();
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        EurekaHttpResponse<Applications> httpResponse = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(this.remoteRegionsRef.get()) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), this.remoteRegionsRef.get());
        Applications serverApps = httpResponse.getEntity();
        if (serverApps == null) {
            logger.warn("Cannot fetch full registry from the server; reconciliation failure");
            return;
        }
        if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.localRegionApps.set(this.filterAndShuffle(serverApps));
            this.getApplications().setVersion(delta.getVersion());
            logger.debug("The Reconcile hashcodes after complete sync up, client : {}, server : {}.", (Object)this.getApplications().getReconcileHashCode(), (Object)delta.getAppsHashCode());
        } else {
            logger.warn("Not setting the applications map as another thread has advanced the update generation");
        }
    }

    private void updateDelta(Applications delta) {
        int deltaCount = 0;
        for (Application app : delta.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                Application existingApp;
                Applications applications = this.getApplications();
                String instanceRegion = this.instanceRegionChecker.getInstanceRegion(instance);
                if (!this.instanceRegionChecker.isLocalRegion(instanceRegion)) {
                    Applications remoteApps = this.remoteRegionVsApps.get(instanceRegion);
                    if (null == remoteApps) {
                        remoteApps = new Applications();
                        this.remoteRegionVsApps.put(instanceRegion, remoteApps);
                    }
                    applications = remoteApps;
                }
                ++deltaCount;
                if (InstanceInfo.ActionType.ADDED.equals((Object)instance.getActionType())) {
                    existingApp = applications.getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        applications.addApplication(app);
                    }
                    logger.debug("Added instance {} to the existing apps in region {}", (Object)instance.getId(), (Object)instanceRegion);
                    applications.getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (InstanceInfo.ActionType.MODIFIED.equals((Object)instance.getActionType())) {
                    existingApp = applications.getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        applications.addApplication(app);
                    }
                    logger.debug("Modified instance {} to the existing apps ", (Object)instance.getId());
                    applications.getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (!InstanceInfo.ActionType.DELETED.equals((Object)instance.getActionType())) continue;
                existingApp = applications.getRegisteredApplications(instance.getAppName());
                if (existingApp == null) {
                    applications.addApplication(app);
                }
                logger.debug("Deleted instance {} to the existing apps ", (Object)instance.getId());
                applications.getRegisteredApplications(instance.getAppName()).removeInstance(instance);
            }
        }
        logger.debug("The total number of instances fetched by the delta processor : {}", (Object)deltaCount);
        this.getApplications().setVersion(delta.getVersion());
        this.getApplications().shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
        for (Applications applications : this.remoteRegionVsApps.values()) {
            applications.setVersion(delta.getVersion());
            applications.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
        }
    }

    private void initScheduledTasks() {
        int expBackOffBound;
        if (this.clientConfig.shouldFetchRegistry()) {
            int registryFetchIntervalSeconds = this.clientConfig.getRegistryFetchIntervalSeconds();
            expBackOffBound = this.clientConfig.getCacheRefreshExecutorExponentialBackOffBound();
            this.scheduler.schedule(new TimedSupervisorTask("cacheRefresh", this.scheduler, this.cacheRefreshExecutor, registryFetchIntervalSeconds, TimeUnit.SECONDS, expBackOffBound, new CacheRefreshThread()), (long)registryFetchIntervalSeconds, TimeUnit.SECONDS);
        }
        if (this.clientConfig.shouldRegisterWithEureka()) {
            int renewalIntervalInSecs = this.instanceInfo.getLeaseInfo().getRenewalIntervalInSecs();
            expBackOffBound = this.clientConfig.getHeartbeatExecutorExponentialBackOffBound();
            logger.info("Starting heartbeat executor: renew interval is: " + renewalIntervalInSecs);
            this.scheduler.schedule(new TimedSupervisorTask("heartbeat", this.scheduler, this.heartbeatExecutor, renewalIntervalInSecs, TimeUnit.SECONDS, expBackOffBound, new HeartbeatThread()), (long)renewalIntervalInSecs, TimeUnit.SECONDS);
            this.instanceInfoReplicator = new InstanceInfoReplicator(this, this.instanceInfo, this.clientConfig.getInstanceInfoReplicationIntervalSeconds(), 2);
            this.statusChangeListener = new ApplicationInfoManager.StatusChangeListener(){

                @Override
                public String getId() {
                    return "statusChangeListener";
                }

                @Override
                public void notify(StatusChangeEvent statusChangeEvent) {
                    if (InstanceInfo.InstanceStatus.DOWN == statusChangeEvent.getStatus() || InstanceInfo.InstanceStatus.DOWN == statusChangeEvent.getPreviousStatus()) {
                        logger.warn("Saw local status change event {}", (Object)statusChangeEvent);
                    } else {
                        logger.info("Saw local status change event {}", (Object)statusChangeEvent);
                    }
                    DiscoveryClient.this.instanceInfoReplicator.onDemandUpdate();
                }
            };
            if (this.clientConfig.shouldOnDemandUpdateStatusChange()) {
                this.applicationInfoManager.registerStatusChangeListener(this.statusChangeListener);
            }
            this.instanceInfoReplicator.start(this.clientConfig.getInitialInstanceInfoReplicationIntervalSeconds());
        } else {
            logger.info("Not registering with Eureka server per configuration");
        }
    }

    private void cancelScheduledTasks() {
        if (this.instanceInfoReplicator != null) {
            this.instanceInfoReplicator.stop();
        }
        if (this.heartbeatExecutor != null) {
            this.heartbeatExecutor.shutdownNow();
        }
        if (this.cacheRefreshExecutor != null) {
            this.cacheRefreshExecutor.shutdownNow();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    @Override
    @Deprecated
    public List<String> getServiceUrlsFromDNS(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromDNS(this.clientConfig, instanceZone, preferSameZone, this.urlRandomizer);
    }

    @Override
    @Deprecated
    public List<String> getDiscoveryServiceUrls(String zone) {
        return EndpointUtils.getDiscoveryServiceUrls(this.clientConfig, zone, this.urlRandomizer);
    }

    @Deprecated
    public static Set<String> getEC2DiscoveryUrlsFromZone(String dnsName, EndpointUtils.DiscoveryUrlType type) {
        return EndpointUtils.getEC2DiscoveryUrlsFromZone(dnsName, type);
    }

    void refreshInstanceInfo() {
        InstanceInfo.InstanceStatus status;
        this.applicationInfoManager.refreshDataCenterInfoIfRequired();
        this.applicationInfoManager.refreshLeaseInfoIfRequired();
        try {
            status = this.getHealthCheckHandler().getStatus(this.instanceInfo.getStatus());
        }
        catch (Exception e) {
            logger.warn("Exception from healthcheckHandler.getStatus, setting status to DOWN", (Throwable)e);
            status = InstanceInfo.InstanceStatus.DOWN;
        }
        if (null != status) {
            this.applicationInfoManager.setInstanceStatus(status);
        }
    }

    @VisibleForTesting
    InstanceInfoReplicator getInstanceInfoReplicator() {
        return this.instanceInfoReplicator;
    }

    @VisibleForTesting
    InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    @Override
    public HealthCheckHandler getHealthCheckHandler() {
        if (this.healthCheckHandler == null) {
            if (null != this.healthCheckHandlerProvider) {
                this.healthCheckHandler = (HealthCheckHandler)this.healthCheckHandlerProvider.get();
            } else if (null != this.healthCheckCallbackProvider) {
                this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge((HealthCheckCallback)this.healthCheckCallbackProvider.get());
            }
            if (null == this.healthCheckHandler) {
                this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge(null);
            }
        }
        return this.healthCheckHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void refreshRegistry() {
        try {
            boolean success;
            boolean isFetchingRemoteRegionRegistries = this.isFetchingRemoteRegionRegistries();
            boolean remoteRegionsModified = false;
            String latestRemoteRegions = this.clientConfig.fetchRegistryForRemoteRegions();
            if (null != latestRemoteRegions) {
                String currentRemoteRegions = this.remoteRegionsToFetch.get();
                if (!latestRemoteRegions.equals(currentRemoteRegions)) {
                    AzToRegionMapper azToRegionMapper = this.instanceRegionChecker.getAzToRegionMapper();
                    synchronized (azToRegionMapper) {
                        if (this.remoteRegionsToFetch.compareAndSet(currentRemoteRegions, latestRemoteRegions)) {
                            String[] remoteRegions = latestRemoteRegions.split(",");
                            this.remoteRegionsRef.set(remoteRegions);
                            this.instanceRegionChecker.getAzToRegionMapper().setRegionsToFetch(remoteRegions);
                            remoteRegionsModified = true;
                        } else {
                            logger.info("Remote regions to fetch modified concurrently, ignoring change from {} to {}", (Object)currentRemoteRegions, (Object)latestRemoteRegions);
                        }
                    }
                } else {
                    this.instanceRegionChecker.getAzToRegionMapper().refreshMapping();
                }
            }
            if (success = this.fetchRegistry(remoteRegionsModified)) {
                this.registrySize = this.localRegionApps.get().size();
                this.lastSuccessfulRegistryFetchTimestamp = System.currentTimeMillis();
            }
            if (logger.isDebugEnabled()) {
                StringBuilder allAppsHashCodes = new StringBuilder();
                allAppsHashCodes.append("Local region apps hashcode: ");
                allAppsHashCodes.append(this.localRegionApps.get().getAppsHashCode());
                allAppsHashCodes.append(", is fetching remote regions? ");
                allAppsHashCodes.append(isFetchingRemoteRegionRegistries);
                for (Map.Entry<String, Applications> entry : this.remoteRegionVsApps.entrySet()) {
                    allAppsHashCodes.append(", Remote region: ");
                    allAppsHashCodes.append(entry.getKey());
                    allAppsHashCodes.append(" , apps hashcode: ");
                    allAppsHashCodes.append(entry.getValue().getAppsHashCode());
                }
                logger.debug("Completed cache refresh task for discovery. All Apps hash code is {} ", (Object)allAppsHashCodes.toString());
            }
        }
        catch (Throwable e) {
            logger.error("Cannot fetch registry from server", e);
        }
    }

    private void fetchRegistryFromBackup() {
        try {
            BackupRegistry backupRegistryInstance = this.newBackupRegistryInstance();
            if (null == backupRegistryInstance) {
                backupRegistryInstance = (BackupRegistry)this.backupRegistryProvider.get();
            }
            if (null != backupRegistryInstance) {
                Applications apps = null;
                if (this.isFetchingRemoteRegionRegistries()) {
                    String remoteRegionsStr = this.remoteRegionsToFetch.get();
                    if (null != remoteRegionsStr) {
                        apps = backupRegistryInstance.fetchRegistry(remoteRegionsStr.split(","));
                    }
                } else {
                    apps = backupRegistryInstance.fetchRegistry();
                }
                if (apps != null) {
                    Applications applications = this.filterAndShuffle(apps);
                    applications.setAppsHashCode(applications.getReconcileHashCode());
                    this.localRegionApps.set(applications);
                    this.logTotalInstances();
                    logger.info("Fetched registry successfully from the backup");
                }
            } else {
                logger.warn("No backup registry instance defined & unable to find any discovery servers.");
            }
        }
        catch (Throwable e) {
            logger.warn("Cannot fetch applications from apps although backup registry was specified", e);
        }
    }

    @Deprecated
    @Nullable
    protected BackupRegistry newBackupRegistryInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return null;
    }

    private Applications filterAndShuffle(Applications apps) {
        if (apps != null) {
            if (this.isFetchingRemoteRegionRegistries()) {
                ConcurrentHashMap<String, Applications> remoteRegionVsApps = new ConcurrentHashMap<String, Applications>();
                apps.shuffleAndIndexInstances(remoteRegionVsApps, this.clientConfig, this.instanceRegionChecker);
                for (Applications applications : remoteRegionVsApps.values()) {
                    applications.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
                }
                this.remoteRegionVsApps = remoteRegionVsApps;
            } else {
                apps.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
            }
        }
        return apps;
    }

    private boolean isFetchingRemoteRegionRegistries() {
        return null != this.remoteRegionsToFetch.get();
    }

    protected void onRemoteStatusChanged(InstanceInfo.InstanceStatus oldStatus, InstanceInfo.InstanceStatus newStatus) {
        this.fireEvent(new StatusChangeEvent(oldStatus, newStatus));
    }

    protected void onCacheRefreshed() {
        this.fireEvent(new CacheRefreshedEvent());
    }

    protected void fireEvent(EurekaEvent event) {
        for (EurekaEventListener listener : this.eventListeners) {
            listener.onEvent(event);
        }
    }

    @Deprecated
    public static String getZone(InstanceInfo myInfo) {
        String[] availZones = staticClientConfig.getAvailabilityZones(staticClientConfig.getRegion());
        return InstanceInfo.getZone(availZones, myInfo);
    }

    @Deprecated
    public static String getRegion() {
        String region = staticClientConfig.getRegion();
        if (region == null) {
            region = "default";
        }
        region = region.trim().toLowerCase();
        return region;
    }

    @Deprecated
    public static List<String> getEurekaServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromConfig(staticClientConfig, instanceZone, preferSameZone);
    }

    public long getLastSuccessfulHeartbeatTimePeriod() {
        return this.lastSuccessfulHeartbeatTimestamp < 0L ? this.lastSuccessfulHeartbeatTimestamp : System.currentTimeMillis() - this.lastSuccessfulHeartbeatTimestamp;
    }

    public long getLastSuccessfulRegistryFetchTimePeriod() {
        return this.lastSuccessfulRegistryFetchTimestamp < 0L ? this.lastSuccessfulRegistryFetchTimestamp : System.currentTimeMillis() - this.lastSuccessfulRegistryFetchTimestamp;
    }

    @Monitor(name="eurekaClient.registration.lastSuccessfulHeartbeatTimePeriod", description="How much time has passed from last successful heartbeat", type=DataSourceType.GAUGE)
    private long getLastSuccessfulHeartbeatTimePeriodInternal() {
        long delay = this.getLastSuccessfulHeartbeatTimePeriod();
        this.heartbeatStalenessMonitor.update(this.computeStalenessMonitorDelay(delay));
        return delay;
    }

    @Monitor(name="eurekaClient.registry.lastSuccessfulRegistryFetchTimePeriod", description="How much time has passed from last successful local registry update", type=DataSourceType.GAUGE)
    private long getLastSuccessfulRegistryFetchTimePeriodInternal() {
        long delay = this.getLastSuccessfulRegistryFetchTimePeriod();
        this.registryStalenessMonitor.update(this.computeStalenessMonitorDelay(delay));
        return delay;
    }

    @Monitor(name="eurekaClient.registry.localRegistrySize", description="Count of instances in the local registry", type=DataSourceType.GAUGE)
    public int localRegistrySize() {
        return this.registrySize;
    }

    private long computeStalenessMonitorDelay(long delay) {
        if (delay < 0L) {
            return System.currentTimeMillis() - this.initTimestampMs;
        }
        return delay;
    }

    class CacheRefreshThread
    implements Runnable {
        CacheRefreshThread() {
        }

        @Override
        public void run() {
            DiscoveryClient.this.refreshRegistry();
        }
    }

    private class HeartbeatThread
    implements Runnable {
        private HeartbeatThread() {
        }

        @Override
        public void run() {
            if (DiscoveryClient.this.renew()) {
                DiscoveryClient.this.lastSuccessfulHeartbeatTimestamp = System.currentTimeMillis();
            }
        }
    }

    public static class DiscoveryClientOptionalArgs
    extends Jersey1DiscoveryClientOptionalArgs {
    }

    private static final class EurekaTransport {
        private ClosableResolver bootstrapResolver;
        private TransportClientFactory transportClientFactory;
        private EurekaHttpClient registrationClient;
        private EurekaHttpClientFactory registrationClientFactory;
        private EurekaHttpClient queryClient;
        private EurekaHttpClientFactory queryClientFactory;

        private EurekaTransport() {
        }

        void shutdown() {
            if (this.registrationClientFactory != null) {
                this.registrationClientFactory.shutdown();
            }
            if (this.queryClientFactory != null) {
                this.queryClientFactory.shutdown();
            }
            if (this.registrationClient != null) {
                this.registrationClient.shutdown();
            }
            if (this.queryClient != null) {
                this.queryClient.shutdown();
            }
            if (this.transportClientFactory != null) {
                this.transportClientFactory.shutdown();
            }
            if (this.bootstrapResolver != null) {
                this.bootstrapResolver.shutdown();
            }
        }
    }
}

