/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey;

import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.MonitoredConnectionManager;
import com.netflix.discovery.shared.transport.jersey.ApacheHttpClientConnectionCleaner;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.SSLSocketFactoryAdapter;
import com.netflix.discovery.util.DiscoveryBuildInfo;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class EurekaJerseyClientImpl
implements EurekaJerseyClient {
    private static final String PROTOCOL = "https";
    private static final String PROTOCOL_SCHEME = "SSL";
    private static final int HTTPS_PORT = 443;
    private static final String KEYSTORE_TYPE = "JKS";
    private final ApacheHttpClient4 apacheHttpClient;
    private final ApacheHttpClientConnectionCleaner apacheHttpClientConnectionCleaner;
    ClientConfig jerseyClientConfig;

    public EurekaJerseyClientImpl(int connectionTimeout, int readTimeout, int connectionIdleTimeout, ClientConfig clientConfig) {
        try {
            this.jerseyClientConfig = clientConfig;
            this.apacheHttpClient = ApacheHttpClient4.create((ClientConfig)this.jerseyClientConfig);
            HttpParams params = this.apacheHttpClient.getClientHandler().getHttpClient().getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
            this.apacheHttpClientConnectionCleaner = new ApacheHttpClientConnectionCleaner(this.apacheHttpClient, connectionIdleTimeout);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create Jersey client", e);
        }
    }

    @Override
    public ApacheHttpClient4 getClient() {
        return this.apacheHttpClient;
    }

    @Override
    public void destroyResources() {
        this.apacheHttpClientConnectionCleaner.shutdown();
        this.apacheHttpClient.destroy();
    }

    public static class EurekaJerseyClientBuilder {
        private boolean systemSSL;
        private String clientName;
        private int maxConnectionsPerHost;
        private int maxTotalConnections;
        private String trustStoreFileName;
        private String trustStorePassword;
        private String userAgent;
        private String proxyUserName;
        private String proxyPassword;
        private String proxyHost;
        private String proxyPort;
        private int connectionTimeout;
        private int readTimeout;
        private int connectionIdleTimeout;
        private EncoderWrapper encoderWrapper;
        private DecoderWrapper decoderWrapper;
        private SSLContext sslContext;

        public EurekaJerseyClientBuilder withClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public EurekaJerseyClientBuilder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public EurekaJerseyClientBuilder withConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public EurekaJerseyClientBuilder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public EurekaJerseyClientBuilder withConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public EurekaJerseyClientBuilder withMaxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public EurekaJerseyClientBuilder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public EurekaJerseyClientBuilder withProxy(String proxyHost, String proxyPort, String user, String password) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUserName = user;
            this.proxyPassword = password;
            return this;
        }

        public EurekaJerseyClientBuilder withSystemSSLConfiguration() {
            this.systemSSL = true;
            return this;
        }

        public EurekaJerseyClientBuilder withTrustStoreFile(String trustStoreFileName, String trustStorePassword) {
            this.trustStoreFileName = trustStoreFileName;
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public EurekaJerseyClientBuilder withEncoder(String encoderName) {
            return this.withEncoderWrapper(CodecWrappers.getEncoder(encoderName));
        }

        public EurekaJerseyClientBuilder withEncoderWrapper(EncoderWrapper encoderWrapper) {
            this.encoderWrapper = encoderWrapper;
            return this;
        }

        public EurekaJerseyClientBuilder withDecoder(String decoderName, String clientDataAccept) {
            return this.withDecoderWrapper(CodecWrappers.resolveDecoder(decoderName, clientDataAccept));
        }

        public EurekaJerseyClientBuilder withDecoderWrapper(DecoderWrapper decoderWrapper) {
            this.decoderWrapper = decoderWrapper;
            return this;
        }

        public EurekaJerseyClientBuilder withCustomSSL(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public EurekaJerseyClient build() {
            MyDefaultApacheHttpClient4Config config = new MyDefaultApacheHttpClient4Config();
            try {
                return new EurekaJerseyClientImpl(this.connectionTimeout, this.readTimeout, this.connectionIdleTimeout, (ClientConfig)config);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot create Jersey client ", e);
            }
        }

        class MyDefaultApacheHttpClient4Config
        extends DefaultApacheHttpClient4Config {
            MyDefaultApacheHttpClient4Config() {
                MonitoredConnectionManager cm = EurekaJerseyClientBuilder.this.systemSSL ? this.createSystemSslCM() : (EurekaJerseyClientBuilder.this.sslContext != null || EurekaJerseyClientBuilder.this.trustStoreFileName != null ? this.createCustomSslCM() : this.createDefaultSslCM());
                if (EurekaJerseyClientBuilder.this.proxyHost != null) {
                    this.addProxyConfiguration(cm);
                }
                DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider(EurekaJerseyClientBuilder.this.encoderWrapper, EurekaJerseyClientBuilder.this.decoderWrapper);
                this.getSingletons().add(discoveryJerseyProvider);
                cm.setDefaultMaxPerRoute(EurekaJerseyClientBuilder.this.maxConnectionsPerHost);
                cm.setMaxTotal(EurekaJerseyClientBuilder.this.maxTotalConnections);
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
                String fullUserAgentName = (EurekaJerseyClientBuilder.this.userAgent == null ? EurekaJerseyClientBuilder.this.clientName : EurekaJerseyClientBuilder.this.userAgent) + "/v" + DiscoveryBuildInfo.buildVersion();
                this.getProperties().put("http.useragent", fullUserAgentName);
                this.getProperties().put("com.sun.jersey.client.property.followRedirects", Boolean.FALSE);
                this.getProperties().put("http.protocol.handle-redirects", Boolean.FALSE);
            }

            private void addProxyConfiguration(MonitoredConnectionManager cm) {
                if (EurekaJerseyClientBuilder.this.proxyUserName != null && EurekaJerseyClientBuilder.this.proxyPassword != null) {
                    this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", EurekaJerseyClientBuilder.this.proxyUserName);
                    this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", EurekaJerseyClientBuilder.this.proxyPassword);
                } else {
                    this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", "guest");
                    this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", "guest");
                }
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + EurekaJerseyClientBuilder.this.proxyHost + ":" + EurekaJerseyClientBuilder.this.proxyPort);
            }

            private MonitoredConnectionManager createSystemSslCM() {
                SSLConnectionSocketFactory systemSocketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
                SSLSocketFactoryAdapter sslSocketFactory = new SSLSocketFactoryAdapter(systemSocketFactory);
                SchemeRegistry sslSchemeRegistry = new SchemeRegistry();
                sslSchemeRegistry.register(new Scheme(EurekaJerseyClientImpl.PROTOCOL, 443, (SchemeSocketFactory)sslSocketFactory));
                MonitoredConnectionManager cm = new MonitoredConnectionManager(EurekaJerseyClientBuilder.this.clientName, sslSchemeRegistry);
                return cm;
            }

            private MonitoredConnectionManager createCustomSslCM() {
                FileInputStream fin = null;
                try {
                    if (EurekaJerseyClientBuilder.this.sslContext == null) {
                        EurekaJerseyClientBuilder.this.sslContext = SSLContext.getInstance(EurekaJerseyClientImpl.PROTOCOL_SCHEME);
                        KeyStore sslKeyStore = KeyStore.getInstance(EurekaJerseyClientImpl.KEYSTORE_TYPE);
                        fin = new FileInputStream(EurekaJerseyClientBuilder.this.trustStoreFileName);
                        sslKeyStore.load(fin, EurekaJerseyClientBuilder.this.trustStorePassword.toCharArray());
                        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        factory.init(sslKeyStore);
                        TrustManager[] trustManagers = factory.getTrustManagers();
                        EurekaJerseyClientBuilder.this.sslContext.init(null, trustManagers, null);
                    }
                    X509HostnameVerifier hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                    SSLConnectionSocketFactory customSslSocketFactory = new SSLConnectionSocketFactory(EurekaJerseyClientBuilder.this.sslContext, hostnameVerifier);
                    SSLSocketFactoryAdapter sslSocketFactory = new SSLSocketFactoryAdapter(customSslSocketFactory);
                    SchemeRegistry sslSchemeRegistry = new SchemeRegistry();
                    sslSchemeRegistry.register(new Scheme(EurekaJerseyClientImpl.PROTOCOL, 443, (SchemeSocketFactory)sslSocketFactory));
                    MonitoredConnectionManager monitoredConnectionManager = new MonitoredConnectionManager(EurekaJerseyClientBuilder.this.clientName, sslSchemeRegistry);
                    return monitoredConnectionManager;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("SSL configuration issue", ex);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }

            private MonitoredConnectionManager createDefaultSslCM() {
                SchemeRegistry registry = new SchemeRegistry();
                registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
                registry.register(new Scheme(EurekaJerseyClientImpl.PROTOCOL, 443, (SchemeSocketFactory)new SSLSocketFactoryAdapter(SSLConnectionSocketFactory.getSocketFactory())));
                return new MonitoredConnectionManager(EurekaJerseyClientBuilder.this.clientName, registry);
            }
        }
    }
}

