/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.google.inject.Inject;
import com.netflix.appinfo.CloudInstanceConfig;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.discovery.StatusChangeEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApplicationInfoManager {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInfoManager.class);
    private static final InstanceStatusMapper NO_OP_MAPPER = new InstanceStatusMapper(){

        @Override
        public InstanceInfo.InstanceStatus map(InstanceInfo.InstanceStatus prev) {
            return prev;
        }
    };
    private static ApplicationInfoManager instance = new ApplicationInfoManager(null, null, null);
    protected final Map<String, StatusChangeListener> listeners;
    private final InstanceStatusMapper instanceStatusMapper;
    private InstanceInfo instanceInfo;
    private EurekaInstanceConfig config;

    @javax.inject.Inject
    public ApplicationInfoManager(EurekaInstanceConfig config, InstanceInfo instanceInfo, OptionalArgs optionalArgs) {
        this.config = config;
        this.instanceInfo = instanceInfo;
        this.listeners = new ConcurrentHashMap<String, StatusChangeListener>();
        this.instanceStatusMapper = optionalArgs != null ? optionalArgs.getInstanceStatusMapper() : NO_OP_MAPPER;
        instance = this;
    }

    public ApplicationInfoManager(EurekaInstanceConfig config, OptionalArgs optionalArgs) {
        this(config, new EurekaConfigBasedInstanceInfoProvider(config).get(), optionalArgs);
    }

    public ApplicationInfoManager(EurekaInstanceConfig config, InstanceInfo instanceInfo) {
        this(config, instanceInfo, null);
    }

    @Deprecated
    public ApplicationInfoManager(EurekaInstanceConfig config) {
        this(config, (OptionalArgs)null);
    }

    @Deprecated
    public static ApplicationInfoManager getInstance() {
        return instance;
    }

    public void initComponent(EurekaInstanceConfig config) {
        try {
            this.config = config;
            this.instanceInfo = new EurekaConfigBasedInstanceInfoProvider(config).get();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize ApplicationInfoManager", e);
        }
    }

    public InstanceInfo getInfo() {
        return this.instanceInfo;
    }

    public EurekaInstanceConfig getEurekaInstanceConfig() {
        return this.config;
    }

    public void registerAppMetadata(Map<String, String> appMetadata) {
        this.instanceInfo.registerRuntimeMetadata(appMetadata);
    }

    public synchronized void setInstanceStatus(InstanceInfo.InstanceStatus status) {
        InstanceInfo.InstanceStatus next = this.instanceStatusMapper.map(status);
        if (next == null) {
            return;
        }
        InstanceInfo.InstanceStatus prev = this.instanceInfo.setStatus(next);
        if (prev != null) {
            for (StatusChangeListener listener : this.listeners.values()) {
                try {
                    listener.notify(new StatusChangeEvent(prev, next));
                }
                catch (Exception e) {
                    logger.warn("failed to notify listener: {}", (Object)listener.getId(), (Object)e);
                }
            }
        }
    }

    public void registerStatusChangeListener(StatusChangeListener listener) {
        this.listeners.put(listener.getId(), listener);
    }

    public void unregisterStatusChangeListener(String listenerId) {
        this.listeners.remove(listenerId);
    }

    public void refreshDataCenterInfoIfRequired() {
        String existingAddress = this.instanceInfo.getHostName();
        String newAddress = this.config instanceof CloudInstanceConfig ? ((CloudInstanceConfig)this.config).resolveDefaultAddress(true) : this.config.getHostName(true);
        String newIp = this.config.getIpAddress();
        if (newAddress != null && !newAddress.equals(existingAddress)) {
            logger.warn("The address changed from : {} => {}", (Object)existingAddress, (Object)newAddress);
            InstanceInfo.Builder builder = new InstanceInfo.Builder(this.instanceInfo);
            builder.setHostName(newAddress).setIPAddr(newIp).setDataCenterInfo(this.config.getDataCenterInfo());
            this.instanceInfo.setIsDirty();
        }
    }

    public void refreshLeaseInfoIfRequired() {
        LeaseInfo leaseInfo = this.instanceInfo.getLeaseInfo();
        if (leaseInfo == null) {
            return;
        }
        int currentLeaseDuration = this.config.getLeaseExpirationDurationInSeconds();
        int currentLeaseRenewal = this.config.getLeaseRenewalIntervalInSeconds();
        if (leaseInfo.getDurationInSecs() != currentLeaseDuration || leaseInfo.getRenewalIntervalInSecs() != currentLeaseRenewal) {
            LeaseInfo newLeaseInfo = LeaseInfo.Builder.newBuilder().setRenewalIntervalInSecs(currentLeaseRenewal).setDurationInSecs(currentLeaseDuration).build();
            this.instanceInfo.setLeaseInfo(newLeaseInfo);
            this.instanceInfo.setIsDirty();
        }
    }

    public static interface InstanceStatusMapper {
        public InstanceInfo.InstanceStatus map(InstanceInfo.InstanceStatus var1);
    }

    public static interface StatusChangeListener {
        public String getId();

        public void notify(StatusChangeEvent var1);
    }

    public static class OptionalArgs {
        private InstanceStatusMapper instanceStatusMapper;

        @Inject(optional=true)
        public void setInstanceStatusMapper(InstanceStatusMapper instanceStatusMapper) {
            this.instanceStatusMapper = instanceStatusMapper;
        }

        InstanceStatusMapper getInstanceStatusMapper() {
            return this.instanceStatusMapper == null ? NO_OP_MAPPER : this.instanceStatusMapper;
        }
    }
}

