/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson.builder;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.discovery.util.StringCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StringInterningAmazonInfoBuilder {
    private static final Set<String> VALUE_INTERN_KEYS;
    private HashMap<String, String> metadata;

    public StringInterningAmazonInfoBuilder withName(String name) {
        return this;
    }

    public StringInterningAmazonInfoBuilder withMetadata(HashMap<String, String> metadata) {
        if (metadata.isEmpty()) {
            this.metadata = metadata;
            return this;
        }
        this.metadata = new HashMap();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String key = entry.getKey().intern();
            String value = entry.getValue();
            if (VALUE_INTERN_KEYS.contains(key)) {
                value = StringCache.intern(value);
            }
            this.metadata.put(key, value);
        }
        return this;
    }

    public AmazonInfo build() {
        return new AmazonInfo(DataCenterInfo.Name.Amazon.name(), this.metadata);
    }

    static {
        HashSet<String> keys = new HashSet<String>();
        keys.add(AmazonInfo.MetaDataKey.accountId.getName());
        keys.add(AmazonInfo.MetaDataKey.amiId.getName());
        keys.add(AmazonInfo.MetaDataKey.availabilityZone.getName());
        keys.add(AmazonInfo.MetaDataKey.instanceType.getName());
        keys.add(AmazonInfo.MetaDataKey.vpcId.getName());
        VALUE_INTERN_KEYS = keys;
    }
}

