/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.google.inject.ProvidedBy;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.PropertiesInstanceConfig;
import com.netflix.appinfo.providers.CloudInstanceConfigProvider;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ProvidedBy(value=CloudInstanceConfigProvider.class)
public class CloudInstanceConfig
extends PropertiesInstanceConfig {
    private static final Logger logger = LoggerFactory.getLogger(CloudInstanceConfig.class);
    private static final DynamicPropertyFactory INSTANCE = DynamicPropertyFactory.getInstance();
    private static final String[] DEFAULT_AWS_ADDRESS_RESOLUTION_ORDER = new String[]{AmazonInfo.MetaDataKey.publicHostname.name(), AmazonInfo.MetaDataKey.localIpv4.name()};
    private DynamicBooleanProperty propValidateInstanceId;
    private volatile AmazonInfo info;

    public CloudInstanceConfig() {
        this.initCloudInstanceConfig(this.namespace);
    }

    public CloudInstanceConfig(String namespace) {
        super(namespace);
        this.initCloudInstanceConfig(namespace);
    }

    private void initCloudInstanceConfig(String namespace) {
        this.propValidateInstanceId = INSTANCE.getBooleanProperty(namespace + "validateInstanceId", true);
        this.info = this.initDataCenterInfo();
    }

    private AmazonInfo initDataCenterInfo() {
        AmazonInfo info;
        try {
            info = AmazonInfo.Builder.newBuilder().autoBuild(this.namespace);
            logger.info("Datacenter is: " + (Object)((Object)DataCenterInfo.Name.Amazon));
        }
        catch (Throwable e) {
            logger.error("Cannot initialize amazon info :", e);
            throw new RuntimeException(e);
        }
        if (info.get(AmazonInfo.MetaDataKey.instanceId) == null) {
            if (this.propValidateInstanceId.get()) {
                throw new RuntimeException("Your datacenter is defined as cloud but we are not able to get the amazon metadata to register. \nSet the property " + this.namespace + "validateInstanceId to false to " + "ignore the metadata call");
            }
            HashMap<String, String> metadataMap = new HashMap<String, String>();
            metadataMap.put(AmazonInfo.MetaDataKey.instanceId.getName(), super.getIpAddress());
            metadataMap.put(AmazonInfo.MetaDataKey.publicHostname.getName(), super.getHostName(false));
            info.setMetadata(metadataMap);
        } else if (info.get(AmazonInfo.MetaDataKey.publicHostname) == null && info.get(AmazonInfo.MetaDataKey.localIpv4) != null) {
            info.getMetadata().put(AmazonInfo.MetaDataKey.publicHostname.getName(), info.get(AmazonInfo.MetaDataKey.localIpv4));
        }
        return info;
    }

    public String resolveDefaultAddress(DataCenterInfo dataCenterInfo) {
        String result = this.getHostName(true);
        if (dataCenterInfo instanceof AmazonInfo) {
            AmazonInfo amazonInfo = (AmazonInfo)dataCenterInfo;
            for (String name : this.getDefaultAddressResolutionOrder()) {
                try {
                    AmazonInfo.MetaDataKey key = AmazonInfo.MetaDataKey.valueOf(name);
                    String address = amazonInfo.get(key);
                    if (address == null || address.isEmpty()) continue;
                    result = address;
                    break;
                }
                catch (Exception e) {
                    logger.error("failed to resolve default address for key {}, skipping", (Object)name, (Object)e);
                }
            }
        } else {
            logger.warn("DataCenterInfo is not of type AmazonInfo. Defaulting to default resolution");
        }
        return result;
    }

    @Override
    public String getHostName(boolean refresh) {
        if (refresh) {
            this.refreshAmazonInfo();
        }
        return this.info.get(AmazonInfo.MetaDataKey.publicHostname);
    }

    @Override
    public String getIpAddress() {
        String ipAddr = this.info.get(AmazonInfo.MetaDataKey.localIpv4);
        return ipAddr == null ? super.getIpAddress() : ipAddr;
    }

    @Override
    public DataCenterInfo getDataCenterInfo() {
        return this.info;
    }

    @Override
    public String[] getDefaultAddressResolutionOrder() {
        String[] order = super.getDefaultAddressResolutionOrder();
        return order.length == 0 ? DEFAULT_AWS_ADDRESS_RESOLUTION_ORDER : order;
    }

    public synchronized void refreshAmazonInfo() {
        try {
            AmazonInfo newInfo = AmazonInfo.Builder.newBuilder().autoBuild(this.namespace);
            if (!newInfo.equals(this.info)) {
                logger.warn("The AmazonInfo changed from : {} => {}", (Object)this.info, (Object)newInfo);
                this.info = newInfo;
            }
        }
        catch (Throwable t) {
            logger.error("Cannot refresh the Amazon Info ", t);
        }
    }
}

