/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.EurekaClientIdentity;
import com.netflix.appinfo.HealthCheckCallback;
import com.netflix.appinfo.HealthCheckCallbackToHandlerBridge;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractAzToRegionMapper;
import com.netflix.discovery.AzToRegionMapper;
import com.netflix.discovery.BackupRegistry;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.DNSBasedAzToRegionMapper;
import com.netflix.discovery.DiscoveryEvent;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.InstanceInfoReplicator;
import com.netflix.discovery.InstanceRegionChecker;
import com.netflix.discovery.NotImplementedRegistryImpl;
import com.netflix.discovery.PropertyBasedAzToRegionMapper;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.endpoint.DnsResolver;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.ClosableResolver;
import com.netflix.discovery.shared.resolver.aws.ApplicationsResolver;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpClients;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import com.netflix.discovery.util.ThresholdLevelsMetric;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiscoveryClient
implements EurekaClient {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryClient.class);
    public static final int MAX_FOLLOWED_REDIRECTS = 10;
    public static final String HTTP_X_DISCOVERY_ALLOW_REDIRECT = "X-Discovery-AllowRedirect";
    private static final String VALUE_DELIMITER = ",";
    private static final String COMMA_STRING = ",";
    private static final String DISCOVERY_APPID = "DISCOVERY";
    private static final String UNKNOWN = "UNKNOWN";
    private static final Pattern REDIRECT_PATH_REGEX = Pattern.compile("(.*/v2/)apps(/.*)?$");
    @Deprecated
    private static EurekaClientConfig staticClientConfig;
    private static final String PREFIX = "DiscoveryClient_";
    private final Timer GET_SERVICE_URLS_DNS_TIMER = Monitors.newTimer((String)"DiscoveryClient_GetServiceUrlsFromDNS");
    private final Timer REGISTER_TIMER = Monitors.newTimer((String)"DiscoveryClient_Register");
    private final Timer REFRESH_TIMER = Monitors.newTimer((String)"DiscoveryClient_Refresh");
    private final Timer REFRESH_DELTA_TIMER = Monitors.newTimer((String)"DiscoveryClient_RefreshDelta");
    private final Counter RECONCILE_HASH_CODES_MISMATCH = Monitors.newCounter((String)"DiscoveryClient_ReconcileHashCodeMismatch");
    private final Timer RENEW_TIMER = Monitors.newTimer((String)"DiscoveryClient_Renew");
    private final Timer CANCEL_TIMER = Monitors.newTimer((String)"DiscoveryClient_Cancel");
    private final Timer FETCH_REGISTRY_TIMER = Monitors.newTimer((String)"DiscoveryClient_FetchRegistry");
    private final Counter SERVER_RETRY_COUNTER = Monitors.newCounter((String)"DiscoveryClient_Retry");
    private final Counter ALL_SERVER_FAILURE_COUNT = Monitors.newCounter((String)"DiscoveryClient_Failed");
    private final Counter REREGISTER_COUNTER = Monitors.newCounter((String)"DiscoveryClient_Reregister");
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor heartbeatExecutor;
    private final ThreadPoolExecutor cacheRefreshExecutor;
    private final Provider<HealthCheckHandler> healthCheckHandlerProvider;
    private final Provider<HealthCheckCallback> healthCheckCallbackProvider;
    private final AtomicReference<List<String>> eurekaServiceUrls = new AtomicReference();
    private final AtomicReference<Applications> localRegionApps = new AtomicReference();
    private final Lock fetchRegistryUpdateLock = new ReentrantLock();
    private final AtomicLong fetchRegistryGeneration;
    private final ApplicationInfoManager applicationInfoManager;
    private final InstanceInfo instanceInfo;
    private final EurekaAccept clientAccept;
    private final AtomicReference<String> remoteRegionsToFetch;
    private final AtomicReference<String[]> remoteRegionsRef;
    private final InstanceRegionChecker instanceRegionChecker;
    private final AtomicReference<String> lastQueryRedirect = new AtomicReference();
    private final AtomicReference<String> lastRegisterRedirect = new AtomicReference();
    private final EventBus eventBus;
    private final EndpointUtils.ServiceUrlRandomizer urlRandomizer;
    private final Provider<BackupRegistry> backupRegistryProvider;
    private final EurekaTransport eurekaTransport;
    private final ApacheHttpClient4 discoveryApacheClient;
    private EurekaJerseyClient discoveryJerseyClient;
    private volatile HealthCheckHandler healthCheckHandler;
    private volatile Map<String, Applications> remoteRegionVsApps = new ConcurrentHashMap<String, Applications>();
    private volatile InstanceInfo.InstanceStatus lastRemoteInstanceStatus = InstanceInfo.InstanceStatus.UNKNOWN;
    private String appPathIdentifier;
    private boolean isRegisteredWithDiscovery = false;
    private ApplicationInfoManager.StatusChangeListener statusChangeListener;
    private InstanceInfoReplicator instanceInfoReplicator;
    private volatile int registrySize = 0;
    private volatile long lastSuccessfulRegistryFetchTimestamp = -1L;
    private volatile long lastSuccessfulHeartbeatTimestamp = -1L;
    private final ThresholdLevelsMetric heartbeatStalenessMonitor;
    private final ThresholdLevelsMetric registryStalenessMonitor;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    protected final EurekaClientConfig clientConfig;
    protected final EurekaTransportConfig transportConfig;
    private final long initTimestampMs;

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config) {
        this(myInfo, config, null);
    }

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config, DiscoveryClientOptionalArgs args) {
        this(ApplicationInfoManager.getInstance(), config, args);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config) {
        this(applicationInfoManager, config, null);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, final EurekaClientConfig config, DiscoveryClientOptionalArgs args) {
        this(applicationInfoManager, config, args, new Provider<BackupRegistry>(){
            private volatile BackupRegistry backupRegistryInstance;

            public synchronized BackupRegistry get() {
                if (this.backupRegistryInstance == null) {
                    String backupRegistryClassName = config.getBackupRegistryImpl();
                    if (null != backupRegistryClassName) {
                        try {
                            this.backupRegistryInstance = (BackupRegistry)Class.forName(backupRegistryClassName).newInstance();
                        }
                        catch (InstantiationException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                    }
                    logger.warn("Using default backup registry implementation which does not do anything.");
                    this.backupRegistryInstance = new NotImplementedRegistryImpl();
                }
                return this.backupRegistryInstance;
            }
        });
    }

    @Inject
    DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, DiscoveryClientOptionalArgs args, Provider<BackupRegistry> backupRegistryProvider) {
        if (args != null) {
            this.healthCheckHandlerProvider = args.healthCheckHandlerProvider;
            this.healthCheckCallbackProvider = args.healthCheckCallbackProvider;
            this.eventBus = args.eventBus;
            this.discoveryJerseyClient = args.eurekaJerseyClient;
        } else {
            this.healthCheckCallbackProvider = null;
            this.healthCheckHandlerProvider = null;
            this.eventBus = null;
            this.discoveryJerseyClient = null;
        }
        this.applicationInfoManager = applicationInfoManager;
        InstanceInfo myInfo = applicationInfoManager.getInfo();
        this.backupRegistryProvider = backupRegistryProvider;
        try {
            this.scheduler = Executors.newScheduledThreadPool(3, new ThreadFactoryBuilder().setNameFormat("DiscoveryClient-%d").setDaemon(true).build());
            staticClientConfig = this.clientConfig = config;
            this.transportConfig = config.getTransportConfig();
            this.instanceInfo = myInfo;
            if (myInfo != null) {
                this.appPathIdentifier = this.instanceInfo.getAppName() + "/" + this.instanceInfo.getId();
            } else {
                logger.warn("Setting instanceInfo to a passed in null value");
            }
            this.urlRandomizer = new EndpointUtils.InstanceInfoBasedUrlRandomizer(this.instanceInfo);
            String[] availZones = this.clientConfig.getAvailabilityZones(this.clientConfig.getRegion());
            String zone = InstanceInfo.getZone(availZones, myInfo);
            this.localRegionApps.set(new Applications());
            this.heartbeatExecutor = new ThreadPoolExecutor(1, this.clientConfig.getHeartbeatExecutorThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.cacheRefreshExecutor = new ThreadPoolExecutor(1, this.clientConfig.getCacheRefreshExecutorThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.fetchRegistryGeneration = new AtomicLong(0L);
            this.clientAccept = EurekaAccept.fromString(this.clientConfig.getClientDataAccept());
            this.eurekaTransport = new EurekaTransport();
            this.scheduleServerEndpointTask(this.eurekaTransport, zone);
            if (this.discoveryJerseyClient == null) {
                EurekaJerseyClientImpl.EurekaJerseyClientBuilder clientBuilder = new EurekaJerseyClientImpl.EurekaJerseyClientBuilder().withUserAgent("Java-EurekaClient").withConnectionTimeout(this.clientConfig.getEurekaServerConnectTimeoutSeconds() * 1000).withReadTimeout(this.clientConfig.getEurekaServerReadTimeoutSeconds() * 1000).withMaxConnectionsPerHost(this.clientConfig.getEurekaServerTotalConnectionsPerHost()).withMaxTotalConnections(this.clientConfig.getEurekaServerTotalConnections()).withConnectionIdleTimeout(this.clientConfig.getEurekaConnectionIdleTimeoutSeconds()).withEncoder(this.clientConfig.getEncoderName()).withDecoder(this.clientConfig.getDecoderName(), this.clientConfig.getClientDataAccept());
                if (this.eurekaServiceUrls.get().get(0).startsWith("https://") && "true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                    clientBuilder.withClientName("DiscoveryClient-HTTPClient-System").withSystemSSLConfiguration();
                } else if (this.clientConfig.getProxyHost() != null && this.clientConfig.getProxyPort() != null) {
                    clientBuilder.withClientName("Proxy-DiscoveryClient-HTTPClient").withProxy(this.clientConfig.getProxyHost(), this.clientConfig.getProxyPort(), this.clientConfig.getProxyUserName(), this.clientConfig.getProxyPassword());
                } else {
                    clientBuilder.withClientName("DiscoveryClient-HTTPClient");
                }
                this.discoveryJerseyClient = clientBuilder.build();
            }
            this.discoveryApacheClient = this.discoveryJerseyClient.getClient();
            this.remoteRegionsToFetch = new AtomicReference<String>(this.clientConfig.fetchRegistryForRemoteRegions());
            this.remoteRegionsRef = new AtomicReference<Object>((this.remoteRegionsToFetch.get() == null ? null : this.remoteRegionsToFetch.get().split(",")));
            AbstractAzToRegionMapper azToRegionMapper = this.clientConfig.shouldUseDnsForFetchingServiceUrls() ? new DNSBasedAzToRegionMapper(this.clientConfig) : new PropertyBasedAzToRegionMapper(this.clientConfig);
            if (null != this.remoteRegionsToFetch.get()) {
                azToRegionMapper.setRegionsToFetch(this.remoteRegionsToFetch.get().split(","));
            }
            this.instanceRegionChecker = new InstanceRegionChecker(azToRegionMapper, this.clientConfig.getRegion());
            boolean enableGZIPContentEncodingFilter = config.shouldGZipContent();
            if (enableGZIPContentEncodingFilter) {
                this.discoveryApacheClient.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
            }
            String ip = this.instanceInfo == null ? null : this.instanceInfo.getIPAddr();
            EurekaClientIdentity identity = new EurekaClientIdentity(ip);
            this.discoveryApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter(identity));
            if (args != null && args.additionalFilters != null) {
                for (ClientFilter filter : args.additionalFilters) {
                    this.discoveryApacheClient.addFilter(filter);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize DiscoveryClient!", e);
        }
        if (this.clientConfig.shouldFetchRegistry() && !this.fetchRegistry(false)) {
            this.fetchRegistryFromBackup();
        }
        this.initScheduledTasks();
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register timers", e);
        }
        this.heartbeatStalenessMonitor = new ThresholdLevelsMetric(this, "eurekaClient.registration.lastHeartbeatSec_", new long[]{15L, 30L, 60L, 120L, 240L, 480L});
        this.registryStalenessMonitor = new ThresholdLevelsMetric(this, "eurekaClient.registry.lastUpdateSec_", new long[]{15L, 30L, 60L, 120L, 240L, 480L});
        DiscoveryManager.getInstance().setDiscoveryClient(this);
        DiscoveryManager.getInstance().setEurekaClientConfig(config);
        this.initTimestampMs = System.currentTimeMillis();
    }

    private void scheduleServerEndpointTask(EurekaTransport eurekaTransport, String zone) {
        this.eurekaServiceUrls.set(this.timedGetDiscoveryServiceUrls(zone));
        this.scheduler.scheduleWithFixedDelay(this.getServiceUrlUpdateTask(zone), this.clientConfig.getEurekaServiceUrlPollIntervalSeconds(), this.clientConfig.getEurekaServiceUrlPollIntervalSeconds(), TimeUnit.SECONDS);
        eurekaTransport.bootstrapResolver = EurekaHttpClients.newBootstrapResolver(this.clientConfig, this.applicationInfoManager.getInfo());
        eurekaTransport.transportClientFactory = EurekaHttpClients.newTransportClientFactory(this.clientConfig, this.applicationInfoManager.getInfo());
        if (this.clientConfig.shouldRegisterWithEureka()) {
            EurekaHttpClientFactory newRegistrationClientFactory = null;
            EurekaHttpClient newRegistrationClient = null;
            try {
                newRegistrationClientFactory = EurekaHttpClients.registrationClientFactory(eurekaTransport.bootstrapResolver, eurekaTransport.transportClientFactory, this.transportConfig);
                newRegistrationClient = newRegistrationClientFactory.newClient();
            }
            catch (Exception e) {
                logger.warn("Experimental transport initialization failure", (Throwable)e);
            }
            eurekaTransport.registrationClientFactory = newRegistrationClientFactory;
            eurekaTransport.registrationClient = newRegistrationClient;
        }
        if (this.clientConfig.shouldFetchRegistry()) {
            EurekaHttpClientFactory newQueryClientFactory = null;
            EurekaHttpClient newQueryClient = null;
            try {
                newQueryClientFactory = EurekaHttpClients.queryClientFactory(eurekaTransport.bootstrapResolver, eurekaTransport.transportClientFactory, this.clientConfig, this.transportConfig, this.applicationInfoManager.getInfo(), new ApplicationsResolver.ApplicationsSource(){

                    @Override
                    public Applications getApplications(int stalenessThreshold, TimeUnit timeUnit) {
                        long thresholdInMs = TimeUnit.MILLISECONDS.convert(stalenessThreshold, timeUnit);
                        long delay = DiscoveryClient.this.getLastSuccessfulRegistryFetchTimePeriod();
                        if (delay > thresholdInMs) {
                            logger.info("Local registry is too stale for local lookup. Threshold:{}, actual:{}", (Object)thresholdInMs, (Object)delay);
                            return null;
                        }
                        return (Applications)DiscoveryClient.this.localRegionApps.get();
                    }
                });
                newQueryClient = newQueryClientFactory.newClient();
            }
            catch (Exception e) {
                logger.warn("Experimental transport initialization failure", (Throwable)e);
            }
            eurekaTransport.queryClientFactory = newQueryClientFactory;
            eurekaTransport.queryClient = newQueryClient;
        }
    }

    @Override
    public Application getApplication(String appName) {
        return this.getApplications().getRegisteredApplications(appName);
    }

    @Override
    public Applications getApplications() {
        return this.localRegionApps.get();
    }

    @Override
    public Applications getApplicationsForARegion(@Nullable String region) {
        if (this.instanceRegionChecker.isLocalRegion(region)) {
            return this.localRegionApps.get();
        }
        return this.remoteRegionVsApps.get(region);
    }

    @Override
    public Set<String> getAllKnownRegions() {
        String localRegion = this.instanceRegionChecker.getLocalRegion();
        if (!this.remoteRegionVsApps.isEmpty()) {
            Set<String> regions = this.remoteRegionVsApps.keySet();
            HashSet<String> toReturn = new HashSet<String>(regions);
            toReturn.add(localRegion);
            return toReturn;
        }
        return Collections.singleton(localRegion);
    }

    @Override
    public List<InstanceInfo> getInstancesById(String id) {
        ArrayList<InstanceInfo> instancesList = new ArrayList<InstanceInfo>();
        for (Application app : this.getApplications().getRegisteredApplications()) {
            InstanceInfo instanceInfo = app.getByInstanceId(id);
            if (instanceInfo == null) continue;
            instancesList.add(instanceInfo);
        }
        return instancesList;
    }

    @Override
    @Deprecated
    public void registerHealthCheckCallback(HealthCheckCallback callback) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a listener for instance info since it is null!");
        }
        if (callback != null) {
            this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge(callback);
        }
    }

    @Override
    public void registerHealthCheck(HealthCheckHandler healthCheckHandler) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a healthcheck handler when instance info is null!");
        }
        if (healthCheckHandler != null) {
            this.healthCheckHandler = healthCheckHandler;
        }
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure) {
        return this.getInstancesByVipAddress(vipAddress, secure, this.instanceRegionChecker.getLocalRegion());
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure, @Nullable String region) {
        Applications applications;
        if (vipAddress == null) {
            throw new IllegalArgumentException("Supplied VIP Address cannot be null");
        }
        if (this.instanceRegionChecker.isLocalRegion(region)) {
            applications = this.localRegionApps.get();
        } else {
            applications = this.remoteRegionVsApps.get(region);
            if (null == applications) {
                logger.debug("No applications are defined for region {}, so returning an empty instance list for vip address {}.", (Object)region, (Object)vipAddress);
                return Collections.emptyList();
            }
        }
        if (!secure) {
            return applications.getInstancesByVirtualHostName(vipAddress);
        }
        return applications.getInstancesBySecureVirtualHostName(vipAddress);
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddressAndAppName(String vipAddress, String appName, boolean secure) {
        List<InstanceInfo> result = new ArrayList<InstanceInfo>();
        if (vipAddress == null && appName == null) {
            throw new IllegalArgumentException("Supplied VIP Address and application name cannot both be null");
        }
        if (vipAddress != null && appName == null) {
            return this.getInstancesByVipAddress(vipAddress, secure);
        }
        if (vipAddress == null && appName != null) {
            Application application = this.getApplication(appName);
            if (application != null) {
                result = application.getInstances();
            }
            return result;
        }
        for (Application app : this.getApplications().getRegisteredApplications()) {
            block1: for (InstanceInfo instance : app.getInstances()) {
                String[] instanceVipAddresses;
                String instanceVipAddress = secure ? instance.getSecureVipAddress() : instance.getVIPAddress();
                if (instanceVipAddress == null) continue;
                for (String vipAddressFromList : instanceVipAddresses = instanceVipAddress.split(",")) {
                    if (!vipAddress.equalsIgnoreCase(vipAddressFromList.trim()) || !appName.equalsIgnoreCase(instance.getAppName())) continue;
                    result.add(instance);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public InstanceInfo getNextServerFromEureka(String virtualHostname, boolean secure) {
        List<InstanceInfo> instanceInfoList = this.getInstancesByVipAddress(virtualHostname, secure);
        if (instanceInfoList == null || instanceInfoList.isEmpty()) {
            throw new RuntimeException("No matches for the virtual host name :" + virtualHostname);
        }
        Applications apps = this.localRegionApps.get();
        int index = (int)(apps.getNextIndex(virtualHostname.toUpperCase(Locale.ROOT), secure).incrementAndGet() % (long)instanceInfoList.size());
        return instanceInfoList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Applications getApplications(String serviceUrl) {
        if (this.shouldUseExperimentalTransportForQuery()) {
            try {
                EurekaHttpResponse<Applications> response;
                EurekaHttpResponse<Applications> eurekaHttpResponse = response = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(new String[0]) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), new String[0]);
                if (response.getStatusCode() == 200) {
                    logger.debug(PREFIX + this.appPathIdentifier + " -  refresh status: " + response.getStatusCode());
                    return response.getEntity();
                }
                logger.error(PREFIX + this.appPathIdentifier + " - was unable to refresh its cache! status = " + response.getStatusCode());
            }
            catch (Throwable th) {
                logger.error(PREFIX + this.appPathIdentifier + " - was unable to refresh its cache! status = " + th.getMessage(), th);
            }
        } else {
            ClientResponse response = null;
            try {
                response = this.makeRemoteCall(Action.Refresh);
                Applications apps = (Applications)response.getEntity(Applications.class);
                logger.debug(PREFIX + this.appPathIdentifier + " -  refresh status: " + response.getStatus());
                Applications applications = apps;
                return applications;
            }
            catch (Throwable th) {
                logger.error(PREFIX + this.appPathIdentifier + " - was unable to refresh its cache! status = " + th.getMessage(), th);
            }
            finally {
                this.closeResponse(response);
            }
        }
        return null;
    }

    private boolean shouldRegister(InstanceInfo myInfo) {
        return this.clientConfig.shouldRegisterWithEureka();
    }

    boolean register() throws Throwable {
        logger.info(PREFIX + this.appPathIdentifier + ": registering service...");
        if (this.shouldUseExperimentalTransportForRegistration()) {
            EurekaHttpResponse<Void> httpResponse;
            try {
                httpResponse = this.eurekaTransport.registrationClient.register(this.instanceInfo);
            }
            catch (Exception e) {
                logger.warn("{} - registration failed {}", new Object[]{PREFIX + this.appPathIdentifier, e.getMessage(), e});
                throw e;
            }
            this.isRegisteredWithDiscovery = true;
            if (logger.isInfoEnabled()) {
                logger.info("{} - registration status: {}", (Object)(PREFIX + this.appPathIdentifier), (Object)httpResponse.getStatusCode());
            }
            return httpResponse.getStatusCode() == 204;
        }
        ClientResponse response = null;
        try {
            response = this.makeRemoteCall(Action.Register);
            this.isRegisteredWithDiscovery = true;
            logger.info("{} - registration status: {}", (Object)(PREFIX + this.appPathIdentifier), response != null ? Integer.valueOf(response.getStatus()) : "not sent");
            boolean e = response != null && response.getStatus() == 204;
            return e;
        }
        catch (Throwable e) {
            logger.warn("{} - registration failed {}", new Object[]{PREFIX + this.appPathIdentifier, e.getMessage(), e});
            throw e;
        }
        finally {
            this.closeResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean renew() {
        if (this.shouldUseExperimentalTransportForRegistration()) {
            try {
                EurekaHttpResponse<InstanceInfo> httpResponse = this.eurekaTransport.registrationClient.sendHeartBeat(this.instanceInfo.getAppName(), this.instanceInfo.getId(), this.instanceInfo, null);
                logger.debug("{} - Heartbeat status: {}", (Object)(PREFIX + this.appPathIdentifier), (Object)httpResponse.getStatusCode());
                if (httpResponse.getStatusCode() == 404) {
                    this.REREGISTER_COUNTER.increment();
                    logger.info("{} - Re-registering apps/{}", (Object)(PREFIX + this.appPathIdentifier), (Object)this.instanceInfo.getAppName());
                    return this.register();
                }
                return httpResponse.getStatusCode() == 200;
            }
            catch (Throwable e) {
                logger.error("{} - was unable to send heartbeat!", (Object)(PREFIX + this.appPathIdentifier), (Object)e);
                return false;
            }
        }
        try (ClientResponse response = null;){
            response = this.makeRemoteCall(Action.Renew);
            logger.debug("{} - Heartbeat status: {}", (Object)(PREFIX + this.appPathIdentifier), response != null ? Integer.valueOf(response.getStatus()) : "not sent");
            if (response == null) {
                boolean e = false;
                return e;
            }
            if (response.getStatus() == 404) {
                this.REREGISTER_COUNTER.increment();
                logger.info("{} - Re-registering apps/{}", (Object)(PREFIX + this.appPathIdentifier), (Object)this.instanceInfo.getAppName());
                boolean e = this.register();
                return e;
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public List<String> getServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromConfig(this.clientConfig, instanceZone, preferSameZone);
    }

    @Override
    @PreDestroy
    public void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            if (this.statusChangeListener != null && this.applicationInfoManager != null) {
                this.applicationInfoManager.unregisterStatusChangeListener(this.statusChangeListener.getId());
            }
            this.cancelScheduledTasks();
            if (this.instanceInfo != null && this.shouldRegister(this.instanceInfo)) {
                this.instanceInfo.setStatus(InstanceInfo.InstanceStatus.DOWN);
                this.unregister();
            }
            if (this.discoveryJerseyClient != null) {
                this.discoveryJerseyClient.destroyResources();
            }
            this.eurekaTransport.shutdown();
            this.heartbeatStalenessMonitor.shutdown();
            this.registryStalenessMonitor.shutdown();
        }
    }

    void unregister() {
        if (this.shouldUseExperimentalTransportForRegistration()) {
            try {
                EurekaHttpResponse<Void> httpResponse = this.eurekaTransport.registrationClient.cancel(this.instanceInfo.getAppName(), this.instanceInfo.getId());
                logger.info(PREFIX + this.appPathIdentifier + " - deregister  status: " + httpResponse.getStatusCode());
            }
            catch (Exception e) {
                logger.error(PREFIX + this.appPathIdentifier + " - de-registration failed" + e.getMessage(), (Throwable)e);
            }
        } else {
            try (ClientResponse response = null;){
                response = this.makeRemoteCall(Action.Cancel);
                logger.info(PREFIX + this.appPathIdentifier + " - deregister  status: " + (response != null ? Integer.valueOf(response.getStatus()) : "not registered"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchRegistry(boolean forceFullRegistryFetch) {
        Stopwatch tracer = this.FETCH_REGISTRY_TIMER.start();
        try {
            Applications applications = this.getApplications();
            if (this.clientConfig.shouldDisableDelta() || !Strings.isNullOrEmpty((String)this.clientConfig.getRegistryRefreshSingleVipAddress()) || forceFullRegistryFetch || applications == null || applications.getRegisteredApplications().size() == 0 || applications.getVersion() == -1L) {
                logger.info("Disable delta property : {}", (Object)this.clientConfig.shouldDisableDelta());
                logger.info("Single vip registry refresh property : {}", (Object)this.clientConfig.getRegistryRefreshSingleVipAddress());
                logger.info("Force full registry fetch : {}", (Object)forceFullRegistryFetch);
                logger.info("Application is null : {}", (Object)(applications == null ? 1 : 0));
                logger.info("Registered Applications size is zero : {}", (Object)(applications.getRegisteredApplications().size() == 0 ? 1 : 0));
                logger.info("Application version is -1: {}", (Object)(applications.getVersion() == -1L ? 1 : 0));
                this.getAndStoreFullRegistry();
            } else {
                this.getAndUpdateDelta(applications);
            }
            applications.setAppsHashCode(applications.getReconcileHashCode());
            this.logTotalInstances();
        }
        catch (Throwable e) {
            logger.error(PREFIX + this.appPathIdentifier + " - was unable to refresh its cache! status = " + e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
        this.onCacheRefreshed();
        this.updateInstanceRemoteStatus();
        return true;
    }

    private synchronized void updateInstanceRemoteStatus() {
        InstanceInfo remoteInstanceInfo;
        Application app;
        InstanceInfo.InstanceStatus currentRemoteInstanceStatus = null;
        if (this.instanceInfo.getAppName() != null && (app = this.getApplication(this.instanceInfo.getAppName())) != null && (remoteInstanceInfo = app.getByInstanceId(this.instanceInfo.getId())) != null) {
            currentRemoteInstanceStatus = remoteInstanceInfo.getStatus();
        }
        if (currentRemoteInstanceStatus == null) {
            currentRemoteInstanceStatus = InstanceInfo.InstanceStatus.UNKNOWN;
        }
        if (this.lastRemoteInstanceStatus != currentRemoteInstanceStatus) {
            this.onRemoteStatusChanged(this.lastRemoteInstanceStatus, currentRemoteInstanceStatus);
            this.lastRemoteInstanceStatus = currentRemoteInstanceStatus;
        }
    }

    @Override
    public InstanceInfo.InstanceStatus getInstanceRemoteStatus() {
        return this.lastRemoteInstanceStatus;
    }

    private String getReconcileHashCode(Applications applications) {
        TreeMap<String, AtomicInteger> instanceCountMap = new TreeMap<String, AtomicInteger>();
        if (this.isFetchingRemoteRegionRegistries()) {
            for (Applications remoteApp : this.remoteRegionVsApps.values()) {
                remoteApp.populateInstanceCountMap(instanceCountMap);
            }
        }
        applications.populateInstanceCountMap(instanceCountMap);
        return Applications.getReconcileHashCode(instanceCountMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndStoreFullRegistry() throws Throwable {
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        logger.info("Getting all instance registry info from the eureka server");
        Applications apps = null;
        if (this.shouldUseExperimentalTransportForQuery()) {
            EurekaHttpResponse<Applications> httpResponse;
            EurekaHttpResponse<Applications> eurekaHttpResponse = httpResponse = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(this.remoteRegionsRef.get()) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), this.remoteRegionsRef.get());
            if (httpResponse.getStatusCode() == Response.Status.OK.getStatusCode()) {
                apps = httpResponse.getEntity();
            }
            logger.info("The response status is {}", (Object)httpResponse.getStatusCode());
        } else {
            ClientResponse response = this.makeRemoteCall(Action.Refresh);
            try {
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    apps = (Applications)response.getEntity(Applications.class);
                }
                logger.info("The response status is {}", (Object)response.getStatus());
            }
            finally {
                this.closeResponse(response);
            }
        }
        if (apps == null) {
            logger.error("The application is null for some reason. Not storing this information");
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.localRegionApps.set(this.filterAndShuffle(apps));
            logger.debug("Got full registry with apps hashcode {}", (Object)apps.getAppsHashCode());
        } else {
            logger.warn("Not updating applications as another thread is updating it already");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndUpdateDelta(Applications applications) throws Throwable {
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        Applications delta = null;
        if (this.shouldUseExperimentalTransportForQuery()) {
            EurekaHttpResponse<Applications> httpResponse = this.eurekaTransport.queryClient.getDelta(this.remoteRegionsRef.get());
            if (httpResponse.getStatusCode() == Response.Status.OK.getStatusCode()) {
                delta = httpResponse.getEntity();
            }
        } else {
            ClientResponse response = this.makeRemoteCall(Action.Refresh_Delta);
            try {
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    delta = (Applications)response.getEntity(Applications.class);
                }
            }
            finally {
                this.closeResponse(response);
            }
        }
        if (delta == null) {
            logger.warn("The server does not allow the delta revision to be applied because it is not safe. Hence got the full registry.");
            this.getAndStoreFullRegistry();
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            logger.debug("Got delta update with apps hashcode {}", (Object)delta.getAppsHashCode());
            String reconcileHashCode = "";
            if (this.fetchRegistryUpdateLock.tryLock()) {
                try {
                    this.updateDelta(delta);
                    reconcileHashCode = this.getReconcileHashCode(applications);
                }
                finally {
                    this.fetchRegistryUpdateLock.unlock();
                }
            } else {
                logger.warn("Cannot acquire update lock, aborting getAndUpdateDelta");
            }
            if (!reconcileHashCode.equals(delta.getAppsHashCode()) || this.clientConfig.shouldLogDeltaDiff()) {
                this.reconcileAndLogDifference(delta, reconcileHashCode);
            }
        } else {
            logger.warn("Not updating application delta as another thread is updating it already");
            logger.debug("Ignoring delta update with apps hashcode {}, as another thread is updating it already", (Object)delta.getAppsHashCode());
        }
    }

    private void logTotalInstances() {
        if (logger.isDebugEnabled()) {
            int totInstances = 0;
            for (Application application : this.getApplications().getRegisteredApplications()) {
                totInstances += application.getInstancesAsIsFromEureka().size();
            }
            logger.debug("The total number of all instances in the client now is {}", (Object)totInstances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileAndLogDifference(Applications delta, String reconcileHashCode) throws Throwable {
        logger.warn("The Reconcile hashcodes do not match, client : {}, server : {}. Getting the full registry", (Object)reconcileHashCode, (Object)delta.getAppsHashCode());
        this.RECONCILE_HASH_CODES_MISMATCH.increment();
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        Applications serverApps = null;
        if (this.shouldUseExperimentalTransportForQuery()) {
            EurekaHttpResponse<Applications> httpResponse = this.clientConfig.getRegistryRefreshSingleVipAddress() == null ? this.eurekaTransport.queryClient.getApplications(new String[0]) : this.eurekaTransport.queryClient.getVip(this.clientConfig.getRegistryRefreshSingleVipAddress(), new String[0]);
            serverApps = httpResponse.getEntity();
        } else {
            ClientResponse response = this.makeRemoteCall(Action.Refresh);
            try {
                serverApps = (Applications)response.getEntity(Applications.class);
            }
            finally {
                this.closeResponse(response);
            }
        }
        if (serverApps == null) {
            logger.warn("Cannot fetch full registry from the server; reconciliation failure");
            return;
        }
        try {
            Map<String, List<String>> reconcileDiffMap = this.getApplications().getReconcileMapDiff(serverApps);
            StringBuilder reconcileBuilder = new StringBuilder("");
            for (Map.Entry<String, List<String>> mapEntry : reconcileDiffMap.entrySet()) {
                reconcileBuilder.append(mapEntry.getKey()).append(": ");
                for (String displayString : mapEntry.getValue()) {
                    reconcileBuilder.append(displayString);
                }
                reconcileBuilder.append('\n');
            }
            String reconcileString = reconcileBuilder.toString();
            logger.warn("The reconcile string is {}", (Object)reconcileString);
        }
        catch (Throwable e) {
            logger.error("Could not calculate reconcile string ", e);
        }
        if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.localRegionApps.set(this.filterAndShuffle(serverApps));
            this.getApplications().setVersion(delta.getVersion());
            logger.warn("The Reconcile hashcodes after complete sync up, client : {}, server : {}.", (Object)this.getApplications().getReconcileHashCode(), (Object)delta.getAppsHashCode());
        } else {
            logger.warn("Not setting the applications map as another thread has advanced the update generation");
        }
    }

    private void updateDelta(Applications delta) {
        int deltaCount = 0;
        for (Application app : delta.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                Application existingApp;
                Applications applications = this.getApplications();
                String instanceRegion = this.instanceRegionChecker.getInstanceRegion(instance);
                if (!this.instanceRegionChecker.isLocalRegion(instanceRegion)) {
                    Applications remoteApps = this.remoteRegionVsApps.get(instanceRegion);
                    if (null == remoteApps) {
                        remoteApps = new Applications();
                        this.remoteRegionVsApps.put(instanceRegion, remoteApps);
                    }
                    applications = remoteApps;
                }
                ++deltaCount;
                if (InstanceInfo.ActionType.ADDED.equals((Object)instance.getActionType())) {
                    existingApp = applications.getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        applications.addApplication(app);
                    }
                    logger.debug("Added instance {} to the existing apps in region {}", (Object)instance.getId(), (Object)instanceRegion);
                    applications.getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (InstanceInfo.ActionType.MODIFIED.equals((Object)instance.getActionType())) {
                    existingApp = applications.getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        applications.addApplication(app);
                    }
                    logger.debug("Modified instance {} to the existing apps ", (Object)instance.getId());
                    applications.getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (!InstanceInfo.ActionType.DELETED.equals((Object)instance.getActionType())) continue;
                existingApp = applications.getRegisteredApplications(instance.getAppName());
                if (existingApp == null) {
                    applications.addApplication(app);
                }
                logger.debug("Deleted instance {} to the existing apps ", (Object)instance.getId());
                applications.getRegisteredApplications(instance.getAppName()).removeInstance(instance);
            }
        }
        logger.debug("The total number of instances fetched by the delta processor : {}", (Object)deltaCount);
        this.getApplications().setVersion(delta.getVersion());
        this.getApplications().shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
        for (Applications applications : this.remoteRegionVsApps.values()) {
            applications.setVersion(delta.getVersion());
            applications.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
        }
    }

    private ClientResponse makeRemoteCall(Action action) throws Throwable {
        ClientResponse response = DiscoveryClient.isQueryAction(action) ? this.makeRemoteCallToRedirectedServer(this.lastQueryRedirect, action) : this.makeRemoteCallToRedirectedServer(this.lastRegisterRedirect, action);
        if (response == null) {
            response = this.makeRemoteCall(action, 0);
        }
        return response;
    }

    private ClientResponse makeRemoteCallToRedirectedServer(AtomicReference<String> lastRedirect, Action action) {
        String lastRedirectUrl = lastRedirect.get();
        if (lastRedirectUrl != null) {
            try {
                ClientResponse clientResponse = this.makeRemoteCall(action, lastRedirectUrl);
                int status = clientResponse.getStatus();
                if (status >= 200 && status < 300) {
                    return clientResponse;
                }
                this.SERVER_RETRY_COUNTER.increment();
                lastRedirect.compareAndSet(lastRedirectUrl, null);
            }
            catch (Throwable ignored) {
                logger.warn("Remote call to last redirect address failed; retrying from configured service URL list");
                this.SERVER_RETRY_COUNTER.increment();
                lastRedirect.compareAndSet(lastRedirectUrl, null);
            }
        }
        return null;
    }

    private static boolean isQueryAction(Action action) {
        return action == Action.Refresh || action == Action.Refresh_Delta;
    }

    private ClientResponse makeRemoteCall(Action action, int serviceUrlIndex) throws Throwable {
        try {
            String serviceUrl = this.eurekaServiceUrls.get().get(serviceUrlIndex);
            return this.makeRemoteCallWithFollowRedirect(action, serviceUrl);
        }
        catch (Throwable t) {
            if (this.eurekaServiceUrls.get().size() > ++serviceUrlIndex) {
                logger.warn("Trying backup: " + this.eurekaServiceUrls.get().get(serviceUrlIndex));
                this.SERVER_RETRY_COUNTER.increment();
                return this.makeRemoteCall(action, serviceUrlIndex);
            }
            this.ALL_SERVER_FAILURE_COUNT.increment();
            logger.error("Can't contact any eureka nodes - possibly a security group issue?", t);
            throw t;
        }
    }

    private ClientResponse makeRemoteCallWithFollowRedirect(Action action, String serviceUrl) throws Throwable {
        URI targetUrl = new URI(serviceUrl);
        for (int followRedirectCount = 0; followRedirectCount < 10; ++followRedirectCount) {
            ClientResponse clientResponse = this.makeRemoteCall(action, targetUrl.toString());
            if (clientResponse.getStatus() != 302) {
                if (followRedirectCount > 0) {
                    if (DiscoveryClient.isQueryAction(action)) {
                        this.lastQueryRedirect.set(targetUrl.toString());
                    } else {
                        this.lastRegisterRedirect.set(targetUrl.toString());
                    }
                }
                return clientResponse;
            }
            targetUrl = DiscoveryClient.getRedirectBaseUri(clientResponse.getLocation());
            if (targetUrl != null) continue;
            throw new IOException("Invalid redirect URL " + clientResponse.getLocation());
        }
        String message = "Follow redirect limit crossed for URI " + serviceUrl;
        logger.warn(message);
        throw new IOException(message);
    }

    private static URI getRedirectBaseUri(URI targetUrl) {
        Matcher pathMatcher = REDIRECT_PATH_REGEX.matcher(targetUrl.getPath());
        if (pathMatcher.matches()) {
            return UriBuilder.fromUri((URI)targetUrl).host(DnsResolver.resolve(targetUrl.getHost())).replacePath(pathMatcher.group(1)).replaceQuery(null).build(new Object[0]);
        }
        logger.warn("Invalid redirect URL {}", (Object)targetUrl);
        return null;
    }

    private ClientResponse makeRemoteCall(Action action, String serviceUrl) throws Throwable {
        String urlPath = null;
        Stopwatch tracer = null;
        ClientResponse response = null;
        logger.debug("Discovery Client talking to the server {}, action {}", (Object)serviceUrl, (Object)action);
        try {
            if (UNKNOWN.equals(this.instanceInfo.getAppName()) && !Action.Refresh.equals((Object)action) && !Action.Refresh_Delta.equals((Object)action)) {
                ClientResponse clientResponse = null;
                return clientResponse;
            }
            WebResource r = this.discoveryApacheClient.resource(serviceUrl);
            if (this.clientConfig.allowRedirects()) {
                r.header(HTTP_X_DISCOVERY_ALLOW_REDIRECT, (Object)"true");
            }
            switch (action) {
                case Renew: {
                    tracer = this.RENEW_TIMER.start();
                    urlPath = "apps/" + this.appPathIdentifier;
                    response = (ClientResponse)r.path(urlPath).queryParam("status", this.instanceInfo.getStatus().toString()).queryParam("lastDirtyTimestamp", this.instanceInfo.getLastDirtyTimestamp().toString()).put(ClientResponse.class);
                    break;
                }
                case Refresh: {
                    tracer = this.REFRESH_TIMER.start();
                    String vipAddress = this.clientConfig.getRegistryRefreshSingleVipAddress();
                    urlPath = vipAddress == null ? "apps/" : "vips/" + vipAddress;
                    String remoteRegionsToFetchStr = this.remoteRegionsToFetch.get();
                    if (!Strings.isNullOrEmpty((String)remoteRegionsToFetchStr)) {
                        urlPath = urlPath + "?regions=" + remoteRegionsToFetchStr;
                    }
                    response = this.getUrl(serviceUrl + urlPath);
                    break;
                }
                case Refresh_Delta: {
                    tracer = this.REFRESH_DELTA_TIMER.start();
                    urlPath = "apps/delta";
                    String remoteRegionsToFetchStr = this.remoteRegionsToFetch.get();
                    if (!Strings.isNullOrEmpty((String)remoteRegionsToFetchStr)) {
                        urlPath = urlPath + "?regions=" + remoteRegionsToFetchStr;
                    }
                    response = this.getUrl(serviceUrl + urlPath);
                    break;
                }
                case Register: {
                    tracer = this.REGISTER_TIMER.start();
                    urlPath = "apps/" + this.instanceInfo.getAppName();
                    response = (ClientResponse)r.path(urlPath).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)this.instanceInfo);
                    break;
                }
                case Cancel: {
                    tracer = this.CANCEL_TIMER.start();
                    urlPath = "apps/" + this.appPathIdentifier;
                    response = (ClientResponse)r.path(urlPath).delete(ClientResponse.class);
                    if (this.isRegisteredWithDiscovery || response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) break;
                    ClientResponse clientResponse = response;
                    return clientResponse;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Finished a call to service url {} and url path {} with status code {}.", (Object[])new String[]{serviceUrl, urlPath, String.valueOf(response.getStatus())});
            }
            if (this.isOk(action, response.getStatus())) {
                ClientResponse clientResponse = response;
                return clientResponse;
            }
            try {
                logger.warn("Action: " + (Object)((Object)action) + "  => returned status of " + response.getStatus() + " from " + serviceUrl + urlPath);
                throw new RuntimeException("Bad status: " + response.getStatus());
            }
            catch (Throwable t) {
                this.closeResponse(response);
                logger.warn("Can't get a response from " + serviceUrl + urlPath, t);
                throw t;
            }
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    private void closeResponse(ClientResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Throwable th) {
                logger.error("Cannot release response resource :", th);
            }
        }
    }

    private void initScheduledTasks() {
        int expBackOffBound;
        if (this.clientConfig.shouldFetchRegistry()) {
            int registryFetchIntervalSeconds = this.clientConfig.getRegistryFetchIntervalSeconds();
            expBackOffBound = this.clientConfig.getCacheRefreshExecutorExponentialBackOffBound();
            this.scheduler.schedule(new TimedSupervisorTask("cacheRefresh", this.scheduler, this.cacheRefreshExecutor, registryFetchIntervalSeconds, TimeUnit.SECONDS, expBackOffBound, new CacheRefreshThread()), (long)registryFetchIntervalSeconds, TimeUnit.SECONDS);
        }
        if (this.shouldRegister(this.instanceInfo)) {
            int renewalIntervalInSecs = this.instanceInfo.getLeaseInfo().getRenewalIntervalInSecs();
            expBackOffBound = this.clientConfig.getHeartbeatExecutorExponentialBackOffBound();
            logger.info("Starting heartbeat executor: renew interval is: " + renewalIntervalInSecs);
            this.scheduler.schedule(new TimedSupervisorTask("heartbeat", this.scheduler, this.heartbeatExecutor, renewalIntervalInSecs, TimeUnit.SECONDS, expBackOffBound, new HeartbeatThread()), (long)renewalIntervalInSecs, TimeUnit.SECONDS);
            this.instanceInfoReplicator = new InstanceInfoReplicator(this, this.instanceInfo, this.clientConfig.getInstanceInfoReplicationIntervalSeconds(), 2);
            this.statusChangeListener = new ApplicationInfoManager.StatusChangeListener(){

                @Override
                public String getId() {
                    return "statusChangeListener";
                }

                @Override
                public void notify(StatusChangeEvent statusChangeEvent) {
                    if (InstanceInfo.InstanceStatus.DOWN == statusChangeEvent.getStatus() || InstanceInfo.InstanceStatus.DOWN == statusChangeEvent.getPreviousStatus()) {
                        logger.warn("Saw local status change event {}", (Object)statusChangeEvent);
                    } else {
                        logger.info("Saw local status change event {}", (Object)statusChangeEvent);
                    }
                    DiscoveryClient.this.instanceInfoReplicator.onDemandUpdate();
                }
            };
            if (this.clientConfig.shouldOnDemandUpdateStatusChange()) {
                this.applicationInfoManager.registerStatusChangeListener(this.statusChangeListener);
            }
            this.instanceInfoReplicator.start(this.clientConfig.getInitialInstanceInfoReplicationIntervalSeconds());
        } else {
            logger.info("Not registering with Eureka server per configuration");
        }
    }

    private void cancelScheduledTasks() {
        if (this.instanceInfoReplicator != null) {
            this.instanceInfoReplicator.stop();
        }
        this.heartbeatExecutor.shutdownNow();
        this.cacheRefreshExecutor.shutdownNow();
        this.scheduler.shutdownNow();
    }

    @Override
    @Deprecated
    public List<String> getServiceUrlsFromDNS(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromDNS(this.clientConfig, instanceZone, preferSameZone, this.urlRandomizer);
    }

    @Override
    @Deprecated
    public List<String> getDiscoveryServiceUrls(String zone) {
        return EndpointUtils.getDiscoveryServiceUrls(this.clientConfig, zone, this.urlRandomizer);
    }

    private List<String> timedGetDiscoveryServiceUrls(String zone) {
        boolean shouldUseDns = this.clientConfig.shouldUseDnsForFetchingServiceUrls();
        if (shouldUseDns) {
            Stopwatch t = this.GET_SERVICE_URLS_DNS_TIMER.start();
            List<String> result = EndpointUtils.getServiceUrlsFromDNS(this.clientConfig, zone, this.clientConfig.shouldPreferSameZoneEureka(), this.urlRandomizer);
            t.stop();
            return result;
        }
        return EndpointUtils.getServiceUrlsFromConfig(this.clientConfig, zone, this.clientConfig.shouldPreferSameZoneEureka());
    }

    @Deprecated
    public static Set<String> getEC2DiscoveryUrlsFromZone(String dnsName, EndpointUtils.DiscoveryUrlType type) {
        return EndpointUtils.getEC2DiscoveryUrlsFromZone(dnsName, type);
    }

    private boolean isOk(Action action, int httpStatus) {
        if (httpStatus >= 200 && httpStatus < 300 || httpStatus == 302) {
            return true;
        }
        if (Action.Renew == action && httpStatus == 404) {
            return true;
        }
        return Action.Refresh_Delta == action && (httpStatus == 403 || httpStatus == 404);
    }

    private InstanceInfo getCoordinatingServer() {
        Application app = this.getApplication(DISCOVERY_APPID);
        List<InstanceInfo> discoveryInstances = null;
        InstanceInfo instanceToReturn = null;
        if (app != null) {
            discoveryInstances = app.getInstances();
        }
        if (discoveryInstances != null) {
            for (InstanceInfo instance : discoveryInstances) {
                if (instance == null || !instance.isCoordinatingDiscoveryServer().booleanValue()) continue;
                instanceToReturn = instance;
                break;
            }
        }
        return instanceToReturn;
    }

    private ClientResponse getUrl(String fullServiceUrl) {
        ClientResponse cr = (ClientResponse)((WebResource.Builder)this.discoveryApacheClient.resource(fullServiceUrl).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Eureka-Accept", (Object)this.clientAccept.name())).get(ClientResponse.class);
        return cr;
    }

    void refreshInstanceInfo() {
        InstanceInfo.InstanceStatus status;
        this.applicationInfoManager.refreshDataCenterInfoIfRequired();
        this.applicationInfoManager.refreshLeaseInfoIfRequired();
        try {
            status = this.getHealthCheckHandler().getStatus(this.instanceInfo.getStatus());
        }
        catch (Exception e) {
            logger.warn("Exception from healthcheckHandler.getStatus, setting status to DOWN", (Throwable)e);
            status = InstanceInfo.InstanceStatus.DOWN;
        }
        if (null != status) {
            this.instanceInfo.setStatus(status);
        }
    }

    @VisibleForTesting
    InstanceInfoReplicator getInstanceInfoReplicator() {
        return this.instanceInfoReplicator;
    }

    @VisibleForTesting
    InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    @Override
    public HealthCheckHandler getHealthCheckHandler() {
        if (this.healthCheckHandler == null) {
            if (null != this.healthCheckHandlerProvider) {
                this.healthCheckHandler = (HealthCheckHandler)this.healthCheckHandlerProvider.get();
            } else if (null != this.healthCheckCallbackProvider) {
                this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge((HealthCheckCallback)this.healthCheckCallbackProvider.get());
            }
            if (null == this.healthCheckHandler) {
                this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge(null);
            }
        }
        return this.healthCheckHandler;
    }

    private void fetchRegistryFromBackup() {
        try {
            BackupRegistry backupRegistryInstance = this.newBackupRegistryInstance();
            if (null == backupRegistryInstance) {
                backupRegistryInstance = (BackupRegistry)this.backupRegistryProvider.get();
            }
            if (null != backupRegistryInstance) {
                Applications apps = null;
                if (this.isFetchingRemoteRegionRegistries()) {
                    String remoteRegionsStr = this.remoteRegionsToFetch.get();
                    if (null != remoteRegionsStr) {
                        apps = backupRegistryInstance.fetchRegistry(remoteRegionsStr.split(","));
                    }
                } else {
                    apps = backupRegistryInstance.fetchRegistry();
                }
                if (apps != null) {
                    Applications applications = this.filterAndShuffle(apps);
                    applications.setAppsHashCode(applications.getReconcileHashCode());
                    this.localRegionApps.set(applications);
                    this.logTotalInstances();
                    logger.info("Fetched registry successfully from the backup");
                }
            } else {
                logger.warn("No backup registry instance defined & unable to find any discovery servers.");
            }
        }
        catch (Throwable e) {
            logger.warn("Cannot fetch applications from apps although backup registry was specified", e);
        }
    }

    @Deprecated
    @Nullable
    protected BackupRegistry newBackupRegistryInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return null;
    }

    private TimerTask getServiceUrlUpdateTask(final String zone) {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    List serviceUrlList = DiscoveryClient.this.timedGetDiscoveryServiceUrls(zone);
                    if (serviceUrlList.isEmpty()) {
                        logger.warn("The service url list is empty");
                        return;
                    }
                    if (!serviceUrlList.equals(DiscoveryClient.this.eurekaServiceUrls.get())) {
                        logger.info("Updating the serviceUrls as they seem to have changed from {} to {} ", (Object)Arrays.toString(((List)DiscoveryClient.this.eurekaServiceUrls.get()).toArray()), (Object)Arrays.toString(serviceUrlList.toArray()));
                        DiscoveryClient.this.eurekaServiceUrls.set(serviceUrlList);
                    }
                }
                catch (Throwable e) {
                    logger.error("Cannot get the eureka service urls :", e);
                }
            }
        };
    }

    private Applications filterAndShuffle(Applications apps) {
        if (apps != null) {
            if (this.isFetchingRemoteRegionRegistries()) {
                ConcurrentHashMap<String, Applications> remoteRegionVsApps = new ConcurrentHashMap<String, Applications>();
                apps.shuffleAndIndexInstances(remoteRegionVsApps, this.clientConfig, this.instanceRegionChecker);
                for (Applications applications : remoteRegionVsApps.values()) {
                    applications.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
                }
                this.remoteRegionVsApps = remoteRegionVsApps;
            } else {
                apps.shuffleInstances(this.clientConfig.shouldFilterOnlyUpInstances());
            }
        }
        return apps;
    }

    private boolean isFetchingRemoteRegionRegistries() {
        return null != this.remoteRegionsToFetch.get();
    }

    private boolean shouldUseExperimentalTransportForQuery() {
        if (this.eurekaTransport.queryClient == null) {
            return false;
        }
        String enabled = this.clientConfig.getExperimental("transport.query.enabled");
        return enabled != null && "true".equalsIgnoreCase(enabled);
    }

    private boolean shouldUseExperimentalTransportForRegistration() {
        if (this.eurekaTransport.registrationClient == null) {
            return false;
        }
        String enabled = this.clientConfig.getExperimental("transport.registration.enabled");
        return enabled != null && "true".equalsIgnoreCase(enabled);
    }

    protected void onRemoteStatusChanged(InstanceInfo.InstanceStatus oldStatus, InstanceInfo.InstanceStatus newStatus) {
        this.fireEvent(new StatusChangeEvent(oldStatus, newStatus));
    }

    protected void onCacheRefreshed() {
        this.fireEvent(new CacheRefreshedEvent());
    }

    protected void fireEvent(DiscoveryEvent event) {
        if (this.eventBus != null) {
            this.eventBus.publish((Object)event);
        }
    }

    @Deprecated
    public static String getZone(InstanceInfo myInfo) {
        String[] availZones = staticClientConfig.getAvailabilityZones(staticClientConfig.getRegion());
        return InstanceInfo.getZone(availZones, myInfo);
    }

    @Deprecated
    public static String getRegion() {
        String region = staticClientConfig.getRegion();
        if (region == null) {
            region = "default";
        }
        region = region.trim().toLowerCase();
        return region;
    }

    @Deprecated
    public static List<String> getEurekaServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        return EndpointUtils.getServiceUrlsFromConfig(staticClientConfig, instanceZone, preferSameZone);
    }

    public long getLastSuccessfulHeartbeatTimePeriod() {
        return this.lastSuccessfulHeartbeatTimestamp < 0L ? this.lastSuccessfulHeartbeatTimestamp : System.currentTimeMillis() - this.lastSuccessfulHeartbeatTimestamp;
    }

    public long getLastSuccessfulRegistryFetchTimePeriod() {
        return this.lastSuccessfulRegistryFetchTimestamp < 0L ? this.lastSuccessfulRegistryFetchTimestamp : System.currentTimeMillis() - this.lastSuccessfulRegistryFetchTimestamp;
    }

    @Monitor(name="eurekaClient.registration.lastSuccessfulHeartbeatTimePeriod", description="How much time has passed from last successful heartbeat", type=DataSourceType.GAUGE)
    private long getLastSuccessfulHeartbeatTimePeriodInternal() {
        long delay = this.getLastSuccessfulHeartbeatTimePeriod();
        this.heartbeatStalenessMonitor.update(this.computeStalenessMonitorDelay(delay));
        return delay;
    }

    @Monitor(name="eurekaClient.registry.lastSuccessfulRegistryFetchTimePeriod", description="How much time has passed from last successful local registry update", type=DataSourceType.GAUGE)
    private long getLastSuccessfulRegistryFetchTimePeriodInternal() {
        long delay = this.getLastSuccessfulRegistryFetchTimePeriod();
        this.registryStalenessMonitor.update(this.computeStalenessMonitorDelay(delay));
        return delay;
    }

    @Monitor(name="eurekaClient.registry.localRegistrySize", description="Count of instances in the local registry", type=DataSourceType.GAUGE)
    public int localRegistrySize() {
        return this.registrySize;
    }

    private long computeStalenessMonitorDelay(long delay) {
        if (delay < 0L) {
            return System.currentTimeMillis() - this.initTimestampMs;
        }
        return delay;
    }

    class CacheRefreshThread
    implements Runnable {
        CacheRefreshThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean success;
                boolean isFetchingRemoteRegionRegistries = DiscoveryClient.this.isFetchingRemoteRegionRegistries();
                boolean remoteRegionsModified = false;
                String latestRemoteRegions = DiscoveryClient.this.clientConfig.fetchRegistryForRemoteRegions();
                if (null != latestRemoteRegions) {
                    String currentRemoteRegions = (String)DiscoveryClient.this.remoteRegionsToFetch.get();
                    if (!latestRemoteRegions.equals(currentRemoteRegions)) {
                        AzToRegionMapper azToRegionMapper = DiscoveryClient.this.instanceRegionChecker.getAzToRegionMapper();
                        synchronized (azToRegionMapper) {
                            if (DiscoveryClient.this.remoteRegionsToFetch.compareAndSet(currentRemoteRegions, latestRemoteRegions)) {
                                String[] remoteRegions = latestRemoteRegions.split(",");
                                DiscoveryClient.this.remoteRegionsRef.set(remoteRegions);
                                DiscoveryClient.this.instanceRegionChecker.getAzToRegionMapper().setRegionsToFetch(remoteRegions);
                                remoteRegionsModified = true;
                            } else {
                                logger.info("Remote regions to fetch modified concurrently, ignoring change from {} to {}", (Object)currentRemoteRegions, (Object)latestRemoteRegions);
                            }
                        }
                    } else {
                        DiscoveryClient.this.instanceRegionChecker.getAzToRegionMapper().refreshMapping();
                    }
                }
                if (success = DiscoveryClient.this.fetchRegistry(remoteRegionsModified)) {
                    DiscoveryClient.this.registrySize = ((Applications)DiscoveryClient.this.localRegionApps.get()).size();
                    DiscoveryClient.this.lastSuccessfulRegistryFetchTimestamp = System.currentTimeMillis();
                }
                if (logger.isDebugEnabled()) {
                    StringBuilder allAppsHashCodes = new StringBuilder();
                    allAppsHashCodes.append("Local region apps hashcode: ");
                    allAppsHashCodes.append(((Applications)DiscoveryClient.this.localRegionApps.get()).getAppsHashCode());
                    allAppsHashCodes.append(", is fetching remote regions? ");
                    allAppsHashCodes.append(isFetchingRemoteRegionRegistries);
                    for (Map.Entry entry : DiscoveryClient.this.remoteRegionVsApps.entrySet()) {
                        allAppsHashCodes.append(", Remote region: ");
                        allAppsHashCodes.append((String)entry.getKey());
                        allAppsHashCodes.append(" , apps hashcode: ");
                        allAppsHashCodes.append(((Applications)entry.getValue()).getAppsHashCode());
                    }
                    logger.debug("Completed cache refresh task for discovery. All Apps hash code is {} ", (Object)allAppsHashCodes.toString());
                }
            }
            catch (Throwable th) {
                logger.error("Cannot fetch registry from server", th);
            }
        }
    }

    private class HeartbeatThread
    implements Runnable {
        private HeartbeatThread() {
        }

        @Override
        public void run() {
            if (DiscoveryClient.this.renew()) {
                DiscoveryClient.this.lastSuccessfulHeartbeatTimestamp = System.currentTimeMillis();
            }
        }
    }

    public static class DiscoveryClientOptionalArgs {
        @Inject(optional=true)
        private EventBus eventBus;
        @Inject(optional=true)
        private Provider<HealthCheckCallback> healthCheckCallbackProvider;
        @Inject(optional=true)
        private Provider<HealthCheckHandler> healthCheckHandlerProvider;
        @Inject(optional=true)
        private Collection<ClientFilter> additionalFilters;
        @Inject(optional=true)
        private EurekaJerseyClient eurekaJerseyClient;

        public void setEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
        }

        public void setHealthCheckCallbackProvider(Provider<HealthCheckCallback> healthCheckCallbackProvider) {
            this.healthCheckCallbackProvider = healthCheckCallbackProvider;
        }

        public void setHealthCheckHandlerProvider(Provider<HealthCheckHandler> healthCheckHandlerProvider) {
            this.healthCheckHandlerProvider = healthCheckHandlerProvider;
        }

        public void setAdditionalFilters(Collection<ClientFilter> additionalFilters) {
            this.additionalFilters = additionalFilters;
        }

        public void setEurekaJerseyClient(EurekaJerseyClient eurekaJerseyClient) {
            this.eurekaJerseyClient = eurekaJerseyClient;
        }
    }

    private static final class EurekaTransport {
        private ClosableResolver bootstrapResolver;
        private TransportClientFactory transportClientFactory;
        private EurekaHttpClient registrationClient;
        private EurekaHttpClientFactory registrationClientFactory;
        private EurekaHttpClient queryClient;
        private EurekaHttpClientFactory queryClientFactory;

        private EurekaTransport() {
        }

        void shutdown() {
            if (this.registrationClientFactory != null) {
                this.registrationClientFactory.shutdown();
            }
            if (this.queryClientFactory != null) {
                this.queryClientFactory.shutdown();
            }
            if (this.registrationClient != null) {
                this.registrationClient.shutdown();
            }
            if (this.queryClient != null) {
                this.queryClient.shutdown();
            }
            if (this.transportClientFactory != null) {
                this.transportClientFactory.shutdown();
            }
            if (this.bootstrapResolver != null) {
                this.bootstrapResolver.shutdown();
            }
        }
    }

    private static enum Action {
        Register,
        Cancel,
        Renew,
        Refresh,
        Refresh_Delta;

    }
}

