/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver.aws;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.aws.AwsEndpoint;
import com.netflix.discovery.shared.resolver.aws.DnsTxtRecordClusterResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigClusterResolver
implements ClusterResolver<AwsEndpoint> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigClusterResolver.class);
    private final EurekaClientConfig clientConfig;
    private final InstanceInfo myInstanceInfo;

    public ConfigClusterResolver(EurekaClientConfig clientConfig, InstanceInfo myInstanceInfo) {
        this.clientConfig = clientConfig;
        this.myInstanceInfo = myInstanceInfo;
    }

    @Override
    public String getRegion() {
        return this.clientConfig.getRegion();
    }

    @Override
    public List<AwsEndpoint> getClusterEndpoints() {
        if (this.clientConfig.shouldUseDnsForFetchingServiceUrls()) {
            return this.getClusterEndpointsFromDns();
        }
        return this.getClusterEndpointsFromConfig();
    }

    private List<AwsEndpoint> getClusterEndpointsFromDns() {
        String region = this.getRegion();
        String discoveryDnsName = "txt." + region + '.' + this.clientConfig.getEurekaServerDNSName();
        int port = Integer.parseInt(this.clientConfig.getEurekaServerPort());
        DnsTxtRecordClusterResolver dnsResolver = new DnsTxtRecordClusterResolver(region, discoveryDnsName, true, port, false, this.clientConfig.getEurekaServerURLContext());
        return dnsResolver.getClusterEndpoints();
    }

    private List<AwsEndpoint> getClusterEndpointsFromConfig() {
        String[] availZones = this.clientConfig.getAvailabilityZones(this.clientConfig.getRegion());
        String myZone = InstanceInfo.getZone(availZones, this.myInstanceInfo);
        Map<String, List<String>> serviceUrls = EndpointUtils.getServiceUrlsMapFromConfig(this.clientConfig, myZone, this.clientConfig.shouldPreferSameZoneEureka());
        ArrayList<AwsEndpoint> endpoints = new ArrayList<AwsEndpoint>();
        for (String zone : serviceUrls.keySet()) {
            for (String url : serviceUrls.get(zone)) {
                try {
                    URI serviceURI = new URI(url);
                    endpoints.add(new AwsEndpoint(serviceURI.getHost(), serviceURI.getPort(), "https".equalsIgnoreCase(serviceURI.getSchemeSpecificPart()), serviceURI.getPath(), this.getRegion(), zone));
                }
                catch (URISyntaxException ignore) {
                    logger.warn("Invalid eureka server URI: ; removing from the server pool", (Object)url);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Config resolved to {}", endpoints);
        }
        return endpoints;
    }
}

