/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Applications;

public interface EurekaHttpClient {
    public HttpResponse<Void> register(InstanceInfo var1);

    public HttpResponse<Void> cancel(String var1, String var2);

    public HttpResponse<InstanceInfo> sendHeartBeat(String var1, String var2, InstanceInfo var3, InstanceInfo.InstanceStatus var4);

    public HttpResponse<Void> statusUpdate(String var1, String var2, InstanceInfo.InstanceStatus var3, InstanceInfo var4);

    public HttpResponse<Void> deleteStatusOverride(String var1, String var2, InstanceInfo var3);

    public HttpResponse<Applications> getApplications();

    public HttpResponse<Applications> getDelta();

    public HttpResponse<InstanceInfo> getInstance(String var1, String var2);

    public void shutdown();

    public static class HttpResponse<T> {
        private final int statusCode;
        private final T entity;

        public HttpResponse(int statusCode) {
            this(statusCode, null);
        }

        public HttpResponse(int statusCode, T entity) {
            this.statusCode = statusCode;
            this.entity = entity;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public T getEntity() {
            return this.entity;
        }

        public static <T> HttpResponse<T> responseWith(int status) {
            return new HttpResponse<Object>(status, null);
        }

        public static <T> HttpResponse<T> responseWith(int status, T entity) {
            return new HttpResponse<T>(status, entity);
        }
    }
}

