/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AbstractInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertiesInstanceConfig
extends AbstractInstanceConfig
implements EurekaInstanceConfig {
    private static final String TEST = "test";
    private static final String ARCHAIUS_DEPLOYMENT_ENVIRONMENT = "archaius.deployment.environment";
    private static final String EUREKA_ENVIRONMENT = "eureka.environment";
    private static final String APP_GROUP_ENV_VAR_NAME = "NETFLIX_APP_GROUP";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesInstanceConfig.class);
    protected String namespace = "eureka.";
    private static final DynamicStringProperty EUREKA_PROPS_FILE = DynamicPropertyFactory.getInstance().getStringProperty("eureka.client.props", "eureka-client");
    private static final DynamicPropertyFactory INSTANCE = DynamicPropertyFactory.getInstance();
    private static final String UNKNOWN_APPLICATION = "unknown";
    private static final String DEFAULT_STATUSPAGE_URLPATH = "/Status";
    private static final String DEFAULT_HOMEPAGE_URLPATH = "/";
    private static final String DEFAULT_HEALTHCHECK_URLPATH = "/healthcheck";
    private String propSecurePort = this.namespace + "securePort";
    private String propSecurePortEnabled = this.propSecurePort + ".enabled";
    private String propNonSecurePort;
    private String idPropName;
    private String propName;
    private String propPortEnabled;
    private String propLeaseRenewalIntervalInSeconds;
    private String propLeaseExpirationDurationInSeconds;
    private String propSecureVirtualHostname;
    private String propVirtualHostname;
    private String propMetadataNamespace;
    private String propASGName;
    private String propAppGroupName;
    private String appGrpNameFromEnv;

    public PropertiesInstanceConfig() {
        this.init(this.namespace);
    }

    public PropertiesInstanceConfig(String namespace, DataCenterInfo info) {
        super(info);
        this.init(namespace);
    }

    public PropertiesInstanceConfig(String namespace) {
        this.init(namespace);
    }

    @Override
    public boolean isInstanceEnabledOnit() {
        return INSTANCE.getBooleanProperty(this.namespace + "traffic.enabled", super.isInstanceEnabledOnit()).get();
    }

    @Override
    public int getNonSecurePort() {
        return INSTANCE.getIntProperty(this.propNonSecurePort, super.getNonSecurePort()).get();
    }

    @Override
    public int getSecurePort() {
        return INSTANCE.getIntProperty(this.propSecurePort, super.getSecurePort()).get();
    }

    @Override
    public boolean isNonSecurePortEnabled() {
        return INSTANCE.getBooleanProperty(this.propPortEnabled, super.isNonSecurePortEnabled()).get();
    }

    @Override
    public boolean getSecurePortEnabled() {
        return INSTANCE.getBooleanProperty(this.propSecurePortEnabled, super.getSecurePortEnabled()).get();
    }

    @Override
    public int getLeaseRenewalIntervalInSeconds() {
        return INSTANCE.getIntProperty(this.propLeaseRenewalIntervalInSeconds, super.getLeaseRenewalIntervalInSeconds()).get();
    }

    @Override
    public int getLeaseExpirationDurationInSeconds() {
        return INSTANCE.getIntProperty(this.propLeaseExpirationDurationInSeconds, super.getLeaseExpirationDurationInSeconds()).get();
    }

    @Override
    public String getVirtualHostName() {
        if (this.isNonSecurePortEnabled()) {
            return INSTANCE.getStringProperty(this.propVirtualHostname, super.getVirtualHostName()).get();
        }
        return null;
    }

    @Override
    public String getSecureVirtualHostName() {
        if (this.getSecurePortEnabled()) {
            return INSTANCE.getStringProperty(this.propSecureVirtualHostname, super.getSecureVirtualHostName()).get();
        }
        return null;
    }

    @Override
    public String getASGName() {
        return INSTANCE.getStringProperty(this.propASGName, super.getASGName()).get();
    }

    @Override
    public Map<String, String> getMetadataMap() {
        LinkedHashMap<String, String> metadataMap = new LinkedHashMap<String, String>();
        Configuration config = (Configuration)INSTANCE.getBackingConfigurationSource();
        String subsetPrefix = this.propMetadataNamespace.charAt(this.propMetadataNamespace.length() - 1) == '.' ? this.propMetadataNamespace.substring(0, this.propMetadataNamespace.length() - 1) : this.propMetadataNamespace;
        Iterator iter = config.subset(subsetPrefix).getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = config.getString(subsetPrefix + "." + key);
            metadataMap.put(key, value);
        }
        return metadataMap;
    }

    @Override
    public String getInstanceId() {
        String result = INSTANCE.getStringProperty(this.idPropName, null).get();
        return result == null ? null : result.trim();
    }

    @Override
    public String getAppname() {
        return INSTANCE.getStringProperty(this.propName, UNKNOWN_APPLICATION).get().trim();
    }

    @Override
    public String getAppGroupName() {
        return INSTANCE.getStringProperty(this.propAppGroupName, this.appGrpNameFromEnv).get().trim();
    }

    @Override
    public String getIpAddress() {
        return super.getIpAddress();
    }

    @Override
    public String getStatusPageUrlPath() {
        return INSTANCE.getStringProperty(this.namespace + "statusPageUrlPath", DEFAULT_STATUSPAGE_URLPATH).get();
    }

    @Override
    public String getStatusPageUrl() {
        return INSTANCE.getStringProperty(this.namespace + "statusPageUrl", null).get();
    }

    @Override
    public String getHomePageUrlPath() {
        return INSTANCE.getStringProperty(this.namespace + "homePageUrlPath", DEFAULT_HOMEPAGE_URLPATH).get();
    }

    @Override
    public String getHomePageUrl() {
        return INSTANCE.getStringProperty(this.namespace + "homePageUrl", null).get();
    }

    @Override
    public String getHealthCheckUrlPath() {
        return INSTANCE.getStringProperty(this.namespace + "healthCheckUrlPath", DEFAULT_HEALTHCHECK_URLPATH).get();
    }

    @Override
    public String getHealthCheckUrl() {
        return INSTANCE.getStringProperty(this.namespace + "healthCheckUrl", null).get();
    }

    @Override
    public String getSecureHealthCheckUrl() {
        return INSTANCE.getStringProperty(this.namespace + "secureHealthCheckUrl", null).get();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    private void init(String namespace) {
        this.namespace = namespace;
        this.propSecurePort = namespace + "securePort";
        this.propSecurePortEnabled = this.propSecurePort + ".enabled";
        this.propNonSecurePort = namespace + "port";
        this.idPropName = namespace + "instanceId";
        this.propName = namespace + "name";
        this.propPortEnabled = this.propNonSecurePort + ".enabled";
        this.propLeaseRenewalIntervalInSeconds = namespace + "lease.renewalInterval";
        this.propLeaseExpirationDurationInSeconds = namespace + "lease.duration";
        this.propSecureVirtualHostname = namespace + "secureVipAddress";
        this.propVirtualHostname = namespace + "vipAddress";
        this.propMetadataNamespace = namespace + "metadata.";
        this.propASGName = namespace + "asgName";
        this.propAppGroupName = namespace + "appGroup";
        this.appGrpNameFromEnv = ConfigurationManager.getConfigInstance().getString(APP_GROUP_ENV_VAR_NAME, UNKNOWN_APPLICATION);
        String env = ConfigurationManager.getConfigInstance().getString(EUREKA_ENVIRONMENT, TEST);
        ConfigurationManager.getConfigInstance().setProperty(ARCHAIUS_DEPLOYMENT_ENVIRONMENT, (Object)env);
        String eurekaPropsFile = EUREKA_PROPS_FILE.get();
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)eurekaPropsFile);
        }
        catch (IOException e) {
            logger.warn("Cannot find the properties specified : {}. This may be okay if there are other environment specific properties or the configuration is installed with a different mechanism.", (Object)eurekaPropsFile);
        }
    }
}

