/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

abstract class CustomizableBeanDeserializer
extends BeanDeserializer {
    protected CustomizableBeanDeserializer(BeanDeserializerBase src) {
        super(src);
    }

    protected Object _deserializeUsingPropertyBased(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Object bean;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(jp, ctxt, this._objectIdReader);
        TokenBuffer unknown = null;
        JsonToken t = jp.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            block22: {
                boolean isComplete;
                String propName;
                block21: {
                    block23: {
                        propName = jp.getCurrentName();
                        jp.nextToken();
                        isComplete = false;
                        if (!this.isCustomField(propName)) break block23;
                        isComplete = this.handleCustomField(creator, buffer, propName, jp, ctxt);
                        if (isComplete) break block21;
                        break block22;
                    }
                    SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                    if (creatorProp != null) {
                        try {
                            Object value = creatorProp.deserialize(jp, ctxt);
                            isComplete = buffer.assignParameter(creatorProp.getCreatorIndex(), value);
                            if (isComplete) break block21;
                            break block22;
                        }
                        catch (UnrecognizedPropertyException e) {
                            // empty catch block
                        }
                    }
                }
                if (isComplete) {
                    Object bean2;
                    jp.nextToken();
                    try {
                        bean2 = creator.build(ctxt, buffer);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                        bean2 = null;
                    }
                    if (bean2.getClass() != this._beanType.getRawClass()) {
                        return this.handlePolymorphic(jp, ctxt, bean2, unknown);
                    }
                    if (unknown != null) {
                        bean2 = this.handleUnknownProperties(ctxt, bean2, unknown);
                    }
                    return this.deserialize(jp, ctxt, bean2);
                }
                if (!buffer.readIdProperty(propName)) {
                    SettableBeanProperty prop = this._beanProperties.find(propName);
                    if (prop != null) {
                        buffer.bufferProperty(prop, prop.deserialize(jp, ctxt));
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                        this.handleIgnoredProperty(jp, ctxt, this.handledType(), propName);
                    } else if (this._anySetter != null) {
                        buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(jp, ctxt));
                    } else {
                        if (unknown == null) {
                            unknown = new TokenBuffer(jp);
                        }
                        unknown.writeFieldName(propName);
                        unknown.copyCurrentStructure(jp);
                    }
                }
            }
            t = jp.nextToken();
        }
        try {
            bean = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            this.wrapInstantiationProblem(e, ctxt);
            bean = null;
        }
        if (unknown != null) {
            if (bean.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, bean, unknown);
            }
            return this.handleUnknownProperties(ctxt, bean, unknown);
        }
        return bean;
    }

    protected abstract boolean isCustomField(String var1);

    protected abstract boolean handleCustomField(PropertyBasedCreator var1, PropertyValueBuffer var2, String var3, JsonParser var4, DeserializationContext var5) throws IOException;
}

