/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.EurekaHttpClient;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JerseyEurekaHttpClient
implements EurekaHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(JerseyEurekaHttpClient.class);
    protected final String serviceUrl;

    protected JerseyEurekaHttpClient(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    protected abstract Client getJerseyClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<Void> register(InstanceInfo info) {
        EurekaHttpClient.HttpResponse<Void> httpResponse;
        String urlPath = "apps/" + info.getAppName();
        ClientResponse response = null;
        try {
            WebResource.Builder resourceBuilder = this.getJerseyClient().resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(resourceBuilder);
            response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resourceBuilder.header("Accept-Encoding", (Object)"gzip")).type(MediaType.APPLICATION_JSON_TYPE)).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)info);
            httpResponse = EurekaHttpClient.HttpResponse.responseWith(response.getStatus());
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[register] Jersey HTTP POST {} with instance {}; statusCode={}", new Object[]{urlPath, info.getId(), response == null ? "N/A" : Integer.valueOf(response.getStatus())});
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[register] Jersey HTTP POST {} with instance {}; statusCode={}", new Object[]{urlPath, info.getId(), response == null ? "N/A" : Integer.valueOf(response.getStatus())});
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<Void> cancel(String appName, String id) {
        EurekaHttpClient.HttpResponse<Void> httpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        ClientResponse response = null;
        try {
            WebResource.Builder resourceBuilder = this.getJerseyClient().resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(resourceBuilder);
            response = (ClientResponse)resourceBuilder.delete(ClientResponse.class);
            httpResponse = EurekaHttpClient.HttpResponse.responseWith(response.getStatus());
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[cancel] Jersey HTTP DELETE {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[cancel] Jersey HTTP DELETE {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        EurekaHttpClient.HttpResponse<InstanceInfo> httpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        Object response = null;
        try {
            WebResource webResource = this.getJerseyClient().resource(this.serviceUrl).path(urlPath).queryParam("status", info.getStatus().toString()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString());
            if (overriddenStatus != null) {
                webResource = webResource.queryParam("overriddenstatus", overriddenStatus.name());
            }
            WebResource.Builder requestBuilder = webResource.getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            httpResponse = EurekaHttpClient.HttpResponse.responseWith(response.getStatus());
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[heartbeat] Jersey HTTP PUT {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[heartbeat] Jersey HTTP PUT {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        EurekaHttpClient.HttpResponse<Void> httpResponse;
        String urlPath = "apps/" + appName + "/" + id + "/status";
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.getJerseyClient().resource(this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString()).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)requestBuilder.put(ClientResponse.class);
            httpResponse = EurekaHttpClient.HttpResponse.responseWith(response.getStatus());
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[statusUpdate] Jersey HTTP PUT {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[statusUpdate] Jersey HTTP PUT {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        EurekaHttpClient.HttpResponse<Void> httpResponse;
        String urlPath = "apps/" + appName + '/' + id + "/status";
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.getJerseyClient().resource(this.serviceUrl).path(urlPath).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString()).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)requestBuilder.delete(ClientResponse.class);
            httpResponse = EurekaHttpClient.HttpResponse.responseWith(response.getStatus());
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[statusOverrideDelete] Jersey HTTP DELETE {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[statusOverrideDelete] Jersey HTTP DELETE {}; statusCode={}", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<Applications> getApplications() {
        EurekaHttpClient.HttpResponse<Object> httpResponse;
        String urlPath = "apps/";
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.getJerseyClient().resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)((WebResource.Builder)requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).get(ClientResponse.class);
            Applications applications = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                applications = (Applications)response.getEntity(Applications.class);
            }
            httpResponse = EurekaHttpClient.HttpResponse.responseWith(response.getStatus(), applications);
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[getApplications] Jersey HTTP GET {}; statusCode=", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[getApplications] Jersey HTTP GET {}; statusCode=", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<Applications> getDelta() {
        EurekaHttpClient.HttpResponse<Object> httpResponse;
        String urlPath = "apps/delta";
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.getJerseyClient().resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)((WebResource.Builder)requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).get(ClientResponse.class);
            Applications applications = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                applications = (Applications)response.getEntity(Applications.class);
            }
            httpResponse = EurekaHttpClient.HttpResponse.responseWith(response.getStatus(), applications);
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[getDelta] Jersey HTTP GET {}; statusCode=", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[getDelta] Jersey HTTP GET {}; statusCode=", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EurekaHttpClient.HttpResponse<InstanceInfo> getInstance(String appName, String id) {
        EurekaHttpClient.HttpResponse<Object> httpResponse;
        String urlPath = "apps/" + appName + '/' + id;
        ClientResponse response = null;
        try {
            WebResource.Builder requestBuilder = this.getJerseyClient().resource(this.serviceUrl).path(urlPath).getRequestBuilder();
            this.addExtraHeaders(requestBuilder);
            response = (ClientResponse)((WebResource.Builder)requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).get(ClientResponse.class);
            InstanceInfo infoFromPeer = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                infoFromPeer = (InstanceInfo)response.getEntity(InstanceInfo.class);
            }
            httpResponse = EurekaHttpClient.HttpResponse.responseWith(response.getStatus(), infoFromPeer);
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("[getInstance] Jersey HTTP GET {}; statusCode=", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
            }
            if (response != null) {
                response.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[getInstance] Jersey HTTP GET {}; statusCode=", (Object)urlPath, response == null ? "N/A" : Integer.valueOf(response.getStatus()));
        }
        if (response != null) {
            response.close();
        }
        return httpResponse;
    }

    @Override
    public void shutdown() {
        this.getJerseyClient().destroy();
    }

    protected void addExtraHeaders(WebResource.Builder webResource) {
    }
}

