/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.MonitoredConnectionManager;
import com.netflix.discovery.util.DiscoveryBuildInfo;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaJerseyClient {
    private static final Logger s_logger = LoggerFactory.getLogger(EurekaJerseyClient.class);
    private static final int HTTP_CONNECTION_CLEANER_INTERVAL_MS = 30000;
    private static final String PROTOCOL = "https";
    private static final String PROTOCOL_SCHEME = "SSL";
    private static final int HTTPS_PORT = 443;
    private static final String KEYSTORE_TYPE = "JKS";
    private final ApacheHttpClient4 apacheHttpClient;
    ClientConfig jerseyClientConfig;
    private final ScheduledExecutorService eurekaConnCleaner = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Eureka-JerseyClient-Conn-Cleaner" + this.threadNumber.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    });

    public EurekaJerseyClient(int connectionTimeout, int readTimeout, int connectionIdleTimeout, ClientConfig clientConfig) {
        try {
            this.jerseyClientConfig = clientConfig;
            this.jerseyClientConfig.getClasses().add(DiscoveryJerseyProvider.class);
            this.apacheHttpClient = ApacheHttpClient4.create((ClientConfig)this.jerseyClientConfig);
            HttpParams params = this.apacheHttpClient.getClientHandler().getHttpClient().getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
            this.eurekaConnCleaner.scheduleWithFixedDelay(new ConnectionCleanerTask(connectionIdleTimeout), 30000L, 30000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create Jersey client", e);
        }
    }

    public ApacheHttpClient4 getClient() {
        return this.apacheHttpClient;
    }

    public void destroyResources() {
        if (this.eurekaConnCleaner != null) {
            this.eurekaConnCleaner.shutdown();
        }
        if (this.apacheHttpClient != null) {
            this.apacheHttpClient.destroy();
        }
    }

    private class ConnectionCleanerTask
    implements Runnable {
        private final int connectionIdleTimeout;
        private final BasicTimer executionTimeStats;
        private final Counter cleanupFailed;

        private ConnectionCleanerTask(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            MonitorConfig.Builder monitorConfigBuilder = MonitorConfig.builder((String)"Eureka-Connection-Cleaner-Time");
            this.executionTimeStats = new BasicTimer(monitorConfigBuilder.build());
            this.cleanupFailed = new BasicCounter(MonitorConfig.builder((String)"Eureka-Connection-Cleaner-Failure").build());
            try {
                Monitors.registerObject((Object)this);
            }
            catch (Exception e) {
                s_logger.error("Unable to register with servo.", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Stopwatch start = this.executionTimeStats.start();
            try {
                EurekaJerseyClient.this.apacheHttpClient.getClientHandler().getHttpClient().getConnectionManager().closeIdleConnections((long)this.connectionIdleTimeout, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                s_logger.error("Cannot clean connections", e);
                this.cleanupFailed.increment();
            }
            finally {
                if (null != start) {
                    start.stop();
                }
            }
        }
    }

    public static class EurekaJerseyClientBuilder {
        private boolean systemSSL;
        private String clientName;
        private int maxConnectionsPerHost;
        private int maxTotalConnections;
        private String trustStoreFileName;
        private String trustStorePassword;
        private String userAgent;
        private String proxyUserName;
        private String proxyPassword;
        private String proxyHost;
        private String proxyPort;
        private int connectionTimeout;
        private int readTimeout;
        private int connectionIdleTimeout;
        private String encoderName;
        private String decoderName;
        private String clientDataAccept;

        public EurekaJerseyClientBuilder withClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public EurekaJerseyClientBuilder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public EurekaJerseyClientBuilder withConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public EurekaJerseyClientBuilder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public EurekaJerseyClientBuilder withConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public EurekaJerseyClientBuilder withMaxConnectionsPerHost(int maxConnectionsPerHost) {
            this.maxConnectionsPerHost = maxConnectionsPerHost;
            return this;
        }

        public EurekaJerseyClientBuilder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public EurekaJerseyClientBuilder withProxy(String proxyHost, String proxyPort, String user, String password) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUserName = user;
            this.proxyPassword = password;
            return this;
        }

        public EurekaJerseyClientBuilder withSystemSSLConfiguration() {
            this.systemSSL = true;
            return this;
        }

        public EurekaJerseyClientBuilder withTrustStoreFile(String trustStoreFileName, String trustStorePassword) {
            this.trustStoreFileName = trustStoreFileName;
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public EurekaJerseyClientBuilder withEncoder(String encoderName) {
            this.encoderName = encoderName;
            return this;
        }

        public EurekaJerseyClientBuilder withDecoder(String decoderName, String clientDataAccept) {
            this.decoderName = decoderName;
            this.clientDataAccept = clientDataAccept;
            return this;
        }

        public EurekaJerseyClient build() {
            MyDefaultApacheHttpClient4Config config = new MyDefaultApacheHttpClient4Config();
            try {
                return new EurekaJerseyClient(this.connectionTimeout, this.readTimeout, this.connectionIdleTimeout, (ClientConfig)config);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot create Jersey client ", e);
            }
        }

        class MyDefaultApacheHttpClient4Config
        extends DefaultApacheHttpClient4Config {
            MyDefaultApacheHttpClient4Config() {
                MonitoredConnectionManager cm = EurekaJerseyClientBuilder.this.systemSSL ? this.createSystemSslCM() : (EurekaJerseyClientBuilder.this.trustStoreFileName != null ? this.createCustomSslCM() : new MonitoredConnectionManager(EurekaJerseyClientBuilder.this.clientName));
                if (EurekaJerseyClientBuilder.this.proxyHost != null) {
                    this.addProxyConfiguration(cm);
                }
                DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider(CodecWrappers.getEncoder(EurekaJerseyClientBuilder.this.encoderName), CodecWrappers.resolveDecoder(EurekaJerseyClientBuilder.this.decoderName, EurekaJerseyClientBuilder.this.clientDataAccept));
                this.getSingletons().add(discoveryJerseyProvider);
                cm.setDefaultMaxPerRoute(EurekaJerseyClientBuilder.this.maxConnectionsPerHost);
                cm.setMaxTotal(EurekaJerseyClientBuilder.this.maxTotalConnections);
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
                String fullUserAgentName = (EurekaJerseyClientBuilder.this.userAgent == null ? EurekaJerseyClientBuilder.this.clientName : EurekaJerseyClientBuilder.this.userAgent) + "/v" + DiscoveryBuildInfo.buildVersion();
                this.getProperties().put("http.useragent", fullUserAgentName);
                this.getProperties().put("com.sun.jersey.client.property.followRedirects", Boolean.FALSE);
                this.getProperties().put("http.protocol.handle-redirects", Boolean.FALSE);
            }

            private void addProxyConfiguration(MonitoredConnectionManager cm) {
                if (EurekaJerseyClientBuilder.this.proxyUserName != null && EurekaJerseyClientBuilder.this.proxyPassword != null) {
                    this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", EurekaJerseyClientBuilder.this.proxyUserName);
                    this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", EurekaJerseyClientBuilder.this.proxyPassword);
                } else {
                    this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", "guest");
                    this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", "guest");
                }
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + EurekaJerseyClientBuilder.this.proxyHost + ":" + EurekaJerseyClientBuilder.this.proxyPort);
            }

            private MonitoredConnectionManager createSystemSslCM() {
                SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSystemSocketFactory();
                SchemeRegistry sslSchemeRegistry = new SchemeRegistry();
                sslSchemeRegistry.register(new Scheme(EurekaJerseyClient.PROTOCOL, 443, (SchemeSocketFactory)sslSocketFactory));
                MonitoredConnectionManager cm = new MonitoredConnectionManager(EurekaJerseyClientBuilder.this.clientName, sslSchemeRegistry);
                return cm;
            }

            private MonitoredConnectionManager createCustomSslCM() {
                FileInputStream fin = null;
                try {
                    SSLContext sslContext = SSLContext.getInstance(EurekaJerseyClient.PROTOCOL_SCHEME);
                    KeyStore sslKeyStore = KeyStore.getInstance(EurekaJerseyClient.KEYSTORE_TYPE);
                    fin = new FileInputStream(EurekaJerseyClientBuilder.this.trustStoreFileName);
                    sslKeyStore.load(fin, EurekaJerseyClientBuilder.this.trustStorePassword.toCharArray());
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    factory.init(sslKeyStore);
                    TrustManager[] trustManagers = factory.getTrustManagers();
                    sslContext.init(null, trustManagers, null);
                    SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext);
                    sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    SchemeRegistry sslSchemeRegistry = new SchemeRegistry();
                    sslSchemeRegistry.register(new Scheme(EurekaJerseyClient.PROTOCOL, 443, (SchemeSocketFactory)sslSocketFactory));
                    MonitoredConnectionManager monitoredConnectionManager = new MonitoredConnectionManager(EurekaJerseyClientBuilder.this.clientName, sslSchemeRegistry);
                    return monitoredConnectionManager;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("SSL configuration issue", ex);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
        }
    }
}

