/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.EurekaClientIdentity;
import com.netflix.appinfo.HealthCheckCallback;
import com.netflix.appinfo.HealthCheckCallbackToHandlerBridge;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractAzToRegionMapper;
import com.netflix.discovery.AzToRegionMapper;
import com.netflix.discovery.BackupRegistry;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.DNSBasedAzToRegionMapper;
import com.netflix.discovery.DiscoveryEvent;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.DnsResolver;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.InstanceInfoReplicator;
import com.netflix.discovery.InstanceRegionChecker;
import com.netflix.discovery.NotImplementedRegistryImpl;
import com.netflix.discovery.PropertyBasedAzToRegionMapper;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.EurekaJerseyClient;
import com.netflix.discovery.util.ThresholdLevelsMetric;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiscoveryClient
implements EurekaClient {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryClient.class);
    public static final int MAX_FOLLOWED_REDIRECTS = 10;
    public static final String HTTP_X_DISCOVERY_ALLOW_REDIRECT = "X-Discovery-AllowRedirect";
    private static final String VALUE_DELIMITER = ",";
    private static final String COMMA_STRING = ",";
    private static final String DISCOVERY_APPID = "DISCOVERY";
    private static final String UNKNOWN = "UNKNOWN";
    private static final Pattern REDIRECT_PATH_REGEX = Pattern.compile("(.*/v2/)apps(/.*)?$");
    protected static EurekaClientConfig clientConfig;
    private static final String PREFIX = "DiscoveryClient_";
    private final Timer GET_SERVICE_URLS_DNS_TIMER = Monitors.newTimer((String)"DiscoveryClient_GetServiceUrlsFromDNS");
    private final Timer REGISTER_TIMER = Monitors.newTimer((String)"DiscoveryClient_Register");
    private final Timer REFRESH_TIMER = Monitors.newTimer((String)"DiscoveryClient_Refresh");
    private final Timer REFRESH_DELTA_TIMER = Monitors.newTimer((String)"DiscoveryClient_RefreshDelta");
    private final Counter RECONCILE_HASH_CODES_MISMATCH = Monitors.newCounter((String)"DiscoveryClient_ReconcileHashCodeMismatch");
    private final Timer RENEW_TIMER = Monitors.newTimer((String)"DiscoveryClient_Renew");
    private final Timer CANCEL_TIMER = Monitors.newTimer((String)"DiscoveryClient_Cancel");
    private final Timer FETCH_REGISTRY_TIMER = Monitors.newTimer((String)"DiscoveryClient_FetchRegistry");
    private final Counter SERVER_RETRY_COUNTER = Monitors.newCounter((String)"DiscoveryClient_Retry");
    private final Counter ALL_SERVER_FAILURE_COUNT = Monitors.newCounter((String)"DiscoveryClient_Failed");
    private final Counter REREGISTER_COUNTER = Monitors.newCounter((String)"DiscoveryClient_Reregister");
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor heartbeatExecutor;
    private final ThreadPoolExecutor cacheRefreshExecutor;
    private final Provider<HealthCheckHandler> healthCheckHandlerProvider;
    private final Provider<HealthCheckCallback> healthCheckCallbackProvider;
    private final AtomicReference<List<String>> eurekaServiceUrls = new AtomicReference();
    private final AtomicReference<Applications> localRegionApps = new AtomicReference();
    private final Lock fetchRegistryUpdateLock = new ReentrantLock();
    private final AtomicLong fetchRegistryGeneration;
    private final ApplicationInfoManager applicationInfoManager;
    private final InstanceInfo instanceInfo;
    private final EurekaAccept clientAccept;
    private EurekaJerseyClient discoveryJerseyClient;
    private final AtomicReference<String> remoteRegionsToFetch;
    private final InstanceRegionChecker instanceRegionChecker;
    private final AtomicReference<String> lastQueryRedirect = new AtomicReference();
    private final AtomicReference<String> lastRegisterRedirect = new AtomicReference();
    private final ApacheHttpClient4 discoveryApacheClient;
    private final EventBus eventBus;
    private final Provider<BackupRegistry> backupRegistryProvider;
    private volatile HealthCheckHandler healthCheckHandler;
    private volatile Map<String, Applications> remoteRegionVsApps = new ConcurrentHashMap<String, Applications>();
    private volatile InstanceInfo.InstanceStatus lastRemoteInstanceStatus = InstanceInfo.InstanceStatus.UNKNOWN;
    private String appPathIdentifier;
    private boolean isRegisteredWithDiscovery = false;
    private ApplicationInfoManager.StatusChangeListener statusChangeListener;
    private InstanceInfoReplicator instanceInfoReplicator;
    private volatile long lastSuccessfulRegistryFetchTimestamp = -1L;
    private volatile long lastSuccessfulHeartbeatTimestamp = -1L;
    private final ThresholdLevelsMetric heartbeatStalenessMonitor;
    private final ThresholdLevelsMetric registryStalenessMonitor;

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config) {
        this(myInfo, config, null);
    }

    @Deprecated
    public DiscoveryClient(InstanceInfo myInfo, EurekaClientConfig config, DiscoveryClientOptionalArgs args) {
        this(ApplicationInfoManager.getInstance(), config, args);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config) {
        this(applicationInfoManager, config, null);
    }

    public DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, DiscoveryClientOptionalArgs args) {
        this(applicationInfoManager, config, args, new Provider<BackupRegistry>(){
            private volatile BackupRegistry backupRegistryInstance;

            public synchronized BackupRegistry get() {
                if (this.backupRegistryInstance == null) {
                    String backupRegistryClassName = clientConfig.getBackupRegistryImpl();
                    if (null != backupRegistryClassName) {
                        try {
                            this.backupRegistryInstance = (BackupRegistry)Class.forName(backupRegistryClassName).newInstance();
                        }
                        catch (InstantiationException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("Error instantiating BackupRegistry.", (Throwable)e);
                        }
                    }
                    logger.warn("Using default backup registry implementation which does not do anything.");
                    this.backupRegistryInstance = new NotImplementedRegistryImpl();
                }
                return this.backupRegistryInstance;
            }
        });
    }

    @Inject
    DiscoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, DiscoveryClientOptionalArgs args, Provider<BackupRegistry> backupRegistryProvider) {
        if (args != null) {
            this.healthCheckHandlerProvider = args.healthCheckHandlerProvider;
            this.healthCheckCallbackProvider = args.healthCheckCallbackProvider;
            this.eventBus = args.eventBus;
        } else {
            this.healthCheckCallbackProvider = null;
            this.healthCheckHandlerProvider = null;
            this.eventBus = null;
        }
        this.applicationInfoManager = applicationInfoManager;
        InstanceInfo myInfo = applicationInfoManager.getInfo();
        this.backupRegistryProvider = backupRegistryProvider;
        try {
            this.scheduler = Executors.newScheduledThreadPool(3, new ThreadFactoryBuilder().setNameFormat("DiscoveryClient-%d").setDaemon(true).build());
            clientConfig = config;
            String zone = DiscoveryClient.getZone(myInfo);
            this.eurekaServiceUrls.set(this.getDiscoveryServiceUrls(zone));
            this.scheduler.scheduleWithFixedDelay(this.getServiceUrlUpdateTask(zone), clientConfig.getEurekaServiceUrlPollIntervalSeconds(), clientConfig.getEurekaServiceUrlPollIntervalSeconds(), TimeUnit.SECONDS);
            this.localRegionApps.set(new Applications());
            this.heartbeatExecutor = new ThreadPoolExecutor(1, clientConfig.getHeartbeatExecutorThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.cacheRefreshExecutor = new ThreadPoolExecutor(1, clientConfig.getCacheRefreshExecutorThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.fetchRegistryGeneration = new AtomicLong(0L);
            this.instanceInfo = myInfo;
            if (myInfo != null) {
                this.appPathIdentifier = this.instanceInfo.getAppName() + "/" + this.instanceInfo.getId();
            } else {
                logger.warn("Setting instanceInfo to a passed in null value");
            }
            EurekaJerseyClient.EurekaJerseyClientBuilder clientBuilder = new EurekaJerseyClient.EurekaJerseyClientBuilder().withUserAgent("Java EurekaClient").withConnectionTimeout(clientConfig.getEurekaServerConnectTimeoutSeconds() * 1000).withReadTimeout(clientConfig.getEurekaServerReadTimeoutSeconds() * 1000).withMaxConnectionsPerHost(clientConfig.getEurekaServerTotalConnectionsPerHost()).withMaxTotalConnections(clientConfig.getEurekaServerTotalConnections()).withConnectionIdleTimeout(clientConfig.getEurekaConnectionIdleTimeoutSeconds());
            DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider(CodecWrappers.getEncoder(clientConfig.getEncoderName()), CodecWrappers.resolveDecoder(clientConfig.getDecoderName(), clientConfig.getClientDataAccept()));
            this.clientAccept = EurekaAccept.fromString(clientConfig.getClientDataAccept());
            if (this.eurekaServiceUrls.get().get(0).startsWith("https://") && "true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                clientBuilder.withClientName("DiscoveryClient-HTTPClient-System").withSystemSSLConfiguration();
            } else if (clientConfig.getProxyHost() != null && clientConfig.getProxyPort() != null) {
                clientBuilder.withClientName("Proxy-DiscoveryClient-HTTPClient").withProxy(clientConfig.getProxyHost(), clientConfig.getProxyPort(), clientConfig.getProxyUserName(), clientConfig.getProxyPassword());
            } else {
                clientBuilder.withClientName("DiscoveryClient-HTTPClient");
            }
            this.discoveryJerseyClient = clientBuilder.build();
            this.discoveryApacheClient = this.discoveryJerseyClient.getClient();
            this.remoteRegionsToFetch = new AtomicReference<String>(clientConfig.fetchRegistryForRemoteRegions());
            AbstractAzToRegionMapper azToRegionMapper = clientConfig.shouldUseDnsForFetchingServiceUrls() ? new DNSBasedAzToRegionMapper() : new PropertyBasedAzToRegionMapper(clientConfig);
            if (null != this.remoteRegionsToFetch.get()) {
                azToRegionMapper.setRegionsToFetch(this.remoteRegionsToFetch.get().split(","));
            }
            this.instanceRegionChecker = new InstanceRegionChecker(azToRegionMapper, clientConfig.getRegion());
            boolean enableGZIPContentEncodingFilter = config.shouldGZipContent();
            if (enableGZIPContentEncodingFilter) {
                this.discoveryApacheClient.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
            }
            String ip = this.instanceInfo == null ? null : this.instanceInfo.getIPAddr();
            EurekaClientIdentity identity = new EurekaClientIdentity(ip);
            this.discoveryApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter(identity));
            if (args != null && args.additionalFilters != null) {
                for (ClientFilter filter : args.additionalFilters) {
                    this.discoveryApacheClient.addFilter(filter);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize DiscoveryClient!", e);
        }
        if (clientConfig.shouldFetchRegistry() && !this.fetchRegistry(false)) {
            this.fetchRegistryFromBackup();
        }
        this.initScheduledTasks();
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register timers", e);
        }
        this.heartbeatStalenessMonitor = new ThresholdLevelsMetric(this, "eurekaClient.registration.lastHeartbeatSec_", new long[]{15L, 30L, 60L, 120L, 240L, 480L});
        this.registryStalenessMonitor = new ThresholdLevelsMetric(this, "eurekaClient.registry.lastUpdateSec_", new long[]{15L, 30L, 60L, 120L, 240L, 480L});
        DiscoveryManager.getInstance().setDiscoveryClient(this);
        DiscoveryManager.getInstance().setEurekaClientConfig(config);
    }

    @Override
    public Application getApplication(String appName) {
        return this.getApplications().getRegisteredApplications(appName);
    }

    @Override
    public Applications getApplications() {
        return this.localRegionApps.get();
    }

    @Override
    public Applications getApplicationsForARegion(@Nullable String region) {
        if (this.instanceRegionChecker.isLocalRegion(region)) {
            return this.localRegionApps.get();
        }
        return this.remoteRegionVsApps.get(region);
    }

    @Override
    public Set<String> getAllKnownRegions() {
        String localRegion = this.instanceRegionChecker.getLocalRegion();
        if (!this.remoteRegionVsApps.isEmpty()) {
            Set<String> regions = this.remoteRegionVsApps.keySet();
            HashSet<String> toReturn = new HashSet<String>(regions);
            toReturn.add(localRegion);
            return toReturn;
        }
        return Collections.singleton(localRegion);
    }

    @Override
    public List<InstanceInfo> getInstancesById(String id) {
        ArrayList<InstanceInfo> instancesList = new ArrayList<InstanceInfo>();
        for (Application app : this.getApplications().getRegisteredApplications()) {
            InstanceInfo instanceInfo = app.getByInstanceId(id);
            if (instanceInfo == null) continue;
            instancesList.add(instanceInfo);
        }
        return instancesList;
    }

    @Override
    @Deprecated
    public void registerHealthCheckCallback(HealthCheckCallback callback) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a listener for instance info since it is null!");
        }
        if (callback != null) {
            this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge(callback);
        }
    }

    @Override
    public void registerHealthCheck(HealthCheckHandler healthCheckHandler) {
        if (this.instanceInfo == null) {
            logger.error("Cannot register a healthcheck handler when instance info is null!");
        }
        if (healthCheckHandler != null) {
            this.healthCheckHandler = healthCheckHandler;
        }
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure) {
        return this.getInstancesByVipAddress(vipAddress, secure, this.instanceRegionChecker.getLocalRegion());
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddress(String vipAddress, boolean secure, @Nullable String region) {
        Applications applications;
        if (vipAddress == null) {
            throw new IllegalArgumentException("Supplied VIP Address cannot be null");
        }
        if (this.instanceRegionChecker.isLocalRegion(region)) {
            applications = this.localRegionApps.get();
        } else {
            applications = this.remoteRegionVsApps.get(region);
            if (null == applications) {
                logger.debug("No applications are defined for region {}, so returning an empty instance list for vip address {}.", (Object)region, (Object)vipAddress);
                return Collections.emptyList();
            }
        }
        if (!secure) {
            return applications.getInstancesByVirtualHostName(vipAddress);
        }
        return applications.getInstancesBySecureVirtualHostName(vipAddress);
    }

    @Override
    public List<InstanceInfo> getInstancesByVipAddressAndAppName(String vipAddress, String appName, boolean secure) {
        List<InstanceInfo> result = new ArrayList<InstanceInfo>();
        if (vipAddress == null && appName == null) {
            throw new IllegalArgumentException("Supplied VIP Address and application name cannot both be null");
        }
        if (vipAddress != null && appName == null) {
            return this.getInstancesByVipAddress(vipAddress, secure);
        }
        if (vipAddress == null && appName != null) {
            Application application = this.getApplication(appName);
            if (application != null) {
                result = application.getInstances();
            }
            return result;
        }
        for (Application app : this.getApplications().getRegisteredApplications()) {
            block1: for (InstanceInfo instance : app.getInstances()) {
                String[] instanceVipAddresses;
                String instanceVipAddress = secure ? instance.getSecureVipAddress() : instance.getVIPAddress();
                if (instanceVipAddress == null) continue;
                for (String vipAddressFromList : instanceVipAddresses = instanceVipAddress.split(",")) {
                    if (!vipAddress.equalsIgnoreCase(vipAddressFromList.trim()) || !appName.equalsIgnoreCase(instance.getAppName())) continue;
                    result.add(instance);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public InstanceInfo getNextServerFromEureka(String virtualHostname, boolean secure) {
        List<InstanceInfo> instanceInfoList = this.getInstancesByVipAddress(virtualHostname, secure);
        if (instanceInfoList == null || instanceInfoList.isEmpty()) {
            throw new RuntimeException("No matches for the virtual host name :" + virtualHostname);
        }
        Applications apps = this.localRegionApps.get();
        int index = (int)(apps.getNextIndex(virtualHostname.toUpperCase(Locale.ROOT), secure).incrementAndGet() % (long)instanceInfoList.size());
        return instanceInfoList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Applications getApplications(String serviceUrl) {
        Applications apps = null;
        try (ClientResponse response = null;){
            response = this.makeRemoteCall(Action.Refresh);
            apps = (Applications)response.getEntity(Applications.class);
            logger.debug(PREFIX + this.appPathIdentifier + " -  refresh status: " + response.getStatus());
            Applications applications = apps;
            return applications;
        }
        return apps;
    }

    private boolean shouldRegister(InstanceInfo myInfo) {
        return clientConfig.shouldRegisterWithEureka();
    }

    boolean register() throws Throwable {
        logger.info(PREFIX + this.appPathIdentifier + ": registering service...");
        try (ClientResponse response = null;){
            response = this.makeRemoteCall(Action.Register);
            this.isRegisteredWithDiscovery = true;
            logger.info("{} - registration status: {}", (Object)(PREFIX + this.appPathIdentifier), response != null ? Integer.valueOf(response.getStatus()) : "not sent");
            boolean bl = response != null && response.getStatus() == 200;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean renew() {
        try (ClientResponse response = null;){
            response = this.makeRemoteCall(Action.Renew);
            logger.debug("{} - Heartbeat status: {}", (Object)(PREFIX + this.appPathIdentifier), response != null ? Integer.valueOf(response.getStatus()) : "not sent");
            if (response == null) {
                boolean bl = false;
                return bl;
            }
            if (response.getStatus() == 404) {
                this.REREGISTER_COUNTER.increment();
                logger.info("{} - Re-registering apps/{}", (Object)(PREFIX + this.appPathIdentifier), (Object)this.instanceInfo.getAppName());
                boolean bl = this.register();
                return bl;
            }
        }
        return true;
    }

    @Override
    public List<String> getServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        int currentOffset;
        ArrayList<String> orderedUrls = new ArrayList<String>();
        String region = DiscoveryClient.getRegion();
        Object[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        if (availZones == null || availZones.length == 0) {
            availZones = new String[]{"default"};
        }
        logger.debug("The availability zone for the given region {} are {}", (Object)region, (Object)Arrays.toString(availZones));
        int myZoneOffset = DiscoveryClient.getZoneOffset(instanceZone, preferSameZone, (String[])availZones);
        List<String> serviceUrls = clientConfig.getEurekaServerServiceUrls((String)availZones[myZoneOffset]);
        if (serviceUrls != null) {
            orderedUrls.addAll(serviceUrls);
        }
        int n = currentOffset = myZoneOffset == availZones.length - 1 ? 0 : myZoneOffset + 1;
        while (currentOffset != myZoneOffset) {
            serviceUrls = clientConfig.getEurekaServerServiceUrls((String)availZones[currentOffset]);
            if (serviceUrls != null) {
                orderedUrls.addAll(serviceUrls);
            }
            if (currentOffset == availZones.length - 1) {
                currentOffset = 0;
                continue;
            }
            ++currentOffset;
        }
        if (orderedUrls.size() < 1) {
            throw new IllegalArgumentException("DiscoveryClient: invalid serviceUrl specified!");
        }
        return orderedUrls;
    }

    @Deprecated
    public static List<String> getEurekaServiceUrlsFromConfig(String instanceZone, boolean preferSameZone) {
        int currentOffset;
        ArrayList<String> orderedUrls = new ArrayList<String>();
        String region = DiscoveryClient.getRegion();
        Object[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        if (availZones == null || availZones.length == 0) {
            availZones = new String[]{"default"};
        }
        logger.debug("The availability zone for the given region {} are {}", (Object)region, (Object)Arrays.toString(availZones));
        int myZoneOffset = DiscoveryClient.getZoneOffset(instanceZone, preferSameZone, (String[])availZones);
        List<String> serviceUrls = clientConfig.getEurekaServerServiceUrls((String)availZones[myZoneOffset]);
        if (serviceUrls != null) {
            orderedUrls.addAll(serviceUrls);
        }
        int n = currentOffset = myZoneOffset == availZones.length - 1 ? 0 : myZoneOffset + 1;
        while (currentOffset != myZoneOffset) {
            serviceUrls = clientConfig.getEurekaServerServiceUrls((String)availZones[currentOffset]);
            if (serviceUrls != null) {
                orderedUrls.addAll(serviceUrls);
            }
            if (currentOffset == availZones.length - 1) {
                currentOffset = 0;
                continue;
            }
            ++currentOffset;
        }
        if (orderedUrls.size() < 1) {
            throw new IllegalArgumentException("DiscoveryClient: invalid serviceUrl specified!");
        }
        return orderedUrls;
    }

    @Override
    @PreDestroy
    public void shutdown() {
        if (this.statusChangeListener != null && this.applicationInfoManager != null) {
            this.applicationInfoManager.unregisterStatusChangeListener(this.statusChangeListener.getId());
        }
        this.cancelScheduledTasks();
        if (this.instanceInfo != null && this.shouldRegister(this.instanceInfo)) {
            this.instanceInfo.setStatus(InstanceInfo.InstanceStatus.DOWN);
            this.unregister();
        }
        if (this.discoveryJerseyClient != null) {
            this.discoveryJerseyClient.destroyResources();
        }
        this.heartbeatStalenessMonitor.shutdown();
        this.registryStalenessMonitor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        try (ClientResponse response = null;){
            response = this.makeRemoteCall(Action.Cancel);
            logger.info(PREFIX + this.appPathIdentifier + " - deregister  status: " + (response != null ? Integer.valueOf(response.getStatus()) : "not registered"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchRegistry(boolean forceFullRegistryFetch) {
        ClientResponse response;
        block9: {
            response = null;
            Stopwatch tracer = this.FETCH_REGISTRY_TIMER.start();
            try {
                Applications applications = this.getApplications();
                if (clientConfig.shouldDisableDelta() || !Strings.isNullOrEmpty((String)clientConfig.getRegistryRefreshSingleVipAddress()) || forceFullRegistryFetch || applications == null || applications.getRegisteredApplications().size() == 0 || applications.getVersion() == -1L) {
                    logger.info("Disable delta property : {}", (Object)clientConfig.shouldDisableDelta());
                    logger.info("Single vip registry refresh property : {}", (Object)clientConfig.getRegistryRefreshSingleVipAddress());
                    logger.info("Force full registry fetch : {}", (Object)forceFullRegistryFetch);
                    logger.info("Application is null : {}", (Object)(applications == null ? 1 : 0));
                    logger.info("Registered Applications size is zero : {}", (Object)(applications.getRegisteredApplications().size() == 0 ? 1 : 0));
                    logger.info("Application version is -1: {}", (Object)(applications.getVersion() == -1L ? 1 : 0));
                    response = this.getAndStoreFullRegistry();
                } else {
                    response = this.getAndUpdateDelta(applications);
                }
                applications.setAppsHashCode(applications.getReconcileHashCode());
                this.logTotalInstances();
                if (logger.isDebugEnabled()) {
                    logger.debug(PREFIX + this.appPathIdentifier + " -  refresh status: " + response.getStatus());
                }
                if (tracer == null) break block9;
            }
            catch (Throwable e) {
                try {
                    logger.error(PREFIX + this.appPathIdentifier + " - was unable to refresh its cache! status = " + e.getMessage(), e);
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (tracer != null) {
                        tracer.stop();
                    }
                    this.closeResponse(response);
                }
            }
            tracer.stop();
        }
        this.closeResponse(response);
        this.onCacheRefreshed();
        this.updateInstanceRemoteStatus();
        return true;
    }

    private synchronized void updateInstanceRemoteStatus() {
        InstanceInfo remoteInstanceInfo;
        Application app;
        InstanceInfo.InstanceStatus currentRemoteInstanceStatus = null;
        if (this.instanceInfo.getAppName() != null && (app = this.getApplication(this.instanceInfo.getAppName())) != null && (remoteInstanceInfo = app.getByInstanceId(this.instanceInfo.getId())) != null) {
            currentRemoteInstanceStatus = remoteInstanceInfo.getStatus();
        }
        if (currentRemoteInstanceStatus == null) {
            currentRemoteInstanceStatus = InstanceInfo.InstanceStatus.UNKNOWN;
        }
        if (this.lastRemoteInstanceStatus != currentRemoteInstanceStatus) {
            this.onRemoteStatusChanged(this.lastRemoteInstanceStatus, currentRemoteInstanceStatus);
            this.lastRemoteInstanceStatus = currentRemoteInstanceStatus;
        }
    }

    @Override
    public InstanceInfo.InstanceStatus getInstanceRemoteStatus() {
        return this.lastRemoteInstanceStatus;
    }

    private String getReconcileHashCode(Applications applications) {
        TreeMap<String, AtomicInteger> instanceCountMap = new TreeMap<String, AtomicInteger>();
        if (this.isFetchingRemoteRegionRegistries()) {
            for (Applications remoteApp : this.remoteRegionVsApps.values()) {
                remoteApp.populateInstanceCountMap(instanceCountMap);
            }
        }
        applications.populateInstanceCountMap(instanceCountMap);
        return Applications.getReconcileHashCode(instanceCountMap);
    }

    private ClientResponse getAndStoreFullRegistry() throws Throwable {
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        ClientResponse response = this.makeRemoteCall(Action.Refresh);
        logger.info("Getting all instance registry info from the eureka server");
        Applications apps = null;
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            apps = (Applications)response.getEntity(Applications.class);
        }
        if (apps == null) {
            logger.error("The application is null for some reason. Not storing this information");
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.localRegionApps.set(this.filterAndShuffle(apps));
            logger.debug("Got full registry with apps hashcode {}", (Object)apps.getAppsHashCode());
        } else {
            logger.warn("Not updating applications as another thread is updating it already");
        }
        logger.info("The response status is {}", (Object)response.getStatus());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientResponse getAndUpdateDelta(Applications applications) throws Throwable {
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        ClientResponse response = this.makeRemoteCall(Action.Refresh_Delta);
        Applications delta = null;
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            delta = (Applications)response.getEntity(Applications.class);
        }
        if (delta == null) {
            logger.warn("The server does not allow the delta revision to be applied because it is not safe. Hence got the full registry.");
            this.closeResponse(response);
            response = this.getAndStoreFullRegistry();
        } else if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            logger.debug("Got delta update with apps hashcode {}", (Object)delta.getAppsHashCode());
            String reconcileHashCode = "";
            if (this.fetchRegistryUpdateLock.tryLock()) {
                try {
                    this.updateDelta(delta);
                    reconcileHashCode = this.getReconcileHashCode(applications);
                }
                finally {
                    this.fetchRegistryUpdateLock.unlock();
                }
            } else {
                logger.warn("Cannot acquire update lock, aborting getAndUpdateDelta");
                return response;
            }
            if (!reconcileHashCode.equals(delta.getAppsHashCode()) || clientConfig.shouldLogDeltaDiff()) {
                response = this.reconcileAndLogDifference(response, delta, reconcileHashCode);
            }
        } else {
            logger.warn("Not updating application delta as another thread is updating it already");
            logger.debug("Ignoring delta update with apps hashcode {}, as another thread is updating it already", (Object)delta.getAppsHashCode());
        }
        return response;
    }

    private void logTotalInstances() {
        if (logger.isDebugEnabled()) {
            int totInstances = 0;
            for (Application application : this.getApplications().getRegisteredApplications()) {
                totInstances += application.getInstancesAsIsFromEureka().size();
            }
            logger.debug("The total number of all instances in the client now is {}", (Object)totInstances);
        }
    }

    private ClientResponse reconcileAndLogDifference(ClientResponse response, Applications delta, String reconcileHashCode) throws Throwable {
        logger.warn("The Reconcile hashcodes do not match, client : {}, server : {}. Getting the full registry", (Object)reconcileHashCode, (Object)delta.getAppsHashCode());
        this.RECONCILE_HASH_CODES_MISMATCH.increment();
        this.closeResponse(response);
        long currentUpdateGeneration = this.fetchRegistryGeneration.get();
        response = this.makeRemoteCall(Action.Refresh);
        Applications serverApps = (Applications)response.getEntity(Applications.class);
        try {
            Map<String, List<String>> reconcileDiffMap = this.getApplications().getReconcileMapDiff(serverApps);
            String reconcileString = "";
            for (Map.Entry<String, List<String>> mapEntry : reconcileDiffMap.entrySet()) {
                reconcileString = reconcileString + mapEntry.getKey() + ": ";
                for (String displayString : mapEntry.getValue()) {
                    reconcileString = reconcileString + displayString;
                }
                reconcileString = reconcileString + "\n";
            }
            logger.warn("The reconcile string is {}", (Object)reconcileString);
        }
        catch (Throwable e) {
            logger.error("Could not calculate reconcile string ", e);
        }
        if (this.fetchRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.localRegionApps.set(this.filterAndShuffle(serverApps));
            this.getApplications().setVersion(delta.getVersion());
            logger.warn("The Reconcile hashcodes after complete sync up, client : {}, server : {}.", (Object)this.getApplications().getReconcileHashCode(), (Object)delta.getAppsHashCode());
        } else {
            logger.warn("Not setting the applications map as another thread has advanced the update generation");
        }
        return response;
    }

    private void updateDelta(Applications delta) {
        int deltaCount = 0;
        for (Application app : delta.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                Application existingApp;
                Applications applications = this.getApplications();
                String instanceRegion = this.instanceRegionChecker.getInstanceRegion(instance);
                if (!this.instanceRegionChecker.isLocalRegion(instanceRegion)) {
                    Applications remoteApps = this.remoteRegionVsApps.get(instanceRegion);
                    if (null == remoteApps) {
                        remoteApps = new Applications();
                        this.remoteRegionVsApps.put(instanceRegion, remoteApps);
                    }
                    applications = remoteApps;
                }
                ++deltaCount;
                if (InstanceInfo.ActionType.ADDED.equals((Object)instance.getActionType())) {
                    existingApp = applications.getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        applications.addApplication(app);
                    }
                    logger.debug("Added instance {} to the existing apps in region {}", (Object)instance.getId(), (Object)instanceRegion);
                    applications.getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (InstanceInfo.ActionType.MODIFIED.equals((Object)instance.getActionType())) {
                    existingApp = applications.getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        applications.addApplication(app);
                    }
                    logger.debug("Modified instance {} to the existing apps ", (Object)instance.getId());
                    applications.getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (!InstanceInfo.ActionType.DELETED.equals((Object)instance.getActionType())) continue;
                existingApp = applications.getRegisteredApplications(instance.getAppName());
                if (existingApp == null) {
                    applications.addApplication(app);
                }
                logger.debug("Deleted instance {} to the existing apps ", (Object)instance.getId());
                applications.getRegisteredApplications(instance.getAppName()).removeInstance(instance);
            }
        }
        logger.debug("The total number of instances fetched by the delta processor : {}", (Object)deltaCount);
        this.getApplications().setVersion(delta.getVersion());
        this.getApplications().shuffleInstances(clientConfig.shouldFilterOnlyUpInstances());
        for (Applications applications : this.remoteRegionVsApps.values()) {
            applications.setVersion(delta.getVersion());
            applications.shuffleInstances(clientConfig.shouldFilterOnlyUpInstances());
        }
    }

    private ClientResponse makeRemoteCall(Action action) throws Throwable {
        ClientResponse response = DiscoveryClient.isQueryAction(action) ? this.makeRemoteCallToRedirectedServer(this.lastQueryRedirect, action) : this.makeRemoteCallToRedirectedServer(this.lastRegisterRedirect, action);
        if (response == null) {
            response = this.makeRemoteCall(action, 0);
        }
        return response;
    }

    private ClientResponse makeRemoteCallToRedirectedServer(AtomicReference<String> lastRedirect, Action action) {
        String lastRedirectUrl = lastRedirect.get();
        if (lastRedirectUrl != null) {
            try {
                ClientResponse clientResponse = this.makeRemoteCall(action, lastRedirectUrl);
                int status = clientResponse.getStatus();
                if (status >= 200 && status < 300) {
                    return clientResponse;
                }
                this.SERVER_RETRY_COUNTER.increment();
                lastRedirect.compareAndSet(lastRedirectUrl, null);
            }
            catch (Throwable ignored) {
                logger.warn("Remote call to last redirect address failed; retrying from configured service URL list");
                this.SERVER_RETRY_COUNTER.increment();
                lastRedirect.compareAndSet(lastRedirectUrl, null);
            }
        }
        return null;
    }

    private static boolean isQueryAction(Action action) {
        return action == Action.Refresh || action == Action.Refresh_Delta;
    }

    private ClientResponse makeRemoteCall(Action action, int serviceUrlIndex) throws Throwable {
        try {
            String serviceUrl = this.eurekaServiceUrls.get().get(serviceUrlIndex);
            return this.makeRemoteCallWithFollowRedirect(action, serviceUrl);
        }
        catch (Throwable t) {
            if (this.eurekaServiceUrls.get().size() > ++serviceUrlIndex) {
                logger.warn("Trying backup: " + this.eurekaServiceUrls.get().get(serviceUrlIndex));
                this.SERVER_RETRY_COUNTER.increment();
                return this.makeRemoteCall(action, serviceUrlIndex);
            }
            this.ALL_SERVER_FAILURE_COUNT.increment();
            logger.error("Can't contact any eureka nodes - possibly a security group issue?", t);
            throw t;
        }
    }

    private ClientResponse makeRemoteCallWithFollowRedirect(Action action, String serviceUrl) throws Throwable {
        URI targetUrl = new URI(serviceUrl);
        for (int followRedirectCount = 0; followRedirectCount < 10; ++followRedirectCount) {
            ClientResponse clientResponse = this.makeRemoteCall(action, targetUrl.toString());
            if (clientResponse.getStatus() != 302) {
                if (followRedirectCount > 0) {
                    if (DiscoveryClient.isQueryAction(action)) {
                        this.lastQueryRedirect.set(targetUrl.toString());
                    } else {
                        this.lastRegisterRedirect.set(targetUrl.toString());
                    }
                }
                return clientResponse;
            }
            targetUrl = DiscoveryClient.getRedirectBaseUri(clientResponse.getLocation());
            if (targetUrl != null) continue;
            throw new IOException("Invalid redirect URL " + clientResponse.getLocation());
        }
        String message = "Follow redirect limit crossed for URI " + serviceUrl;
        logger.warn(message);
        throw new IOException(message);
    }

    private static URI getRedirectBaseUri(URI targetUrl) {
        Matcher pathMatcher = REDIRECT_PATH_REGEX.matcher(targetUrl.getPath());
        if (pathMatcher.matches()) {
            return UriBuilder.fromUri((URI)targetUrl).host(DnsResolver.resolve(targetUrl.getHost())).replacePath(pathMatcher.group(1)).replaceQuery(null).build(new Object[0]);
        }
        logger.warn("Invalid redirect URL {}", (Object)targetUrl);
        return null;
    }

    private ClientResponse makeRemoteCall(Action action, String serviceUrl) throws Throwable {
        String urlPath = null;
        Stopwatch tracer = null;
        ClientResponse response = null;
        logger.debug("Discovery Client talking to the server {}, action {}", (Object)serviceUrl, (Object)action);
        try {
            if (UNKNOWN.equals(this.instanceInfo.getAppName()) && !Action.Refresh.equals((Object)action) && !Action.Refresh_Delta.equals((Object)action)) {
                ClientResponse clientResponse = null;
                return clientResponse;
            }
            WebResource r = this.discoveryApacheClient.resource(serviceUrl);
            if (clientConfig.allowRedirects()) {
                r.header(HTTP_X_DISCOVERY_ALLOW_REDIRECT, (Object)"true");
            }
            switch (action) {
                case Renew: {
                    tracer = this.RENEW_TIMER.start();
                    urlPath = "apps/" + this.appPathIdentifier;
                    response = (ClientResponse)r.path(urlPath).queryParam("status", this.instanceInfo.getStatus().toString()).queryParam("lastDirtyTimestamp", this.instanceInfo.getLastDirtyTimestamp().toString()).put(ClientResponse.class);
                    break;
                }
                case Refresh: {
                    tracer = this.REFRESH_TIMER.start();
                    String vipAddress = clientConfig.getRegistryRefreshSingleVipAddress();
                    urlPath = vipAddress == null ? "apps/" : "vips/" + vipAddress;
                    String remoteRegionsToFetchStr = this.remoteRegionsToFetch.get();
                    if (!Strings.isNullOrEmpty((String)remoteRegionsToFetchStr)) {
                        urlPath = urlPath + "?regions=" + remoteRegionsToFetchStr;
                    }
                    response = this.getUrl(serviceUrl + urlPath);
                    break;
                }
                case Refresh_Delta: {
                    tracer = this.REFRESH_DELTA_TIMER.start();
                    urlPath = "apps/delta";
                    String remoteRegionsToFetchStr = this.remoteRegionsToFetch.get();
                    if (!Strings.isNullOrEmpty((String)remoteRegionsToFetchStr)) {
                        urlPath = urlPath + "?regions=" + remoteRegionsToFetchStr;
                    }
                    response = this.getUrl(serviceUrl + urlPath);
                    break;
                }
                case Register: {
                    tracer = this.REGISTER_TIMER.start();
                    urlPath = "apps/" + this.instanceInfo.getAppName();
                    response = (ClientResponse)r.path(urlPath).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)this.instanceInfo);
                    break;
                }
                case Cancel: {
                    tracer = this.CANCEL_TIMER.start();
                    urlPath = "apps/" + this.appPathIdentifier;
                    response = (ClientResponse)r.path(urlPath).delete(ClientResponse.class);
                    if (this.isRegisteredWithDiscovery || response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) break;
                    ClientResponse clientResponse = response;
                    return clientResponse;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Finished a call to service url {} and url path {} with status code {}.", (Object[])new String[]{serviceUrl, urlPath, String.valueOf(response.getStatus())});
            }
            if (this.isOk(action, response.getStatus())) {
                ClientResponse clientResponse = response;
                return clientResponse;
            }
            try {
                logger.warn("Action: " + (Object)((Object)action) + "  => returned status of " + response.getStatus() + " from " + serviceUrl + urlPath);
                throw new RuntimeException("Bad status: " + response.getStatus());
            }
            catch (Throwable t) {
                this.closeResponse(response);
                logger.warn("Can't get a response from " + serviceUrl + urlPath, t);
                throw t;
            }
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    private void closeResponse(ClientResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Throwable th) {
                logger.error("Cannot release response resource :", th);
            }
        }
    }

    private void initScheduledTasks() {
        int expBackOffBound;
        if (clientConfig.shouldFetchRegistry()) {
            int registryFetchIntervalSeconds = clientConfig.getRegistryFetchIntervalSeconds();
            expBackOffBound = clientConfig.getCacheRefreshExecutorExponentialBackOffBound();
            this.scheduler.schedule(new TimedSupervisorTask("cacheRefresh", this.scheduler, this.cacheRefreshExecutor, registryFetchIntervalSeconds, TimeUnit.SECONDS, expBackOffBound, new CacheRefreshThread()), (long)registryFetchIntervalSeconds, TimeUnit.SECONDS);
        }
        if (this.shouldRegister(this.instanceInfo)) {
            int renewalIntervalInSecs = this.instanceInfo.getLeaseInfo().getRenewalIntervalInSecs();
            expBackOffBound = clientConfig.getHeartbeatExecutorExponentialBackOffBound();
            logger.info("Starting heartbeat executor: renew interval is: " + renewalIntervalInSecs);
            this.scheduler.schedule(new TimedSupervisorTask("heartbeat", this.scheduler, this.heartbeatExecutor, renewalIntervalInSecs, TimeUnit.SECONDS, expBackOffBound, new HeartbeatThread()), (long)renewalIntervalInSecs, TimeUnit.SECONDS);
            this.instanceInfoReplicator = new InstanceInfoReplicator(this, this.instanceInfo, clientConfig.getInstanceInfoReplicationIntervalSeconds(), 2);
            this.statusChangeListener = new ApplicationInfoManager.StatusChangeListener(){

                @Override
                public String getId() {
                    return "statusChangeListener";
                }

                @Override
                public void notify(StatusChangeEvent statusChangeEvent) {
                    logger.info("Saw local status change event {}", (Object)statusChangeEvent);
                    DiscoveryClient.this.instanceInfoReplicator.onDemandUpdate();
                }
            };
            if (clientConfig.shouldOnDemandUpdateStatusChange()) {
                this.applicationInfoManager.registerStatusChangeListener(this.statusChangeListener);
            }
            this.instanceInfoReplicator.start(clientConfig.getInitialInstanceInfoReplicationIntervalSeconds());
        } else {
            logger.info("Not registering with Eureka server per configuration");
        }
    }

    private void cancelScheduledTasks() {
        if (this.instanceInfoReplicator != null) {
            this.instanceInfoReplicator.stop();
        }
        this.heartbeatExecutor.shutdownNow();
        this.cacheRefreshExecutor.shutdownNow();
        this.scheduler.shutdownNow();
    }

    @Override
    public List<String> getServiceUrlsFromDNS(String instanceZone, boolean preferSameZone) {
        Stopwatch t = this.GET_SERVICE_URLS_DNS_TIMER.start();
        String region = DiscoveryClient.getRegion();
        Map<String, List<String>> zoneDnsNamesMap = DiscoveryClient.getZoneBasedDiscoveryUrlsFromRegion(region);
        Set<String> availableZones = zoneDnsNamesMap.keySet();
        ArrayList<String> zones = new ArrayList<String>(availableZones);
        if (zones.isEmpty()) {
            throw new RuntimeException("No available zones configured for the instanceZone " + instanceZone);
        }
        int zoneIndex = 0;
        boolean zoneFound = false;
        for (String zone : zones) {
            logger.debug("Checking if the instance zone {} is the same as the zone from DNS {}", (Object)instanceZone, (Object)zone);
            if (preferSameZone) {
                if (instanceZone.equalsIgnoreCase(zone)) {
                    zoneFound = true;
                }
            } else if (!instanceZone.equalsIgnoreCase(zone)) {
                zoneFound = true;
            }
            if (zoneFound) {
                Object[] args = new Object[]{zones, instanceZone, zoneIndex};
                logger.debug("The zone index from the list {} that matches the instance zone {} is {}", args);
                break;
            }
            ++zoneIndex;
        }
        if (zoneIndex >= zones.size()) {
            logger.warn("No match for the zone {} in the list of available zones {}", (Object)instanceZone, (Object)Arrays.toString(zones.toArray()));
        } else {
            for (int i = 0; i < zoneIndex; ++i) {
                String zone;
                zone = (String)zones.remove(0);
                zones.add(zone);
            }
        }
        ArrayList<String> serviceUrls = new ArrayList<String>();
        for (String zone : zones) {
            for (String zoneCname : zoneDnsNamesMap.get(zone)) {
                ArrayList<String> ec2Urls = new ArrayList<String>(DiscoveryClient.getEC2DiscoveryUrlsFromZone(zoneCname, DiscoveryUrlType.CNAME));
                if (ec2Urls.size() > 1) {
                    this.arrangeListBasedonHostname(ec2Urls);
                }
                for (String ec2Url : ec2Urls) {
                    String serviceUrl = "http://" + ec2Url + ":" + clientConfig.getEurekaServerPort() + "/" + clientConfig.getEurekaServerURLContext() + "/";
                    logger.debug("The EC2 url is {}", (Object)serviceUrl);
                    serviceUrls.add(serviceUrl);
                }
            }
        }
        String primaryServiceUrl = (String)serviceUrls.remove(0);
        this.arrangeListBasedonHostname(serviceUrls);
        serviceUrls.add(0, primaryServiceUrl);
        logger.debug("This client will talk to the following serviceUrls in order : {} ", (Object)Arrays.toString(serviceUrls.toArray()));
        t.stop();
        return serviceUrls;
    }

    @Override
    public List<String> getDiscoveryServiceUrls(String zone) {
        boolean shouldUseDns = clientConfig.shouldUseDnsForFetchingServiceUrls();
        if (shouldUseDns) {
            return this.getServiceUrlsFromDNS(zone, clientConfig.shouldPreferSameZoneEureka());
        }
        return this.getServiceUrlsFromConfig(zone, clientConfig.shouldPreferSameZoneEureka());
    }

    @Deprecated
    public static String getZone(InstanceInfo myInfo) {
        String[] availZones = clientConfig.getAvailabilityZones(clientConfig.getRegion());
        return InstanceInfo.getZone(availZones, myInfo);
    }

    public static String getRegion() {
        String region = clientConfig.getRegion();
        if (region == null) {
            region = "default";
        }
        region = region.trim().toLowerCase();
        return region;
    }

    static Map<String, List<String>> getZoneBasedDiscoveryUrlsFromRegion(String region) {
        String discoveryDnsName = null;
        try {
            discoveryDnsName = "txt." + region + "." + clientConfig.getEurekaServerDNSName();
            logger.debug("The region url to be looked up is {} :", (Object)discoveryDnsName);
            TreeSet<String> zoneCnamesForRegion = new TreeSet<String>(DnsResolver.getCNamesFromTxtRecord(discoveryDnsName));
            TreeMap<String, List<String>> zoneCnameMapForRegion = new TreeMap<String, List<String>>();
            for (String zoneCname : zoneCnamesForRegion) {
                String zone = null;
                if (DiscoveryClient.isEC2Url(zoneCname)) {
                    throw new RuntimeException("Cannot find the right DNS entry for " + discoveryDnsName + ". " + "Expected mapping of the format <aws_zone>.<domain_name>");
                }
                String[] cnameTokens = zoneCname.split("\\.");
                zone = cnameTokens[0];
                logger.debug("The zoneName mapped to region {} is {}", (Object)region, (Object)zone);
                ArrayList<String> zoneCnamesSet = (ArrayList<String>)zoneCnameMapForRegion.get(zone);
                if (zoneCnamesSet == null) {
                    zoneCnamesSet = new ArrayList<String>();
                    zoneCnameMapForRegion.put(zone, zoneCnamesSet);
                }
                zoneCnamesSet.add(zoneCname);
            }
            return zoneCnameMapForRegion;
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get cnames bound to the region:" + discoveryDnsName, e);
        }
    }

    private static boolean isEC2Url(String zoneCname) {
        return zoneCname.startsWith("ec2");
    }

    public static Set<String> getEC2DiscoveryUrlsFromZone(String dnsName, DiscoveryUrlType type) {
        TreeSet<String> eipsForZone = null;
        try {
            dnsName = "txt." + dnsName;
            logger.debug("The zone url to be looked up is {} :", (Object)dnsName);
            Set<String> ec2UrlsForZone = DnsResolver.getCNamesFromTxtRecord(dnsName);
            for (String ec2Url : ec2UrlsForZone) {
                logger.debug("The eureka url for the dns name {} is {}", (Object)dnsName, (Object)ec2Url);
                ec2UrlsForZone.add(ec2Url);
            }
            if (DiscoveryUrlType.CNAME.equals((Object)type)) {
                return ec2UrlsForZone;
            }
            eipsForZone = new TreeSet<String>();
            for (String cname : ec2UrlsForZone) {
                String[] tokens = cname.split("\\.");
                String ec2HostName = tokens[0];
                String[] ips = ec2HostName.split("-");
                StringBuffer eipBuffer = new StringBuffer();
                for (int ipCtr = 1; ipCtr < 5; ++ipCtr) {
                    eipBuffer.append(ips[ipCtr]);
                    if (ipCtr >= 4) continue;
                    eipBuffer.append(".");
                }
                eipsForZone.add(eipBuffer.toString());
            }
            logger.debug("The EIPS for {} is {} :", (Object)dnsName, eipsForZone);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot get cnames bound to the region:" + dnsName, e);
        }
        return eipsForZone;
    }

    private static int getZoneOffset(String myZone, boolean preferSameZone, String[] availZones) {
        for (int i = 0; i < availZones.length; ++i) {
            if (myZone == null || availZones[i].equalsIgnoreCase(myZone.trim()) != preferSameZone) continue;
            return i;
        }
        logger.warn("DISCOVERY: Could not pick a zone based on preferred zone settings. My zone - {}, preferSameZone- {}. Defaulting to " + availZones[0], (Object)myZone, (Object)preferSameZone);
        return 0;
    }

    private boolean isOk(Action action, int httpStatus) {
        if (httpStatus >= 200 && httpStatus < 300 || httpStatus == 302) {
            return true;
        }
        if (Action.Renew == action && httpStatus == 404) {
            return true;
        }
        return Action.Refresh_Delta == action && (httpStatus == 403 || httpStatus == 404);
    }

    private InstanceInfo getCoordinatingServer() {
        Application app = this.getApplication(DISCOVERY_APPID);
        List<InstanceInfo> discoveryInstances = null;
        InstanceInfo instanceToReturn = null;
        if (app != null) {
            discoveryInstances = app.getInstances();
        }
        if (discoveryInstances != null) {
            for (InstanceInfo instance : discoveryInstances) {
                if (instance == null || !instance.isCoordinatingDiscoveryServer().booleanValue()) continue;
                instanceToReturn = instance;
                break;
            }
        }
        return instanceToReturn;
    }

    private ClientResponse getUrl(String fullServiceUrl) {
        ClientResponse cr = (ClientResponse)((WebResource.Builder)this.discoveryApacheClient.resource(fullServiceUrl).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Eureka-Accept", (Object)this.clientAccept.name())).get(ClientResponse.class);
        return cr;
    }

    void refreshInstanceInfo() {
        InstanceInfo.InstanceStatus status;
        this.applicationInfoManager.refreshDataCenterInfoIfRequired();
        this.applicationInfoManager.refreshLeaseInfoIfRequired();
        try {
            status = this.getHealthCheckHandler().getStatus(this.instanceInfo.getStatus());
        }
        catch (Exception e) {
            logger.warn("Exception from healthcheckHandler.getStatus, setting status to DOWN", (Throwable)e);
            status = InstanceInfo.InstanceStatus.DOWN;
        }
        if (null != status) {
            this.instanceInfo.setStatus(status);
        }
    }

    @VisibleForTesting
    InstanceInfoReplicator getInstanceInfoReplicator() {
        return this.instanceInfoReplicator;
    }

    @VisibleForTesting
    InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    @Override
    public HealthCheckHandler getHealthCheckHandler() {
        if (this.healthCheckHandler == null) {
            if (null != this.healthCheckHandlerProvider) {
                this.healthCheckHandler = (HealthCheckHandler)this.healthCheckHandlerProvider.get();
            } else if (null != this.healthCheckCallbackProvider) {
                this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge((HealthCheckCallback)this.healthCheckCallbackProvider.get());
            }
            if (null == this.healthCheckHandler) {
                this.healthCheckHandler = new HealthCheckCallbackToHandlerBridge(null);
            }
        }
        return this.healthCheckHandler;
    }

    private void fetchRegistryFromBackup() {
        try {
            BackupRegistry backupRegistryInstance = this.newBackupRegistryInstance();
            if (null == backupRegistryInstance) {
                backupRegistryInstance = (BackupRegistry)this.backupRegistryProvider.get();
            }
            if (null != backupRegistryInstance) {
                Applications apps = null;
                if (this.isFetchingRemoteRegionRegistries()) {
                    String remoteRegionsStr = this.remoteRegionsToFetch.get();
                    if (null != remoteRegionsStr) {
                        apps = backupRegistryInstance.fetchRegistry(remoteRegionsStr.split(","));
                    }
                } else {
                    apps = backupRegistryInstance.fetchRegistry();
                }
                if (apps != null) {
                    Applications applications = this.filterAndShuffle(apps);
                    applications.setAppsHashCode(applications.getReconcileHashCode());
                    this.localRegionApps.set(applications);
                    this.logTotalInstances();
                    logger.info("Fetched registry successfully from the backup");
                }
            } else {
                logger.warn("No backup registry instance defined & unable to find any discovery servers.");
            }
        }
        catch (Throwable e) {
            logger.warn("Cannot fetch applications from apps although backup registry was specified", e);
        }
    }

    @Deprecated
    @Nullable
    protected BackupRegistry newBackupRegistryInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return null;
    }

    private TimerTask getServiceUrlUpdateTask(final String zone) {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    List<String> serviceUrlList = DiscoveryClient.this.getDiscoveryServiceUrls(zone);
                    if (serviceUrlList.isEmpty()) {
                        logger.warn("The service url list is empty");
                        return;
                    }
                    if (!serviceUrlList.equals(DiscoveryClient.this.eurekaServiceUrls.get())) {
                        logger.info("Updating the serviceUrls as they seem to have changed from {} to {} ", (Object)Arrays.toString(((List)DiscoveryClient.this.eurekaServiceUrls.get()).toArray()), (Object)Arrays.toString(serviceUrlList.toArray()));
                        DiscoveryClient.this.eurekaServiceUrls.set(serviceUrlList);
                    }
                }
                catch (Throwable e) {
                    logger.error("Cannot get the eureka service urls :", e);
                }
            }
        };
    }

    private Applications filterAndShuffle(Applications apps) {
        if (apps != null) {
            if (this.isFetchingRemoteRegionRegistries()) {
                ConcurrentHashMap<String, Applications> remoteRegionVsApps = new ConcurrentHashMap<String, Applications>();
                apps.shuffleAndIndexInstances(remoteRegionVsApps, clientConfig, this.instanceRegionChecker);
                for (Applications applications : remoteRegionVsApps.values()) {
                    applications.shuffleInstances(clientConfig.shouldFilterOnlyUpInstances());
                }
                this.remoteRegionVsApps = remoteRegionVsApps;
            } else {
                apps.shuffleInstances(clientConfig.shouldFilterOnlyUpInstances());
            }
        }
        return apps;
    }

    private boolean isFetchingRemoteRegionRegistries() {
        return null != this.remoteRegionsToFetch.get();
    }

    private void arrangeListBasedonHostname(List<String> list) {
        int listSize = 0;
        if (list != null) {
            listSize = list.size();
        }
        if (this.instanceInfo == null || listSize == 0) {
            return;
        }
        int instanceHashcode = this.instanceInfo.getHostName().hashCode();
        if (instanceHashcode < 0) {
            instanceHashcode *= -1;
        }
        int backupInstance = instanceHashcode % listSize;
        for (int i = 0; i < backupInstance; ++i) {
            String zone = list.remove(0);
            list.add(zone);
        }
    }

    protected void onRemoteStatusChanged(InstanceInfo.InstanceStatus oldStatus, InstanceInfo.InstanceStatus newStatus) {
        this.fireEvent(new StatusChangeEvent(oldStatus, newStatus));
    }

    protected void onCacheRefreshed() {
        this.fireEvent(new CacheRefreshedEvent());
    }

    protected void fireEvent(DiscoveryEvent event) {
        if (this.eventBus != null) {
            this.eventBus.publish((Object)event);
        }
    }

    @Monitor(name="eurekaClient.registration.lastSuccessfulHeartbeatTimePeriod", description="How much time has passed from last successful heartbeat", type=DataSourceType.GAUGE)
    public long getLastSuccessfulHeartbeatTimePeriod() {
        long delay = this.lastSuccessfulHeartbeatTimestamp < 0L ? 0L : System.currentTimeMillis() - this.lastSuccessfulHeartbeatTimestamp;
        this.heartbeatStalenessMonitor.update(delay);
        return delay;
    }

    @Monitor(name="eurekaClient.registry.lastSuccessfulRegistryFetchTimePeriod", description="How much time has passed from last successful local registry update", type=DataSourceType.GAUGE)
    public long getLastSuccessfulRegistryFetchTimePeriod() {
        long delay = this.lastSuccessfulRegistryFetchTimestamp < 0L ? 0L : System.currentTimeMillis() - this.lastSuccessfulRegistryFetchTimestamp;
        this.registryStalenessMonitor.update(delay);
        return delay;
    }

    class CacheRefreshThread
    implements Runnable {
        CacheRefreshThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean success;
                boolean isFetchingRemoteRegionRegistries = DiscoveryClient.this.isFetchingRemoteRegionRegistries();
                boolean remoteRegionsModified = false;
                String latestRemoteRegions = clientConfig.fetchRegistryForRemoteRegions();
                if (null != latestRemoteRegions) {
                    String currentRemoteRegions = (String)DiscoveryClient.this.remoteRegionsToFetch.get();
                    if (!latestRemoteRegions.equals(currentRemoteRegions)) {
                        AzToRegionMapper azToRegionMapper = DiscoveryClient.this.instanceRegionChecker.getAzToRegionMapper();
                        synchronized (azToRegionMapper) {
                            if (DiscoveryClient.this.remoteRegionsToFetch.compareAndSet(currentRemoteRegions, latestRemoteRegions)) {
                                String[] remoteRegions = latestRemoteRegions.split(",");
                                DiscoveryClient.this.instanceRegionChecker.getAzToRegionMapper().setRegionsToFetch(remoteRegions);
                                remoteRegionsModified = true;
                            } else {
                                logger.info("Remote regions to fetch modified concurrently, ignoring change from {} to {}", (Object)currentRemoteRegions, (Object)latestRemoteRegions);
                            }
                        }
                    } else {
                        DiscoveryClient.this.instanceRegionChecker.getAzToRegionMapper().refreshMapping();
                    }
                }
                if (success = DiscoveryClient.this.fetchRegistry(remoteRegionsModified)) {
                    DiscoveryClient.this.lastSuccessfulRegistryFetchTimestamp = System.currentTimeMillis();
                }
                if (logger.isDebugEnabled()) {
                    StringBuilder allAppsHashCodes = new StringBuilder();
                    allAppsHashCodes.append("Local region apps hashcode: ");
                    allAppsHashCodes.append(((Applications)DiscoveryClient.this.localRegionApps.get()).getAppsHashCode());
                    allAppsHashCodes.append(", is fetching remote regions? ");
                    allAppsHashCodes.append(isFetchingRemoteRegionRegistries);
                    for (Map.Entry entry : DiscoveryClient.this.remoteRegionVsApps.entrySet()) {
                        allAppsHashCodes.append(", Remote region: ");
                        allAppsHashCodes.append((String)entry.getKey());
                        allAppsHashCodes.append(" , apps hashcode: ");
                        allAppsHashCodes.append(((Applications)entry.getValue()).getAppsHashCode());
                    }
                    logger.debug("Completed cache refresh task for discovery. All Apps hash code is {} ", (Object)allAppsHashCodes.toString());
                }
            }
            catch (Throwable th) {
                logger.error("Cannot fetch registry from server", th);
            }
        }
    }

    private class HeartbeatThread
    implements Runnable {
        private HeartbeatThread() {
        }

        @Override
        public void run() {
            if (DiscoveryClient.this.renew()) {
                DiscoveryClient.this.lastSuccessfulHeartbeatTimestamp = System.currentTimeMillis();
            }
        }
    }

    public static enum DiscoveryUrlType {
        CNAME,
        A;

    }

    public static class DiscoveryClientOptionalArgs {
        @Inject(optional=true)
        private EventBus eventBus;
        @Inject(optional=true)
        private Provider<HealthCheckCallback> healthCheckCallbackProvider;
        @Inject(optional=true)
        private Provider<HealthCheckHandler> healthCheckHandlerProvider;
        @Inject(optional=true)
        private Collection<ClientFilter> additionalFilters;

        public void setEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
        }

        public void setHealthCheckCallbackProvider(Provider<HealthCheckCallback> healthCheckCallbackProvider) {
            this.healthCheckCallbackProvider = healthCheckCallbackProvider;
        }

        public void setHealthCheckHandlerProvider(Provider<HealthCheckHandler> healthCheckHandlerProvider) {
            this.healthCheckHandlerProvider = healthCheckHandlerProvider;
        }

        public void setAdditionalFilters(Collection<ClientFilter> additionalFilters) {
            this.additionalFilters = additionalFilters;
        }
    }

    private static enum Action {
        Register,
        Cancel,
        Renew,
        Refresh,
        Refresh_Delta;

    }
}

