/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.google.inject.ProvidedBy;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.PropertiesInstanceConfig;
import com.netflix.appinfo.providers.CloudInstanceConfigProvider;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ProvidedBy(value=CloudInstanceConfigProvider.class)
public class CloudInstanceConfig
extends PropertiesInstanceConfig {
    private static final Logger logger = LoggerFactory.getLogger(CloudInstanceConfig.class);
    private static final DynamicPropertyFactory INSTANCE = DynamicPropertyFactory.getInstance();
    private DynamicBooleanProperty propValidateInstanceId;
    private DataCenterInfo info;

    public CloudInstanceConfig() {
        this.initCloudInstanceConfig(this.namespace);
    }

    public CloudInstanceConfig(String namespace) {
        super(namespace);
        this.initCloudInstanceConfig(namespace);
    }

    private void initCloudInstanceConfig(String namespace) {
        this.propValidateInstanceId = INSTANCE.getBooleanProperty(namespace + "validateInstanceId", true);
        this.info = this.initDataCenterInfo();
    }

    private DataCenterInfo initDataCenterInfo() {
        AmazonInfo info;
        try {
            info = AmazonInfo.Builder.newBuilder().autoBuild(this.namespace);
            logger.info("Datacenter is: " + (Object)((Object)DataCenterInfo.Name.Amazon));
        }
        catch (Throwable e) {
            logger.error("Cannot initialize amazon info :", e);
            throw new RuntimeException(e);
        }
        AmazonInfo amazonInfo = info;
        if (amazonInfo.get(AmazonInfo.MetaDataKey.instanceId) == null) {
            if (this.propValidateInstanceId.get()) {
                throw new RuntimeException("Your datacenter is defined as cloud but we are not able to get the amazon metadata to register. \nSet the property " + this.namespace + "validateInstanceId to false to ignore the" + "metadata call");
            }
            HashMap<String, String> metadataMap = new HashMap<String, String>();
            metadataMap.put(AmazonInfo.MetaDataKey.instanceId.getName(), super.getIpAddress());
            metadataMap.put(AmazonInfo.MetaDataKey.publicHostname.getName(), super.getHostName(false));
            amazonInfo.setMetadata(metadataMap);
        } else if (amazonInfo.get(AmazonInfo.MetaDataKey.publicHostname) == null && amazonInfo.get(AmazonInfo.MetaDataKey.localIpv4) != null) {
            amazonInfo.getMetadata().put(AmazonInfo.MetaDataKey.publicHostname.getName(), amazonInfo.get(AmazonInfo.MetaDataKey.localIpv4));
        }
        return info;
    }

    @Override
    public String getHostName(boolean refresh) {
        if (refresh) {
            this.refreshAmazonInfo();
        }
        return ((AmazonInfo)this.info).get(AmazonInfo.MetaDataKey.publicHostname);
    }

    @Override
    public DataCenterInfo getDataCenterInfo() {
        return this.info;
    }

    public synchronized void refreshAmazonInfo() {
        try {
            AmazonInfo newInfo = AmazonInfo.Builder.newBuilder().autoBuild(this.namespace);
            String newHostname = newInfo.get(AmazonInfo.MetaDataKey.publicHostname);
            String existingHostname = ((AmazonInfo)this.info).get(AmazonInfo.MetaDataKey.publicHostname);
            if (newHostname != null && !newHostname.equals(existingHostname)) {
                logger.warn("The public hostname changed from : " + existingHostname + " => " + newHostname);
                this.info = newInfo;
            }
        }
        catch (Throwable t) {
            logger.error("Cannot refresh the Amazon Info ", t);
        }
    }
}

