/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.provider;

import com.netflix.discovery.converters.EurekaJacksonCodec;
import com.netflix.discovery.provider.ISerializer;
import com.netflix.discovery.provider.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class DiscoveryJerseyProvider
implements MessageBodyWriter,
MessageBodyReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryJerseyProvider.class);
    private static ConcurrentHashMap<Class, ISerializer> serializers = new ConcurrentHashMap();

    public boolean isReadable(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.checkForAnnotation(serializableClass);
    }

    public Object readFrom(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap headers, InputStream inputStream) throws IOException, WebApplicationException {
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            try {
                return EurekaJacksonCodec.getInstance().readValue(serializableClass, inputStream);
            }
            catch (Error e) {
                LOGGER.error("Unexpected error occured during de-serialization of discovery data, doing connection cleanup.", (Throwable)e);
                inputStream.close();
                throw e;
            }
        }
        ISerializer serializer = DiscoveryJerseyProvider.getSerializer(serializableClass);
        if (null != serializer) {
            try {
                return serializer.read(inputStream, serializableClass, mediaType);
            }
            catch (Error e) {
                LOGGER.error("Unexpected error occured during de-serialization of discovery data, doing connection cleanup.", (Throwable)e);
                if (null != inputStream) {
                    inputStream.close();
                    LOGGER.error("Unexpected error occured during de-serialization of discovery data, done connection cleanup.", (Throwable)e);
                }
                throw e;
            }
        }
        LOGGER.error("No serializer available for serializable class: " + serializableClass + ", de-serialization will fail.");
        throw new IOException("No serializer available for serializable class: " + serializableClass);
    }

    public long getSize(Object serializableObject, Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.checkForAnnotation(serializableClass);
    }

    public void writeTo(Object serializableObject, Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap headers, OutputStream outputStream) throws IOException, WebApplicationException {
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            EurekaJacksonCodec.getInstance().writeTo(serializableObject, outputStream);
        } else {
            ISerializer serializer = DiscoveryJerseyProvider.getSerializer(serializableClass);
            if (null != serializer) {
                serializer.write(serializableObject, outputStream, mediaType);
            } else {
                LOGGER.error("No serializer available for serializable class: " + serializableClass + ", serialization will fail.");
                throw new IOException("No serializer available for serializable class: " + serializableClass);
            }
        }
    }

    private boolean checkForAnnotation(Class serializableClass) {
        try {
            Serializer annotation = serializableClass.getAnnotation(Serializer.class);
            if (annotation != null) {
                return true;
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Exception in checking for annotations", th);
        }
        return false;
    }

    @Nullable
    private static ISerializer getSerializer(Class serializableClass) {
        Serializer payloadConverter;
        String serializer;
        ISerializer converter = null;
        Serializer annotation = serializableClass.getAnnotation(Serializer.class);
        if (annotation != null && (serializer = (payloadConverter = annotation).value()) != null && (converter = serializers.get(serializableClass)) == null) {
            try {
                converter = (ISerializer)Class.forName(serializer).newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.error("Error creating a serializer.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Error creating a serializer.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Error creating a serializer.", (Throwable)e);
            }
            if (null != converter) {
                serializers.put(serializableClass, converter);
            }
        }
        return converter;
    }
}

