/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StringCache {
    public static final int LENGTH_LIMIT = 38;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, WeakReference<String>> cache = new WeakHashMap<String, WeakReference<String>>();
    private final int lengthLimit;

    public StringCache() {
        this(38);
    }

    public StringCache(int lengthLimit) {
        this.lengthLimit = lengthLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cachedValueOf(String str) {
        if (str != null && (this.lengthLimit < 0 || str.length() <= this.lengthLimit)) {
            WeakReference<String> ref;
            try {
                this.lock.readLock().lock();
                ref = this.cache.get(str);
                if (ref != null) {
                    String string = (String)ref.get();
                    return string;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            try {
                this.lock.writeLock().lock();
                ref = this.cache.get(str);
                if (ref != null) {
                    String string = (String)ref.get();
                    return string;
                }
                this.cache.put(str, new WeakReference<String>(str));
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return str;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        try {
            this.lock.readLock().lock();
            int n = this.cache.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

